/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Date;
import org.netbeans.modules.bugtracking.APIAccessor;
import org.netbeans.modules.bugtracking.RepositoryImpl;
import org.netbeans.modules.bugtracking.api.Issue;
import org.netbeans.modules.bugtracking.spi.IssueController;
import org.netbeans.modules.bugtracking.spi.IssueProvider;
import org.netbeans.modules.bugtracking.spi.IssueScheduleInfo;
import org.netbeans.modules.bugtracking.spi.IssueScheduleProvider;
import org.netbeans.modules.bugtracking.spi.IssueStatusProvider;
import org.netbeans.modules.bugtracking.tasks.TaskSchedulingManager;
import org.netbeans.modules.bugtracking.ui.issue.IssueAction;
import org.netbeans.modules.team.spi.OwnerInfo;

public final class IssueImpl<R, I> {
    public static final int SHORT_DISP_NAME_LENGTH = 15;
    public static final String EVENT_ISSUE_DATA_CHANGED = "issue.data_changed";
    public static final String EVENT_ISSUE_DELETED = "issue.deleted";
    private Issue issue;
    private final RepositoryImpl<R, ?, I> repo;
    private final IssueProvider<I> issueProvider;
    private final I data;
    private String fakeId;

    IssueImpl(RepositoryImpl<R, ?, I> repo, IssueProvider<I> issueProvider, I data) {
        this.issueProvider = issueProvider;
        this.data = data;
        this.repo = repo;
        issueProvider.addPropertyChangeListener(data, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("issue.schedule_changed".equals(evt.getPropertyName())) {
                    IssueImpl.this.handleScheduling();
                } else if (IssueImpl.EVENT_ISSUE_DELETED.equals(evt.getPropertyName())) {
                    IssueImpl.this.issueDeleted();
                }
            }
        });
        if (this.hasSchedule()) {
            this.handleScheduling();
        }
    }

    public synchronized Issue getIssue() {
        if (this.issue == null) {
            this.issue = APIAccessor.IMPL.createIssue(this);
        }
        return this.issue;
    }

    public void open() {
        IssueAction.openIssue(this);
    }

    public String getShortenedDisplayName() {
        int limit;
        String displayName = this.getDisplayName();
        int length = displayName.length();
        if (length <= (limit = 15)) {
            return displayName;
        }
        String trimmed = displayName.substring(0, limit).trim();
        StringBuilder buf = new StringBuilder(limit + 4);
        buf.append(trimmed);
        if (length > limit + 1 && Character.isSpaceChar(displayName.charAt(limit))) {
            buf.append(' ');
        }
        buf.append("...");
        return buf.toString();
    }

    public RepositoryImpl getRepositoryImpl() {
        return this.repo;
    }

    IssueProvider getProvider() {
        return this.issueProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getID() {
        String id = this.issueProvider.getID(this.data);
        if (id == null) {
            RepositoryImpl<R, ?, I> repositoryImpl = this.repo;
            synchronized (repositoryImpl) {
                if (this.fakeId == null) {
                    this.fakeId = this.repo.getNextFakeIssueID();
                }
                return this.fakeId;
            }
        }
        return id;
    }

    public String getSummary() {
        return this.issueProvider.getSummary(this.data);
    }

    public String getTooltip() {
        return this.issueProvider.getTooltip(this.data);
    }

    public void attachFile(File file, String description, boolean isPatch) {
        this.issueProvider.attachFile(this.data, file, description, isPatch);
    }

    public void addComment(String comment, boolean closeAsFixed) {
        this.issueProvider.addComment(this.data, comment, closeAsFixed);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.issueProvider.addPropertyChangeListener(this.data, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.issueProvider.removePropertyChangeListener(this.data, listener);
    }

    public boolean refresh() {
        return this.issueProvider.refresh(this.data);
    }

    public boolean isNew() {
        return this.issueProvider.isNew(this.data);
    }

    public boolean isFinished() {
        return this.issueProvider.isFinished(this.data);
    }

    public String getDisplayName() {
        return this.issueProvider.getDisplayName(this.data);
    }

    public void setContext(OwnerInfo info) {
        this.repo.setIssueContext(this.data, info);
    }

    public IssueController getController() {
        return this.issueProvider.getController(this.data);
    }

    public boolean isData(Object obj) {
        return this.data == obj;
    }

    public boolean hasStatus() {
        IssueStatusProvider<R, I> sp = this.repo.getStatusProvider();
        return sp != null;
    }

    public IssueStatusProvider.Status getStatus() {
        IssueStatusProvider<R, I> sp = this.repo.getStatusProvider();
        if (sp == null) {
            return IssueStatusProvider.Status.SEEN;
        }
        return sp.getStatus(this.data);
    }

    public void addIssueStatusListener(PropertyChangeListener l) {
        IssueStatusProvider<R, I> sp = this.repo.getStatusProvider();
        if (sp == null) {
            return;
        }
        sp.addPropertyChangeListener(this.data, l);
    }

    public void removeIssueStatusListener(PropertyChangeListener l) {
        IssueStatusProvider<R, I> sp = this.repo.getStatusProvider();
        if (sp == null) {
            return;
        }
        sp.removePropertyChangeListener(this.data, l);
    }

    public void setSeen(boolean isUptodate) {
        IssueStatusProvider<R, I> sp = this.repo.getStatusProvider();
        if (sp == null) {
            return;
        }
        sp.setSeenIncoming(this.data, isUptodate);
    }

    public boolean submit() {
        IssueStatusProvider<R, I> sp = this.repo.getStatusProvider();
        if (sp == null) {
            return false;
        }
        return sp.submit(this.data);
    }

    public void discardChanges() {
        IssueStatusProvider<R, I> sp = this.repo.getStatusProvider();
        if (sp == null) {
            return;
        }
        sp.discardOutgoing(this.data);
    }

    public boolean hasSchedule() {
        IssueScheduleProvider<I> isp = this.repo.getSchedulingProvider();
        return isp != null;
    }

    public void setSchedule(IssueScheduleInfo info) {
        IssueScheduleProvider<I> isp = this.repo.getSchedulingProvider();
        assert (isp != null) : "do no call .setSchedule() if .hasSchedule() is false";
        if (isp != null) {
            isp.setSchedule(this.data, info);
            this.handleScheduling();
        }
    }

    public Date getDueDate() {
        IssueScheduleProvider<I> isp = this.repo.getSchedulingProvider();
        return isp != null ? isp.getDueDate(this.data) : null;
    }

    public IssueScheduleInfo getSchedule() {
        IssueScheduleProvider<I> isp = this.repo.getSchedulingProvider();
        return isp != null ? isp.getSchedule(this.data) : null;
    }

    public boolean providesPriority() {
        return this.repo.getPriorityProvider() != null;
    }

    public String getPriority() {
        return this.repo.getPriorityName(this.data);
    }

    public Image getPriorityIcon() {
        return this.repo.getPriorityIcon(this.data);
    }

    private void handleScheduling() {
        TaskSchedulingManager.getInstance().handleTask(this);
    }

    private void issueDeleted() {
        TaskSchedulingManager.getInstance().taskDeleted(this);
    }
}

