/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.netbeans.api.keyring.Keyring;
import org.netbeans.modules.bugtracking.APIAccessor;
import org.netbeans.modules.bugtracking.BugtrackingManager;
import org.netbeans.modules.bugtracking.DelegatingConnector;
import org.netbeans.modules.bugtracking.RepositoryImpl;
import org.netbeans.modules.bugtracking.SPIAccessor;
import org.netbeans.modules.bugtracking.api.Repository;
import org.netbeans.modules.bugtracking.commons.NBBugzillaUtils;
import org.netbeans.modules.bugtracking.spi.RepositoryInfo;
import org.netbeans.modules.bugtracking.team.TeamRepositories;
import org.netbeans.modules.bugtracking.util.BugtrackingUtil;
import org.netbeans.modules.team.commons.LogUtils;
import org.netbeans.modules.team.spi.TeamAccessorUtils;
import org.openide.util.NbPreferences;

public class RepositoryRegistry {
    public static final String EVENT_REPOSITORIES_CHANGED = "bugtracking.repositories.changed";
    private final PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    private static final String BUGTRACKING_REPO = "bugracking.repository_";
    private static final String DELIMITER = "<=>";
    private static final Object REPOSITORIES_LOCK = new Object();
    private static RepositoryRegistry instance;
    private RepositoriesMap repositories;
    private static final String JIRA_REPO_ID = "jira.repository_";
    private static final String BUGZILLA_REPO_ID = "bugzilla.repository_";
    private static final String NB_BUGZILLA_USERNAME = "nbbugzilla.username";
    private static final String NB_BUGZILLA_PASSWORD = "nbbugzilla.password";
    private static final String REPOSITORY_SETTING_SHORT_LOGIN = "bugzilla.shortLoginEnabled";

    private RepositoryRegistry() {
    }

    public static synchronized RepositoryRegistry getInstance() {
        if (instance == null) {
            instance = new RepositoryRegistry();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<RepositoryImpl> getRepositories() {
        Object object = REPOSITORIES_LOCK;
        synchronized (object) {
            List<RepositoryImpl> l = this.getStoredRepositories().getRepositories();
            return new LinkedList<RepositoryImpl>(l);
        }
    }

    public Collection<RepositoryImpl> getKnownRepositories(boolean pingOpenProjects) {
        return this.getKnownRepositories(pingOpenProjects, false);
    }

    public Collection<RepositoryImpl> getKnownRepositories(boolean pingOpenProjects, boolean onlyDashboardOpenProjects) {
        Collection<RepositoryImpl> otherRepos = this.getRepositories();
        Collection<RepositoryImpl> teamRepos = TeamRepositories.getInstance().getRepositories(pingOpenProjects, onlyDashboardOpenProjects);
        ArrayList<RepositoryImpl> ret = new ArrayList<RepositoryImpl>(teamRepos.size() + otherRepos.size());
        ret.addAll(otherRepos);
        ret.addAll(teamRepos);
        this.logRepositoryUsage(ret);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<RepositoryImpl> getRepositories(String connectorID, boolean allKnown) {
        LinkedList<RepositoryImpl> ret = new LinkedList<RepositoryImpl>();
        Object object = REPOSITORIES_LOCK;
        synchronized (object) {
            Map m = (Map)this.getStoredRepositories().get(connectorID);
            if (m != null) {
                ret.addAll(m.values());
            }
        }
        if (allKnown) {
            Collection<RepositoryImpl> repos = TeamRepositories.getInstance().getRepositories(false, true);
            for (RepositoryImpl impl : repos) {
                if (!connectorID.equals(impl.getConnectorId())) continue;
                ret.add(impl);
            }
        }
        return ret;
    }

    public RepositoryImpl getRepository(String connectorId, String repoId, boolean allKnown) {
        Collection<RepositoryImpl> repos = this.getRepositories(connectorId, allKnown);
        for (RepositoryImpl repo : repos) {
            if (!repo.getId().equals(repoId)) continue;
            return repo;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRepository(RepositoryImpl repository) {
        assert (repository != null);
        if (repository.isTeamRepository() && !NBBugzillaUtils.isNbRepository((String)repository.getUrl())) {
            return;
        }
        Object object = REPOSITORIES_LOCK;
        synchronized (object) {
            this.getStoredRepositories().put(repository);
            this.putRepository(repository);
        }
        this.fireRepositoriesChanged(null, Arrays.asList(repository));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRepository(RepositoryImpl repository) {
        Object object = REPOSITORIES_LOCK;
        synchronized (object) {
            RepositoryInfo info = repository.getInfo();
            String connectorID = info.getConnectorId();
            this.getPreferences().remove(this.getRepositoryKey(info));
            this.getStoredRepositories().remove(connectorID, repository);
        }
        this.fireRepositoriesChanged(Arrays.asList(repository), null);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
        TeamRepositories.getInstance().removePropertyChangeListener(listener);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
        TeamRepositories.getInstance().addPropertyChangeListener(listener);
    }

    void flushRepositories() {
        this.repositories = null;
    }

    private String getRepositoryKey(RepositoryInfo info) {
        return BUGTRACKING_REPO + info.getConnectorId() + DELIMITER + info.getID();
    }

    private RepositoriesMap getStoredRepositories() {
        if (this.repositories == null) {
            this.repositories = new RepositoriesMap();
            this.migrateBugzilla();
            this.migrateJira();
            String[] ids = this.getRepositoryIds();
            DelegatingConnector[] connectors = BugtrackingManager.getInstance().getConnectors();
            if (ids != null) {
                for (String id : ids) {
                    String[] idArray = id.split(DELIMITER);
                    String connectorId = idArray[0].substring(BUGTRACKING_REPO.length());
                    for (DelegatingConnector c : connectors) {
                        Repository repo;
                        RepositoryInfo info;
                        if (!c.getID().equals(connectorId) || (info = SPIAccessor.IMPL.read(this.getPreferences(), id)) == null || (repo = c.createRepository(info)) == null) continue;
                        this.repositories.put(APIAccessor.IMPL.getImpl(repo));
                    }
                }
            }
            for (DelegatingConnector c : connectors) {
                Repository repo;
                if (!BugtrackingManager.isLocalConnectorID(c.getID()) || (repo = c.createRepository()) == null) continue;
                this.repositories.put(APIAccessor.IMPL.getImpl(repo));
            }
        }
        return this.repositories;
    }

    private String[] getRepositoryIds() {
        return this.getKeysWithPrefix(BUGTRACKING_REPO);
    }

    void putRepository(RepositoryImpl repository) {
        RepositoryInfo info = repository.getInfo();
        String key = this.getRepositoryKey(info);
        SPIAccessor.IMPL.store(this.getPreferences(), info, key);
    }

    private Preferences getPreferences() {
        return NbPreferences.forModule(RepositoryRegistry.class);
    }

    private String[] getKeysWithPrefix(String prefix) {
        String[] keys = null;
        try {
            keys = this.getPreferences().keys();
        }
        catch (BackingStoreException ex) {
            BugtrackingManager.LOG.log(Level.SEVERE, null, ex);
        }
        if (keys == null || keys.length == 0) {
            return new String[0];
        }
        ArrayList<String> ret = new ArrayList<String>();
        for (String key : keys) {
            if (!key.startsWith(prefix)) continue;
            ret.add(key);
        }
        return ret.toArray(new String[ret.size()]);
    }

    private void fireRepositoriesChanged(Collection<RepositoryImpl> oldRepositories, Collection<RepositoryImpl> newRepositories) {
        this.changeSupport.firePropertyChange(EVENT_REPOSITORIES_CHANGED, oldRepositories, newRepositories);
    }

    private void migrateBugzilla() {
        String[] repoIds;
        Preferences preferences = RepositoryRegistry.getBugzillaPreferences();
        for (String id : repoIds = this.getRepoIds(preferences, BUGZILLA_REPO_ID)) {
            this.migrateBugzillaRepository(preferences, id);
            preferences.remove(BUGZILLA_REPO_ID + id);
        }
        preferences.remove(NB_BUGZILLA_USERNAME);
    }

    private void migrateJira() {
        String[] repoIds;
        Preferences preferences = RepositoryRegistry.getJiraPreferences();
        for (String id : repoIds = this.getRepoIds(preferences, JIRA_REPO_ID)) {
            this.migrateJiraRepository(preferences, id);
            preferences.remove(JIRA_REPO_ID + id);
        }
    }

    private String[] getRepoIds(Preferences preferences, String repoId) {
        String[] keys = null;
        try {
            keys = preferences.keys();
        }
        catch (BackingStoreException ex) {
            BugtrackingManager.LOG.log(Level.SEVERE, null, ex);
        }
        if (keys == null || keys.length == 0) {
            return new String[0];
        }
        ArrayList<String> ret = new ArrayList<String>();
        for (String key : keys) {
            if (!key.startsWith(repoId)) continue;
            ret.add(key.substring(repoId.length()));
        }
        return ret.toArray(new String[ret.size()]);
    }

    private void migrateBugzillaRepository(Preferences preferences, String repoID) {
        char[] password;
        String user;
        String[] values = RepositoryRegistry.getRepositoryValues(preferences, BUGZILLA_REPO_ID, repoID);
        if (values == null) {
            return;
        }
        assert (values.length == 3 || values.length == 6 || values.length == 7);
        String url = values[0];
        if (NBBugzillaUtils.isNbRepository((String)url)) {
            user = RepositoryRegistry.getBugzillaNBUsername();
            char[] psswdArray = RepositoryRegistry.getNBPassword();
            password = psswdArray != null ? psswdArray : new char[]{};
        } else {
            user = values[1];
            password = BugtrackingUtil.readPassword(values[2], null, user, url);
        }
        String httpUser = values.length > 3 ? values[3] : null;
        char[] httpPassword = values.length > 3 ? BugtrackingUtil.readPassword(values[4], "http", httpUser, url) : new char[]{};
        String shortNameEnabled = "false";
        if (values.length > 5) {
            shortNameEnabled = values[5];
        }
        String name = values.length > 6 ? values[6] : repoID;
        RepositoryInfo info = new RepositoryInfo(repoID, "org.netbeans.modules.bugzilla", url, name, name, user, httpUser, password, httpPassword);
        info.putValue(REPOSITORY_SETTING_SHORT_LOGIN, shortNameEnabled);
        SPIAccessor.IMPL.store(this.getPreferences(), info, this.getRepositoryKey(info));
    }

    private void migrateJiraRepository(Preferences preferences, String repoID) {
        String[] values = RepositoryRegistry.getRepositoryValues(preferences, JIRA_REPO_ID, repoID);
        String url = values[0];
        String user = values[1];
        String password = new String(BugtrackingUtil.readPassword(values[2], null, user, url));
        String httpUser = values.length > 3 ? values[3] : null;
        String httpPassword = new String(values.length > 3 ? BugtrackingUtil.readPassword(values[4], "http", httpUser, url) : null);
        String repoName = values.length > 5 ? values[5] : repoID;
        RepositoryInfo info = new RepositoryInfo(repoID, "org.netbeans.modules.jira", url, repoName, repoName, user, httpUser, password.toCharArray(), httpPassword.toCharArray());
        SPIAccessor.IMPL.store(this.getPreferences(), info, this.getRepositoryKey(info));
    }

    private static String[] getRepositoryValues(Preferences preferences, String repoPrefix, String repoID) {
        String repoString = preferences.get(repoPrefix + repoID, "");
        if (repoString.equals("")) {
            return null;
        }
        return repoString.split(DELIMITER);
    }

    private static Preferences getBugzillaPreferences() {
        return NbPreferences.root().node("org/netbeans/modules/bugzilla");
    }

    private static Preferences getJiraPreferences() {
        return NbPreferences.root().node("org/netbeans/modules/jira");
    }

    private static String getBugzillaNBUsername() {
        String user = RepositoryRegistry.getBugzillaPreferences().get(NB_BUGZILLA_USERNAME, "");
        return user;
    }

    private static char[] getNBPassword() {
        return Keyring.read((String)NB_BUGZILLA_PASSWORD);
    }

    private void logRepositoryUsage(Collection<RepositoryImpl> ret) {
        for (RepositoryImpl repositoryImpl : ret) {
            LogUtils.logRepositoryUsage((String)repositoryImpl.getConnectorId(), (String)repositoryImpl.getUrl());
            if (!repositoryImpl.isTeamRepository()) continue;
            TeamAccessorUtils.logTeamUsage((String)repositoryImpl.getUrl(), (Object[])new Object[]{"ISSUE_TRACKING", LogUtils.getBugtrackingType((String)repositoryImpl.getConnectorId())});
        }
    }

    private class RepositoriesMap
    extends HashMap<String, Map<String, RepositoryImpl>> {
        private RepositoriesMap() {
        }

        public void remove(String connectorID, RepositoryImpl repository) {
            Map m = (Map)this.get(connectorID);
            if (m != null) {
                m.remove(repository.getId());
            }
        }

        public void put(RepositoryImpl repository) {
            String connectorID = repository.getInfo().getConnectorId();
            HashMap<String, RepositoryImpl> m = (HashMap<String, RepositoryImpl>)this.get(connectorID);
            if (m == null) {
                m = new HashMap<String, RepositoryImpl>();
                this.put(connectorID, m);
            }
            m.put(repository.getId(), repository);
        }

        List<RepositoryImpl> getRepositories() {
            LinkedList<RepositoryImpl> ret = new LinkedList<RepositoryImpl>();
            for (Map.Entry e : this.entrySet()) {
                ret.addAll(((Map)e.getValue()).values());
            }
            return ret;
        }
    }
}

