/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.tasks.dashboard;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.bugtracking.QueryImpl;
import org.netbeans.modules.bugtracking.RepositoryImpl;
import org.netbeans.modules.bugtracking.settings.DashboardSettings;
import org.netbeans.modules.bugtracking.tasks.Category;
import org.netbeans.modules.bugtracking.tasks.DashboardUtils;
import org.netbeans.modules.bugtracking.tasks.dashboard.DashboardViewer;
import org.openide.util.RequestProcessor;

public class DashboardRefresher {
    private static final Logger LOG = Logger.getLogger(DashboardRefresher.class.getName());
    private static final RequestProcessor RP = new RequestProcessor(DashboardRefresher.class.getName());
    private final RequestProcessor.Task refreshDashboard = RP.create(new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LOG.finer("dashbord refresh start:");
            LOG.log(Level.FINER, "  dashboardBusy: {0}", DashboardRefresher.this.dashboardBusy);
            LOG.log(Level.FINER, "  refreshEnabled: {0}", DashboardRefresher.this.refreshEnabled);
            if (DashboardRefresher.this.dashboardBusy || !DashboardRefresher.this.refreshEnabled) {
                DashboardRefresher.this.refreshWaiting = true;
                return;
            }
            try {
                DashboardRefresher.this.refreshDashboard();
            }
            finally {
                DashboardRefresher.this.setupDashboardRefresh();
            }
        }
    });
    private final RequestProcessor.Task refreshSchedule = RP.create(new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                DashboardViewer.getInstance().updateScheduleCategories();
            }
            finally {
                DashboardRefresher.this.setupScheduleRefresh();
            }
        }
    });
    private static DashboardRefresher instance;
    private boolean refreshEnabled;
    private boolean dashboardBusy = false;
    private boolean refreshWaiting = false;

    private DashboardRefresher() {
    }

    public static DashboardRefresher getInstance() {
        if (instance == null) {
            instance = new DashboardRefresher();
        }
        return instance;
    }

    public void setupDashboardRefresh() {
        DashboardSettings settings = DashboardSettings.getInstance();
        if (!settings.isAutoSync() || !this.refreshEnabled) {
            return;
        }
        this.refreshDashboard.cancel();
        this.scheduleDashboardRefresh();
    }

    public void setupScheduleRefresh() {
        this.refreshSchedule.cancel();
        this.refreshSchedule.schedule(DashboardUtils.getMillisToTomorrow());
    }

    private void scheduleDashboardRefresh() {
        DashboardSettings settings = DashboardSettings.getInstance();
        int delay = settings.getAutoSyncValue();
        delay = delay * 60 * 1000;
        this.refreshDashboard.schedule(delay);
        LOG.log(Level.FINE, "tasks dashboard refresh scheduled in {0}", delay);
    }

    public void setRefreshEnabled(boolean refreshEnabled) {
        this.refreshEnabled = refreshEnabled;
    }

    public void setDashboardBusy(boolean dashboardBusy) {
        this.dashboardBusy = dashboardBusy;
        if (!dashboardBusy && this.refreshWaiting) {
            this.refreshWaiting = false;
            this.refreshDashboard.schedule(0);
        }
    }

    private void refreshDashboard() {
        List<RepositoryImpl> repositories = DashboardViewer.getInstance().getRepositories(true);
        List<Category> categories = DashboardViewer.getInstance().getCategories(true, true);
        for (RepositoryImpl repository : repositories) {
            for (QueryImpl query : repository.getQueries()) {
                if (DashboardUtils.isQueryAutoRefresh(query)) {
                    LOG.log(Level.INFO, "refreshing query {0} - {1}", new Object[]{query.getRepositoryImpl().getDisplayName(), query.getDisplayName()});
                    query.refresh();
                    continue;
                }
                LOG.log(Level.FINE, "skipped refreshing query {0} - {1}", new Object[]{query.getRepositoryImpl().getDisplayName(), query.getDisplayName()});
            }
        }
        for (Category category : categories) {
            category.refresh();
        }
    }
}

