/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.tasks.dashboard;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DropMode;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.bugtracking.BugtrackingManager;
import org.netbeans.modules.bugtracking.IssueImpl;
import org.netbeans.modules.bugtracking.QueryImpl;
import org.netbeans.modules.bugtracking.RepositoryImpl;
import org.netbeans.modules.bugtracking.tasks.Category;
import org.netbeans.modules.bugtracking.tasks.DashboardTopComponent;
import org.netbeans.modules.bugtracking.tasks.DashboardTransferHandler;
import org.netbeans.modules.bugtracking.tasks.DashboardUtils;
import org.netbeans.modules.bugtracking.tasks.NotificationManager;
import org.netbeans.modules.bugtracking.tasks.RecentCategory;
import org.netbeans.modules.bugtracking.tasks.ScheduleCategory;
import org.netbeans.modules.bugtracking.tasks.UnsubmittedCategory;
import org.netbeans.modules.bugtracking.tasks.actions.Actions;
import org.netbeans.modules.bugtracking.tasks.cache.CategoryEntry;
import org.netbeans.modules.bugtracking.tasks.cache.DashboardStorage;
import org.netbeans.modules.bugtracking.tasks.cache.TaskEntry;
import org.netbeans.modules.bugtracking.tasks.dashboard.CategoryNode;
import org.netbeans.modules.bugtracking.tasks.dashboard.ClosedCategoryNode;
import org.netbeans.modules.bugtracking.tasks.dashboard.ClosedRepositoryNode;
import org.netbeans.modules.bugtracking.tasks.dashboard.DashboardRefresher;
import org.netbeans.modules.bugtracking.tasks.dashboard.ErrorNode;
import org.netbeans.modules.bugtracking.tasks.dashboard.QueryNode;
import org.netbeans.modules.bugtracking.tasks.dashboard.RecentCategoryNode;
import org.netbeans.modules.bugtracking.tasks.dashboard.RepositoryNode;
import org.netbeans.modules.bugtracking.tasks.dashboard.ScheduleCategoryNode;
import org.netbeans.modules.bugtracking.tasks.dashboard.TaskNode;
import org.netbeans.modules.bugtracking.tasks.dashboard.TitleNode;
import org.netbeans.modules.bugtracking.tasks.dashboard.UnsubmittedCategoryNode;
import org.netbeans.modules.bugtracking.tasks.filter.AppliedFilters;
import org.netbeans.modules.bugtracking.tasks.filter.DashboardFilter;
import org.netbeans.modules.bugtracking.tasks.filter.UnsubmittedCategoryFilter;
import org.netbeans.modules.team.commons.ColorManager;
import org.netbeans.modules.team.commons.treelist.LinkButton;
import org.netbeans.modules.team.commons.treelist.ListNode;
import org.netbeans.modules.team.commons.treelist.TreeList;
import org.netbeans.modules.team.commons.treelist.TreeListModel;
import org.netbeans.modules.team.commons.treelist.TreeListModelListener;
import org.netbeans.modules.team.commons.treelist.TreeListNode;
import org.netbeans.modules.team.ide.spi.ProjectServices;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public final class DashboardViewer
implements PropertyChangeListener {
    public static final String PREF_ALL_PROJECTS = "allProjects";
    public static final String PREF_COUNT = "count";
    public static final String PREF_ID = "id";
    private final TreeListModel model = new TreeListModel();
    private static final ListModel EMPTY_MODEL = new AbstractListModel(){

        @Override
        public int getSize() {
            return 0;
        }

        @Override
        public Object getElementAt(int index) {
            return null;
        }
    };
    private final RequestProcessor REQUEST_PROCESSOR = new RequestProcessor("Dashboard");
    private final TreeList treeList = new TreeList(this.model);
    public final JScrollPane dashboardComponent;
    private boolean opened = false;
    private final TitleNode titleCategoryNode;
    private final TitleNode titleRepositoryNode;
    private final ErrorNode errorRepositories;
    private final ErrorNode errorCategories;
    private final Object LOCK_CATEGORIES = new Object();
    private final Object LOCK_REPOSITORIES = new Object();
    private final Map<Category, CategoryNode> mapCategoryToNode;
    private final Map<String, RepositoryNode> mapRepositoryToNode;
    private final Map<RepositoryImpl, UnsubmittedCategoryNode> mapRepositoryToUnsubmittedNode;
    private List<CategoryNode> categoryNodes;
    private List<RepositoryNode> repositoryNodes;
    private final AppliedFilters<TaskNode> appliedTaskFilters;
    private final AppliedFilters<CategoryNode> appliedCategoryFilters;
    private final AppliedFilters<RepositoryNode> appliedRepositoryFilters;
    private int taskHits;
    private final Map<TreeListNode, Boolean> expandedNodes = new HashMap<TreeListNode, Boolean>();
    private TreeListNode activeTaskNode;
    public static final Logger LOG = Logger.getLogger(DashboardViewer.class.getName());
    private final ModelListener modelListener;
    private ScheduleCategoryNode todayCategoryNode;
    private ScheduleCategoryNode thisWeekCategoryNode;
    private boolean categoriesLoaded = false;

    private DashboardViewer() {
        this.dashboardComponent = new JScrollPane(){

            @Override
            public void requestFocus() {
                Component view = this.getViewport().getView();
                if (view != null) {
                    view.requestFocus();
                } else {
                    super.requestFocus();
                }
            }

            @Override
            public boolean requestFocusInWindow() {
                Component view = this.getViewport().getView();
                return view != null ? view.requestFocusInWindow() : super.requestFocusInWindow();
            }
        };
        this.dashboardComponent.setHorizontalScrollBarPolicy(31);
        this.dashboardComponent.setBorder(BorderFactory.createEmptyBorder());
        this.dashboardComponent.setBackground(ColorManager.getDefault().getDefaultBackground());
        this.dashboardComponent.getViewport().setBackground(ColorManager.getDefault().getDefaultBackground());
        this.mapCategoryToNode = new HashMap<Category, CategoryNode>();
        this.mapRepositoryToNode = new HashMap<String, RepositoryNode>();
        this.mapRepositoryToUnsubmittedNode = new HashMap<RepositoryImpl, UnsubmittedCategoryNode>();
        this.categoryNodes = new ArrayList<CategoryNode>();
        this.repositoryNodes = new ArrayList<RepositoryNode>();
        LinkButton btnAddCategory = new LinkButton((Icon)ImageUtilities.loadImageIcon((String)"org/netbeans/modules/bugtracking/tasks/resources/add_category.png", (boolean)true), (Action)new Actions.CreateCategoryAction());
        btnAddCategory.setToolTipText(NbBundle.getMessage(DashboardViewer.class, (String)"LBL_CreateCategory"));
        LinkButton btnClearCategories = new LinkButton((Icon)ImageUtilities.loadImageIcon((String)"org/netbeans/modules/bugtracking/tasks/resources/clear.png", (boolean)true), (Action)new Actions.ClearCategoriesAction());
        btnClearCategories.setToolTipText(NbBundle.getMessage(DashboardViewer.class, (String)"LBL_ClearCategories"));
        this.titleCategoryNode = new TitleNode(NbBundle.getMessage(TitleNode.class, (String)"LBL_Categories"), btnAddCategory, btnClearCategories);
        LinkButton btnAddRepo = new LinkButton((Icon)ImageUtilities.loadImageIcon((String)"org/netbeans/modules/bugtracking/tasks/resources/add_repo.png", (boolean)true), (Action)new Actions.CreateRepositoryAction());
        btnAddRepo.setToolTipText(NbBundle.getMessage(DashboardViewer.class, (String)"LBL_AddRepo"));
        this.titleRepositoryNode = new TitleNode(NbBundle.getMessage(TitleNode.class, (String)"LBL_Repositories"), btnAddRepo);
        AbstractAction reloadAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DashboardViewer.this.loadData();
            }
        };
        this.errorRepositories = new ErrorNode(NbBundle.getMessage(TitleNode.class, (String)"ERR_Repositories"), reloadAction);
        this.errorCategories = new ErrorNode(NbBundle.getMessage(TitleNode.class, (String)"ERR_Categories"), reloadAction);
        this.modelListener = new ModelListener();
        this.model.addModelListener((TreeListModelListener)this.modelListener);
        this.model.addRoot(-1, (TreeListNode)this.titleCategoryNode);
        this.model.addRoot(-1, (TreeListNode)this.titleRepositoryNode);
        AccessibleContext accessibleContext = this.treeList.getAccessibleContext();
        String a11y = NbBundle.getMessage(DashboardViewer.class, (String)"A11Y_TeamProjects");
        accessibleContext.setAccessibleName(a11y);
        accessibleContext.setAccessibleDescription(a11y);
        this.appliedTaskFilters = new AppliedFilters();
        this.appliedCategoryFilters = new AppliedFilters();
        this.appliedRepositoryFilters = new AppliedFilters();
        this.appliedCategoryFilters.addFilter(new UnsubmittedCategoryFilter());
        this.taskHits = 0;
        this.treeList.setTransferHandler((TransferHandler)new DashboardTransferHandler());
        this.treeList.setDragEnabled(true);
        this.treeList.setDropMode(DropMode.ON_OR_INSERT);
        this.treeList.setModel((ListModel)this.model);
        this.attachActions();
        this.dashboardComponent.setViewportView((Component)this.treeList);
        this.dashboardComponent.invalidate();
        this.dashboardComponent.revalidate();
        this.dashboardComponent.repaint();
    }

    public static DashboardViewer getInstance() {
        return Holder.theInstance;
    }

    @Override
    public void propertyChange(final PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("bugtracking.repositories.changed")) {
            this.REQUEST_PROCESSOR.post(new Runnable(){

                @Override
                public void run() {
                    DashboardViewer.this.titleRepositoryNode.setProgressVisible(true);
                    Collection addedRepositories = (Collection)evt.getNewValue();
                    Collection removedRepositories = (Collection)evt.getOldValue();
                    if (addedRepositories == null && removedRepositories == null) {
                        DashboardViewer.this.updateRepositories(DashboardUtils.getRepositories());
                    } else {
                        DashboardViewer.this.updateRepositories(addedRepositories, removedRepositories);
                    }
                    DashboardViewer.this.titleRepositoryNode.setProgressVisible(false);
                }
            });
        } else if (evt.getPropertyName().equals("dashboard.task_limit_changed")) {
            this.REQUEST_PROCESSOR.post(new Runnable(){

                @Override
                public void run() {
                    DashboardViewer.this.updateContent(true);
                }
            });
        } else if (evt.getPropertyName().equals("dashboard.auto_sync_changed")) {
            DashboardRefresher.getInstance().setupDashboardRefresh();
        } else if (evt.getPropertyName().equals("dashboard.sort_attributes_changed")) {
            this.REQUEST_PROCESSOR.post(new Runnable(){

                @Override
                public void run() {
                    DashboardViewer.this.updateContent(false);
                }
            });
        }
    }

    public void select(Collection<? extends TreeListNode> toSelect) {
        for (TreeListNode treeListNode : toSelect) {
            TreeListNode parent = treeListNode.getParent();
            if (parent != null && !parent.isExpanded()) {
                parent.setExpanded(true);
            }
            this.treeList.setSelectedValue((Object)treeListNode, true);
        }
    }

    public void select(RepositoryImpl repository) {
        RepositoryNode node = this.mapRepositoryToNode.get(repository.getId());
        if (node != null) {
            ArrayList<RepositoryNode> l = new ArrayList<RepositoryNode>(1);
            l.add(node);
            this.select(l);
        }
    }

    public void select(QueryImpl query, boolean expand) {
        RepositoryNode node = this.mapRepositoryToNode.get(query.getRepositoryImpl().getId());
        if (node != null) {
            List<QueryNode> queryNodes = node.getQueryNodes();
            for (QueryNode queryNode : queryNodes) {
                if (!queryNode.getQuery().equals(query)) continue;
                this.select(Arrays.asList(queryNode));
                if (expand) {
                    queryNode.setExpanded(true);
                }
                return;
            }
        }
    }

    public void showTodayCategory() {
        if (!this.isCategoryInFilter(this.todayCategoryNode)) {
            DashboardTopComponent.findInstance().showTodayCategory();
        } else {
            this.selectTodayCategory();
        }
    }

    public void selectTodayCategory() {
        this.treeList.setSelectedValue((Object)this.todayCategoryNode, true);
        this.todayCategoryNode.setExpanded(true);
    }

    public void saveExpandedState() {
        this.expandedNodes.clear();
        for (CategoryNode categoryNode : this.categoryNodes) {
            this.expandedNodes.put((TreeListNode)categoryNode, categoryNode.isExpanded());
        }
        for (RepositoryNode repositoryNode : this.repositoryNodes) {
            for (TreeListNode n : repositoryNode.getChildren()) {
                this.expandedNodes.put(n, n.isExpanded());
            }
        }
    }

    public void resetExpandedState() {
        for (CategoryNode categoryNode : this.categoryNodes) {
            Boolean state = this.expandedNodes.get(categoryNode);
            if (state == null) continue;
            categoryNode.setExpanded(state);
        }
        for (RepositoryNode repositoryNode : this.repositoryNodes) {
            for (TreeListNode n : repositoryNode.getChildren()) {
                Boolean state = this.expandedNodes.get(n);
                if (state == null) continue;
                n.setExpanded(state.booleanValue());
            }
        }
        this.expandedNodes.clear();
    }

    public void addDashboardSelectionListener(ListSelectionListener listener) {
        this.treeList.addListSelectionListener(listener);
    }

    public void removeDashboardSelectionListener(ListSelectionListener listener) {
        this.treeList.removeListSelectionListener(listener);
    }

    public void addModelListener(TreeListModelListener listener) {
        this.model.addModelListener(listener);
    }

    public void removeModelListener(TreeListModelListener listener) {
        this.model.removeModelListener(listener);
    }

    public void setActiveTaskNode(TreeListNode activeTaskNode) {
        this.activeTaskNode = activeTaskNode;
    }

    public boolean containsActiveTask(TreeListNode parent) {
        if (this.activeTaskNode == null) {
            return false;
        }
        for (TreeListNode activeParent = this.activeTaskNode.getParent(); activeParent != null; activeParent = activeParent.getParent()) {
            if (!parent.equals(activeParent)) continue;
            return true;
        }
        return false;
    }

    public boolean isTaskNodeActive(TaskNode taskNode) {
        return taskNode.equals(this.activeTaskNode);
    }

    boolean isOpened() {
        return this.opened;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.LOCK_CATEGORIES;
        synchronized (object) {
            this.treeList.setModel(EMPTY_MODEL);
            this.model.clear();
            this.opened = false;
        }
    }

    public JComponent getComponent() {
        this.opened = true;
        return this.dashboardComponent;
    }

    public void addTaskToCategory(Category category, TaskNode ... taskNodes) {
        ArrayList<TaskNode> toSelect = new ArrayList<TaskNode>();
        CategoryNode destCategoryNode = this.mapCategoryToNode.get(category);
        for (TaskNode taskNode : taskNodes) {
            TaskNode categorizedTaskNode = this.getCategorizedTask(taskNode);
            if (categorizedTaskNode != null) {
                if (category.equals(categorizedTaskNode.getCategory())) {
                    return;
                }
                taskNode = categorizedTaskNode;
            }
            boolean isCatInFilter = this.isCategoryInFilter(destCategoryNode);
            boolean isTaskInFilter = this.appliedTaskFilters.isInFilter(taskNode);
            TaskNode toAdd = new TaskNode(taskNode.getTask(), (TreeListNode)destCategoryNode);
            if (destCategoryNode.addTaskNode(toAdd, isTaskInFilter)) {
                if (taskNode.isCategorized()) {
                    this.removeTask(taskNode);
                }
                toAdd.setCategory(category);
                if (DashboardViewer.getInstance().isTaskNodeActive(taskNode)) {
                    DashboardViewer.getInstance().setActiveTaskNode((TreeListNode)toAdd);
                }
                toSelect.add(toAdd);
            }
            if (!isTaskInFilter || isCatInFilter) continue;
            this.addCategoryToModel(destCategoryNode);
        }
        destCategoryNode.updateContentAndSelect(toSelect);
        this.storeCategory(category);
    }

    public void removeTask(TaskNode ... taskNodes) {
        HashMap<Category, ArrayList<TaskNode>> map = new HashMap<Category, ArrayList<TaskNode>>();
        for (TaskNode taskNode : taskNodes) {
            ArrayList<TaskNode> tasks = (ArrayList<TaskNode>)map.get(taskNode.getCategory());
            if (tasks == null) {
                tasks = new ArrayList<TaskNode>();
            }
            tasks.add(taskNode);
            map.put(taskNode.getCategory(), tasks);
        }
        for (Map.Entry entry : map.entrySet()) {
            Category category = (Category)entry.getKey();
            List tasks = (List)entry.getValue();
            CategoryNode categoryNode = this.mapCategoryToNode.get(category);
            if (categoryNode == null) {
                LOG.log(Level.WARNING, "categoryNode is null: categoryNode={0}, category={1}", new Object[]{categoryNode, category});
                LOG.log(Level.WARNING, "tasks.size()={0}, tasks:", tasks.size());
                for (TaskNode taskNode : tasks) {
                    LOG.log(Level.WARNING, "taskNode={0}, taskNode.category={2}", new Object[]{taskNode, taskNode.getCategory()});
                }
            }
            boolean isOldInFilter = this.isCategoryInFilter(categoryNode);
            for (TaskNode taskNode : tasks) {
                taskNode.setCategory(null);
                categoryNode.removeTaskNode(taskNode);
            }
            this.model.contentChanged((ListNode)categoryNode);
            if (!this.isCategoryInFilter(categoryNode) && isOldInFilter) {
                this.model.removeRoot((TreeListNode)categoryNode);
            } else {
                categoryNode.updateContent();
            }
            this.storeCategory(categoryNode.getCategory());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Category> getCategories(boolean openedOnly, boolean includeUnsubmitted) {
        Object object = this.LOCK_CATEGORIES;
        synchronized (object) {
            ArrayList<Category> list = new ArrayList<Category>(this.categoryNodes.size());
            for (CategoryNode categoryNode : this.categoryNodes) {
                if (openedOnly && !categoryNode.isOpened() || !includeUnsubmitted && !categoryNode.getCategory().persist()) continue;
                list.add(categoryNode.getCategory());
            }
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Category> preloadCategories() {
        Object object = this.LOCK_CATEGORIES;
        synchronized (object) {
            boolean loadNeeded;
            boolean bl = loadNeeded = !this.categoriesLoaded;
            if (loadNeeded) {
                this.loadCategories();
            }
            ArrayList<Category> list = new ArrayList<Category>(this.categoryNodes.size());
            for (CategoryNode categoryNode : this.categoryNodes) {
                if (!categoryNode.isOpened() || !categoryNode.getCategory().persist()) continue;
                list.add(categoryNode.getCategory());
                if (!loadNeeded) continue;
                categoryNode.getCategory().refresh();
                categoryNode.updateContent();
            }
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCategoryNameUnique(String categoryName) {
        Object object = this.LOCK_CATEGORIES;
        synchronized (object) {
            for (CategoryNode node : this.categoryNodes) {
                if (!node.getCategory().getName().equalsIgnoreCase(categoryName)) continue;
                return false;
            }
            return true;
        }
    }

    public void renameCategory(Category category, final String newName) {
        CategoryNode node = this.mapCategoryToNode.remove(category);
        final String oldName = category.getName();
        category.setName(newName);
        this.mapCategoryToNode.put(category, node);
        this.model.contentChanged((ListNode)node);
        this.REQUEST_PROCESSOR.post(new Runnable(){

            @Override
            public void run() {
                DashboardStorage.getInstance().renameCategory(oldName, newName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCategory(Category category) {
        Object object = this.LOCK_CATEGORIES;
        synchronized (object) {
            CategoryNode newCategoryNode = new CategoryNode(category, false);
            this.categoryNodes.add(newCategoryNode);
            this.mapCategoryToNode.put(category, newCategoryNode);
            this.addCategoryToModel(newCategoryNode);
            this.storeCategory(category);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteCategory(final CategoryNode ... toDelete) {
        String message;
        String names = toDelete.length == 1 ? toDelete[0].getCategory().getName() : toDelete.length + " " + NbBundle.getMessage(DashboardViewer.class, (String)"LBL_Categories").toLowerCase();
        String title = NbBundle.getMessage(DashboardViewer.class, (String)"LBL_DeleteCatTitle");
        if (DashboardUtils.confirmDelete(title, message = NbBundle.getMessage(DashboardViewer.class, (String)"LBL_DeleteCatQuestion", (Object)names))) {
            Object object = this.LOCK_CATEGORIES;
            synchronized (object) {
                for (CategoryNode categoryNode : toDelete) {
                    this.model.removeRoot((TreeListNode)categoryNode);
                    this.categoryNodes.remove(categoryNode);
                    this.mapCategoryToNode.remove(categoryNode.getCategory());
                }
            }
            this.REQUEST_PROCESSOR.post(new Runnable(){

                @Override
                public void run() {
                    String[] names = new String[toDelete.length];
                    for (int i = 0; i < names.length; ++i) {
                        names[i] = toDelete[i].getCategory().getName();
                    }
                    DashboardStorage.getInstance().deleteCategories(names);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCategoryOpened(CategoryNode categoryNode, boolean opened) {
        Object object = this.LOCK_CATEGORIES;
        synchronized (object) {
            this.categoryNodes.remove(categoryNode);
            if (this.isCategoryInFilter(categoryNode)) {
                this.model.removeRoot((TreeListNode)categoryNode);
            }
            Category category = categoryNode.getCategory();
            CategoryNode newNode = opened ? new CategoryNode(category, true) : new ClosedCategoryNode(category);
            this.categoryNodes.add(newNode);
            this.mapCategoryToNode.put(category, newNode);
            if (this.isCategoryInFilter(newNode)) {
                this.addCategoryToModel(newNode);
            }
            this.storeClosedCategories();
        }
    }

    private void addCategoryToModel(CategoryNode categoryNode) {
        int size = this.model.getRootNodes().size();
        boolean added = false;
        for (int index = this.model.getRootNodes().indexOf((Object)this.titleCategoryNode) + 1; index < size; ++index) {
            TreeListNode node = (TreeListNode)this.model.getRootNodes().get(index);
            if (node instanceof CategoryNode) {
                CategoryNode displNode = (CategoryNode)node;
                if (categoryNode.compareTo(displNode) >= 0) continue;
                this.addRootToModel(this.model.getRootNodes().indexOf(node), (TreeListNode)categoryNode);
                added = true;
                break;
            }
            this.addRootToModel(this.model.getRootNodes().indexOf(node), (TreeListNode)categoryNode);
            added = true;
            break;
        }
        if (!added) {
            this.addRootToModel(-1, (TreeListNode)categoryNode);
        }
    }

    private void storeCategory(final Category category) {
        if (!category.persist()) {
            return;
        }
        final ArrayList<TaskEntry> taskEntries = new ArrayList<TaskEntry>(category.getTasks().size());
        for (IssueImpl issue : category.getTasks()) {
            taskEntries.add(new TaskEntry(issue.getID(), issue.getRepositoryImpl().getId()));
        }
        this.REQUEST_PROCESSOR.post(new Runnable(){

            @Override
            public void run() {
                DashboardStorage.getInstance().storeCategory(category.getName(), taskEntries);
            }
        });
    }

    private void storeClosedCategories() {
        final DashboardStorage storage = DashboardStorage.getInstance();
        List<CategoryNode> closed = this.getClosedCategoryNodes();
        final ArrayList<String> names = new ArrayList<String>(closed.size());
        for (CategoryNode categoryNode : closed) {
            names.add(categoryNode.getCategory().getName());
        }
        this.REQUEST_PROCESSOR.post(new Runnable(){

            @Override
            public void run() {
                storage.storeClosedCategories(names);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<CategoryNode> getClosedCategoryNodes() {
        Object object = this.LOCK_CATEGORIES;
        synchronized (object) {
            ArrayList<CategoryNode> closed = new ArrayList<CategoryNode>(this.categoryNodes.size());
            for (CategoryNode categoryNode : this.categoryNodes) {
                if (categoryNode.isOpened()) continue;
                closed.add(categoryNode);
            }
            return closed;
        }
    }

    public void clearCategories() {
        NotifyDescriptor nd = new NotifyDescriptor((Object)NbBundle.getMessage(DashboardViewer.class, (String)"LBL_ClearCatQuestion"), NbBundle.getMessage(DashboardViewer.class, (String)"LBL_ClearCatTitle"), 0, 3, null, NotifyDescriptor.YES_OPTION);
        if (DialogDisplayer.getDefault().notify(nd) == NotifyDescriptor.YES_OPTION) {
            ArrayList<TaskNode> finished = new ArrayList<TaskNode>();
            for (CategoryNode categoryNode : this.categoryNodes) {
                if (!categoryNode.isOpened() || !categoryNode.getCategory().persist()) continue;
                for (TaskNode taskNode : categoryNode.getTaskNodes()) {
                    if (!taskNode.getTask().isFinished()) continue;
                    finished.add(taskNode);
                }
            }
            this.removeTask(finished.toArray(new TaskNode[finished.size()]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRepository(RepositoryImpl repository) {
        Object object = this.LOCK_REPOSITORIES;
        synchronized (object) {
            RepositoryNode repositoryNode = new RepositoryNode(repository);
            this.repositoryNodes.add(repositoryNode);
            this.mapRepositoryToNode.put(repository.getId(), repositoryNode);
            this.addRepositoryToModel(repositoryNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRepository(final RepositoryNode ... toRemove) {
        String message;
        String names = toRemove.length == 1 ? toRemove[0].getRepository().getDisplayName() : toRemove.length + " " + NbBundle.getMessage(DashboardViewer.class, (String)"LBL_Repositories").toLowerCase();
        String title = NbBundle.getMessage(DashboardViewer.class, (String)"LBL_RemoveRepoTitle");
        if (DashboardUtils.confirmDelete(title, message = NbBundle.getMessage(DashboardViewer.class, (String)"LBL_RemoveQuestion", (Object)names))) {
            for (RepositoryNode repositoryNode : toRemove) {
                Object object = this.LOCK_REPOSITORIES;
                synchronized (object) {
                    this.repositoryNodes.remove(repositoryNode);
                    this.mapRepositoryToNode.remove(repositoryNode.getRepository().getId());
                }
                this.model.removeRoot((TreeListNode)repositoryNode);
            }
            this.REQUEST_PROCESSOR.post(new Runnable(){

                @Override
                public void run() {
                    for (RepositoryNode repositoryNode : toRemove) {
                        repositoryNode.getRepository().remove();
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRepositoryOpened(RepositoryNode repositoryNode, boolean opened) {
        Object object = this.LOCK_REPOSITORIES;
        synchronized (object) {
            this.repositoryNodes.remove(repositoryNode);
            if (this.isRepositoryInFilter(repositoryNode)) {
                this.model.removeRoot((TreeListNode)repositoryNode);
            }
            final RepositoryImpl repository = repositoryNode.getRepository();
            RepositoryNode newNode = opened ? new RepositoryNode(repository) : new ClosedRepositoryNode(repository);
            this.repositoryNodes.add(newNode);
            this.mapRepositoryToNode.put(repository.getId(), newNode);
            if (this.isRepositoryInFilter(newNode)) {
                this.addRepositoryToModel(newNode);
            }
            this.storeClosedRepositories();
            this.REQUEST_PROCESSOR.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Map map = DashboardViewer.this.mapRepositoryToUnsubmittedNode;
                    synchronized (map) {
                        DashboardViewer.this.updateCategoryNode((CategoryNode)DashboardViewer.this.mapRepositoryToUnsubmittedNode.get(repository));
                    }
                }
            });
        }
    }

    public void deleteQuery(QueryNode ... toDelete) {
        String message;
        String names = "";
        for (int i = 0; i < toDelete.length; ++i) {
            QueryNode queryNode = toDelete[i];
            names = names + queryNode.getQuery().getDisplayName();
            if (i == toDelete.length - 1) continue;
            names = names + ", ";
        }
        String title = NbBundle.getMessage(DashboardViewer.class, (String)"LBL_DeleteQueryTitle");
        if (DashboardUtils.confirmDelete(title, message = NbBundle.getMessage(DashboardViewer.class, (String)"LBL_DeleteQueryQuestion", (Object)names))) {
            for (QueryNode queryNode : toDelete) {
                queryNode.getQuery().remove();
            }
        }
    }

    private void addRepositoryToModel(RepositoryNode repositoryNode) {
        int size = this.model.getRootNodes().size();
        boolean added = false;
        for (int index = this.model.getRootNodes().indexOf((Object)this.titleRepositoryNode) + 1; index < size; ++index) {
            TreeListNode node = (TreeListNode)this.model.getRootNodes().get(index);
            if (node instanceof RepositoryNode) {
                RepositoryNode displNode = (RepositoryNode)node;
                if (repositoryNode.compareTo(displNode) >= 0) continue;
                this.addRootToModel(this.model.getRootNodes().indexOf(node), (TreeListNode)repositoryNode);
                added = true;
                break;
            }
            this.addRootToModel(this.model.getRootNodes().indexOf(node), (TreeListNode)repositoryNode);
            added = true;
            break;
        }
        if (!added) {
            this.addRootToModel(-1, (TreeListNode)repositoryNode);
        }
    }

    private void storeClosedRepositories() {
        final DashboardStorage storage = DashboardStorage.getInstance();
        List<RepositoryNode> closed = this.getClosedRepositoryNodes();
        final ArrayList<String> ids = new ArrayList<String>(closed.size());
        for (RepositoryNode repositoryNode : closed) {
            ids.add(repositoryNode.getRepository().getId());
        }
        this.REQUEST_PROCESSOR.post(new Runnable(){

            @Override
            public void run() {
                storage.storeClosedRepositories(ids);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<RepositoryNode> getClosedRepositoryNodes() {
        Object object = this.LOCK_REPOSITORIES;
        synchronized (object) {
            ArrayList<RepositoryNode> closed = new ArrayList<RepositoryNode>(this.repositoryNodes.size());
            for (RepositoryNode repositoryNode : this.repositoryNodes) {
                if (repositoryNode.isOpened()) continue;
                closed.add(repositoryNode);
            }
            return closed;
        }
    }

    public AppliedFilters<TaskNode> getAppliedTaskFilters() {
        return this.appliedTaskFilters;
    }

    public int updateTaskFilter(DashboardFilter<TaskNode> oldFilter, DashboardFilter<TaskNode> newFilter) {
        if (oldFilter != null) {
            this.appliedTaskFilters.removeFilter(oldFilter);
        }
        return this.applyTaskFilter(newFilter, true);
    }

    public int applyTaskFilter(DashboardFilter<TaskNode> taskFilter, boolean refresh) {
        this.appliedTaskFilters.addFilter(taskFilter);
        return this.manageApplyFilter(refresh);
    }

    public int removeTaskFilter(DashboardFilter<TaskNode> taskFilter, boolean refresh) {
        this.appliedTaskFilters.removeFilter(taskFilter);
        return this.manageRemoveFilter(refresh, taskFilter.expandNodes());
    }

    public int updateCategoryFilter(DashboardFilter<CategoryNode> filter) {
        if (filter != null) {
            this.appliedCategoryFilters.removeFilter(filter);
        }
        return this.applyCategoryFilter(filter, true);
    }

    public int applyCategoryFilter(DashboardFilter<CategoryNode> categoryFilter, boolean refresh) {
        this.appliedCategoryFilters.addFilter(categoryFilter);
        return this.manageApplyFilter(refresh);
    }

    public int removeCategoryFilter(DashboardFilter<CategoryNode> categoryFilter, boolean refresh) {
        this.appliedCategoryFilters.removeFilter(categoryFilter);
        return this.manageRemoveFilter(refresh, categoryFilter.expandNodes());
    }

    public int applyRepositoryFilter(DashboardFilter<RepositoryNode> repositoryFilter, boolean refresh) {
        this.appliedRepositoryFilters.addFilter(repositoryFilter);
        return this.manageApplyFilter(refresh);
    }

    public int removeRepositoryFilter(DashboardFilter<RepositoryNode> repositoryFilter, boolean refresh) {
        this.appliedRepositoryFilters.removeFilter(repositoryFilter);
        return this.manageRemoveFilter(refresh, repositoryFilter.expandNodes());
    }

    public void clearFilters() {
        this.appliedCategoryFilters.clear();
        this.appliedRepositoryFilters.clear();
        this.appliedTaskFilters.clear();
    }

    private int manageRemoveFilter(boolean refresh, boolean wasForceExpand) {
        if (refresh) {
            this.taskHits = 0;
            this.updateContent(false);
            return this.taskHits;
        }
        return -1;
    }

    private int manageApplyFilter(boolean refresh) {
        if (refresh) {
            this.taskHits = 0;
            this.updateContent(false);
            return this.taskHits;
        }
        return -1;
    }

    public boolean expandNodes() {
        return this.appliedTaskFilters.expandNodes() || this.appliedCategoryFilters.expandNodes() || this.appliedRepositoryFilters.expandNodes();
    }

    public boolean showHitCount() {
        return this.appliedTaskFilters.showHitCount() || this.appliedCategoryFilters.showHitCount() || this.appliedRepositoryFilters.showHitCount();
    }

    public boolean isNodeExpanded(TreeListNode node) {
        if (this.expandNodes()) {
            return true;
        }
        Boolean state = this.expandedNodes.get(node);
        return state != null ? state : false;
    }

    public List<TreeListNode> getSelectedNodes() {
        Object[] selectedValues;
        ArrayList<TreeListNode> nodes = new ArrayList<TreeListNode>();
        for (Object object : selectedValues = this.treeList.getSelectedValues()) {
            nodes.add((TreeListNode)object);
        }
        return nodes;
    }

    public void loadData() {
        this.removeErrorNodes();
        this.REQUEST_PROCESSOR.post(new Runnable(){

            @Override
            public void run() {
                DashboardViewer.this.titleRepositoryNode.setProgressVisible(true);
                DashboardViewer.this.titleCategoryNode.setProgressVisible(true);
                Callable<Void> c = new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        DashboardViewer.this.loadRepositories();
                        DashboardViewer.this.titleRepositoryNode.setProgressVisible(false);
                        DashboardViewer.this.loadCategories();
                        DashboardViewer.this.titleCategoryNode.setProgressVisible(false);
                        DashboardRefresher refresher = DashboardRefresher.getInstance();
                        refresher.setupDashboardRefresh();
                        refresher.setupScheduleRefresh();
                        NotificationManager.getInstance().showNotifications();
                        return null;
                    }
                };
                ProjectServices projectServices = BugtrackingManager.getInstance().getProjectServices();
                try {
                    if (projectServices != null) {
                        projectServices.runAfterProjectOpenFinished((Callable)c);
                    } else {
                        c.call();
                    }
                }
                catch (Exception ex) {
                    BugtrackingManager.LOG.log(Level.WARNING, null, ex);
                }
            }
        });
    }

    private void removeErrorNodes() {
        if (this.model.getRootNodes().contains((Object)this.errorCategories)) {
            this.model.removeRoot((TreeListNode)this.errorCategories);
        }
        if (this.model.getRootNodes().contains((Object)this.errorRepositories)) {
            this.model.removeRoot((TreeListNode)this.errorRepositories);
        }
    }

    private void loadCategories() {
        if (this.categoriesLoaded) {
            return;
        }
        try {
            DashboardStorage storage = DashboardStorage.getInstance();
            List<CategoryEntry> categoryEntries = storage.readCategories();
            List<String> names = storage.readClosedCategories();
            ArrayList<CategoryNode> catNodes = new ArrayList<CategoryNode>(categoryEntries.size());
            for (CategoryEntry categoryEntry : categoryEntries) {
                boolean open;
                boolean bl = open = !names.contains(categoryEntry.getCategoryName());
                if (open) {
                    catNodes.add(new CategoryNode(new Category(categoryEntry.getCategoryName()), true));
                    continue;
                }
                catNodes.add(new ClosedCategoryNode(new Category(categoryEntry.getCategoryName())));
            }
            catNodes.addAll(this.loadScheduledCategories());
            catNodes.add(this.getRecentCategoryNode());
            catNodes.addAll(this.loadUnsubmitedCategories());
            this.setCategories(catNodes);
            this.categoriesLoaded = true;
        }
        catch (Throwable ex) {
            LOG.log(Level.WARNING, "Categories loading failed due to: {0}", ex);
            this.categoriesLoaded = false;
            this.showCategoriesError();
        }
    }

    private CategoryNode getRecentCategoryNode() {
        RecentCategory recentCategory = new RecentCategory();
        RecentCategoryNode recentCategoryNode = new RecentCategoryNode(recentCategory);
        return recentCategoryNode;
    }

    private List<CategoryNode> loadScheduledCategories() {
        ArrayList<CategoryNode> catNodes = new ArrayList<CategoryNode>();
        ScheduleCategory todayCat = new ScheduleCategory(NbBundle.getMessage(DashboardViewer.class, (String)"LBL_Today"), DashboardUtils.getToday(), 1);
        this.todayCategoryNode = new ScheduleCategoryNode(todayCat);
        catNodes.add(this.todayCategoryNode);
        ScheduleCategory thisWeekCat = new ScheduleCategory(NbBundle.getMessage(DashboardViewer.class, (String)"LBL_ThisWeek"), DashboardUtils.getThisWeek(), 2);
        this.thisWeekCategoryNode = new ScheduleCategoryNode(thisWeekCat);
        catNodes.add(this.thisWeekCategoryNode);
        ScheduleCategory allCat = new ScheduleCategory(NbBundle.getMessage(DashboardViewer.class, (String)"LBL_All"), DashboardUtils.getAll(), 10);
        ScheduleCategoryNode all = new ScheduleCategoryNode(allCat);
        catNodes.add(all);
        return catNodes;
    }

    public void updateScheduleCategories() {
        ScheduleCategory today = (ScheduleCategory)this.todayCategoryNode.getCategory();
        today.setScheduleInfo(DashboardUtils.getToday());
        this.todayCategoryNode.updateContent();
        ScheduleCategory thisWeek = (ScheduleCategory)this.thisWeekCategoryNode.getCategory();
        thisWeek.setScheduleInfo(DashboardUtils.getThisWeek());
        this.thisWeekCategoryNode.updateContent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<CategoryNode> loadUnsubmitedCategories() {
        Collection<RepositoryImpl> allRepositories = DashboardUtils.getRepositories();
        ArrayList<CategoryNode> catNodes = new ArrayList<CategoryNode>(allRepositories.size());
        Map<RepositoryImpl, UnsubmittedCategoryNode> map = this.mapRepositoryToUnsubmittedNode;
        synchronized (map) {
            this.mapRepositoryToUnsubmittedNode.clear();
            for (RepositoryImpl repository : allRepositories) {
                UnsubmittedCategoryNode unsubmittedCategoryNode = this.createUnsubmittedCategoryNode(repository);
                this.mapRepositoryToUnsubmittedNode.put(repository, unsubmittedCategoryNode);
                catNodes.add(unsubmittedCategoryNode);
            }
        }
        return catNodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateUnsubmitedCategories(List<RepositoryNode> toRemove, List<RepositoryNode> toAdd) {
        Object object = this.LOCK_CATEGORIES;
        synchronized (object) {
            for (RepositoryNode repositoryNode : toRemove) {
                Map<RepositoryImpl, UnsubmittedCategoryNode> map = this.mapRepositoryToUnsubmittedNode;
                synchronized (map) {
                    CategoryNode categoryNode = this.mapRepositoryToUnsubmittedNode.remove(repositoryNode.getRepository());
                    this.mapCategoryToNode.remove(categoryNode.getCategory());
                    this.categoryNodes.remove(categoryNode);
                    this.model.removeRoot((TreeListNode)categoryNode);
                }
            }
            for (RepositoryNode newRepository : toAdd) {
                UnsubmittedCategoryNode categoryNode = this.createUnsubmittedCategoryNode(newRepository.getRepository());
                Map<RepositoryImpl, UnsubmittedCategoryNode> map = this.mapRepositoryToUnsubmittedNode;
                synchronized (map) {
                    this.mapRepositoryToUnsubmittedNode.put(newRepository.getRepository(), categoryNode);
                    this.mapCategoryToNode.put(categoryNode.getCategory(), categoryNode);
                    this.categoryNodes.add(categoryNode);
                    if (this.isCategoryInFilter(categoryNode)) {
                        this.addCategoryToModel(categoryNode);
                    }
                }
            }
        }
    }

    public void updateCategoryNode(CategoryNode node) {
        boolean isInModel = this.model.getRootNodes().contains(node);
        boolean categoryInFilter = this.isCategoryInFilter(node);
        if (categoryInFilter && !isInModel) {
            this.addCategoryToModel(node);
        } else if (!categoryInFilter && isInModel) {
            this.model.removeRoot((TreeListNode)node);
        }
    }

    private UnsubmittedCategoryNode createUnsubmittedCategoryNode(RepositoryImpl repository) {
        UnsubmittedCategory unsubmittedCategory = new UnsubmittedCategory(repository);
        UnsubmittedCategoryNode unsubmittedCategoryNode = new UnsubmittedCategoryNode((Category)unsubmittedCategory, repository);
        unsubmittedCategoryNode.updateContent();
        return unsubmittedCategoryNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCategories() {
        Object object = this.LOCK_CATEGORIES;
        synchronized (object) {
            for (CategoryNode categoryNode : this.categoryNodes) {
                categoryNode.getCategory().reload();
                categoryNode.updateContent();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRepositories(Collection<RepositoryImpl> addedRepositories, Collection<RepositoryImpl> removedRepositories) {
        Object object = this.LOCK_REPOSITORIES;
        synchronized (object) {
            ArrayList<RepositoryNode> toAdd = new ArrayList<RepositoryNode>();
            ArrayList<RepositoryNode> toRemove = new ArrayList<RepositoryNode>();
            if (removedRepositories != null) {
                for (RepositoryNode oldRepository : this.repositoryNodes) {
                    if (!removedRepositories.contains(oldRepository.getRepository())) continue;
                    toRemove.add(oldRepository);
                }
            }
            if (addedRepositories != null) {
                List<RepositoryImpl> oldValue = this.getRepositories(false);
                for (RepositoryImpl addedRepository : addedRepositories) {
                    if (oldValue.contains(addedRepository)) continue;
                    toAdd.add(this.createRepositoryNode(addedRepository));
                }
            }
            this.updateRepositories((List<RepositoryNode>)toRemove, (List<RepositoryNode>)toAdd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRepositories(Collection<RepositoryImpl> repositories) {
        Object object = this.LOCK_REPOSITORIES;
        synchronized (object) {
            ArrayList<RepositoryNode> toAdd = new ArrayList<RepositoryNode>();
            ArrayList<RepositoryNode> toRemove = new ArrayList<RepositoryNode>();
            for (RepositoryNode oldRepository : this.repositoryNodes) {
                if (repositories.contains(oldRepository.getRepository())) continue;
                toRemove.add(oldRepository);
            }
            List<RepositoryImpl> oldValue = this.getRepositories(false);
            for (RepositoryImpl newRepository : repositories) {
                if (oldValue.contains(newRepository)) continue;
                toAdd.add(this.createRepositoryNode(newRepository));
            }
            this.updateRepositories((List<RepositoryNode>)toRemove, (List<RepositoryNode>)toAdd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRepositories(List<RepositoryNode> toRemove, List<RepositoryNode> toAdd) {
        Object object = this.LOCK_REPOSITORIES;
        synchronized (object) {
            this.repositoryNodes.removeAll(toRemove);
            this.mapRepositoryToNode.keySet().removeAll(toRemove);
            for (RepositoryNode repositoryNode : toRemove) {
                this.model.removeRoot((TreeListNode)repositoryNode);
            }
            for (RepositoryNode newRepository : toAdd) {
                this.repositoryNodes.add(newRepository);
                this.mapRepositoryToNode.put(newRepository.getRepository().getId(), newRepository);
                if (!this.isRepositoryInFilter(newRepository)) continue;
                this.addRepositoryToModel(newRepository);
            }
        }
        this.updateUnsubmitedCategories(toRemove, toAdd);
        this.updateCategories();
    }

    private RepositoryNode createRepositoryNode(RepositoryImpl repository) {
        boolean open = DashboardUtils.isRepositoryOpened(repository.getId());
        if (open) {
            return new RepositoryNode(repository);
        }
        return new ClosedRepositoryNode(repository);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RepositoryImpl> getRepositories(boolean openedOnly) {
        Object object = this.LOCK_REPOSITORIES;
        synchronized (object) {
            ArrayList<RepositoryImpl> repositories = new ArrayList<RepositoryImpl>();
            for (RepositoryNode repositoryNode : this.repositoryNodes) {
                if (openedOnly && !repositoryNode.isOpened()) continue;
                repositories.add(repositoryNode.getRepository());
            }
            return repositories;
        }
    }

    public RequestProcessor getRequestProcessor() {
        return this.REQUEST_PROCESSOR;
    }

    private void loadRepositories() {
        try {
            Collection<RepositoryImpl> allRepositories = DashboardUtils.getRepositories();
            ArrayList<RepositoryNode> repoNodes = new ArrayList<RepositoryNode>(allRepositories.size());
            for (RepositoryImpl repository : allRepositories) {
                boolean open = DashboardUtils.isRepositoryOpened(repository.getId());
                if (open) {
                    repoNodes.add(new RepositoryNode(repository));
                    continue;
                }
                repoNodes.add(new ClosedRepositoryNode(repository));
            }
            this.setRepositories(repoNodes);
        }
        catch (Throwable ex) {
            LOG.log(Level.WARNING, "Repositories loading failed due to: {0}", ex);
            this.showRepositoriesError();
        }
    }

    private void showRepositoriesError() {
        int index = this.model.getRootNodes().indexOf((Object)this.titleRepositoryNode) + 1;
        this.model.addRoot(index, (TreeListNode)this.errorRepositories);
    }

    private void showCategoriesError() {
        int index = this.model.getRootNodes().indexOf((Object)this.titleCategoryNode) + 1;
        this.model.addRoot(index, (TreeListNode)this.errorCategories);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TaskNode getCategorizedTask(TaskNode taskNode) {
        Object object = this.LOCK_CATEGORIES;
        synchronized (object) {
            for (CategoryNode categoryNode : this.categoryNodes) {
                TaskNode catTaskNode;
                int index = categoryNode.indexOf(taskNode.getTask());
                if (index == -1 || (catTaskNode = categoryNode.getTaskNodes().get(index)) == null || catTaskNode.getCategory() == null) continue;
                return catTaskNode;
            }
            return null;
        }
    }

    private void addRootToModel(int index, TreeListNode node) {
        this.model.addRoot(index, node);
    }

    private void removeRootFromModel(TreeListNode node) {
        this.model.removeRoot(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateContent(boolean initPaging) {
        Object object = this.LOCK_CATEGORIES;
        synchronized (object) {
            for (CategoryNode categoryNode : this.categoryNodes) {
                if (initPaging) {
                    categoryNode.initPaging();
                }
                categoryNode.updateContent();
            }
            this.setCategories(this.categoryNodes);
        }
        object = this.LOCK_REPOSITORIES;
        synchronized (object) {
            for (RepositoryNode repositoryNode : this.repositoryNodes) {
                repositoryNode.updateContent(initPaging);
            }
            this.setRepositories(this.repositoryNodes);
        }
    }

    private List<CategoryNode> filterCategories(List<CategoryNode> allCategories) {
        this.mapCategoryToNode.clear();
        ArrayList<CategoryNode> filtered = new ArrayList<CategoryNode>();
        for (CategoryNode categoryNode : allCategories) {
            this.mapCategoryToNode.put(categoryNode.getCategory(), categoryNode);
            if (!this.isCategoryInFilter(categoryNode)) continue;
            this.taskHits += categoryNode.getFilteredTaskCount();
            filtered.add(categoryNode);
        }
        return filtered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCategories(List<CategoryNode> catNodes) {
        Object object = this.LOCK_CATEGORIES;
        synchronized (object) {
            this.removeNodesFromModel(CategoryNode.class);
            this.categoryNodes = catNodes;
            Collections.sort(this.categoryNodes);
            List<CategoryNode> filterCategories = this.filterCategories(this.categoryNodes);
            int index = this.model.getRootNodes().indexOf((Object)this.titleCategoryNode) + 1;
            for (CategoryNode categoryNode : filterCategories) {
                this.addRootToModel(index++, (TreeListNode)categoryNode);
            }
        }
    }

    private List<RepositoryNode> filterRepositories(List<RepositoryNode> allRepositories) {
        this.mapRepositoryToNode.clear();
        ArrayList<RepositoryNode> filtered = new ArrayList<RepositoryNode>();
        for (RepositoryNode repositoryNode : allRepositories) {
            this.mapRepositoryToNode.put(repositoryNode.getRepository().getId(), repositoryNode);
            if (!this.isRepositoryInFilter(repositoryNode)) continue;
            this.taskHits += repositoryNode.getFilterHits();
            filtered.add(repositoryNode);
        }
        return filtered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setRepositories(List<RepositoryNode> repoNodes) {
        Object object = this.LOCK_REPOSITORIES;
        synchronized (object) {
            this.removeNodesFromModel(RepositoryNode.class);
            this.repositoryNodes = repoNodes;
            Collections.sort(this.repositoryNodes);
            List<RepositoryNode> filterRepositories = this.filterRepositories(this.repositoryNodes);
            int index = this.model.getRootNodes().indexOf((Object)this.titleRepositoryNode) + 1;
            for (RepositoryNode repositoryNode : filterRepositories) {
                this.addRootToModel(index++, (TreeListNode)repositoryNode);
            }
        }
    }

    private boolean isCategoryInFilter(CategoryNode categoryNode) {
        return this.expandNodes() ? categoryNode.getFilteredTaskCount() > 0 && this.appliedCategoryFilters.isInFilter(categoryNode) : this.appliedCategoryFilters.isInFilter(categoryNode);
    }

    private boolean isRepositoryInFilter(RepositoryNode repositoryNode) {
        return this.expandNodes() ? repositoryNode.getFilteredQueryCount() > 0 && this.appliedRepositoryFilters.isInFilter(repositoryNode) : this.appliedRepositoryFilters.isInFilter(repositoryNode);
    }

    private void removeNodesFromModel(Class nodeClass) {
        ArrayList<TreeListNode> nodesToRemove = new ArrayList<TreeListNode>();
        for (TreeListNode root : this.model.getRootNodes()) {
            if (root == null || !nodeClass.isAssignableFrom(root.getClass())) continue;
            nodesToRemove.add(root);
        }
        for (TreeListNode node : nodesToRemove) {
            this.removeRootFromModel(node);
        }
    }

    private void attachActions() {
        this.treeList.getInputMap(1).put(Actions.REFRESH_KEY, "org.netbeans.modules.tasks.ui.action.Action.UniversalRefreshAction");
        this.treeList.getActionMap().put("org.netbeans.modules.tasks.ui.action.Action.UniversalRefreshAction", new Actions.UniversalRefreshAction());
        this.treeList.getInputMap(1).put(Actions.DELETE_KEY, "org.netbeans.modules.tasks.ui.action.Action.UniversalDeleteAction");
        this.treeList.getActionMap().put("org.netbeans.modules.tasks.ui.action.Action.UniversalDeleteAction", new Actions.UniversalDeleteAction());
    }

    private void handleSelection(TreeListNode node) {
        int indexOfNode;
        ListSelectionModel selectionModel = this.treeList.getSelectionModel();
        List children = node.getChildren();
        int childrenSize = children.size();
        this.removeChildrenSelection(children);
        if (!selectionModel.isSelectionEmpty() && (selectionModel.isSelectedIndex(indexOfNode = this.model.getAllNodes().indexOf(node)) || selectionModel.isSelectedIndex(indexOfNode + childrenSize + 1))) {
            int maxSelectionIndex;
            int minSelectionIndex = selectionModel.getMinSelectionIndex();
            if (minSelectionIndex == (maxSelectionIndex = selectionModel.getMaxSelectionIndex())) {
                selectionModel.setSelectionInterval(minSelectionIndex, maxSelectionIndex);
            } else {
                ArrayList<Integer> selectedIndexes = new ArrayList<Integer>(maxSelectionIndex - minSelectionIndex + 1);
                for (int i = minSelectionIndex; i <= maxSelectionIndex; ++i) {
                    if (!selectionModel.isSelectedIndex(i)) continue;
                    selectedIndexes.add(i);
                }
                selectionModel.clearSelection();
                Iterator i$ = selectedIndexes.iterator();
                while (i$.hasNext()) {
                    int index = (Integer)i$.next();
                    selectionModel.addSelectionInterval(index, index);
                }
            }
        }
    }

    private void removeChildrenSelection(List<TreeListNode> children) {
        if (children.isEmpty()) {
            return;
        }
        List allNodes = this.model.getAllNodes();
        int firstIndex = allNodes.indexOf(children.get(0));
        int lastIndex = allNodes.indexOf(children.get(children.size() - 1));
        this.treeList.getSelectionModel().removeSelectionInterval(firstIndex, lastIndex);
    }

    private class ModelListener
    implements TreeListModelListener {
        private ModelListener() {
        }

        public void nodeExpanded(TreeListNode node) {
            DashboardViewer.this.handleSelection(node);
        }
    }

    private static class Holder {
        private static final DashboardViewer theInstance = new DashboardViewer();

        private Holder() {
        }
    }
}

