/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.common.api;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.editor.NbEditorDocument;
import org.netbeans.spi.lexer.MutableTextInput;
import org.openide.util.Parameters;

public class LexerUtils {
    public static void rebuildTokenHierarchy(final Document doc) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NbEditorDocument nbdoc = (NbEditorDocument)doc;
                nbdoc.runAtomic(new Runnable(){

                    @Override
                    public void run() {
                        MutableTextInput mti = (MutableTextInput)doc.getProperty(MutableTextInput.class);
                        if (mti != null) {
                            mti.tokenHierarchyControl().rebuild();
                        }
                    }
                });
            }
        });
    }

    public static int getLineOffset(CharSequence text, int offset) throws BadLocationException {
        if (text == null) {
            throw new NullPointerException();
        }
        if (offset < 0 || offset > text.length()) {
            throw new BadLocationException("The given offset is out of bounds <0, " + text.length() + ">", offset);
        }
        int line = 0;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '\r') {
                throw new IllegalArgumentException("The input text cannot contain carriage return char \\r");
            }
            if (i == offset) {
                return line;
            }
            if (c != '\n') continue;
            ++line;
        }
        return line;
    }

    public static int getLineBeginningOffset(CharSequence text, int line) throws BadLocationException {
        if (text == null) {
            throw new NullPointerException();
        }
        if (line < 0) {
            throw new IllegalArgumentException("Line number must be >= 0!");
        }
        int linecount = 0;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '\r') {
                throw new IllegalArgumentException("The input text cannot contain carriage return char \\r");
            }
            if (linecount == line) {
                return i;
            }
            if (c != '\n') continue;
            ++linecount;
        }
        return text.length();
    }

    public static int[] findLineBoundaries(CharSequence text, int offset) {
        int max;
        int min;
        int l = text.length();
        if (offset == -1 || offset > l) {
            return null;
        }
        if (offset == l && l >= 1 && text.charAt(l - 1) == '\n') {
            return new int[]{l - 1, l};
        }
        for (min = offset; min > 1 && text.charAt(min - 1) != '\n'; --min) {
        }
        for (max = offset; max < l && text.charAt(max) != '\n'; ++max) {
        }
        return new int[]{min, max};
    }

    public static Token followsToken(TokenSequence ts, TokenId searchedId, boolean backwards, boolean repositionBack, TokenId ... skipIds) {
        return LexerUtils.followsToken(ts, Collections.singletonList(searchedId), backwards, repositionBack, skipIds);
    }

    public static Token followsToken(TokenSequence ts, Collection<? extends TokenId> searchedIds, boolean backwards, boolean repositionBack, TokenId ... skipIds) {
        return LexerUtils.followsToken(ts, searchedIds, backwards, repositionBack, false, skipIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Token followsToken(TokenSequence ts, Collection<? extends TokenId> searchedIds, boolean backwards, boolean repositionBack, boolean includeCurrentToken, TokenId ... skipIds) {
        List<TokenId> skip = Arrays.asList(skipIds);
        int index = ts.index();
        try {
            while (includeCurrentToken || (backwards ? ts.movePrevious() : ts.moveNext())) {
                includeCurrentToken = false;
                Token token = ts.token();
                TokenId id = token.id();
                if (searchedIds.contains(id)) {
                    Token token2 = token;
                    return token2;
                }
                if (skip.contains(id)) continue;
                break;
            }
        }
        finally {
            if (repositionBack) {
                int idx = ts.moveIndex(index);
                boolean moved = ts.moveNext();
                assert (idx == 0 && moved);
            }
        }
        return null;
    }

    public static TokenSequence getJoinedTokenSequence(Document doc, int offset, Language language) {
        return LexerUtils.getTokenSequence(doc, offset, language, true);
    }

    public static TokenSequence getTokenSequence(Document doc, int offset, Language language, boolean joined) {
        return LexerUtils.getTokenSequence(TokenHierarchy.get((Document)doc), offset, language, joined);
    }

    public static TokenSequence getTokenSequence(TokenHierarchy th, int offset, Language language, boolean joined) {
        TokenSequence ts = th.tokenSequence();
        if (ts == null) {
            return null;
        }
        ts.move(offset);
        while (ts.moveNext() || ts.movePrevious()) {
            if (ts.language() == language) {
                return ts;
            }
            if ((ts = ts.embeddedJoined()) == null) break;
            ts.move(offset);
        }
        return null;
    }

    public static CharSequence trim(CharSequence chs) {
        char c;
        char c2;
        if (chs == null) {
            throw new NullPointerException();
        }
        if (chs.length() == 0) {
            return chs;
        }
        int wsPrefixLen = 0;
        for (int i = 0; i < chs.length() && Character.isWhitespace(c2 = chs.charAt(i)); ++i) {
            ++wsPrefixLen;
        }
        int wsPostfixLen = 0;
        for (int i = chs.length() - 1; i >= wsPrefixLen && Character.isWhitespace(c = chs.charAt(i)); --i) {
            ++wsPostfixLen;
        }
        return chs.subSequence(wsPrefixLen, chs.length() - wsPostfixLen);
    }

    public static boolean equals(CharSequence text1, CharSequence text2, boolean ignoreCase, boolean optimized) {
        Parameters.notNull((CharSequence)"text1", (Object)text1);
        Parameters.notNull((CharSequence)"text2", (Object)text2);
        if (text1.length() != text2.length()) {
            return false;
        }
        for (int i = 0; i < text1.length(); ++i) {
            char ch2;
            char ch1 = ignoreCase && !optimized ? Character.toLowerCase(text1.charAt(i)) : text1.charAt(i);
            char c = ch2 = ignoreCase ? Character.toLowerCase(text2.charAt(i)) : text2.charAt(i);
            if (ch1 == ch2) continue;
            return false;
        }
        return true;
    }

    public static boolean startsWith(CharSequence text1, CharSequence prefix, boolean ignoreCase, boolean optimized) {
        if (text1.length() < prefix.length()) {
            return false;
        }
        return LexerUtils.equals(text1.subSequence(0, prefix.length()), prefix, ignoreCase, optimized);
    }

    public static boolean endsWith(CharSequence text1, CharSequence prefix, boolean ignoreCase, boolean optimized) {
        if (text1.length() < prefix.length()) {
            return false;
        }
        return LexerUtils.equals(text1.subSequence(text1.length() - prefix.length(), text1.length()), prefix, ignoreCase, optimized);
    }
}

