/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.common.sourcemap;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.json.simple.parser.ParseException;
import org.netbeans.modules.web.common.sourcemap.Mapping;
import org.netbeans.modules.web.common.sourcemap.MappingTokenizer;

public class SourceMap {
    private static final String SUPPORTED_VERSION = "3";
    private static final Map<String, SourceMap> cache = new WeakHashMap<String, SourceMap>();
    private JSONObject sourceMap;
    private final Map<Integer, List<Mapping>> mappings = new HashMap<Integer, List<Mapping>>();
    private final String sourceRoot;

    public static SourceMap parse(String sourceMap) throws IllegalArgumentException {
        SourceMap map = cache.get(sourceMap);
        if (map == null) {
            map = new SourceMap(sourceMap);
            cache.put(sourceMap, map);
        }
        return map;
    }

    private SourceMap(String sourceMap) {
        this(SourceMap.toJSONObject(sourceMap));
    }

    private SourceMap(JSONObject sourceMap) {
        String version;
        this.sourceMap = sourceMap;
        Object versionValue = sourceMap.get((Object)"version");
        String string = version = versionValue == null ? null : versionValue.toString();
        if (!SUPPORTED_VERSION.equals(version)) {
            throw new IllegalArgumentException("Unsupported version of the source map: " + version);
        }
        String mappingInfo = (String)sourceMap.get((Object)"mappings");
        MappingTokenizer tokenizer = new MappingTokenizer(mappingInfo);
        int line = 0;
        ArrayList<Mapping> lineInfo = null;
        for (Mapping mapping : tokenizer) {
            if (mapping == Mapping.NEW_LINE) {
                if (lineInfo != null) {
                    this.mappings.put(line, lineInfo);
                    lineInfo = null;
                }
                ++line;
                continue;
            }
            if (lineInfo == null) {
                lineInfo = new ArrayList<Mapping>();
            }
            lineInfo.add(mapping);
        }
        if (lineInfo != null) {
            this.mappings.put(line, lineInfo);
        }
        this.sourceRoot = (String)sourceMap.get((Object)"sourceRoot");
    }

    public String getSourcePath(int sourceIndex) {
        JSONArray sources = (JSONArray)this.sourceMap.get((Object)"sources");
        String source = (String)sources.get(sourceIndex);
        if (this.sourceRoot != null && !this.sourceRoot.isEmpty()) {
            return this.sourceRoot + File.separator + source;
        }
        return source;
    }

    public String getName(int nameIndex) {
        JSONArray names = (JSONArray)this.sourceMap.get((Object)"names");
        return (String)names.get(nameIndex);
    }

    public Mapping findMapping(int line, int column) {
        Mapping result = null;
        List<Mapping> lineInfo = this.mappings.get(line);
        if (lineInfo != null) {
            for (Mapping mapping : lineInfo) {
                if (mapping.getColumn() > column) break;
                result = mapping;
            }
        }
        return result;
    }

    public Mapping findMapping(int line) {
        Mapping result = null;
        List<Mapping> lineInfo = this.mappings.get(line);
        if (lineInfo != null && !lineInfo.isEmpty()) {
            result = lineInfo.get(0);
        }
        return result;
    }

    private static JSONObject toJSONObject(String text) throws IllegalArgumentException {
        try {
            JSONObject json = (JSONObject)JSONValue.parseWithException((String)text);
            return json;
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException(text);
        }
    }
}

