/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject;

import java.awt.Image;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.modules.web.clientproject.api.util.StringUtilities;
import org.netbeans.modules.web.clientproject.createprojectapi.ClientSideProjectGenerator;
import org.netbeans.modules.web.clientproject.createprojectapi.CreateProjectProperties;
import org.netbeans.modules.web.common.api.UsageLogger;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.project.ui.ProjectConvertor;
import org.netbeans.spi.project.ui.support.ProjectConvertors;
import org.openide.filesystems.FileObject;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;

public final class ClientSideProjectConvertor
implements ProjectConvertor {
    private static final Logger LOGGER = Logger.getLogger(ClientSideProjectConvertor.class.getName());
    private static final String[] JSON_FILES = new String[]{"package.json", "bower.json"};

    public ProjectConvertor.Result isProject(FileObject projectDirectory) {
        assert (projectDirectory != null);
        String displayName = null;
        String fileName = null;
        for (String jsonFile : JSON_FILES) {
            FileObject file = projectDirectory.getFileObject(jsonFile);
            if (file == null) continue;
            fileName = file.getNameExt();
            displayName = this.getDisplayName(file);
            if (StringUtilities.hasText((String)displayName)) break;
        }
        assert (fileName != null) : this.getChildrenNames(projectDirectory);
        if (!StringUtilities.hasText(displayName)) {
            displayName = projectDirectory.getNameExt();
        }
        Lookup transientLkp = ProjectConvertors.createProjectConvertorLookup((Object[])new Object[]{new ConvertorClassPathProvider(), ProjectConvertors.createFileEncodingQuery()});
        return new ProjectConvertor.Result(transientLkp, (Callable)new Factory(projectDirectory, displayName, (Closeable)transientLkp, fileName), displayName, ImageUtilities.image2Icon((Image)ImageUtilities.loadImage((String)"org/netbeans/modules/web/clientproject/ui/resources/html5-project.png")));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @CheckForNull
    private String getDisplayName(FileObject jsonFile) {
        assert (jsonFile != null);
        JSONParser parser = new JSONParser();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(jsonFile.getInputStream(), StandardCharsets.UTF_8));){
            JSONObject content = (JSONObject)parser.parse((Reader)reader);
            Object name = content.get((Object)"name");
            if (!(name instanceof String)) return null;
            String string = (String)name;
            return string;
        }
        catch (IOException | ParseException ex) {
            LOGGER.log(Level.FINE, jsonFile.getPath(), ex);
        }
        return null;
    }

    private Object getChildrenNames(FileObject projectDirectory) {
        StringBuilder sb = new StringBuilder();
        for (FileObject child : projectDirectory.getChildren()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(child.getNameExt());
        }
        return sb.toString();
    }

    private static class ConvertorClassPathProvider
    implements ClassPathProvider {
        private ConvertorClassPathProvider() {
        }

        @CheckForNull
        public ClassPath findClassPath(@NonNull FileObject file, @NonNull String type) {
            Project p;
            if ("classpath/html5".equals(type) && (p = ProjectConvertors.getNonConvertorOwner((FileObject)file)) != null) {
                return ((ClassPathProvider)p.getLookup().lookup(ClassPathProvider.class)).findClassPath(file, type);
            }
            return null;
        }
    }

    private static final class Factory
    implements Callable<Project> {
        private static final UsageLogger PROJECT_CONVERTOR_USAGE_LOGGER = new UsageLogger.Builder("org.netbeans.ui.metrics.web.clientproject").message(ClientSideProjectConvertor.class, "USG_PROJECT_CONVERTOR").firstMessageOnly(false).create();
        private static final String[] KNOWN_SITE_ROOTS = new String[]{"public", "app", "web", "www", "public_html"};
        private final FileObject projectDirectory;
        private final String displayName;
        private final Closeable transientLkp;
        private final String fileName;

        Factory(FileObject projectDirectory, String displayName, Closeable transientLkp, String fileName) {
            assert (projectDirectory != null);
            assert (displayName != null) : projectDirectory;
            assert (transientLkp != null) : projectDirectory;
            assert (fileName != null) : projectDirectory;
            this.projectDirectory = projectDirectory;
            this.displayName = displayName;
            this.transientLkp = transientLkp;
            this.fileName = fileName;
        }

        @Override
        public Project call() throws Exception {
            this.transientLkp.close();
            PROJECT_CONVERTOR_USAGE_LOGGER.log(new Object[]{this.fileName});
            return ClientSideProjectGenerator.createProject(new CreateProjectProperties(this.projectDirectory, this.displayName).setSourceFolder("").setSiteRootFolder(this.detectSiteRoot()).setAutoconfigured(true));
        }

        private String detectSiteRoot() {
            for (String dir : KNOWN_SITE_ROOTS) {
                FileObject fo = this.projectDirectory.getFileObject(dir);
                if (fo == null || !fo.isFolder()) continue;
                return dir;
            }
            return "";
        }
    }
}

