/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject.ui.wizard;

import java.awt.Component;
import java.awt.EventQueue;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.modules.web.clientproject.ClientSideProject;
import org.netbeans.modules.web.clientproject.createprojectapi.CreateProjectUtils;
import org.netbeans.modules.web.clientproject.env.CommonProjectHelper;
import org.netbeans.modules.web.clientproject.spi.ClientProjectExtender;
import org.netbeans.modules.web.clientproject.spi.SiteTemplateImplementation;
import org.netbeans.modules.web.clientproject.ui.wizard.Bundle;
import org.netbeans.modules.web.clientproject.ui.wizard.ExistingClientSideProjectPanel;
import org.netbeans.modules.web.clientproject.ui.wizard.SiteTemplateWizardPanel;
import org.netbeans.modules.web.clientproject.util.ClientSideProjectUtilities;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.Pair;

public final class ClientSideProjectWizardIterator
implements WizardDescriptor.ProgressInstantiatingIterator<WizardDescriptor> {
    private static final Logger LOGGER = Logger.getLogger(ClientSideProjectWizardIterator.class.getName());
    private static final String NEW_HTML5_PROJECT_ICON = "org/netbeans/modules/web/clientproject/ui/resources/new-html5-project.png";
    private static final String NEW_JS_LIBRARY_ICON = "org/netbeans/modules/web/clientproject/ui/resources/new-js-library.png";
    private final Wizard wizard;
    private int index;
    private WizardDescriptor.Panel<WizardDescriptor>[] panels;
    private WizardDescriptor.Panel<WizardDescriptor>[] extenderPanels;
    private WizardDescriptor.Panel<WizardDescriptor>[] initPanels;
    private Collection<? extends ClientProjectExtender> extenders;
    private WizardDescriptor wizardDescriptor;
    private boolean withExtenders;

    private ClientSideProjectWizardIterator(Wizard wizard) {
        this(wizard, false);
    }

    private ClientSideProjectWizardIterator(Wizard wizard, boolean withExtenders) {
        assert (wizard != null);
        this.wizard = wizard;
        this.withExtenders = withExtenders;
    }

    public static ClientSideProjectWizardIterator newHtml5Project() {
        return new ClientSideProjectWizardIterator(new NewHtml5ProjectWizard());
    }

    public static ClientSideProjectWizardIterator newLibraryProject() {
        return new ClientSideProjectWizardIterator(new NewJsLibraryProjectWizard());
    }

    public static ClientSideProjectWizardIterator existingHtml5Project() {
        return new ClientSideProjectWizardIterator(new ExistingHtml5ProjectWizard());
    }

    public static ClientSideProjectWizardIterator newProjectWithExtender() {
        return new ClientSideProjectWizardIterator(new NewHtml5ProjectWizard(true), true);
    }

    public Set<FileObject> instantiate(ProgressHandle handle) throws IOException {
        handle.start();
        handle.progress(Bundle.ClientSideProjectWizardIterator_progress_creatingProject());
        LinkedHashSet<FileObject> files = new LinkedHashSet<FileObject>();
        File projectDirectory = FileUtil.normalizeFile((File)((File)this.wizardDescriptor.getProperty("PROJECT_DIRECTORY")));
        String name = (String)this.wizardDescriptor.getProperty("NAME");
        if (!projectDirectory.isDirectory() && !projectDirectory.mkdirs()) {
            throw new IOException("Cannot create project directory");
        }
        FileObject dir = FileUtil.toFileObject((File)projectDirectory);
        CommonProjectHelper projectHelper = ClientSideProjectUtilities.setupProject(dir, name);
        files.add(dir);
        ClientSideProject project = (ClientSideProject)FileOwnerQuery.getOwner((FileObject)projectHelper.getProjectDirectory());
        Pair<FileObject, FileObject> folders = this.wizard.instantiate(files, handle, this.wizardDescriptor, project);
        FileObject sources = (FileObject)folders.first();
        FileObject siteRoot = (FileObject)folders.second();
        if (sources != null) {
            FileObject mainFile = sources.getFileObject("main.js");
            if (mainFile != null) {
                files.add(mainFile);
            }
        } else if (this.wizard.hasSources()) {
            ClientSideProjectWizardIterator.errorOccured(Bundle.ClientSideProjectWizardIterator_error_noSources());
        }
        if (siteRoot != null) {
            FileObject indexFile = siteRoot.getFileObject("index", "html");
            if (indexFile != null) {
                files.add(indexFile);
            }
        } else if (this.wizard.hasSiteRoot()) {
            ClientSideProjectWizardIterator.errorOccured(Bundle.ClientSideProjectWizardIterator_error_noSiteRoot());
        }
        File parent = projectDirectory.getParentFile();
        if (parent != null && parent.exists()) {
            ProjectChooser.setProjectsFolder((File)parent);
        }
        handle.finish();
        this.wizard.logUsage(this.wizardDescriptor, dir, sources, siteRoot);
        return files;
    }

    public Set<FileObject> instantiate() throws IOException {
        throw new UnsupportedOperationException("never implemented - use progress one");
    }

    public void initialize(WizardDescriptor wiz) {
        this.wizardDescriptor = wiz;
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                ClientSideProjectWizardIterator.this.initializeInternal();
            }
        });
    }

    void initializeInternal() {
        int i;
        assert (EventQueue.isDispatchThread());
        this.index = 0;
        this.extenders = this.withExtenders ? Lookup.getDefault().lookupAll(ClientProjectExtender.class) : Collections.EMPTY_LIST;
        this.panels = this.wizard.createPanels();
        LinkedList<String> steps = new LinkedList<String>();
        steps.addAll(Arrays.asList(this.wizard.createSteps()));
        ArrayList<WizardDescriptor.Panel> extenderPanelsCol = new ArrayList<WizardDescriptor.Panel>();
        ArrayList<WizardDescriptor.Panel> initPanelsCol = new ArrayList<WizardDescriptor.Panel>();
        for (ClientProjectExtender clientProjectExtender : this.extenders) {
            clientProjectExtender.initialize(this.wizardDescriptor);
            for (WizardDescriptor.Panel panel : clientProjectExtender.createWizardPanels()) {
                extenderPanelsCol.add(panel);
                steps.add(panel.getComponent().getName());
            }
            int i2 = 0;
            for (WizardDescriptor.Panel panel : clientProjectExtender.createInitPanels()) {
                initPanelsCol.add(panel);
                steps.add(i2++, panel.getComponent().getName());
            }
        }
        this.extenderPanels = extenderPanelsCol.toArray(new WizardDescriptor.Panel[0]);
        this.initPanels = initPanelsCol.toArray(new WizardDescriptor.Panel[0]);
        for (i = 0; i < this.initPanels.length; ++i) {
            Component component = this.initPanels[i].getComponent();
            assert (steps.get(i) != null) : "Missing name for step: " + i;
            if (!(component instanceof JComponent)) continue;
            JComponent jc = (JComponent)component;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
            jc.putClientProperty("WizardPanel_contentData", steps.toArray());
            jc.setName((String)steps.get(i));
        }
        while (i < this.panels.length + this.initPanels.length) {
            Component component = this.panels[i - this.initPanels.length].getComponent();
            assert (steps.get(i) != null) : "Missing name for step: " + i;
            if (component instanceof JComponent) {
                JComponent jc = (JComponent)component;
                jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
                jc.putClientProperty("WizardPanel_contentData", steps.toArray(new String[0]));
                jc.setName((String)steps.get(i));
            }
            ++i;
        }
        while (i < this.extenderPanels.length + this.panels.length + this.initPanels.length) {
            Component component = this.extenderPanels[i - this.panels.length - this.initPanels.length].getComponent();
            assert (steps.get(i) != null) : "Missing name for step: " + i;
            if (component instanceof JComponent) {
                JComponent jc = (JComponent)component;
                jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
                jc.putClientProperty("WizardPanel_contentData", steps.toArray());
                jc.setName((String)steps.get(i));
            }
            ++i;
        }
    }

    public void uninitialize(WizardDescriptor wiz) {
        this.wizardDescriptor.putProperty("PROJECT_DIRECTORY", null);
        this.wizardDescriptor.putProperty("NAME", null);
        this.wizard.uninitialize(this.wizardDescriptor);
        this.panels = null;
        this.extenders = null;
        this.extenderPanels = null;
        this.initPanels = null;
    }

    public String name() {
        return Bundle.ClientSideProjectWizardIterator_name(this.index + 1, this.panels.length);
    }

    public boolean hasNext() {
        return this.index < this.panels.length + this.extenderPanels.length + this.initPanels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public WizardDescriptor.Panel<WizardDescriptor> current() {
        this.setTitle();
        if (this.index < this.initPanels.length) {
            return this.initPanels[this.index];
        }
        if (this.index < this.initPanels.length + this.panels.length) {
            return this.panels[this.index - this.initPanels.length];
        }
        return this.extenderPanels[this.index - this.initPanels.length - this.panels.length];
    }

    private void setTitle() {
        if (this.wizardDescriptor != null) {
            String title = this.wizard.getTitle();
            assert (title != null) : "Title expected for wizard type: " + this.wizard;
            this.wizardDescriptor.putProperty("NewProjectWizard_Title", (Object)title);
        }
    }

    public void addChangeListener(ChangeListener l) {
    }

    public void removeChangeListener(ChangeListener l) {
    }

    static void errorOccured(String message) {
        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message, 0));
    }

    public static final class NewJsLibraryProjectWizard
    implements Wizard {
        private static final String LIBRARY_PROJECT_NAME = "JsLibrary";
        private final Pair<WizardDescriptor.FinishablePanel<WizardDescriptor>, String> baseWizard = CreateProjectUtils.createBaseWizardPanel("JsLibrary");
        private final Pair<WizardDescriptor.FinishablePanel<WizardDescriptor>, String> toolsWizard = CreateProjectUtils.createToolsWizardPanel(CreateProjectUtils.Tools.all());

        @Override
        public String getTitle() {
            return Bundle.ClientSideProjectWizardIterator_newLibrary_displayName();
        }

        @Override
        public boolean hasSources() {
            return true;
        }

        @Override
        public boolean hasSiteRoot() {
            return false;
        }

        @Override
        public WizardDescriptor.Panel<WizardDescriptor>[] createPanels() {
            WizardDescriptor.Panel[] panels = new WizardDescriptor.Panel[]{(WizardDescriptor.Panel)this.baseWizard.first(), (WizardDescriptor.Panel)this.toolsWizard.first()};
            return panels;
        }

        @Override
        public String[] createSteps() {
            return new String[]{(String)this.baseWizard.second(), (String)this.toolsWizard.second()};
        }

        @Override
        public Pair<FileObject, FileObject> instantiate(Set<FileObject> files, ProgressHandle handle, WizardDescriptor wizardDescriptor, ClientSideProject project) throws IOException {
            ClientSideProjectUtilities.initializeProject(project, "src", null, null, null);
            FileObject sources = project.getProjectDirectory().getFileObject("src");
            FileObject mainFile = this.createMainFile(sources);
            files.add(mainFile);
            files.addAll(CreateProjectUtils.instantiateTools(project, (WizardDescriptor.FinishablePanel<WizardDescriptor>)((WizardDescriptor.FinishablePanel)this.toolsWizard.first())));
            return Pair.of((Object)sources, null);
        }

        @Override
        public void uninitialize(WizardDescriptor wizardDescriptor) {
        }

        @Override
        public void logUsage(WizardDescriptor wizardDescriptor, FileObject projectDir, FileObject sources, FileObject siteRoot) {
            ClientSideProjectUtilities.logUsageProjectCreate(false, null, null, true, null, false);
        }

        private FileObject createMainFile(FileObject sources) throws IOException {
            assert (sources != null);
            FileObject indexTemplate = FileUtil.getConfigFile((String)"Templates/Other/javascript.js");
            DataFolder dataFolder = DataFolder.findFolder((FileObject)sources);
            DataObject dataIndex = DataObject.find((FileObject)indexTemplate);
            return dataIndex.createFromTemplate(dataFolder, "main").getPrimaryFile();
        }
    }

    public static final class ExistingHtml5ProjectWizard
    implements Wizard {
        public static final String SITE_ROOT = "SITE_ROOT";
        public static final String SOURCE_ROOT = "SOURCES_ROOT";
        public static final String TEST_ROOT = "TEST_ROOT";

        @Override
        public WizardDescriptor.Panel<WizardDescriptor>[] createPanels() {
            WizardDescriptor.Panel[] panels = new WizardDescriptor.Panel[]{new ExistingClientSideProjectPanel()};
            return panels;
        }

        @Override
        public String getTitle() {
            return Bundle.ClientSideProjectWizardIterator_existingProject_displayName();
        }

        @Override
        public boolean hasSources() {
            return false;
        }

        @Override
        public boolean hasSiteRoot() {
            return false;
        }

        @Override
        public String[] createSteps() {
            return new String[]{Bundle.ExistingProjectWizard_step_createProject()};
        }

        @Override
        public Pair<FileObject, FileObject> instantiate(Set<FileObject> files, ProgressHandle handle, WizardDescriptor wizardDescriptor, ClientSideProject project) throws IOException {
            String testFolder;
            File projectDir = FileUtil.toFile((FileObject)project.getProjectDirectory());
            File siteRoot = (File)wizardDescriptor.getProperty(SITE_ROOT);
            File sources = (File)wizardDescriptor.getProperty(SOURCE_ROOT);
            assert (siteRoot != null || sources != null) : String.valueOf(siteRoot) + " :: " + String.valueOf(sources);
            if (projectDir.equals(siteRoot)) {
                testFolder = null;
            } else {
                testFolder = this.getExistingDir(wizardDescriptor, TEST_ROOT);
                if (testFolder == null) {
                    testFolder = this.findTestFolder(project.getProjectDirectory());
                }
            }
            ClientSideProjectUtilities.initializeProject(project, sources != null ? sources.getAbsolutePath() : null, siteRoot != null ? siteRoot.getAbsolutePath() : null, testFolder, null);
            return Pair.of((Object)(sources != null ? FileUtil.toFileObject((File)sources) : null), (Object)(siteRoot != null ? FileUtil.toFileObject((File)siteRoot) : null));
        }

        @Override
        public void logUsage(WizardDescriptor wizardDescriptor, FileObject projectDir, FileObject sources, FileObject siteRoot) {
            boolean hasSiteRoot = siteRoot != null;
            ClientSideProjectUtilities.logUsageProjectCreate(true, null, hasSiteRoot ? Boolean.valueOf(ClientSideProjectUtilities.isParentOrItself(projectDir, siteRoot)) : null, !hasSiteRoot, null, false);
        }

        @Override
        public void uninitialize(WizardDescriptor wizardDescriptor) {
            wizardDescriptor.putProperty(SITE_ROOT, null);
            wizardDescriptor.putProperty(SOURCE_ROOT, null);
            wizardDescriptor.putProperty(TEST_ROOT, null);
        }

        @CheckForNull
        private String getExistingDir(WizardDescriptor wizardDescriptor, String property) {
            File dir = (File)wizardDescriptor.getProperty(property);
            if (dir != null) {
                return dir.getAbsolutePath();
            }
            return null;
        }

        @CheckForNull
        private String findTestFolder(FileObject projectDir) {
            for (String name : new String[]{"test", "spec"}) {
                FileObject folder = projectDir.getFileObject(name);
                if (folder == null || !folder.isFolder()) continue;
                return FileUtil.toFile((FileObject)folder).getAbsolutePath();
            }
            return null;
        }
    }

    public static final class NewHtml5ProjectWizard
    implements Wizard {
        public static final String SITE_TEMPLATE = "SITE_TEMPLATE";
        public static final String SITE_ROOT = "SITE_ROOT";
        private static final String HTML_PROJECT_NAME = "HTML5Application";
        private final Pair<WizardDescriptor.FinishablePanel<WizardDescriptor>, String> baseWizard;
        private final Pair<WizardDescriptor.FinishablePanel<WizardDescriptor>, String> toolsWizard;
        private boolean withExtenders;

        public NewHtml5ProjectWizard(boolean withExtenders) {
            this.withExtenders = withExtenders;
            this.baseWizard = CreateProjectUtils.createBaseWizardPanel(HTML_PROJECT_NAME);
            this.toolsWizard = CreateProjectUtils.createToolsWizardPanel(CreateProjectUtils.Tools.all());
        }

        public NewHtml5ProjectWizard() {
            this(false);
        }

        @Override
        public String getTitle() {
            return Bundle.ClientSideProjectWizardIterator_newProject_displayName();
        }

        @Override
        public boolean hasSources() {
            return false;
        }

        @Override
        public boolean hasSiteRoot() {
            return true;
        }

        @Override
        public WizardDescriptor.Panel<WizardDescriptor>[] createPanels() {
            WizardDescriptor.Panel[] panels = new WizardDescriptor.Panel[]{(WizardDescriptor.Panel)this.baseWizard.first(), new SiteTemplateWizardPanel(), (WizardDescriptor.Panel)this.toolsWizard.first()};
            return panels;
        }

        @Override
        public String[] createSteps() {
            return new String[]{(String)this.baseWizard.second(), Bundle.NewProjectWizard_step_chooseSite(), (String)this.toolsWizard.second()};
        }

        @Override
        public Pair<FileObject, FileObject> instantiate(Set<FileObject> files, ProgressHandle handle, WizardDescriptor wizardDescriptor, ClientSideProject project) throws IOException {
            CommonProjectHelper projectHelper = project.getProjectHelper();
            String customSiteRoot = (String)wizardDescriptor.getProperty(SITE_ROOT);
            SiteTemplateImplementation siteTemplate = (SiteTemplateImplementation)wizardDescriptor.getProperty(SITE_TEMPLATE);
            SiteTemplateImplementation.ProjectProperties projectProperties = new SiteTemplateImplementation.ProjectProperties().setSiteRootFolder(customSiteRoot != null ? customSiteRoot : "public_html").setTestFolder("test");
            if (siteTemplate != null) {
                siteTemplate.configure(projectProperties);
                this.initProject(project, projectProperties, wizardDescriptor);
                this.applySiteTemplate(projectHelper.getProjectDirectory(), projectProperties, siteTemplate, handle);
            } else {
                this.initProject(project, projectProperties, wizardDescriptor);
            }
            FileObject siteRootDir = project.getSiteRootFolder();
            if (siteRootDir == null) {
                return Pair.of(null, null);
            }
            File[] htmlFiles = FileUtil.toFile((FileObject)siteRootDir).listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isFile() && pathname.getName().toLowerCase().endsWith("html");
                }
            });
            if (htmlFiles != null && htmlFiles.length == 0) {
                this.createIndexFile(siteRootDir);
            }
            if (this.withExtenders) {
                for (ClientProjectExtender extender : Lookup.getDefault().lookupAll(ClientProjectExtender.class)) {
                    extender.apply(project.getProjectDirectory(), siteRootDir, "js/lib");
                }
            }
            files.addAll(CreateProjectUtils.instantiateTools(project, (WizardDescriptor.FinishablePanel<WizardDescriptor>)((WizardDescriptor.FinishablePanel)this.toolsWizard.first())));
            return Pair.of(null, (Object)siteRootDir);
        }

        @Override
        public void logUsage(WizardDescriptor wizardDescriptor, FileObject projectDir, FileObject sources, FileObject siteRoot) {
            SiteTemplateImplementation siteTemplate = (SiteTemplateImplementation)wizardDescriptor.getProperty(SITE_TEMPLATE);
            ClientSideProjectUtilities.logUsageProjectCreate(false, siteTemplate, null, false, null, false);
        }

        @Override
        public void uninitialize(WizardDescriptor wizardDescriptor) {
            wizardDescriptor.putProperty(SITE_TEMPLATE, null);
            wizardDescriptor.putProperty(SITE_ROOT, null);
        }

        private void initProject(ClientSideProject project, SiteTemplateImplementation.ProjectProperties properties, WizardDescriptor wizardDescriptor) throws IOException {
            String seleniumTestingProvider;
            ClientSideProjectUtilities.initializeProject(project, properties.getSourceFolder(), properties.getSiteRootFolder(), properties.getTestFolder(), properties.getTestSeleniumFolder());
            String jsTestingProvider = properties.getJsTestingProvider();
            if (jsTestingProvider != null) {
                ClientSideProjectUtilities.setJsTestingProvider(project, jsTestingProvider);
            }
            if ((seleniumTestingProvider = properties.getSeleniumTestingProvider()) != null) {
                ClientSideProjectUtilities.setSeleniumTestingProvider(project, seleniumTestingProvider);
            }
        }

        private void applySiteTemplate(FileObject projectDir, SiteTemplateImplementation.ProjectProperties projectProperties, SiteTemplateImplementation siteTemplate, ProgressHandle handle) {
            assert (!EventQueue.isDispatchThread());
            String templateName = siteTemplate.getName();
            try {
                siteTemplate.apply(projectDir, projectProperties, handle);
            }
            catch (IOException ex) {
                LOGGER.log(Level.INFO, null, ex);
                ClientSideProjectWizardIterator.errorOccured(Bundle.ClientSideProjectWizardIterator_error_applyingSiteTemplate(templateName));
            }
        }

        private void createIndexFile(FileObject siteRoot) throws IOException {
            FileObject indexTemplate = FileUtil.getConfigFile((String)"Templates/Other/html.html");
            DataFolder dataFolder = DataFolder.findFolder((FileObject)siteRoot);
            DataObject dataIndex = DataObject.find((FileObject)indexTemplate);
            dataIndex.createFromTemplate(dataFolder, "index");
        }
    }

    public static interface Wizard {
        public static final String PROJECT_DIRECTORY = "PROJECT_DIRECTORY";
        public static final String NAME = "NAME";

        public String getTitle();

        public boolean hasSources();

        public boolean hasSiteRoot();

        public WizardDescriptor.Panel<WizardDescriptor>[] createPanels();

        public String[] createSteps();

        public Pair<FileObject, FileObject> instantiate(Set<FileObject> var1, ProgressHandle var2, WizardDescriptor var3, ClientSideProject var4) throws IOException;

        public void uninitialize(WizardDescriptor var1);

        public void logUsage(WizardDescriptor var1, FileObject var2, @NullAllowed FileObject var3, @NullAllowed FileObject var4);
    }
}

