/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.metadata;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Set;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.validation.metadata.ConstraintDescriptor;
import org.primefaces.context.RequestContext;
import org.primefaces.metadata.BeanValidationMetadataExtractor;
import org.primefaces.metadata.ComponentMetadataTransformer;

public class BeanValidationComponentMetadataTransformer
extends ComponentMetadataTransformer {
    private static final BeanValidationComponentMetadataTransformer INSTANCE = new BeanValidationComponentMetadataTransformer();

    public static BeanValidationComponentMetadataTransformer getInstance() {
        return INSTANCE;
    }

    public void transform(FacesContext context, RequestContext requestContext, UIComponent component) throws IOException {
        if (!(component instanceof EditableValueHolder) || !(component instanceof UIInput)) {
            return;
        }
        UIInput input = (UIInput)component;
        EditableValueHolder editableValueHolder = (EditableValueHolder)component;
        if (editableValueHolder.isRequired() && this.isMaxlenghtSet(input)) {
            return;
        }
        Set<ConstraintDescriptor<?>> constraints = BeanValidationMetadataExtractor.extract(context, requestContext, component.getValueExpression("value"));
        if (constraints != null && !constraints.isEmpty()) {
            for (ConstraintDescriptor<?> constraintDescriptor : constraints) {
                this.applyConstraint(constraintDescriptor, input, editableValueHolder);
            }
        }
    }

    protected void applyConstraint(ConstraintDescriptor constraintDescriptor, UIInput input, EditableValueHolder editableValueHolder) {
        Size size;
        Annotation constraint = constraintDescriptor.getAnnotation();
        if (!this.isMaxlenghtSet(input)) {
            if (constraint.annotationType().equals(Max.class)) {
                Max max = (Max)constraint;
                if (max.value() > 0L) {
                    this.setMaxlength(input, Long.valueOf(max.value()).intValue());
                }
            } else if (constraint.annotationType().equals(Size.class) && (size = (Size)constraint).max() > 0) {
                this.setMaxlength(input, size.max());
            }
        }
        if (!editableValueHolder.isRequired()) {
            if (constraint.annotationType().equals(Min.class)) {
                Min min = (Min)constraint;
                if (min.value() > 0L) {
                    editableValueHolder.setRequired(true);
                }
            } else if (constraint.annotationType().equals(Size.class)) {
                size = (Size)constraint;
                if (size.min() > 0) {
                    editableValueHolder.setRequired(true);
                }
            } else if (constraint.annotationType().equals(NotNull.class)) {
                editableValueHolder.setRequired(true);
            }
        }
    }
}

