/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.antproject.base;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.netbeans.api.java.project.classpath.ProjectClassPathModifier;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.ant.AntBuildExtender;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.groovy.support.spi.GroovyExtenderImplementation;
import org.netbeans.spi.project.support.ant.GeneratedFilesHelper;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.EditableProperties;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.Parameters;

public abstract class AbstractGroovyExtender
implements GroovyExtenderImplementation {
    private static final String EXTENSIBLE_TARGET_NAME = "-pre-pre-compile";
    private static final String GROOVY_EXTENSION_ID = "groovy";
    private static final String PROJECT_PROPERTIES_PATH = "nbproject/project.properties";
    private static final String EXCLUDE_PROPERTY = "build.classes.excludes";
    private static final String DISABLE_COMPILE_ON_SAVE = "compile.on.save.unsupported.groovy";
    private static final String EXCLUSION_PATTERN = "**/*.groovy";
    private final Project project;

    protected AbstractGroovyExtender(Project project) {
        this.project = project;
    }

    protected abstract URL getGroovyBuildXls();

    public boolean isActive() {
        AntBuildExtender extender = (AntBuildExtender)this.project.getLookup().lookup(AntBuildExtender.class);
        return extender != null && extender.getExtension(GROOVY_EXTENSION_ID) != null;
    }

    public boolean activate() {
        return this.addClasspath() & this.addExcludes() & this.addBuildScript() & this.addDisableCompileOnSaveProperty();
    }

    public boolean deactivate() {
        return this.removeClasspath() & this.removeExcludes() & this.removeBuildScript() & this.removeDisableCompileOnSaveProperty();
    }

    protected final boolean addClasspath() {
        Library groovyAllLib = this.getGroovyAllLibrary();
        if (groovyAllLib != null) {
            try {
                SourceGroup[] sourceGroups;
                Sources sources = ProjectUtils.getSources((Project)this.project);
                for (SourceGroup sourceGroup : sourceGroups = sources.getSourceGroups("java")) {
                    if (sourceGroup.getRootFolder().getName().equals("test")) continue;
                    ProjectClassPathModifier.addLibraries((Library[])new Library[]{groovyAllLib}, (FileObject)sourceGroup.getRootFolder(), (String)"classpath/compile");
                }
                return true;
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (UnsupportedOperationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return false;
    }

    protected final boolean removeClasspath() {
        Library groovyAllLib = this.getGroovyAllLibrary();
        if (groovyAllLib != null) {
            try {
                SourceGroup[] sourceGroups;
                Sources sources = ProjectUtils.getSources((Project)this.project);
                for (SourceGroup sourceGroup : sourceGroups = sources.getSourceGroups("java")) {
                    ProjectClassPathModifier.removeLibraries((Library[])new Library[]{groovyAllLib}, (FileObject)sourceGroup.getRootFolder(), (String)"classpath/compile");
                }
                return true;
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (UnsupportedOperationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return false;
    }

    private Library getGroovyAllLibrary() {
        for (Library library : LibraryManager.getDefault().getLibraries()) {
            List uriContent = library.getContent("classpath");
            try {
                if (!this.containsClass(uriContent, "groovy.lang.GroovyObject")) continue;
                return library;
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return null;
    }

    private boolean containsClass(List<URL> classPath, String className) throws IOException {
        Parameters.notNull((CharSequence)"classpath", classPath);
        Parameters.notNull((CharSequence)"className", (Object)className);
        ArrayList<File> diskFiles = new ArrayList<File>();
        for (URL url : classPath) {
            File diskFile;
            URL localURL;
            FileObject fo;
            URL archiveURL = FileUtil.getArchiveFile((URL)url);
            if (archiveURL != null) {
                url = archiveURL;
            }
            if ("nbinst".equals(url.getProtocol()) && (fo = URLMapper.findFileObject((URL)url)) != null && (localURL = URLMapper.findURL((FileObject)fo, (int)1)) != null) {
                url = localURL;
            }
            if ((fo = URLMapper.findFileObject((URL)url)) == null || (diskFile = FileUtil.toFile((FileObject)fo)) == null) continue;
            diskFiles.add(diskFile);
        }
        return this.containsClass((Collection<File>)diskFiles, className);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean containsClass(Collection<File> classpath, String className) throws IOException {
        Parameters.notNull((CharSequence)"classpath", classpath);
        Parameters.notNull((CharSequence)"driverClassName", (Object)className);
        String classFilePath = className.replace('.', '/') + ".class";
        for (File file : classpath) {
            if (file.isFile()) {
                JarFile jf = new JarFile(file);
                try {
                    Enumeration<JarEntry> entries = jf.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry entry = entries.nextElement();
                        if (!classFilePath.equals(entry.getName())) continue;
                        boolean bl = true;
                        return bl;
                    }
                    continue;
                }
                finally {
                    jf.close();
                    continue;
                }
            }
            if (!new File(file, classFilePath).exists()) continue;
            return true;
        }
        return false;
    }

    protected final boolean addExcludes() {
        try {
            EditableProperties props = AbstractGroovyExtender.getEditableProperties(this.project, PROJECT_PROPERTIES_PATH);
            String exclude = props.getProperty(EXCLUDE_PROPERTY);
            if (!exclude.contains(EXCLUSION_PATTERN)) {
                props.setProperty(EXCLUDE_PROPERTY, exclude + "," + EXCLUSION_PATTERN);
                AbstractGroovyExtender.storeEditableProperties(this.project, PROJECT_PROPERTIES_PATH, props);
            }
            return true;
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return false;
        }
    }

    protected final boolean removeExcludes() {
        try {
            EditableProperties props = AbstractGroovyExtender.getEditableProperties(this.project, PROJECT_PROPERTIES_PATH);
            String exclude = props.getProperty(EXCLUDE_PROPERTY);
            if (exclude.contains(",**/*.groovy")) {
                exclude = exclude.replace(",**/*.groovy", "");
                props.setProperty(EXCLUDE_PROPERTY, exclude);
                AbstractGroovyExtender.storeEditableProperties(this.project, PROJECT_PROPERTIES_PATH, props);
            }
            return true;
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return false;
        }
    }

    protected final boolean addBuildScript() {
        AntBuildExtender extender = (AntBuildExtender)this.project.getLookup().lookup(AntBuildExtender.class);
        if (extender != null && extender.getExtensibleTargets().contains(EXTENSIBLE_TARGET_NAME)) {
            AntBuildExtender.Extension extension = extender.getExtension(GROOVY_EXTENSION_ID);
            if (extension == null) {
                FileObject destDirFO = this.project.getProjectDirectory().getFileObject("nbproject");
                try {
                    GeneratedFilesHelper helper = new GeneratedFilesHelper(this.project.getProjectDirectory());
                    helper.generateBuildScriptFromStylesheet("nbproject/groovy-build.xml", this.getGroovyBuildXls());
                    FileObject destFileFO = destDirFO.getFileObject("groovy-build", "xml");
                    extension = extender.addExtension(GROOVY_EXTENSION_ID, destFileFO);
                    extension.addDependency(EXTENSIBLE_TARGET_NAME, "-groovy-init-macrodef-javac");
                    ProjectManager.getDefault().saveProject(this.project);
                    return true;
                }
                catch (IOException ioe) {
                    Exceptions.printStackTrace((Throwable)ioe);
                }
            } else {
                return true;
            }
        }
        return false;
    }

    protected final boolean removeBuildScript() {
        AntBuildExtender extender = (AntBuildExtender)this.project.getLookup().lookup(AntBuildExtender.class);
        if (extender != null && extender.getExtensibleTargets().contains(EXTENSIBLE_TARGET_NAME)) {
            AntBuildExtender.Extension extension = extender.getExtension(GROOVY_EXTENSION_ID);
            if (extension != null) {
                FileObject destDirFO = this.project.getProjectDirectory().getFileObject("nbproject");
                try {
                    FileObject fileToRemove;
                    extension.removeDependency(EXTENSIBLE_TARGET_NAME, "-groovy-init-macrodef-javac");
                    extender.removeExtension(GROOVY_EXTENSION_ID);
                    if (destDirFO != null && (fileToRemove = destDirFO.getFileObject("groovy-build.xml")) != null) {
                        fileToRemove.delete();
                    }
                    ProjectManager.getDefault().saveProject(this.project);
                    return true;
                }
                catch (IOException ioe) {
                    Exceptions.printStackTrace((Throwable)ioe);
                }
            } else {
                return true;
            }
        }
        return false;
    }

    protected final boolean addDisableCompileOnSaveProperty() {
        try {
            EditableProperties props = AbstractGroovyExtender.getEditableProperties(this.project, PROJECT_PROPERTIES_PATH);
            props.put(DISABLE_COMPILE_ON_SAVE, "true");
            AbstractGroovyExtender.storeEditableProperties(this.project, PROJECT_PROPERTIES_PATH, props);
            return true;
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return false;
        }
    }

    protected final boolean removeDisableCompileOnSaveProperty() {
        try {
            EditableProperties props = AbstractGroovyExtender.getEditableProperties(this.project, PROJECT_PROPERTIES_PATH);
            props.remove((Object)DISABLE_COMPILE_ON_SAVE);
            AbstractGroovyExtender.storeEditableProperties(this.project, PROJECT_PROPERTIES_PATH, props);
            return true;
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return false;
        }
    }

    private static EditableProperties getEditableProperties(final Project prj, final String propertiesPath) throws IOException {
        try {
            return (EditableProperties)ProjectManager.mutex().readAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<EditableProperties>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public EditableProperties run() throws IOException {
                    FileObject propertiesFo = prj.getProjectDirectory().getFileObject(propertiesPath);
                    EditableProperties ep = null;
                    if (propertiesFo != null) {
                        InputStream is = null;
                        ep = new EditableProperties(false);
                        try {
                            is = propertiesFo.getInputStream();
                            ep.load(is);
                        }
                        finally {
                            if (is != null) {
                                is.close();
                            }
                        }
                    }
                    return ep;
                }
            });
        }
        catch (MutexException ex) {
            return null;
        }
    }

    private static void storeEditableProperties(final Project prj, final String propertiesPath, final EditableProperties ep) throws IOException {
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Void run() throws IOException {
                    FileObject propertiesFo = prj.getProjectDirectory().getFileObject(propertiesPath);
                    if (propertiesFo != null) {
                        OutputStream os = null;
                        try {
                            os = propertiesFo.getOutputStream();
                            ep.store(os);
                        }
                        finally {
                            if (os != null) {
                                os.close();
                            }
                        }
                    }
                    return null;
                }
            });
        }
        catch (MutexException mutexException) {
            // empty catch block
        }
    }
}

