/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.terminal.actions;

import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import org.netbeans.lib.terminalemulator.ActiveTerm;
import org.netbeans.modules.terminal.actions.TerminalAction;
import org.netbeans.modules.terminal.ioprovider.Terminal;
import org.openide.util.Lookup;
import org.openide.util.actions.Presenter;

public class WrapAction
extends TerminalAction
implements Presenter.Popup {
    private static final String BOOLEAN_STATE_ACTION_KEY = "boolean_state_action";
    private static final String BOOLEAN_STATE_ENABLED_KEY = "boolean_state_enabled";

    public WrapAction(Terminal context) {
        super(context);
        this.putValue("Name", WrapAction.getMessage("CTL_Wrap"));
        this.putValue(BOOLEAN_STATE_ACTION_KEY, true);
    }

    @Override
    public void performAction() {
        Terminal terminal = this.getTerminal();
        ActiveTerm term = terminal.term();
        if (!terminal.isEnabled()) {
            return;
        }
        boolean hs = term.isHorizontallyScrollable();
        term.setHorizontallyScrollable(!hs);
    }

    @Override
    public Object getValue(String key) {
        if (key.equals(BOOLEAN_STATE_ENABLED_KEY)) {
            Terminal terminal = this.getTerminal();
            if (terminal == null) {
                return false;
            }
            ActiveTerm term = terminal.term();
            return !term.isHorizontallyScrollable();
        }
        return super.getValue(key);
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new WrapAction((Terminal)actionContext.lookup(Terminal.class));
    }

    public JMenuItem getPopupPresenter() {
        JCheckBoxMenuItem item = new JCheckBoxMenuItem(this);
        item.setSelected((Boolean)this.getValue(BOOLEAN_STATE_ENABLED_KEY));
        return item;
    }
}

