/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seplatform.api;

import java.io.IOException;
import java.util.Map;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.modules.java.j2seplatform.platformdefinition.PlatformConvertor;
import org.netbeans.modules.java.j2seplatform.wizard.NewJ2SEPlatform;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.util.Parameters;

public class J2SEPlatformCreator {
    private J2SEPlatformCreator() {
    }

    @NonNull
    public static JavaPlatform createJ2SEPlatform(@NonNull FileObject installFolder) throws IOException {
        Parameters.notNull((CharSequence)"installFolder", (Object)installFolder);
        return J2SEPlatformCreator.createJ2SEPlatformImpl(installFolder, null);
    }

    @NonNull
    public static JavaPlatform createJ2SEPlatform(@NonNull FileObject installFolder, @NonNull String platformName) throws IOException, IllegalArgumentException {
        Parameters.notNull((CharSequence)"installFolder", (Object)installFolder);
        Parameters.notNull((CharSequence)"platformName", (Object)platformName);
        for (JavaPlatform jp : JavaPlatformManager.getDefault().getInstalledPlatforms()) {
            if (!platformName.equals(jp.getDisplayName())) continue;
            throw new IllegalArgumentException(platformName);
        }
        return J2SEPlatformCreator.createJ2SEPlatformImpl(installFolder, platformName);
    }

    @NonNull
    private static JavaPlatform createJ2SEPlatformImpl(@NonNull FileObject installFolder, @NullAllowed String displayName) throws IOException {
        NewJ2SEPlatform plat = NewJ2SEPlatform.create(installFolder);
        plat.run();
        if (!plat.isValid()) {
            throw new IOException("Invalid J2SE platform in " + installFolder);
        }
        if (displayName == null) {
            displayName = J2SEPlatformCreator.createPlatformDisplayName(plat);
        }
        String antName = J2SEPlatformCreator.createPlatformAntName(displayName);
        plat.setDisplayName(displayName);
        plat.setAntName(antName);
        return PlatformConvertor.create(plat);
    }

    @NonNull
    private static String createPlatformDisplayName(@NonNull JavaPlatform plat) {
        Map m = plat.getSystemProperties();
        String vmVersion = (String)m.get("java.specification.version");
        StringBuilder displayName = new StringBuilder("JDK ");
        if (vmVersion != null) {
            displayName.append(vmVersion);
        }
        return displayName.toString();
    }

    @NonNull
    private static String createPlatformAntName(@NonNull String displayName) {
        assert (displayName != null && displayName.length() > 0);
        String antName = PropertyUtils.getUsablePropertyName((String)displayName);
        if (J2SEPlatformCreator.platformExists(antName)) {
            String baseName = antName;
            int index = 1;
            antName = baseName + Integer.toString(index);
            while (J2SEPlatformCreator.platformExists(antName)) {
                antName = baseName + Integer.toString(++index);
            }
        }
        return antName;
    }

    private static boolean platformExists(@NonNull String antName) {
        assert (antName != null && antName.length() > 0);
        for (JavaPlatform p : JavaPlatformManager.getDefault().getInstalledPlatforms()) {
            String otherName = (String)p.getProperties().get("platform.ant.name");
            if (!antName.equals(otherName)) continue;
            return true;
        }
        return false;
    }
}

