/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.requirejs.editor.model;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.javascript2.editor.model.JsObject;
import org.netbeans.modules.javascript2.editor.spi.model.ModelElementFactory;
import org.netbeans.modules.javascript2.editor.spi.model.ModelInterceptor;
import org.netbeans.modules.javascript2.requirejs.editor.model.Bundle;
import org.openide.filesystems.FileObject;

public class RequireJsModelInterceptor
implements ModelInterceptor {
    private static final Logger LOGGER = Logger.getLogger(RequireJsModelInterceptor.class.getName());
    private static Collection<JsObject> globals = null;

    public Collection<JsObject> interceptGlobal(ModelElementFactory factory, FileObject fo) {
        return this.getGlobalObjects(factory, fo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<JsObject> getGlobalObjects(ModelElementFactory factory, FileObject fo) {
        if (globals == null) {
            InputStream is = this.getClass().getClassLoader().getResourceAsStream("org/netbeans/modules/javascript2/requirejs/resources/requirejs.js.model");
            try {
                Set<JsObject> set = Collections.singleton(factory.loadGlobalObject(is, Bundle.label_requirejs(), new URL("http://requirejs.org/docs/api.html")));
                return set;
            }
            catch (IOException ex) {
                LOGGER.log(Level.WARNING, null, ex);
                Set<JsObject> set = Collections.emptySet();
                return set;
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException ex) {
                    LOGGER.log(Level.INFO, null, ex);
                }
            }
        }
        return globals;
    }
}

