/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.TypeElement;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.AttachingDICookie;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.core.api.support.java.SourceUtils;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.Servlet;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.deployment.plugins.api.ServerDebugInfo;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.modules.java.api.common.project.BaseActionProvider;
import org.netbeans.modules.javaee.project.api.WhiteListUpdater;
import org.netbeans.modules.javaee.project.api.ant.ui.J2EEProjectProperties;
import org.netbeans.modules.web.api.webmodule.RequestParametersQuery;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.jsps.parserapi.JspParserAPI;
import org.netbeans.modules.web.jsps.parserapi.JspParserFactory;
import org.netbeans.modules.web.jsps.parserapi.PageInfo;
import org.netbeans.modules.web.project.ProjectWebModule;
import org.netbeans.modules.web.project.Utils;
import org.netbeans.modules.web.project.WebProject;
import org.netbeans.modules.web.project.classpath.ClassPathProviderImpl;
import org.netbeans.modules.web.project.ui.ServletScanObserver;
import org.netbeans.modules.web.project.ui.ServletUriPanel;
import org.netbeans.modules.web.project.ui.SetExecutionUriAction;
import org.netbeans.modules.web.project.ui.customizer.WebProjectProperties;
import org.netbeans.modules.websvc.api.client.WebServicesClientSupport;
import org.netbeans.modules.websvc.api.client.WsCompileClientEditorSupport;
import org.netbeans.modules.websvc.api.webservices.WebServicesSupport;
import org.netbeans.modules.websvc.api.webservices.WsCompileEditorSupport;
import org.netbeans.spi.java.classpath.ClassPathFactory;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.java.project.classpath.support.ProjectClassPathSupport;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;

public class WebActionProvider
extends BaseActionProvider {
    private static final String DIRECTORY_DEPLOYMENT_SUPPORTED = "directory.deployment.supported";
    private static final String COMMAND_VERIFY = "verify";
    private static final String[] supportedActions = new String[]{"build", "clean", "rebuild", "compile.single", "run", "run.single", "debug", "debug.single", "profile", "profile.single", "redeploy", "javadoc", "test", "test.single", "debug.test.single", "profile.test.single", "run.single.method", "debug.single.method", "debug.fix", "verify", "delete", "copy", "move", "rename"};
    private static final String[] platformSensitiveActions = new String[]{"build", "rebuild", "compile.single", "run.single", "debug.single", "profile.single", "javadoc", "test", "test.single", "debug.test.single", "profile.test.single", "run.single.method", "debug.single.method"};
    private Set<String> bkgScanSensitiveActions;
    private Set<String> needJavaModelActions;
    private static final String[] actionsDisabledForQuickRun = new String[]{"compile.single", "debug.fix"};
    Map<String, String[]> commands = new HashMap<String, String[]>();

    public WebActionProvider(WebProject project, UpdateHelper updateHelper, PropertyEvaluator evaluator) {
        super((Project)project, updateHelper, evaluator, project.getSourceRoots(), project.getTestSourceRoots(), project.getAntProjectHelper(), (BaseActionProvider.Callback)new CallbackImpl(project.getClassPathProvider(), project.getWebModule()));
        this.commands.put("build", new String[]{"dist"});
        this.commands.put("clean", new String[]{"clean"});
        this.commands.put("rebuild", new String[]{"clean", "dist"});
        this.commands.put("compile.single", new String[]{"compile-single"});
        this.commands.put("run", new String[]{"run"});
        this.commands.put("run.single", new String[]{"run-main"});
        this.commands.put("redeploy", new String[]{"run-deploy"});
        this.commands.put("debug", new String[]{"debug"});
        this.commands.put("debug.single", new String[]{"debug-single-main"});
        this.commands.put("profile", new String[]{"profile"});
        this.commands.put("profile.single", new String[]{"profile-single-main"});
        this.commands.put("javadoc", new String[]{"javadoc"});
        this.commands.put("test", new String[]{"test"});
        this.commands.put("test.single", new String[]{"test-single"});
        this.commands.put("debug.test.single", new String[]{"debug-test"});
        this.commands.put("profile.test.single", new String[]{"profile-test"});
        this.commands.put("debug.fix", new String[]{"debug-fix"});
        this.commands.put(COMMAND_VERIFY, new String[]{COMMAND_VERIFY});
        this.bkgScanSensitiveActions = new HashSet<String>(Arrays.asList("run.single"));
        this.needJavaModelActions = new HashSet<String>(Arrays.asList("debug.fix"));
        this.setServerExecution(true);
    }

    protected String[] getPlatformSensitiveActions() {
        return platformSensitiveActions;
    }

    protected String[] getActionsDisabledForQuickRun() {
        return actionsDisabledForQuickRun;
    }

    public Map<String, String[]> getCommands() {
        return this.commands;
    }

    protected Set<String> getScanSensitiveActions() {
        return this.bkgScanSensitiveActions;
    }

    protected Set<String> getJavaModelActions() {
        return this.needJavaModelActions;
    }

    protected boolean isCompileOnSaveEnabled() {
        return Boolean.parseBoolean(this.getEvaluator().getProperty("j2ee.compile.on.save"));
    }

    public String[] getSupportedActions() {
        return (String[])supportedActions.clone();
    }

    protected void updateJavaRunnerClasspath(String command, Map<String, Object> execProperties) {
        if ("test.single".equals(command) || "debug.test.single".equals(command) || "profile.test.single".equals(command) || "debug.single.method".equals(command) || "run.single.method".equals(command) || "run.single".equals(command) || "debug.single".equals(command) || "profile.single".equals(command)) {
            String s;
            FileObject fo = (FileObject)execProperties.get("execute.file");
            ClassPath cp = this.getCallback().findClassPath(fo, "classpath/execute");
            ClassPath cp2 = ClassPathFactory.createClassPath((ClassPathImplementation)ProjectClassPathSupport.createPropertyBasedClassPathImplementation((File)FileUtil.toFile((FileObject)this.getProject().getProjectDirectory()), (PropertyEvaluator)this.getEvaluator(), (String[])new String[]{"j2ee.platform.classpath", "j2ee.platform.embeddableejb.classpath"}));
            cp = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{cp, cp2});
            execProperties.put("execute.classpath", cp);
            LinkedList<String> coll = (LinkedList<String>)execProperties.get("run.jvmargs");
            if (coll == null) {
                coll = new LinkedList<String>();
                execProperties.put("run.jvmargs", coll);
            }
            if ((s = this.getEvaluator().getProperty("runmain.jvmargs")) != null && s.trim().length() > 0) {
                coll.add(s);
            }
            if ((s = this.getEvaluator().getProperty("endorsed.classpath")) != null && s.trim().length() > 0) {
                ClassPath ecp = ClassPathFactory.createClassPath((ClassPathImplementation)ProjectClassPathSupport.createPropertyBasedClassPathImplementation((File)FileUtil.toFile((FileObject)this.getProject().getProjectDirectory()), (PropertyEvaluator)this.getEvaluator(), (String[])new String[]{"endorsed.classpath"}));
                coll.add("-Xbootclasspath/p:\"" + ecp.toString(ClassPath.PathConversionMode.WARN) + "\"");
            }
        }
    }

    protected boolean handleJavaClass(Properties p, FileObject javaFile, String command, List<String> targetNames) {
        return this.runServlet(p, javaFile, "LBL_RunAction", "debug.single".equals(command), "profile.single".equals(command), targetNames);
    }

    public String[] getTargetNames(String command, Lookup context, Properties p, boolean doJavaChecks) throws IllegalArgumentException {
        FileObject fo = (FileObject)context.lookup(FileObject.class);
        if (fo == null) {
            fo = this.getProject().getProjectDirectory();
        }
        String ctx = FileUtil.toFile((FileObject)fo).getAbsolutePath();
        p.setProperty("browser.context", ctx);
        if (command.equals("run.single") || command.equals("run") || command.equals("redeploy") || command.equals("debug") || command.equals("debug.single") || command.equals("debug.fix") || command.equals("profile") || command.equals("profile.single") || command.equals("test.single") || command.equals("debug.test.single") || command.equals("profile.test.single")) {
            this.setDirectoryDeploymentProperty(p);
        }
        if (command.equals("redeploy")) {
            p.setProperty("forceRedeploy", "true");
        } else {
            p.setProperty("forceRedeploy", "false");
        }
        if (this.isDebugged()) {
            p.setProperty("is.debugged", "true");
        }
        if (command.equals("run.single") || command.equals("debug.single") || command.equals("profile.single")) {
            String[] res = super.getTargetNames(command, context, p, doJavaChecks);
            if (res != null) {
                return res;
            }
            if (!this.checkSelectedServer(command.equals("debug.single"), command.equals("profile.single"))) {
                return null;
            }
            String[] targetNames = command.equals("debug.single") ? new String[]{"debug"} : (command.equals("profile.single") ? new String[]{"profile"} : new String[]{"run"});
            FileObject[] files = this.findJsps(context);
            if (files != null && files.length > 0) {
                String requestParams;
                String raw = this.getAntProjectHelper().getStandardPropertyEvaluator().getProperty("compile.jsps");
                boolean compile = this.decodeBoolean(raw);
                if (!compile) {
                    this.setAllPropertiesForSingleJSPCompilation(p, files);
                }
                if ((requestParams = RequestParametersQuery.getFileAndParameters((FileObject)files[0])) != null) {
                    p.setProperty("client.urlPart", requestParams);
                    p.setProperty("run.single.on.server", "yes");
                    return targetNames;
                }
                return null;
            }
            FileObject[] htmlFiles = this.findHtml(context);
            if (htmlFiles != null && htmlFiles.length > 0) {
                String requestParams = RequestParametersQuery.getFileAndParameters((FileObject)htmlFiles[0]);
                if (requestParams == null && (requestParams = FileUtil.getRelativePath((FileObject)WebModule.getWebModule((FileObject)htmlFiles[0]).getDocumentBase(), (FileObject)htmlFiles[0])) != null) {
                    requestParams = "/" + requestParams.replace(" ", "%20");
                }
                if (requestParams != null) {
                    p.setProperty("client.urlPart", requestParams);
                    p.setProperty("run.single.on.server", "yes");
                    return targetNames;
                }
                return null;
            }
            return null;
        }
        if (command.equals("run") || command.equals("redeploy")) {
            if (!this.checkSelectedServer(false, false)) {
                return null;
            }
            if (WhiteListUpdater.isWhitelistViolated((Project)this.getProject())) {
                return null;
            }
            return this.commands.get(command);
        }
        if (command.equals("profile")) {
            if (!this.checkSelectedServer(false, true)) {
                return null;
            }
            this.initWebServiceProperties(p);
        } else if (command.equals("debug")) {
            if (!this.checkSelectedServer(true, false)) {
                return null;
            }
            this.initWebServiceProperties(p);
        } else if (command.equals("compile.single")) {
            String[] res = super.getTargetNames(command, context, p, doJavaChecks);
            if (res != null) {
                return res;
            }
            FileObject[] files = this.findJsps(context);
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    FileObject jsp = files[i];
                    if (!this.areIncludesModified(jsp)) continue;
                    this.invalidateClassFile(jsp);
                }
                this.setAllPropertiesForSingleJSPCompilation(p, files);
                return new String[]{"compile-single-jsp"};
            }
            return null;
        }
        return super.getTargetNames(command, context, p, doJavaChecks);
    }

    private void initWebServiceProperties(Properties p) {
        WebServicesClientSupport wscs = WebServicesClientSupport.getWebServicesClientSupport((FileObject)this.getProject().getProjectDirectory());
        if (wscs != null) {
            List serviceClients = wscs.getServiceClients();
            HashSet<String> scNames = new HashSet<String>();
            for (WsCompileClientEditorSupport.ServiceSettings serviceClientSettings : serviceClients) {
                scNames.add(serviceClientSettings.getServiceName());
            }
            StringBuffer clientDCP = new StringBuffer();
            StringBuffer clientWDD = new StringBuffer();
            Set globalPath = GlobalPathRegistry.getDefault().getSourceRoots();
            HashSet<String> serverNames = new HashSet<String>();
            for (FileObject sourceRoot : globalPath) {
                String wdd;
                WebServicesSupport wss;
                Project serverProject = FileOwnerQuery.getOwner((FileObject)sourceRoot);
                if (serverProject == null || !serverNames.add(serverProject.getProjectDirectory().getName()) || (wss = WebServicesSupport.getWebServicesSupport((FileObject)serverProject.getProjectDirectory())) == null) continue;
                List services = wss.getServices();
                boolean match = false;
                for (WsCompileEditorSupport.ServiceSettings serviceSettings : services) {
                    String serviceName = serviceSettings.getServiceName();
                    if (!scNames.contains(serviceName)) continue;
                    match = true;
                    break;
                }
                if (!match) continue;
                AntProjectHelper serverHelper = wss.getAntProjectHelper();
                String dcp = serverHelper.getStandardPropertyEvaluator().getProperty("debug.classpath");
                if (dcp != null) {
                    String[] pathTokens = PropertyUtils.tokenizePath((String)dcp);
                    for (int i = 0; i < pathTokens.length; ++i) {
                        File f = new File(pathTokens[i]);
                        if (!f.isAbsolute()) {
                            pathTokens[i] = serverProject.getProjectDirectory().getPath() + "/" + pathTokens[i];
                        }
                        clientDCP.append(pathTokens[i] + ":");
                    }
                }
                if ((wdd = serverHelper.getStandardPropertyEvaluator().getProperty("web.docbase.dir")) == null) continue;
                String[] pathTokens = PropertyUtils.tokenizePath((String)wdd);
                for (int i = 0; i < pathTokens.length; ++i) {
                    File f = new File(pathTokens[i]);
                    if (!f.isAbsolute()) {
                        pathTokens[i] = serverProject.getProjectDirectory().getPath() + "/" + pathTokens[i];
                    }
                    clientWDD.append(pathTokens[i] + ":");
                }
            }
            if (clientDCP.length() > 0) {
                p.setProperty("ws.debug.classpaths", clientDCP.toString());
            }
            if (clientWDD.length() > 0) {
                p.setProperty("ws.web.docbase.dirs", clientWDD.toString());
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean runServlet(Properties p, FileObject javaFile, String actionName, boolean debug, boolean profile, List<String> targetNames) {
        String[] urlPatterns;
        assert (!debug || !profile);
        WebModule webModule = WebModule.getWebModule((FileObject)javaFile);
        final Dialog[] waitDialog = new Dialog[1];
        final boolean[] cancel = new boolean[1];
        if (SetExecutionUriAction.isScanInProgress(webModule, javaFile, new ServletScanObserver(){

            @Override
            public void scanFinished() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (waitDialog[0] != null) {
                            waitDialog[0].setVisible(false);
                            waitDialog[0].dispose();
                        }
                    }
                });
            }
        })) {
            JLabel label = new JLabel(NbBundle.getMessage(WebActionProvider.class, (String)"MSG_WaitScan"), UIManager.getIcon("OptionPane.informationIcon"), 2);
            label.setBorder(new EmptyBorder(12, 12, 11, 11));
            DialogDescriptor dd = new DialogDescriptor((Object)label, NbBundle.getMessage(WebActionProvider.class, (String)actionName).replace("&", ""), true, new Object[]{NbBundle.getMessage(WebActionProvider.class, (String)"LBL_CancelAction", (Object[])new Object[]{NbBundle.getMessage(WebActionProvider.class, (String)actionName)})}, null, 0, null, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    if (waitDialog[0] != null) {
                        waitDialog[0].setVisible(false);
                        waitDialog[0].dispose();
                        cancel[0] = true;
                    }
                }
            });
            waitDialog[0] = DialogDisplayer.getDefault().createDialog(dd);
            waitDialog[0].pack();
            waitDialog[0].setVisible(true);
            if (cancel[0]) {
                return true;
            }
        }
        if ((urlPatterns = SetExecutionUriAction.getServletMappings(webModule, javaFile)) != null && urlPatterns.length > 0) {
            ServletUriPanel uriPanel = new ServletUriPanel(urlPatterns, (String)javaFile.getAttribute("execution.uri"), false);
            DialogDescriptor desc = new DialogDescriptor((Object)uriPanel, NbBundle.getMessage(WebActionProvider.class, (String)"TTL_setServletExecutionUri"));
            Object res = DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
            if (!res.equals(NotifyDescriptor.YES_OPTION)) return true;
            p.setProperty("client.urlPart", uriPanel.getServletUri());
            try {
                javaFile.setAttribute("execution.uri", (Object)uriPanel.getServletUri());
            }
            catch (IOException ex) {}
        } else {
            if (!debug) return this.runEmptyMapping(javaFile);
            return this.debugEmptyMapping(javaFile);
        }
        p.setProperty("run.single.on.server", "yes");
        if (profile) {
            targetNames.add("profile");
            return true;
        } else if (debug) {
            targetNames.add("debug");
            return true;
        } else {
            targetNames.add("run");
        }
        return true;
    }

    private boolean runEmptyMapping(FileObject javaFile) {
        String mes = MessageFormat.format(NbBundle.getMessage(WebActionProvider.class, (String)"TXT_noExecutableClass"), javaFile.getName());
        NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)mes, 0);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
        return true;
    }

    private boolean debugEmptyMapping(FileObject javaFile) {
        JavaSource js = JavaSource.forFileObject((FileObject)javaFile);
        if (this.isWebService(js)) {
            String mes = MessageFormat.format(NbBundle.getMessage(WebActionProvider.class, (String)"TXT_cannotDebugWebservice"), javaFile.getName());
            NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)mes, 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
            return true;
        }
        String mes = MessageFormat.format(NbBundle.getMessage(WebActionProvider.class, (String)"TXT_missingServletMappings"), javaFile.getName());
        NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)mes, 0);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
        return true;
    }

    public void invalidateClassFile(FileObject jsp) {
        String dir = this.getAntProjectHelper().getStandardPropertyEvaluator().getProperty("build.generated.dir");
        if (dir == null) {
            return;
        }
        dir = dir + "/src";
        WebModule wm = WebModule.getWebModule((FileObject)jsp);
        if (wm == null) {
            return;
        }
        String name = Utils.getServletName(wm.getDocumentBase(), jsp);
        String filePath = name.substring(0, name.lastIndexOf(46)).replace('.', '/');
        String fileClass = dir + '/' + filePath + ".class";
        String fileJava = dir + '/' + filePath + ".java";
        FileObject fC = FileUtil.toFileObject((File)this.getAntProjectHelper().resolveFile(fileClass));
        FileObject fJ = FileUtil.toFileObject((File)this.getAntProjectHelper().resolveFile(fileJava));
        try {
            if (fJ != null && fJ.isValid()) {
                fJ.delete();
            }
            if (fC != null && fC.isValid()) {
                fC.delete();
            }
        }
        catch (IOException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
    }

    public boolean areIncludesModified(FileObject jsp) {
        boolean modified = false;
        WebModule wm = WebModule.getWebModule((FileObject)jsp);
        JspParserAPI jspParser = JspParserFactory.getJspParser();
        JspParserAPI.ParseResult result = jspParser.analyzePage(jsp, wm, 1);
        if (!result.isParsingSuccess()) {
            modified = true;
        } else {
            List includes;
            PageInfo pi = result.getPageInfo();
            if (pi != null && (includes = pi.getDependants()) != null && includes.size() > 0) {
                long jspTS = jsp.lastModified().getTime();
                int size = includes.size();
                for (int i = 0; i < size; ++i) {
                    String filename = (String)includes.get(i);
                    filename = FileUtil.toFile((FileObject)wm.getDocumentBase()).getPath() + filename;
                    File f = new File(filename);
                    long incTS = f.lastModified();
                    if (incTS <= jspTS) continue;
                    modified = true;
                    break;
                }
            }
        }
        return modified;
    }

    private boolean decodeBoolean(String raw) {
        String lowecaseRaw;
        return raw != null && ((lowecaseRaw = raw.toLowerCase()).equals("true") || lowecaseRaw.equals("yes") || lowecaseRaw.equals("enabled"));
    }

    private void setAllPropertiesForSingleJSPCompilation(Properties p, FileObject[] files) {
        p.setProperty("jsp.includes", this.getBuiltJspFileNamesAsPath(files));
        p.setProperty("javac.jsp.includes", this.getCommaSeparatedGeneratedJavaFiles(files));
    }

    public String getCommaSeparatedGeneratedJavaFiles(FileObject[] jspFiles) {
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < jspFiles.length; ++i) {
            String jspRes = this.getJspResource(jspFiles[i]);
            if (i > 0) {
                b.append(',');
            }
            b.append(Utils.getGeneratedJavaResource(jspRes));
        }
        return b.toString();
    }

    private String getJspResource(FileObject jsp) {
        ProjectWebModule pwm = this.getWebProject().getWebModule();
        FileObject webDir = pwm.getDocumentBase();
        return FileUtil.getRelativePath((FileObject)webDir, (FileObject)jsp);
    }

    public File getBuiltJsp(FileObject jsp) {
        ProjectWebModule pwm = this.getWebProject().getWebModule();
        FileObject webDir = pwm.getDocumentBase();
        String relFile = FileUtil.getRelativePath((FileObject)webDir, (FileObject)jsp).replace('/', File.separatorChar);
        File webBuildDir = pwm.getContentDirectoryAsFile();
        return new File(webBuildDir, relFile);
    }

    public String getBuiltJspFileNamesAsPath(FileObject[] files) {
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < files.length; ++i) {
            String path = this.getBuiltJsp(files[i]).getAbsolutePath();
            if (i > 0) {
                b.append(File.pathSeparator);
            }
            b.append(path);
        }
        return b.toString();
    }

    private WebProject getWebProject() {
        return (WebProject)this.getProject();
    }

    public boolean isActionEnabled(String command, Lookup context) {
        if (command.equals(COMMAND_VERIFY)) {
            return this.getWebProject().getWebModule().hasVerifierSupport();
        }
        if (super.isActionEnabled(command, context)) {
            return true;
        }
        if (command.equals("compile.single") || command.equals("debug.single") || command.equals("run.single") || command.equals("profile.single")) {
            return this.findJsps(context) != null || this.findHtml(context) != null;
        }
        return false;
    }

    private static FileObject[] findSelectedFilesByMimeType(Lookup context, FileObject dir, String mimeType, String suffix, boolean strict) {
        if (dir != null && !dir.isFolder()) {
            throw new IllegalArgumentException("Not a folder: " + dir);
        }
        ArrayList<FileObject> files = new ArrayList<FileObject>();
        for (DataObject d : context.lookupAll(DataObject.class)) {
            boolean matches;
            FileObject f = d.getPrimaryFile();
            boolean bl = matches = FileUtil.toFile((FileObject)f) != null;
            if (dir != null) {
                matches &= FileUtil.isParentOf((FileObject)dir, (FileObject)f) || dir == f;
            }
            if (mimeType != null) {
                matches &= f.getMIMEType().equals(mimeType);
            }
            if (suffix != null) {
                matches &= !f.getNameExt().endsWith(suffix);
            }
            if (matches) {
                files.add(f);
                continue;
            }
            if (!strict) continue;
            return null;
        }
        if (files.isEmpty()) {
            return null;
        }
        return files.toArray(new FileObject[files.size()]);
    }

    private FileObject[] findHtml(Lookup context) {
        FileObject webDir = this.getWebProject().getWebModule().getDocumentBase();
        FileObject[] files = null;
        if (webDir != null && (files = WebActionProvider.findSelectedFilesByMimeType(context, webDir, "text/html", null, true)) == null) {
            files = WebActionProvider.findSelectedFilesByMimeType(context, webDir, "text/xhtml", null, true);
        }
        return files;
    }

    private FileObject[] findJsps(Lookup context) {
        FileObject webDir = this.getWebProject().getWebModule().getDocumentBase();
        FileObject[] files = null;
        if (webDir != null) {
            files = WebActionProvider.findSelectedFilesByMimeType(context, webDir, "text/x-jsp", ".jspf", true);
        }
        return files;
    }

    private boolean isDebugged() {
        J2eeModuleProvider jmp = (J2eeModuleProvider)this.getWebProject().getLookup().lookup(J2eeModuleProvider.class);
        Session[] sessions = DebuggerManager.getDebuggerManager().getSessions();
        ServerDebugInfo sdi = null;
        if (sessions != null && sessions.length > 0 && (sdi = jmp.getServerDebugInfo()) == null) {
            return false;
        }
        if (sessions != null) {
            for (int i = 0; i < sessions.length; ++i) {
                String hostname;
                String shmem;
                Object o;
                Session s = sessions[i];
                if (s == null || (o = s.lookupFirst(null, AttachingDICookie.class)) == null) continue;
                AttachingDICookie attCookie = (AttachingDICookie)o;
                if (!(sdi.getTransport().equals("dt_shmem") ? (shmem = attCookie.getSharedMemoryName()) != null && shmem.equalsIgnoreCase(sdi.getShmemName()) : (hostname = attCookie.getHostName()) != null && hostname.equalsIgnoreCase(sdi.getHost()) && attCookie.getPortNumber() == sdi.getPort())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkSelectedServer(boolean checkDebug, boolean checkProfile) {
        PropertyEvaluator eval = this.getAntProjectHelper().getStandardPropertyEvaluator();
        if ("false".equals(eval.getProperty("j2ee.server.check"))) {
            return true;
        }
        return J2EEProjectProperties.checkSelectedServer((Project)this.getProject(), (AntProjectHelper)this.getAntProjectHelper(), (Profile)((WebProject)this.getProject()).getAPIWebModule().getJ2eeProfile(), (J2eeModule.Type)J2eeModule.Type.WAR, (J2EEProjectProperties.SetServerInstanceCallback)new J2EEProjectProperties.SetServerInstanceCallback(){

            public void setServerInstance(String serverInstanceId) {
                WebActionProvider.this.setServerInstance(serverInstanceId);
            }
        }, (boolean)checkDebug, (boolean)checkProfile, (boolean)false);
    }

    private void setServerInstance(String serverInstanceId) {
        WebProjectProperties.setServerInstance((WebProject)this.getProject(), this.getUpdateHelper(), serverInstanceId);
    }

    private boolean isDDServlet(Lookup context, FileObject javaClass) {
        FileObject webInfDir = this.getWebProject().getWebModule().getWebInf();
        if (webInfDir == null) {
            return false;
        }
        FileObject fo = webInfDir.getFileObject("web.xml");
        if (fo == null) {
            return false;
        }
        String relPath = FileUtil.getRelativePath((FileObject)this.getRoot(this.getWebProject().getSourceRoots().getRoots(), javaClass), (FileObject)javaClass);
        String className = relPath.replace('/', '.').replaceFirst("\\.java$", "");
        try {
            WebApp webApp = DDProvider.getDefault().getDDRoot(fo);
            Servlet servlet = (Servlet)webApp.findBeanByName("Servlet", "ServletClass", className);
            return servlet != null;
        }
        catch (IOException ex) {
            return false;
        }
    }

    private FileObject getRoot(FileObject[] roots, FileObject file) {
        FileObject srcDir = null;
        for (int i = 0; i < roots.length; ++i) {
            if (!FileUtil.isParentOf((FileObject)roots[i], (FileObject)file) && !roots[i].equals(file)) continue;
            srcDir = roots[i];
            break;
        }
        return srcDir;
    }

    private void setDirectoryDeploymentProperty(Properties p) {
        String instance = this.getAntProjectHelper().getStandardPropertyEvaluator().getProperty("j2ee.server.instance");
        if (instance != null) {
            J2eeModuleProvider jmp = (J2eeModuleProvider)this.getProject().getLookup().lookup(J2eeModuleProvider.class);
            String sdi = jmp.getServerInstanceID();
            J2eeModule mod = jmp.getJ2eeModule();
            if (sdi != null && mod != null) {
                boolean cFD = Deployment.getDefault().canFileDeploy(instance, mod);
                p.setProperty(DIRECTORY_DEPLOYMENT_SUPPORTED, "" + cFD);
            }
        }
    }

    private boolean isWebService(JavaSource js) {
        final boolean[] foundWebServiceAnnotation = new boolean[]{false};
        if (js != null) {
            try {
                js.runUserActionTask((Task)new Task<CompilationController>(){

                    public void run(CompilationController ci) throws Exception {
                        TypeElement wsElement;
                        ci.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        TypeElement classEl = SourceUtils.getPublicTopLevelElement((CompilationController)ci);
                        if (classEl != null && (wsElement = ci.getElements().getTypeElement("javax.jws.WebService")) != null) {
                            List<? extends AnnotationMirror> annotations = classEl.getAnnotationMirrors();
                            for (AnnotationMirror annotationMirror : annotations) {
                                if (!ci.getTypes().isSameType(wsElement.asType(), annotationMirror.getAnnotationType())) continue;
                                foundWebServiceAnnotation[0] = true;
                                break;
                            }
                        }
                    }
                }, true);
            }
            catch (IOException ioex) {
                Exceptions.printStackTrace((Throwable)ioex);
            }
        }
        return foundWebServiceAnnotation[0];
    }

    public static WebActionProvider create(@NonNull Lookup lkp) {
        Parameters.notNull((CharSequence)"lkp", (Object)lkp);
        WebProject project = (WebProject)lkp.lookup(WebProject.class);
        WebActionProvider webActionProvider = new WebActionProvider(project, project.getUpdateHelper(), project.evaluator());
        webActionProvider.startFSListener();
        return webActionProvider;
    }

    private static class CallbackImpl
    implements BaseActionProvider.Callback2 {
        private final J2eeModuleProvider provider;
        private final ClassPathProviderImpl cp;

        public CallbackImpl(ClassPathProviderImpl cp, J2eeModuleProvider provider) {
            this.cp = cp;
            this.provider = provider;
        }

        public ClassPath getProjectSourcesClassPath(String type) {
            return this.cp.getProjectSourcesClassPath(type);
        }

        public ClassPath findClassPath(FileObject file, String type) {
            return this.cp.findClassPath(file, type);
        }

        public void antTargetInvocationFailed(String command, Lookup context) {
            Deployment.getDefault().resumeDeployOnSave(this.provider);
        }

        public void antTargetInvocationFinished(String command, Lookup context, int result) {
            Deployment.getDefault().resumeDeployOnSave(this.provider);
        }

        public void antTargetInvocationStarted(String command, Lookup context) {
            Deployment.getDefault().suspendDeployOnSave(this.provider);
        }
    }
}

