/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.qnavigator.navigator;

import java.awt.Image;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.netbeans.api.actions.Openable;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmEnum;
import org.netbeans.modules.cnd.api.model.CsmEnumerator;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.deep.CsmCaseStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmCompoundStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmDeclarationStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmExceptionHandler;
import org.netbeans.modules.cnd.api.model.deep.CsmExpressionStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmForStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmIfStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmLoopStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmRangeForStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmReturnStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmSwitchStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmTryCatchStatement;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelutil.CsmImageLoader;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.editor.breadcrumbs.spi.BreadcrumbsController;
import org.netbeans.modules.editor.breadcrumbs.spi.BreadcrumbsElement;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.CharSequences;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public final class StatementNode
implements BreadcrumbsElement {
    private final List<CsmTrueElement> trueCsmElements;
    private List<BreadcrumbsElement> children;
    private final BreadcrumbsElement parent;
    private final CharSequence displayName;
    private final Lookup lookup;
    private final DataObject cdo;
    private final int openOffset;
    private int startOffset;
    private int endOffset;
    private final Image icon;
    private final AtomicBoolean canceled;
    private final CharSequence text;

    static StatementNode createStatementNode(CsmOffsetable ofsetable, String decoration, BreadcrumbsElement parent, DataObject cdo, AtomicBoolean canceled, CharSequence text) {
        if (CsmKindUtilities.isStatement((CsmObject)ofsetable)) {
            CsmStatement statement = (CsmStatement)ofsetable;
            switch (statement.getKind()) {
                case COMPOUND: {
                    return StatementNode.createBodyNode((CsmCompoundStatement)statement, decoration, parent, cdo, canceled, text);
                }
                case IF: {
                    return StatementNode.createIfNode((CsmIfStatement)statement, decoration, parent, cdo, canceled, text);
                }
                case TRY_CATCH: {
                    return StatementNode.createTryNode((CsmTryCatchStatement)statement, decoration, parent, cdo, canceled, text);
                }
                case CATCH: {
                    return StatementNode.createBodyNode((CsmCompoundStatement)((CsmExceptionHandler)statement), decoration, parent, cdo, canceled, text);
                }
                case DECLARATION: {
                    return StatementNode.createDeclarationNode((CsmDeclarationStatement)statement, decoration, parent, cdo, canceled, text);
                }
                case WHILE: 
                case DO_WHILE: {
                    return StatementNode.createLoopNode((CsmLoopStatement)statement, decoration, parent, cdo, canceled, text);
                }
                case FOR: {
                    return StatementNode.createForNode((CsmForStatement)statement, decoration, parent, cdo, canceled, text);
                }
                case RANGE_FOR: {
                    return StatementNode.createRangeForNode((CsmRangeForStatement)statement, decoration, parent, cdo, canceled, text);
                }
                case SWITCH: {
                    return StatementNode.createSwitchNode((CsmSwitchStatement)statement, decoration, parent, cdo, canceled, text);
                }
                case EXPRESSION: {
                    return StatementNode.createExpressionNode((CsmExpressionStatement)statement, decoration, parent, cdo, canceled, text);
                }
                case RETURN: {
                    return StatementNode.createReturnNode((CsmReturnStatement)statement, decoration, parent, cdo, canceled, text);
                }
                case CASE: {
                    return StatementNode.createCaseNode((CsmCaseStatement)statement, decoration, parent, cdo, canceled, text);
                }
            }
            return null;
        }
        if (CsmKindUtilities.isDeclaration((CsmObject)ofsetable)) {
            if (CsmKindUtilities.isClass((CsmObject)ofsetable)) {
                ArrayList<CsmTrueElement> inner = new ArrayList<CsmTrueElement>();
                CsmClass cls = (CsmClass)ofsetable;
                for (CsmMember member : cls.getMembers()) {
                    if (canceled != null && canceled.get()) break;
                    CsmTrueElement csmTrueElement = new CsmTrueElement((CsmOffsetable)member);
                    inner.add(csmTrueElement);
                }
                return new StatementNode(ofsetable, decoration, inner, parent, cdo, canceled, text);
            }
            if (CsmKindUtilities.isEnum((CsmObject)ofsetable)) {
                ArrayList<CsmTrueElement> inner = new ArrayList<CsmTrueElement>();
                CsmEnum cls = (CsmEnum)ofsetable;
                for (CsmEnumerator member : cls.getEnumerators()) {
                    if (canceled != null && canceled.get()) break;
                    CsmTrueElement csmTrueElement = new CsmTrueElement((CsmOffsetable)member);
                    inner.add(csmTrueElement);
                }
                return new StatementNode(ofsetable, decoration, inner, parent, cdo, canceled, text);
            }
            if (CsmKindUtilities.isFunctionDefinition((CsmObject)ofsetable)) {
                ArrayList<CsmTrueElement> inner = new ArrayList<CsmTrueElement>();
                CsmCompoundStatement body = ((CsmFunctionDefinition)ofsetable).getBody();
                if (body != null) {
                    for (CsmStatement st : body.getStatements()) {
                        if (canceled != null && canceled.get()) break;
                        CsmTrueElement csmTrueElement = new CsmTrueElement((CsmOffsetable)st);
                        inner.add(csmTrueElement);
                    }
                }
                return new StatementNode(ofsetable, decoration, inner, parent, cdo, canceled, text);
            }
            return new StatementNode(ofsetable, decoration, Collections.<CsmTrueElement>emptyList(), parent, cdo, canceled, text);
        }
        return null;
    }

    private static StatementNode createBodyNode(CsmCompoundStatement body, String decoration, BreadcrumbsElement parent, DataObject cdo, AtomicBoolean canceled, CharSequence text) {
        ArrayList<CsmTrueElement> st = new ArrayList<CsmTrueElement>();
        for (CsmStatement s : body.getStatements()) {
            if (canceled != null && canceled.get()) break;
            st.add(new CsmTrueElement((CsmOffsetable)s));
        }
        return new StatementNode((CsmOffsetable)body, decoration, st, parent, cdo, canceled, text);
    }

    private static StatementNode createIfNode(CsmIfStatement stmt, String decoration, BreadcrumbsElement parent, DataObject cdo, AtomicBoolean canceled, CharSequence text) {
        ArrayList<CsmTrueElement> st = new ArrayList<CsmTrueElement>();
        CsmStatement thenStmt = stmt.getThen();
        int lastThenOffset = -1;
        if (thenStmt != null) {
            CsmTrueElement csmTrueElement = new CsmTrueElement((CsmOffsetable)thenStmt);
            st.add(csmTrueElement);
            csmTrueElement.decoration = "then ";
            ArrayList<CsmOffsetable> list = new ArrayList<CsmOffsetable>();
            list.add((CsmOffsetable)thenStmt);
            csmTrueElement.body = list;
            lastThenOffset = thenStmt.getEndOffset();
        }
        CsmStatement elseStmt = stmt.getElse();
        while (elseStmt != null && elseStmt.getKind() == CsmStatement.Kind.IF) {
            CsmIfStatement elseIfStmt = (CsmIfStatement)elseStmt;
            CsmTrueElement csmTrueElement = new CsmTrueElement((CsmOffsetable)elseIfStmt);
            st.add(csmTrueElement);
            csmTrueElement.decoration = "else ";
            ArrayList<CsmOffsetable> list = new ArrayList<CsmOffsetable>();
            csmTrueElement.body = list;
            CsmStatement elifThenStmt = elseIfStmt.getThen();
            if (elifThenStmt != null) {
                list.add((CsmOffsetable)elifThenStmt);
                csmTrueElement.startOffset = lastThenOffset >= 0 ? lastThenOffset + 1 : elseStmt.getStartOffset();
                csmTrueElement.endOffset = elifThenStmt.getEndOffset();
                lastThenOffset = elifThenStmt.getEndOffset();
            }
            elseStmt = elseIfStmt.getElse();
        }
        if (elseStmt != null) {
            CsmTrueElement csmTrueElement = new CsmTrueElement((CsmOffsetable)elseStmt);
            st.add(csmTrueElement);
            csmTrueElement.decoration = "else ";
            if (lastThenOffset >= 0) {
                csmTrueElement.startOffset = lastThenOffset + 1;
            }
            ArrayList<CsmOffsetable> list = new ArrayList<CsmOffsetable>();
            list.add((CsmOffsetable)elseStmt);
            csmTrueElement.body = list;
        }
        return new StatementNode((CsmOffsetable)stmt, decoration, st, parent, cdo, canceled, text);
    }

    private static StatementNode createTryNode(CsmTryCatchStatement stmt, String decoration, BreadcrumbsElement parent, DataObject cdo, AtomicBoolean canceled, CharSequence text) {
        ArrayList<CsmTrueElement> st = new ArrayList<CsmTrueElement>();
        if (stmt.getTryStatement() != null) {
            st.add(new CsmTrueElement((CsmOffsetable)stmt.getTryStatement()));
        }
        for (CsmExceptionHandler handler : stmt.getHandlers()) {
            if (canceled != null && canceled.get()) break;
            st.add(new CsmTrueElement((CsmOffsetable)handler));
        }
        return new StatementNode((CsmOffsetable)stmt, decoration, st, parent, cdo, canceled, text);
    }

    private static StatementNode createLoopNode(CsmLoopStatement stmt, String decoration, BreadcrumbsElement parent, DataObject cdo, AtomicBoolean canceled, CharSequence text) {
        ArrayList<CsmTrueElement> st = new ArrayList<CsmTrueElement>();
        CsmStatement body = stmt.getBody();
        if (CsmKindUtilities.isCompoundStatement((CsmObject)body)) {
            for (CsmStatement s : ((CsmCompoundStatement)body).getStatements()) {
                st.add(new CsmTrueElement((CsmOffsetable)s));
            }
        } else if (body != null) {
            st.add(new CsmTrueElement((CsmOffsetable)stmt.getBody()));
        }
        return new StatementNode((CsmOffsetable)stmt, decoration, st, parent, cdo, canceled, text);
    }

    private static StatementNode createForNode(CsmForStatement stmt, String decoration, BreadcrumbsElement parent, DataObject cdo, AtomicBoolean canceled, CharSequence text) {
        ArrayList<CsmTrueElement> st = new ArrayList<CsmTrueElement>();
        CsmStatement body = stmt.getBody();
        if (CsmKindUtilities.isCompoundStatement((CsmObject)body)) {
            for (CsmStatement s : ((CsmCompoundStatement)body).getStatements()) {
                if (canceled == null || !canceled.get()) {
                    st.add(new CsmTrueElement((CsmOffsetable)s));
                    continue;
                }
                break;
            }
        } else if (body != null) {
            st.add(new CsmTrueElement((CsmOffsetable)stmt.getBody()));
        }
        return new StatementNode((CsmOffsetable)stmt, decoration, st, parent, cdo, canceled, text);
    }

    private static StatementNode createRangeForNode(CsmRangeForStatement stmt, String decoration, BreadcrumbsElement parent, DataObject cdo, AtomicBoolean canceled, CharSequence text) {
        ArrayList<CsmTrueElement> st = new ArrayList<CsmTrueElement>();
        if (stmt.getDeclaration() != null) {
            st.add(new CsmTrueElement((CsmOffsetable)stmt.getDeclaration()));
        }
        if (stmt.getBody() != null) {
            st.add(new CsmTrueElement((CsmOffsetable)stmt.getBody()));
        }
        return new StatementNode((CsmOffsetable)stmt, decoration, st, parent, cdo, canceled, text);
    }

    private static StatementNode createSwitchNode(CsmSwitchStatement stmt, String decoration, BreadcrumbsElement parent, DataObject cdo, AtomicBoolean canceled, CharSequence text) {
        ArrayList<CsmTrueElement> st = new ArrayList<CsmTrueElement>();
        CsmStatement body = stmt.getBody();
        if (CsmKindUtilities.isCompoundStatement((CsmObject)body)) {
            CsmTrueElement currElement = null;
            int lastTrueStart = body.getStartOffset() + 1;
            for (CsmStatement c : ((CsmCompoundStatement)body).getStatements()) {
                if (canceled != null && canceled.get()) break;
                if (c.getKind() == CsmStatement.Kind.CASE || c.getKind() == CsmStatement.Kind.DEFAULT) {
                    if (currElement != null) {
                        st.add(currElement);
                    }
                    currElement = new CsmTrueElement((CsmOffsetable)c);
                    currElement.startOffset = lastTrueStart;
                    currElement.decoration = c.getKind() == CsmStatement.Kind.CASE ? "case " : "";
                    currElement.body = new ArrayList<CsmOffsetable>();
                    lastTrueStart = c.getEndOffset() + 1;
                    continue;
                }
                if (currElement == null) continue;
                currElement.body.add((CsmOffsetable)c);
                currElement.endOffset = c.getEndOffset();
                lastTrueStart = c.getEndOffset() + 1;
            }
            if (currElement != null) {
                st.add(currElement);
            }
        }
        return new StatementNode((CsmOffsetable)stmt, decoration, st, parent, cdo, canceled, text);
    }

    private static StatementNode createExpressionNode(CsmExpressionStatement stmt, String decoration, BreadcrumbsElement parent, DataObject cdo, AtomicBoolean canceled, CharSequence text) {
        return new StatementNode((CsmOffsetable)stmt, decoration, Collections.<CsmTrueElement>emptyList(), parent, cdo, canceled, text);
    }

    private static StatementNode createReturnNode(CsmReturnStatement stmt, String decoration, BreadcrumbsElement parent, DataObject cdo, AtomicBoolean canceled, CharSequence text) {
        return new StatementNode((CsmOffsetable)stmt, decoration, Collections.<CsmTrueElement>emptyList(), parent, cdo, canceled, text);
    }

    private static StatementNode createDeclarationNode(CsmDeclarationStatement stmt, String decoration, BreadcrumbsElement parent, DataObject cdo, AtomicBoolean canceled, CharSequence text) {
        ArrayList<CsmTrueElement> inner = new ArrayList();
        for (CsmDeclaration decl : stmt.getDeclarators()) {
            CsmTrueElement csmTrueElement;
            if (CsmKindUtilities.isClass((CsmObject)decl)) {
                csmTrueElement = new CsmTrueElement((CsmOffsetable)decl);
                inner.add(csmTrueElement);
                CsmClass cls = (CsmClass)decl;
                csmTrueElement.body = new ArrayList<CsmOffsetable>();
                for (CsmMember member : cls.getMembers()) {
                    csmTrueElement.body.add((CsmOffsetable)member);
                }
                continue;
            }
            if (CsmKindUtilities.isEnum((CsmObject)decl)) {
                csmTrueElement = new CsmTrueElement((CsmOffsetable)decl);
                inner.add(csmTrueElement);
                CsmEnum en = (CsmEnum)decl;
                csmTrueElement.body = new ArrayList<CsmOffsetable>();
                for (CsmMember member : en.getEnumerators()) {
                    csmTrueElement.body.add((CsmOffsetable)member);
                }
                continue;
            }
            if (!CsmKindUtilities.isFunctionDefinition((CsmObject)decl)) continue;
            csmTrueElement = new CsmTrueElement((CsmOffsetable)decl);
            inner.add(csmTrueElement);
            CsmCompoundStatement body = ((CsmFunctionDefinition)decl).getBody();
            csmTrueElement.body = Collections.singletonList(body);
        }
        if (inner.isEmpty()) {
            inner = Collections.emptyList();
        }
        return new StatementNode((CsmOffsetable)stmt, decoration, inner, parent, cdo, canceled, text);
    }

    private static StatementNode createCaseNode(CsmCaseStatement stmt, String decoration, BreadcrumbsElement parent, DataObject cdo, AtomicBoolean canceled, CharSequence text) {
        return new StatementNode((CsmOffsetable)stmt, decoration, Collections.<CsmTrueElement>emptyList(), parent, cdo, canceled, text);
    }

    private StatementNode(CsmTrueElement owner, String decoration, List<CsmTrueElement> trueCsmElements, BreadcrumbsElement parent, DataObject cdo, AtomicBoolean canceled, CharSequence text) {
        this(owner.ofsetable, decoration, trueCsmElements, parent, cdo, canceled, text);
        this.startOffset = owner.startOffset;
        this.endOffset = owner.endOffset;
    }

    private StatementNode(CsmOffsetable owner, String decoration, List<CsmTrueElement> trueCsmElements, BreadcrumbsElement parent, DataObject cdo, AtomicBoolean canceled, CharSequence text) {
        this.icon = CsmKindUtilities.isDeclaration((CsmObject)owner) ? CsmImageLoader.getImage((CsmObject)owner) : BreadcrumbsController.NO_ICON;
        this.trueCsmElements = trueCsmElements;
        this.parent = parent;
        this.canceled = canceled;
        StringBuilder buf = new StringBuilder();
        if (decoration != null) {
            buf.append(decoration);
        }
        this.text = text;
        this.openOffset = owner.getStartOffset();
        this.startOffset = owner.getStartOffset();
        int end = owner.getEndOffset();
        if (canceled == null || !canceled.get()) {
            CharSequence aText;
            int shift = 0;
            if (text == null) {
                aText = owner.getText();
                shift = -this.startOffset;
            } else {
                aText = text;
            }
            block9: for (int i = this.startOffset + shift; i < aText.length() && i < end + shift; ++i) {
                char c = aText.charAt(i);
                switch (c) {
                    case ' ': {
                        if (buf.length() <= 0) continue block9;
                        buf.append(c);
                        continue block9;
                    }
                    case '\t': {
                        if (buf.length() <= 0) continue block9;
                        buf.append(' ');
                        continue block9;
                    }
                    case '\n': {
                        break block9;
                    }
                    case '<': {
                        buf.append("&lt;");
                        continue block9;
                    }
                    case '>': {
                        buf.append("&gt;");
                        continue block9;
                    }
                    case '&': {
                        buf.append("&amp;");
                        continue block9;
                    }
                    case '/': {
                        if (i + 1 >= aText.length() || aText.charAt(i) != '/') continue block9;
                        break block9;
                    }
                    default: {
                        buf.append(c);
                    }
                }
            }
        }
        for (CsmTrueElement s : trueCsmElements) {
            if (s.endOffset <= end) continue;
            end = s.endOffset;
        }
        this.endOffset = end;
        int i = buf.indexOf("{");
        if (i > 0) {
            buf.setLength(i);
        }
        this.displayName = CharSequences.create((CharSequence)buf.toString().trim());
        this.cdo = cdo;
        this.lookup = Lookups.fixed((Object[])new Object[]{new OpenableImpl(this)});
    }

    public String getHtmlDisplayName() {
        return this.displayName.toString();
    }

    public Image getIcon(int type) {
        return this.icon;
    }

    public Image getOpenedIcon(int type) {
        return this.icon;
    }

    public List<BreadcrumbsElement> getChildren() {
        if (this.children == null) {
            this.children = new ArrayList<BreadcrumbsElement>();
            for (CsmTrueElement s : this.trueCsmElements) {
                StatementNode node;
                if (this.canceled != null && this.canceled.get()) break;
                List body = s.body;
                String decoration = s.decoration;
                if (body != null) {
                    CsmStatement statement;
                    CsmOffsetable content;
                    if (body.size() == 1 && CsmKindUtilities.isStatement((CsmObject)(content = body.get(0))) && (statement = (CsmStatement)content).getKind() == CsmStatement.Kind.COMPOUND) {
                        body = ((CsmCompoundStatement)statement).getStatements();
                    }
                    if (body.size() == 1 && s.ofsetable == body.get(0)) {
                        node = StatementNode.createStatementNode(s.ofsetable, decoration, this, this.cdo, this.canceled, this.text);
                        if (node != null) {
                            node.startOffset = s.startOffset;
                            node.endOffset = s.endOffset;
                        }
                    } else {
                        ArrayList<CsmTrueElement> sts = new ArrayList<CsmTrueElement>();
                        for (CsmOffsetable st : body) {
                            if (this.canceled != null && this.canceled.get()) break;
                            sts.add(new CsmTrueElement(st));
                        }
                        node = new StatementNode(s, decoration, sts, (BreadcrumbsElement)this, this.cdo, this.canceled, this.text);
                    }
                } else {
                    node = StatementNode.createStatementNode(s.ofsetable, decoration, this, this.cdo, this.canceled, this.text);
                }
                if (node == null) continue;
                this.children.add(node);
            }
        }
        return this.children;
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    public BreadcrumbsElement getParent() {
        return this.parent;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    private static final class CsmTrueElement {
        final CsmOffsetable ofsetable;
        List<CsmOffsetable> body;
        String decoration;
        int startOffset;
        int endOffset;

        private CsmTrueElement(CsmOffsetable offsetable) {
            this.ofsetable = offsetable;
            this.startOffset = offsetable.getStartOffset();
            this.endOffset = offsetable.getEndOffset();
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append(Integer.toString(this.startOffset));
            buf.append('-');
            buf.append(Integer.toString(this.endOffset));
            buf.append(' ');
            if (this.decoration != null) {
                buf.append(this.decoration);
            }
            return buf.toString();
        }
    }

    private static final class OpenableImpl
    implements Openable,
    OpenCookie {
        private final StatementNode node;

        public OpenableImpl(StatementNode node) {
            this.node = node;
        }

        public void open() {
            CsmUtilities.openSource((FileObject)this.node.cdo.getPrimaryFile(), (int)this.node.openOffset);
        }
    }
}

