/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.javaee.ide;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.ActionType;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.OperationUnsupportedException;
import javax.enterprise.deploy.spi.status.ClientConfiguration;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.netbeans.modules.glassfish.javaee.Hk2DeploymentManager;
import org.netbeans.modules.glassfish.javaee.ide.FastDeploy;
import org.netbeans.modules.glassfish.javaee.ide.Hk2DeploymentStatus;
import org.netbeans.modules.glassfish.javaee.ide.Hk2Target;
import org.netbeans.modules.glassfish.javaee.ide.Hk2TargetModuleID;
import org.netbeans.modules.glassfish.tooling.GlassFishIdeException;
import org.netbeans.modules.glassfish.tooling.TaskEvent;
import org.netbeans.modules.glassfish.tooling.TaskState;
import org.netbeans.modules.glassfish.tooling.TaskStateListener;
import org.netbeans.modules.glassfish.tooling.admin.CommandGetProperty;
import org.netbeans.modules.glassfish.tooling.admin.ResultMap;
import org.netbeans.modules.glassfish.tooling.data.GlassFishServer;
import org.netbeans.modules.glassfish.tooling.utils.Utils;
import org.netbeans.modules.j2ee.dd.api.application.Application;
import org.netbeans.modules.j2ee.dd.api.application.DDProvider;
import org.netbeans.modules.j2ee.dd.api.application.Module;
import org.netbeans.modules.j2ee.dd.api.application.Web;
import org.openide.filesystems.FileUtil;

public class MonitorProgressObject
implements ProgressObject,
TaskStateListener {
    private static final String PROPERTY_PATTERN_PREFIX = "applications.application.";
    private final Hk2DeploymentManager dm;
    private final Hk2TargetModuleID moduleId;
    private final CommandType commandType;
    private volatile DeploymentStatus operationStatus;
    private CopyOnWriteArrayList<ProgressListener> listeners = new CopyOnWriteArrayList();
    private static final String[] TYPES = new String[]{"web", "ejb"};

    public MonitorProgressObject(Hk2DeploymentManager dm, Hk2TargetModuleID moduleId) {
        this(dm, moduleId, CommandType.DISTRIBUTE);
    }

    public MonitorProgressObject(Hk2DeploymentManager dm, Hk2TargetModuleID moduleId, CommandType commandType) {
        this.dm = dm;
        this.moduleId = moduleId;
        this.commandType = commandType;
        this.operationStatus = new Hk2DeploymentStatus(commandType, StateType.RUNNING, ActionType.EXECUTE, "Initializing...");
    }

    public DeploymentStatus getDeploymentStatus() {
        return this.operationStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TargetModuleID[] getResultTargetModuleIDs() {
        if (null == this.moduleId) {
            return this.computeResultTMID();
        }
        Hk2TargetModuleID hk2TargetModuleID = this.moduleId;
        synchronized (hk2TargetModuleID) {
            return this.computeResultTMID();
        }
    }

    public ClientConfiguration getClientConfiguration(TargetModuleID moduleId) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isCancelSupported() {
        return false;
    }

    public void cancel() throws OperationUnsupportedException {
        throw new OperationUnsupportedException("Cancel not supported yet.");
    }

    public boolean isStopSupported() {
        return false;
    }

    public void stop() throws OperationUnsupportedException {
        throw new OperationUnsupportedException("Stop not supported yet.");
    }

    public void operationStateChanged(TaskState newState, TaskEvent event, String ... args) {
        String message = args != null ? Utils.concatenate((String[])args) : "";
        Logger.getLogger("glassfish-javaee").log(Level.FINE, message);
        String relayedMessage = newState == TaskState.FAILED ? message : "";
        this.fireHandleProgressEvent(new Hk2DeploymentStatus(this.commandType, this.translateState(newState), ActionType.EXECUTE, relayedMessage));
    }

    private TargetModuleID[] computeResultTMID() {
        TargetModuleID[] retVal = new TargetModuleID[]{this.moduleId};
        try {
            retVal = this.createModuleIdTree(this.moduleId);
        }
        catch (InterruptedException ex) {
            Logger.getLogger("glassfish-javaee").log(Level.INFO, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger("glassfish-javaee").log(Level.INFO, null, ex);
        }
        catch (TimeoutException ex) {
            Logger.getLogger("glassfish-javaee").log(Level.INFO, null, ex);
        }
        return retVal;
    }

    private void loopThroughListeners(DeploymentStatus status) {
        this.operationStatus = status;
        ProgressEvent event = new ProgressEvent((Object)this.dm, (TargetModuleID)this.moduleId, status);
        for (ProgressListener target : this.listeners) {
            target.handleProgressEvent(event);
        }
    }

    private StateType translateState(TaskState commonState) {
        switch (commonState) {
            case READY: 
            case RUNNING: {
                return StateType.RUNNING;
            }
            case COMPLETED: {
                return StateType.COMPLETED;
            }
            case FAILED: {
                return StateType.FAILED;
            }
        }
        return StateType.FAILED;
    }

    public void addProgressListener(ProgressListener listener) {
        this.listeners.add(listener);
    }

    public void removeProgressListener(ProgressListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireHandleProgressEvent(DeploymentStatus status) {
        if (null == this.moduleId) {
            this.loopThroughListeners(status);
        } else {
            Hk2TargetModuleID hk2TargetModuleID = this.moduleId;
            synchronized (hk2TargetModuleID) {
                this.loopThroughListeners(status);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TargetModuleID[] createModuleIdTree(Hk2TargetModuleID moduleId) throws InterruptedException, ExecutionException, TimeoutException {
        Hk2TargetModuleID hk2TargetModuleID = moduleId;
        synchronized (hk2TargetModuleID) {
            Hk2TargetModuleID root = Hk2TargetModuleID.get((Hk2Target)moduleId.getTarget(), moduleId.getModuleID(), null, moduleId.getLocation(), true);
            String query = this.getNameToQuery(moduleId.getModuleID());
            int queryLen = query != null ? query.length() : 0;
            StringBuilder propertyPattern = new StringBuilder(PROPERTY_PATTERN_PREFIX.length() + queryLen);
            propertyPattern.append(PROPERTY_PATTERN_PREFIX);
            if (queryLen > 0) {
                propertyPattern.append(query);
            }
            try {
                ResultMap result = CommandGetProperty.getProperties((GlassFishServer)this.dm.getCommonServerSupport().getInstance(), (String)propertyPattern.toString(), (long)60000L);
                if (result.getState() == TaskState.COMPLETED) {
                    Map values = result.getValue();
                    for (Map.Entry e : values.entrySet()) {
                        String k = (String)e.getKey();
                        int dex1 = k.lastIndexOf(".module.");
                        int dex2 = k.lastIndexOf(".name");
                        String moduleName = (String)e.getValue();
                        if (dex2 <= dex1 || dex1 <= 0 || moduleId.getModuleID().equals(moduleName)) continue;
                        for (String guess : TYPES) {
                            String type = (String)values.get(PROPERTY_PATTERN_PREFIX + moduleId.getModuleID() + ".module." + moduleName + ".engine." + guess + ".sniffer");
                            if (null == type) continue;
                            Hk2TargetModuleID kid = Hk2TargetModuleID.get((Hk2Target)moduleId.getTarget(), moduleName, "web".equals(guess) ? this.determineContextRoot(root, moduleName) : null, moduleId.getLocation() + File.separator + FastDeploy.transform(moduleName));
                            root.addChild(kid);
                        }
                    }
                }
            }
            catch (GlassFishIdeException gfie) {
                Logger.getLogger("glassfish-javaee").log(Level.INFO, "Could not retrieve property from server.", gfie);
            }
            return new TargetModuleID[]{root};
        }
    }

    private String getNameToQuery(String name) {
        if (name.indexOf(46) == -1) {
            return name + ".*";
        }
        StringTokenizer st = new StringTokenizer(name, ".");
        String newName = "";
        int segment = 0;
        int nameSegment = 0;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            ++segment;
            if (token.length() <= newName.length()) continue;
            newName = token;
            nameSegment = segment;
        }
        return (nameSegment > 1 ? "*." + newName : newName) + ".*";
    }

    private String determineContextRoot(Hk2TargetModuleID root, String moduleName) {
        File appxml;
        String retVal = "/" + moduleName;
        int dex = moduleName.lastIndexOf(46);
        if (dex > -1) {
            retVal = "/" + moduleName.substring(0, dex);
        }
        if ((appxml = new File(root.getLocation(), "META-INF" + File.separator + "application.xml")).exists()) {
            try {
                Module[] mods;
                DDProvider ddp = DDProvider.getDefault();
                Application app = ddp.getDDRoot(FileUtil.createData((File)FileUtil.normalizeFile((File)appxml)));
                for (Module m : mods = app.getModule()) {
                    Web w = m.getWeb();
                    if (null == w || !moduleName.equals(w.getWebUri())) continue;
                    retVal = w.getContextRoot();
                    break;
                }
            }
            catch (IOException ex) {
                Logger.getLogger("glassfish-javaee").log(Level.INFO, null, ex);
            }
        }
        return retVal;
    }
}

