/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb2;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.cnd.debugger.common2.capture.ExternalStart;
import org.netbeans.modules.cnd.debugger.common2.capture.ExternalStartManager;
import org.netbeans.modules.cnd.debugger.common2.debugger.Address;
import org.netbeans.modules.cnd.debugger.common2.debugger.DebuggerSettingsBridge;
import org.netbeans.modules.cnd.debugger.common2.debugger.Error;
import org.netbeans.modules.cnd.debugger.common2.debugger.EvalAnnotation;
import org.netbeans.modules.cnd.debugger.common2.debugger.EvaluationWindow;
import org.netbeans.modules.cnd.debugger.common2.debugger.Frame;
import org.netbeans.modules.cnd.debugger.common2.debugger.LocalModel;
import org.netbeans.modules.cnd.debugger.common2.debugger.Location;
import org.netbeans.modules.cnd.debugger.common2.debugger.Log;
import org.netbeans.modules.cnd.debugger.common2.debugger.MacroSupport;
import org.netbeans.modules.cnd.debugger.common2.debugger.ModelChangeDelegator;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebugger;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebuggerImpl;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebuggerInfo;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebuggerManager;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeSession;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeWatch;
import org.netbeans.modules.cnd.debugger.common2.debugger.RoutingToken;
import org.netbeans.modules.cnd.debugger.common2.debugger.SignalDialog;
import org.netbeans.modules.cnd.debugger.common2.debugger.StackModel;
import org.netbeans.modules.cnd.debugger.common2.debugger.Thread;
import org.netbeans.modules.cnd.debugger.common2.debugger.ThreadModel;
import org.netbeans.modules.cnd.debugger.common2.debugger.ToolTipView;
import org.netbeans.modules.cnd.debugger.common2.debugger.VarContinuation;
import org.netbeans.modules.cnd.debugger.common2.debugger.Variable;
import org.netbeans.modules.cnd.debugger.common2.debugger.WatchModel;
import org.netbeans.modules.cnd.debugger.common2.debugger.WatchVariable;
import org.netbeans.modules.cnd.debugger.common2.debugger.assembly.BreakpointModel;
import org.netbeans.modules.cnd.debugger.common2.debugger.assembly.Controller;
import org.netbeans.modules.cnd.debugger.common2.debugger.assembly.DisFragModel;
import org.netbeans.modules.cnd.debugger.common2.debugger.assembly.Disassembly;
import org.netbeans.modules.cnd.debugger.common2.debugger.assembly.FormatOption;
import org.netbeans.modules.cnd.debugger.common2.debugger.assembly.MemoryWindow;
import org.netbeans.modules.cnd.debugger.common2.debugger.assembly.RegistersWindow;
import org.netbeans.modules.cnd.debugger.common2.debugger.assembly.StateModel;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.BreakpointManager;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.BreakpointProvider;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.Handler;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.HandlerCommand;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.HandlerExpert;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.NativeBreakpoint;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.types.ExceptionBreakpointType;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.types.FunctionBreakpointType;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.types.InstructionBreakpointType;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.types.LineBreakpointType;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.types.SysCallBreakpointType;
import org.netbeans.modules.cnd.debugger.common2.debugger.io.IOPack;
import org.netbeans.modules.cnd.debugger.common2.debugger.options.DbgProfile;
import org.netbeans.modules.cnd.debugger.common2.debugger.options.DebuggerOption;
import org.netbeans.modules.cnd.debugger.common2.debugger.options.Signals;
import org.netbeans.modules.cnd.debugger.common2.debugger.remote.CndRemote;
import org.netbeans.modules.cnd.debugger.common2.debugger.remote.Host;
import org.netbeans.modules.cnd.debugger.common2.debugger.remote.Platform;
import org.netbeans.modules.cnd.debugger.common2.utils.Executor;
import org.netbeans.modules.cnd.debugger.common2.utils.FileMapper;
import org.netbeans.modules.cnd.debugger.common2.utils.InfoPanel;
import org.netbeans.modules.cnd.debugger.common2.utils.IpeUtils;
import org.netbeans.modules.cnd.debugger.common2.utils.ItemSelectorResult;
import org.netbeans.modules.cnd.debugger.common2.utils.ListMapItem;
import org.netbeans.modules.cnd.debugger.common2.utils.StopWatch;
import org.netbeans.modules.cnd.debugger.common2.utils.options.OptionClient;
import org.netbeans.modules.cnd.debugger.common2.utils.options.OptionSet;
import org.netbeans.modules.cnd.debugger.gdb2.Catalog;
import org.netbeans.modules.cnd.debugger.gdb2.Gdb;
import org.netbeans.modules.cnd.debugger.gdb2.GdbDebuggerInfo;
import org.netbeans.modules.cnd.debugger.gdb2.GdbDebuggerSettingsBridge;
import org.netbeans.modules.cnd.debugger.gdb2.GdbDisassembly;
import org.netbeans.modules.cnd.debugger.gdb2.GdbEngineCapabilityProvider;
import org.netbeans.modules.cnd.debugger.gdb2.GdbEngineProvider;
import org.netbeans.modules.cnd.debugger.gdb2.GdbError;
import org.netbeans.modules.cnd.debugger.gdb2.GdbFrame;
import org.netbeans.modules.cnd.debugger.gdb2.GdbHandlerCommand;
import org.netbeans.modules.cnd.debugger.gdb2.GdbHandlerExpert;
import org.netbeans.modules.cnd.debugger.gdb2.GdbLocal;
import org.netbeans.modules.cnd.debugger.gdb2.GdbMemoryFormat;
import org.netbeans.modules.cnd.debugger.gdb2.GdbThread;
import org.netbeans.modules.cnd.debugger.gdb2.GdbUtils;
import org.netbeans.modules.cnd.debugger.gdb2.GdbVariable;
import org.netbeans.modules.cnd.debugger.gdb2.GdbVersionPeculiarity;
import org.netbeans.modules.cnd.debugger.gdb2.GdbWatch;
import org.netbeans.modules.cnd.debugger.gdb2.Log;
import org.netbeans.modules.cnd.debugger.gdb2.ValuePresenter;
import org.netbeans.modules.cnd.debugger.gdb2.VariableBag;
import org.netbeans.modules.cnd.debugger.gdb2.actions.GdbStartActionProvider;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MICommand;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MIConst;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MIRecord;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MIResult;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MITList;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MITListItem;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MIUserInteraction;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MIValue;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessChangeEvent;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.DebuggerEngineProvider;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.text.Line;
import org.openide.util.Exceptions;

public final class GdbDebuggerImpl
extends NativeDebuggerImpl
implements BreakpointProvider,
Gdb.Factory.Listener {
    private GdbEngineProvider engineProvider;
    private volatile Gdb gdb;
    private GdbVersionPeculiarity peculiarity;
    private final DebuggerSettingsBridge profileBridge;
    static final Logger LOG = Logger.getLogger(GdbDebuggerImpl.class.toString());
    private final GdbHandlerExpert handlerExpert;
    private MILocation homeLoc;
    private boolean dynamicType;
    private DisModel disModel = new DisModel();
    private DisController disController = new DisController();
    private final GdbDisassembly disassembly;
    private boolean update_dis = true;
    private final VariableBag variableBag = new VariableBag();
    private FileMapper fmap = FileMapper.getDefault();
    private String currentThreadId;
    public static final String MI_BKPT = "bkpt";
    public static final String MI_WPT = "wpt";
    public static final String MI_EXP = "exp";
    public static final String MI_NUMBER = "number";
    public static final String MI_FRAME = "frame";
    public static final String MI_THREADS = "threads";
    public static final String MI_CURRENT_THREAD = "current-thread-id";
    public static final String MI_WATCHPOINT_TRIGGER = "watchpoint-trigger";
    public static final String MI_WATCHPOINT_SCOPE = "watchpoint-scope";
    public static final String MI_SYSCALL_ENTRY = "syscall-entry";
    public static final String MI_SYSCALL_RETURN = "syscall-return";
    public static final String MI_NUMCHILD = "numchild";
    private GdbDebuggerInfo gdi;
    private Gdb.Factory factory;
    private static boolean warnUnsupported = false;
    private static final String STEP_INTO_ID = "STEP_INTO";
    private boolean targetAttach = false;
    private static final String ATTACH_ID = "ATTACH";
    private volatile String firstBreakpointId = null;
    private static final int PRINT_REPEAT = Integer.getInteger("gdb.print.repeat", 0);
    private static final int STACK_MAX_DEPTH = Integer.getInteger("gdb.stack.maxdepth", 1024);
    private static final int PRINT_ELEMENTS = Integer.getInteger("gdb.print.elements", 400);
    private static final boolean ENABLE_PRETTY_PRINTING = !Boolean.getBoolean("gdb.pretty.disable");
    private GdbThread[] threads = new GdbThread[0];
    private int current_thread_index;
    private boolean get_threads = false;
    private GdbThread[] threadsWithStacks = new GdbThread[0];
    private boolean get_debugging = false;
    private boolean showMessage = true;
    private boolean get_frames = false;
    static String corrupt_stack = "Previous frame identical to this frame (corrupt stack?)";
    boolean try_one_more = false;
    private boolean get_watches = false;
    public static final String STRUCT_VALUE = "{...}";
    private boolean get_locals = false;
    private GdbVariable[] local_vars = new GdbVariable[0];
    private static final int MEMORY_READ_WIDTH = 16;
    private Map<Integer, String> regNames = null;
    private final ConcurrentLinkedQueue<Integer> cliBreakpointsRTs = new ConcurrentLinkedQueue();

    public GdbDebuggerImpl(ContextProvider ctxProvider) {
        super(ctxProvider);
        List l = this.debuggerEngine.lookup(null, DebuggerEngineProvider.class);
        for (int lx = 0; lx < l.size(); ++lx) {
            if (!(l.get(lx) instanceof GdbEngineProvider)) continue;
            this.engineProvider = (GdbEngineProvider)((Object)l.get(lx));
        }
        if (this.engineProvider == null) {
            throw new IllegalArgumentException("GdbDebuggerImpl not started via GdbEngineProvider");
        }
        this.state().capabAutoRun = false;
        this.profileBridge = new GdbDebuggerSettingsBridge((NativeDebugger)this);
        this.handlerExpert = new GdbHandlerExpert(this);
        this.disassembly = new GdbDisassembly(this, (BreakpointModel)this.breakpointModel());
        this.disStateModel().addListener((StateModel.Listener)this.disassembly);
    }

    public String debuggerType() {
        return "gdb";
    }

    public DebuggerSettingsBridge profileBridge() {
        return this.profileBridge;
    }

    public Gdb gdb() {
        return this.gdb;
    }

    public boolean isConnected() {
        return this.gdb != null && this.gdb.connected() && !this.postedKillEngine;
    }

    public void rememberDDI(GdbDebuggerInfo gdi) {
        this.gdi = gdi;
    }

    public NativeDebuggerInfo getNDI() {
        return this.gdi;
    }

    boolean isShortName() {
        DebuggerOption option = DebuggerOption.OUTPUT_SHORT_FILE_NAME;
        return option.isEnabled((OptionSet)this.optionLayers());
    }

    public void start(GdbDebuggerInfo gdi) {
        ExternalStart xstart;
        if (Log.Start.debug) {
            int act = gdi.getAction();
            System.out.printf("START ==========\n\t", new Object[0]);
            if ((act & 1) != 0) {
                System.out.printf("RUN ", new Object[0]);
            }
            if ((act & 2) != 0) {
                System.out.printf("STEP ", new Object[0]);
            }
            if ((act & 4) != 0) {
                System.out.printf("ATTACH ", new Object[0]);
            }
            if ((act & 8) != 0) {
                System.out.printf("CORE ", new Object[0]);
            }
            if ((act & 0x10) != 0) {
                System.out.printf("LOAD ", new Object[0]);
            }
            if ((act & 0x20) != 0) {
                System.out.printf("CONNECT ", new Object[0]);
            }
            System.out.printf("\n", new Object[0]);
        }
        this.rememberDDI(gdi);
        this.session().setSessionHost(gdi.getHostName());
        this.session().setSessionEngine(GdbEngineCapabilityProvider.getGdbEngineType());
        final boolean connectExisting = (gdi.getAction() & 0x20) != 0;
        this.profileBridge.setup((NativeDebuggerInfo)gdi);
        if (!connectExisting) {
            int flags = 0;
            if (Log.Startup.nopty) {
                flags |= 1;
            }
            this.executor = Executor.getDefault((String)Catalog.get("Gdb"), (Host)this.getHost(), (int)flags, (ChangeListener)new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (e instanceof NativeProcessChangeEvent && ((NativeProcessChangeEvent)e).state == NativeProcess.State.FINISHED && !GdbDebuggerImpl.this.postedKill) {
                        NativeDebuggerManager.warning((String)Catalog.format("MSG_GdbUnexpectedlyStopped", GdbDebuggerImpl.this.executor.getExitValue()));
                        GdbDebuggerImpl.this.kill();
                    }
                }
            });
        }
        final String[] additionalArgv = null;
        if (gdi.isCaptured() && (xstart = ExternalStartManager.getXstart((Host)this.getHost())) != null) {
            xstart.debuggerStarted();
        }
        if (NativeDebuggerManager.isAsyncStart()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GdbDebuggerImpl.this.start2(GdbDebuggerImpl.this.executor, additionalArgv, GdbDebuggerImpl.this, connectExisting);
                }
            });
        } else {
            CndRemote.validate((String)gdi.getHostName(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    GdbDebuggerImpl.this.start2(GdbDebuggerImpl.this.executor, additionalArgv, GdbDebuggerImpl.this, connectExisting);
                }
            });
        }
    }

    private boolean directoryExists(ExecutionEnvironment env, String path) throws ConnectException, IOException, InterruptedException {
        FileObject fileObject = FileSystemProvider.getFileObject((ExecutionEnvironment)env, (String)path);
        if (fileObject != null) {
            return fileObject.isFolder();
        }
        return HostInfoUtils.directoryExists((ExecutionEnvironment)env, (String)path);
    }

    private void start2(final Executor executor, final String[] additionalArgv, final Gdb.Factory.Listener listener, final boolean connectExisting) {
        String runDir;
        boolean preventRunPathConvertion;
        String gdbInitFile = DebuggerOption.GDB_INIT_FILE.getCurrValue((OptionSet)this.optionLayers());
        boolean preventInitPathConvertion = gdbInitFile.startsWith("///");
        if (!preventInitPathConvertion) {
            gdbInitFile = this.localToRemote("gdbInitFile", gdbInitFile);
        }
        if (!(preventRunPathConvertion = (runDir = this.gdi.getRunDir()).startsWith("///"))) {
            runDir = this.localToRemote("gdbRunDirectory", runDir);
        }
        final String finalRunDir = runDir;
        final String finalGdbInitFile = gdbInitFile;
        NativeDebuggerManager.getRequestProcessor().post(new Runnable(){

            @Override
            public void run() {
                final AtomicBoolean exists = new AtomicBoolean();
                try {
                    exists.set(GdbDebuggerImpl.this.directoryExists(executor.getExecutionEnvironment(), finalRunDir));
                }
                catch (IOException ioe) {
                    exists.set(false);
                }
                catch (InterruptedException ex) {
                    return;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (!exists.get()) {
                            NativeDebuggerManager.error((String)Catalog.format("MSG_NonExistentWorkDir", finalRunDir));
                            GdbDebuggerImpl.this.kill();
                            return;
                        }
                        GdbDebuggerImpl.this.factory = new Gdb.Factory(executor, additionalArgv, listener, false, GdbDebuggerImpl.this.isShortName(), finalGdbInitFile, GdbDebuggerImpl.this.getHost(), connectExisting, finalRunDir, GdbDebuggerImpl.this.gdi);
                        GdbDebuggerImpl.this.factory.start();
                    }
                });
            }
        });
    }

    @Override
    public void assignGdb(Gdb tentativeGdb) {
        if (Log.Start.debug) {
            System.out.printf("GdbDebuggerImpl.assignGdb()\n", new Object[0]);
        }
        this.gdb = tentativeGdb;
        this.gdb.setDebugger(this);
        GdbStartActionProvider.succeeded();
        NativeDebuggerManager.get().setCurrentDebugger((NativeDebugger)this);
    }

    @Override
    public void assignIOPack(IOPack ioPack) {
        if (Log.Start.debug) {
            System.out.printf("GdbDebuggerImpl.assignIOPack()\n", new Object[0]);
        }
        this.setIOPack(ioPack);
    }

    @Override
    public void connectFailed(String toWhom, String why, IOPack ioPack) {
        if (Log.Start.debug) {
            System.out.printf("GdbDebuggerImpl.connectFailed()\n", new Object[0]);
        }
        String msg = Catalog.format("ConnectionFailed", toWhom, why);
        Gdb.dyingWords(msg, ioPack);
        this.session.kill();
    }

    private void warnVersionUnsupported(double gdbVersion) {
        if (!warnUnsupported) {
            InfoPanel panel = new InfoPanel(Catalog.format("ERR_UnsupportedVersion", gdbVersion), Catalog.get("MSG_Do_Not_Show_Again_In_Session"));
            NotifyDescriptor.Message descriptor = new NotifyDescriptor.Message((Object)panel, 2);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
            warnUnsupported = panel.dontShowAgain();
        }
    }

    void setGdbVersion(String version) {
        double gdbVersion = 6.8;
        try {
            gdbVersion = GdbUtils.parseVersionString(version);
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Unable to parse gdb version {0}", version);
        }
        this.peculiarity = GdbVersionPeculiarity.create(gdbVersion, this.getHost().getPlatform());
        if (!this.peculiarity.isSupported()) {
            this.warnVersionUnsupported(gdbVersion);
        }
    }

    public final void kill() {
        super.preKill();
        this.optionLayers().save();
        IOPack ioPack = this.getIOPack();
        if (ioPack != null) {
            ioPack.bringDown();
            ioPack.close();
        }
        this.postedKillEngine = true;
        this.state().isLoaded = false;
        this.stateChanged();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (MemoryWindow.getDefault().isShowing()) {
                    MemoryWindow.getDefault().setDebugger(null);
                }
            }
        });
        this.engineProvider.getDestructor().killEngine();
    }

    boolean postedKillEngine() {
        return this.postedKillEngine;
    }

    public void postKill() {
        this.postedKill = true;
        NativeDebuggerManager.getRequestProcessor().post(new Runnable(){

            @Override
            public void run() {
                if (GdbDebuggerImpl.this.gdb != null && GdbDebuggerImpl.this.gdb.connected()) {
                    if (GdbDebuggerImpl.this.getHost().getPlatform() == Platform.Windows_x86 || !GdbDebuggerImpl.this.pause(true)) {
                        try {
                            GdbDebuggerImpl.this.executor.terminate();
                            GdbDebuggerImpl.this.kill();
                        }
                        catch (IOException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                        return;
                    }
                    MiCommandImpl cmd = new MiCommandImpl("-gdb-exit"){

                        @Override
                        protected void onError(MIRecord record) {
                            this.finish();
                        }

                        @Override
                        protected void onExit(MIRecord record) {
                            GdbDebuggerImpl.this.kill();
                            this.finish();
                        }
                    };
                    GdbDebuggerImpl.this.gdb.sendCommand(cmd);
                } else {
                    GdbDebuggerImpl.this.kill();
                }
            }
        });
    }

    public void shutDown() {
        this.postKill();
    }

    public final void stepInto() {
        this.sendResumptive(this.peculiarity.execStepCommand(this.currentThreadId));
    }

    private void stepIntoMain() {
        this.send("-break-insert -t main");
        this.firstBreakpointId = STEP_INTO_ID;
        MIResumptiveCommand cmd = new MIResumptiveCommand("-exec-run"){

            @Override
            protected void onRunning(MIRecord record) {
                GdbDebuggerImpl.this.startRecordingIfNeeded();
                super.onRunning(record);
            }
        };
        this.gdb.sendCommand(cmd, true);
    }

    public final void stepOver() {
        this.sendResumptive(this.peculiarity.execNextCommand(this.currentThreadId));
    }

    public final void stepOut() {
        if (!this.peculiarity.isLldb()) {
            this.send("-stack-select-frame 0");
        }
        this.execFinish();
    }

    private void execFinish() {
        this.sendResumptive(this.peculiarity.execFinishCommand(this.currentThreadId));
    }

    public final void pathmap(String pathmap) {
        this.send(pathmap);
    }

    private void notImplemented(String method) {
        System.out.printf("NOT IMPLEMENTED: GdbDebuggerImpl.%s()\n", method);
    }

    public final void stepTo(final String selectedText) {
        if (selectedText == null || selectedText.trim().isEmpty()) {
            return;
        }
        String expandedExpr = MacroSupport.expandMacro((NativeDebugger)this, (String)selectedText);
        String cmdString = "-data-evaluate-expression \"" + expandedExpr + "\"";
        MiCommandImpl cmd = new MiCommandImpl(cmdString){

            @Override
            protected void onDone(MIRecord record) {
                MITList results = record.results();
                String value = results.getConstValue("value");
                value = value.substring(value.indexOf(125) + 1);
                if ((value = value.substring(0, value.indexOf(60)).trim()).isEmpty()) {
                    value = selectedText;
                }
                MiCommandImpl cmd2 = new MiCommandImpl("-break-insert -t *" + value){

                    @Override
                    protected void onDone(MIRecord record) {
                        GdbDebuggerImpl.this.go();
                        this.finish();
                    }
                };
                GdbDebuggerImpl.this.gdb.sendCommand(cmd2);
                this.finish();
            }
        };
        this.gdb.sendCommand(cmd);
    }

    public final void go() {
        if (this.state().isProcess) {
            this.sendResumptive("-exec-continue");
        } else {
            this.sendResumptive("-exec-run");
        }
    }

    public void resumeThread(Thread thread) {
        this.sendResumptive("-exec-continue --thread " + ((GdbThread)thread).getId());
    }

    private void doMIAttach(GdbDebuggerInfo gdi) {
        String cmdString;
        String remoteTarget = gdi.getTargetCommand();
        if (remoteTarget != null) {
            cmdString = "target " + remoteTarget;
            this.targetAttach = true;
        } else {
            long pid = gdi.getPid();
            cmdString = "attach " + Long.toString(pid);
        }
        this.firstBreakpointId = ATTACH_ID;
        MiCommandImpl cmd = new MiCommandImpl(cmdString){

            @Override
            protected void onDone(MIRecord record) {
                GdbDebuggerImpl.this.attachDone();
                GdbDebuggerImpl.this.startRecordingIfNeeded();
                this.finish();
            }
        };
        this.gdb.sendCommand(cmd);
    }

    private void attachDone() {
        this.firstBreakpointId = null;
        if (this.state().isProcess) {
            return;
        }
        this.state().isProcess = true;
        this.stateChanged();
        this.session().setSessionState(this.state());
        long pid = this.getNDI().getPid();
        if (pid != -1L) {
            this.session().setPid(pid);
        }
        this.profileBridge().noteAttached();
        if (DebuggerOption.RUN_AUTOSTART.isEnabled((OptionSet)this.optionLayers())) {
            this.go();
        } else {
            this.requestStack(null);
        }
    }

    private void doMICorefile(GdbDebuggerInfo gdi) {
        String corefile = gdi.getCorefile();
        String cmdString = "core " + corefile;
        MiCommandImpl cmd = new MiCommandImpl(cmdString){

            @Override
            protected void onDone(MIRecord record) {
                GdbDebuggerImpl.this.state().isCore = true;
                GdbDebuggerImpl.this.stateChanged();
                GdbDebuggerImpl.this.session().setSessionState(GdbDebuggerImpl.this.state());
                GdbDebuggerImpl.this.startRecordingIfNeeded();
                MiCommandImpl cmd2 = new MiCommandImpl("-thread-list-ids"){

                    @Override
                    protected void onDone(MIRecord record) {
                        GdbDebuggerImpl.this.currentThreadId = record.results().getConstValue(GdbDebuggerImpl.MI_CURRENT_THREAD);
                        GdbDebuggerImpl.this.requestStack(null);
                        this.finish();
                    }
                };
                GdbDebuggerImpl.this.gdb.sendCommand(cmd2);
                this.finish();
            }
        };
        this.gdb.sendCommand(cmd);
    }

    public void contAt(String src, int line) {
        src = this.localToRemote("contAt", src);
        this.sendResumptive("-exec-jump \"" + src + ':' + line + '\"');
    }

    public void contAtInst(String addr) {
        this.sendResumptive("-exec-jump *" + addr);
    }

    public void runToCursor(String src, int line) {
        src = this.localToRemote("runToCursor", src);
        if (!this.state().isProcess) {
            this.send("-break-insert -t " + src + ":" + line);
            this.go();
        } else {
            this.sendResumptive("-exec-until \"" + src + ':' + line + '\"');
        }
    }

    public void runToCursorInst(String addr) {
        this.sendResumptive("-exec-until *" + addr);
    }

    public GdbVersionPeculiarity getGdbVersionPeculiarity() {
        return this.peculiarity;
    }

    public void pause() {
        this.pause(false);
    }

    private boolean pause(boolean silentStop) {
        int pid = (int)this.session().getPid();
        if (pid > 0) {
            return this.gdb.pause(pid, silentStop, this.targetAttach);
        }
        return false;
    }

    public void interrupt() {
        this.gdb.interrupt();
    }

    public void terminate() {
        int pid = (int)this.session().getPid();
        if (pid > 0) {
            MiCommandImpl command = new MiCommandImpl("kill"){

                @Override
                protected void onDone(MIRecord record) {
                    GdbDebuggerImpl.this.resetCurrentLine();
                    GdbDebuggerImpl.this.state().isRunning = false;
                    GdbDebuggerImpl.this.state().isProcess = false;
                    GdbDebuggerImpl.this.updateActions();
                    GdbDebuggerImpl.this.session().setSessionState(GdbDebuggerImpl.this.state());
                    GdbDebuggerImpl.this.session().setPid(-1L);
                    GdbDebuggerImpl.this.session().update();
                    super.onDone(record);
                }
            };
            this.sendCommandInt(command);
        }
    }

    public void detach() {
        this.sendCommandInt(new MiCommandImpl("detach"));
    }

    static int extractPid1(MIRecord record) {
        StringTokenizer st = new StringTokenizer(record.command().getConsoleStream());
        while (st.hasMoreTokens()) {
            int pidEnd;
            String str = st.nextToken();
            if (!"process".equals(str) || !st.hasMoreTokens()) continue;
            String pidStr = st.nextToken();
            for (pidEnd = 0; pidEnd < pidStr.length() && Character.isDigit(pidStr.charAt(pidEnd)); ++pidEnd) {
            }
            try {
                return Integer.parseInt(pidStr.substring(0, pidEnd));
            }
            catch (Exception e) {
                Exceptions.printStackTrace((Throwable)new Exception("Pid parsing error: " + record.command().getConsoleStream(), e));
            }
        }
        return 0;
    }

    private int extractPid2(String console) {
        int pid = 0;
        if (Log.Gdb.pid) {
            System.out.printf("//////// '%s'\n", console);
        }
        if (console != null) {
            StringTokenizer st = new StringTokenizer(console);
            int ntokens = 0;
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (Log.Gdb.pid) {
                    System.out.printf("\t%d: '%s'\n", ntokens, token);
                }
                if (ntokens == 3) {
                    String pidStr = token;
                    pid = Integer.parseInt(pidStr);
                    break;
                }
                ++ntokens;
            }
        }
        if (Log.Gdb.pid) {
            System.out.printf("\\\\\\\\ pid %d\n", pid);
        }
        return pid;
    }

    private void sendPidCommand(boolean resume) {
        if (this.session().getPid() <= 0L) {
            if (this.getHost().getPlatform() == Platform.Windows_x86) {
                InfoThreadsMICmd findPidCmd = new InfoThreadsMICmd(resume);
                this.gdb.sendCommand(findPidCmd);
            } else if (this.getHost().getPlatform() != Platform.MacOSX_x86) {
                InfoProcMICmd findPidCmd = new InfoProcMICmd(resume);
                InfoThreadsMICmd findPidCmd2 = new InfoThreadsMICmd(resume);
                findPidCmd.chain(null, findPidCmd2);
                this.gdb.sendCommand(findPidCmd);
            }
        } else if (resume) {
            this.go();
        }
    }

    static long extractPidThreads(MIRecord record) {
        String msg = record.command().getConsoleStream();
        Pattern pattern = Pattern.compile("[*]\\s+1\\s+[Tt]hread\\s+\\d+");
        Matcher matcher = pattern.matcher(msg);
        if (matcher.find()) {
            String group = matcher.group();
            Pattern patternPid = Pattern.compile("\\d+$");
            Matcher matcherPid = patternPid.matcher(group);
            if (matcherPid.find()) {
                try {
                    return Long.parseLong(matcherPid.group());
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
            }
        }
        return 0L;
    }

    private void setFirstBreakpointId(MIRecord record) {
        MIValue numberValue;
        MIValue bkptValue = record.results().valueOf(MI_BKPT);
        if (bkptValue != null && (numberValue = bkptValue.asTList().valueOf(MI_NUMBER)) != null) {
            this.firstBreakpointId = numberValue.asConst().value();
        }
    }

    public void rerun() {
        MiCommandImpl breakStartCmd = new MiCommandImpl("-break-insert -t _start"){

            @Override
            protected void onDone(MIRecord record) {
                GdbDebuggerImpl.this.setFirstBreakpointId(record);
                super.onDone(record);
            }
        };
        breakStartCmd.setEmptyDoneIsError();
        MiCommandImpl breakMainCmd = new MiCommandImpl("-break-insert -t main"){

            @Override
            protected void onDone(MIRecord record) {
                GdbDebuggerImpl.this.setFirstBreakpointId(record);
                super.onDone(record);
            }
        };
        breakMainCmd.setEmptyDoneIsError();
        MIResumptiveCommand runCmd = new MIResumptiveCommand("-exec-run"){

            @Override
            protected void onRunning(MIRecord record) {
                GdbDebuggerImpl.this.state().isProcess = true;
                GdbDebuggerImpl.this.startRecordingIfNeeded();
                super.onRunning(record);
            }
        };
        breakStartCmd.chain(runCmd, breakMainCmd);
        breakMainCmd.chain(runCmd, runCmd);
        this.session().setPid(-1L);
        if (this.getHost().getPlatform() == Platform.MacOSX_x86) {
            this.gdb.sendCommand(breakMainCmd);
        } else {
            this.gdb.sendCommand(breakStartCmd);
        }
    }

    public void makeCalleeCurrent() {
        int frameNo;
        GdbFrame frame = this.getCurrentFrame();
        if (frame != null && (frameNo = Integer.parseInt(frame.getNumber())) > 0) {
            this.makeFrameCurrent(this.getStack()[frameNo - 1]);
        }
    }

    public void makeCallerCurrent() {
        Frame[] stack;
        int newFrameNo;
        GdbFrame frame = this.getCurrentFrame();
        if (frame != null && (newFrameNo = Integer.parseInt(frame.getNumber()) + 1) < (stack = this.getStack()).length) {
            this.makeFrameCurrent(stack[newFrameNo]);
        }
    }

    public void popToHere(Frame frame) {
        if (this.warnAboutReverseIfNeeded()) {
            return;
        }
        for (int frameNo = Integer.parseInt(frame.getNumber()); frameNo > 0; --frameNo) {
            this.popTopmostCall();
        }
    }

    private boolean warnAboutReverseIfNeeded() {
        if (!DebuggerOption.GDB_REVERSE_DEBUGGING.isEnabled((OptionSet)this.optionLayers())) {
            NativeDebuggerManager.error((String)Catalog.get("MSG_Reverse_Debugging_Option"));
            return true;
        }
        return false;
    }

    public void popTopmostCall() {
        if (!this.warnAboutReverseIfNeeded()) {
            this.sendResumptive(this.peculiarity.execFinishCommand(this.currentThreadId) + " --reverse");
        }
    }

    private void startRecordingIfNeeded() {
        if (DebuggerOption.GDB_REVERSE_DEBUGGING.isEnabled((OptionSet)this.optionLayers())) {
            this.send("-gdb-set record stop-at-limit off");
            this.send("record");
        }
    }

    public void popLastDebuggerCall() {
    }

    public void popToCurrentFrame() {
        this.popToHere(this.getCurrentFrame());
    }

    public FileMapper fmap() {
        return this.fmap;
    }

    private static String parseEnvDirFromOption(String src) {
        StringBuilder res = new StringBuilder();
        StringTokenizer st = new StringTokenizer(src, File.pathSeparator);
        while (st.hasMoreTokens()) {
            res.append(" \"");
            res.append(st.nextToken());
            res.append("\"");
        }
        return res.toString();
    }

    void initializeGdb(FileMapper fmap) {
        String sourceFolders;
        if (Log.Start.debug) {
            System.out.printf("GdbDebuggerImpl.initializeGdb()\n", new Object[0]);
        }
        assert (this.isConnected()) : "initializeGdb() called when gdb wasn't ready";
        if (this.getHost().isRemote()) {
            this.fmap = FileMapper.getByType((FileMapper.Type)FileMapper.Type.NULL);
        } else if (fmap != null) {
            this.fmap = fmap;
        }
        this.manager().initialUnsavedFiles((NativeDebugger)this);
        if (this.gdi.isCaptured()) {
            this.setCaptureState(NativeDebuggerImpl.CaptureState.INITIAL);
            this.setCaptureInfo(this.gdi.getCaptureInfo());
        } else assert (this.getCaptureState() == NativeDebuggerImpl.CaptureState.NONE);
        this.initFeatures();
        if (!this.peculiarity.isLldb()) {
            this.initSignalsList();
        }
        this.send("-gdb-set print repeat " + PRINT_REPEAT);
        this.send("-gdb-set backtrace limit " + STACK_MAX_DEPTH);
        this.send("-gdb-set print elements " + PRINT_ELEMENTS);
        this.send("-gdb-set follow-fork-mode " + DebuggerOption.GDB_FOLLOW_FORK_MODE.getCurrValue((OptionSet)this.optionLayers()));
        this.send("-gdb-set detach-on-fork " + DebuggerOption.GDB_DETACH_ON_FORK.getCurrValue((OptionSet)this.optionLayers()));
        if (ENABLE_PRETTY_PRINTING) {
            this.sendSilent("-enable-pretty-printing");
        }
        if ((sourceFolders = DebuggerOption.GDB_SOURCE_DIRS.getCurrValue((OptionSet)this.optionLayers())) != null && !sourceFolders.isEmpty()) {
            this.send("-environment-directory" + GdbDebuggerImpl.parseEnvDirFromOption(sourceFolders));
        }
        if (this.getHost().getPlatform() == Platform.Windows_x86 && this.getIOPack().isExternal()) {
            this.send("set new-console");
        }
        this.debug(this.gdi);
        this.manager().setCurrentSession(null);
        this.manager().setCurrentSession(this.session.coreSession());
    }

    private void initialAction() {
        if (NativeDebuggerManager.isStartModel() && this.gdi != null) {
            if ((this.gdi.getAction() & 1) != 0) {
                this.rerun();
                this.gdi.removeAction(1);
            }
            if ((this.gdi.getAction() & 4) != 0) {
                this.doMIAttach(this.gdi);
                this.gdi.removeAction(4);
            }
            if ((this.gdi.getAction() & 8) != 0) {
                this.doMICorefile(this.gdi);
                this.gdi.removeAction(8);
            }
            if ((this.gdi.getAction() & 2) != 0) {
                this.stepIntoMain();
                this.gdi.removeAction(2);
            }
        }
    }

    void noteProgLoaded(String progname) {
        this.profileBridge().noteProgLoaded(progname);
        this.manager().formatStatusText("ReadyToRun", new Object[0]);
        NativeDebuggerManager.get().addRecentDebugTarget(progname, false);
        this.gdb.setGdbIdleHandler(new Runnable(){

            @Override
            public void run() {
                if (Log.Bpt.fix6810534) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            GdbDebuggerImpl.this.initialAction();
                        }
                    });
                } else {
                    GdbDebuggerImpl.this.initialAction();
                }
            }
        });
    }

    public OptionClient getOptionClient() {
        return null;
    }

    public String getDebuggingOption(String name) {
        this.notImplemented("getDebuggingOption");
        return null;
    }

    public void setOption(String name, String value) {
        this.notImplemented("setOption() " + name + " " + value);
    }

    public void setAccessChecking(boolean enable) {
    }

    public void setMemuseChecking(boolean enable) {
    }

    public void setLeaksChecking(boolean enable) {
    }

    private void overrideOptions() {
    }

    private String getErrMsg(MIRecord record) {
        String errMsg = null;
        if (record.isError()) {
            errMsg = record.error();
        } else if (!record.isEmpty()) {
            errMsg = record.results().getConstValue("msg");
        } else {
            if (record.command() != null) {
                errMsg = record.command().getLogStream();
            }
            if (errMsg == null) {
                errMsg = Catalog.get("MSG_UnknownFailure");
            }
        }
        return errMsg;
    }

    private void genericFailure(MIRecord record) {
        String errMsg = this.getErrMsg(record);
        this.manager().error(record.command().routingToken(), (Error)new GdbError(errMsg), (NativeDebugger)this);
    }

    private void unexpected(String what, String command) {
        System.out.println("Unexpcted callback '" + what + "' on '" + command + "'");
    }

    void genericRunning() {
        NativeSession s = this.session();
        this.clearFiredEvents();
        this.deleteMarkLocations();
        this.deliverSignal = -1;
        this.stateSetRunning(true);
        this.stateChanged();
        if (s != null) {
            s.setSessionState(this.state());
        }
        this.setStatusText(Catalog.get("MSG_running"));
    }

    private boolean dontKillOnExit() {
        return !DebuggerOption.FINISH_SESSION.isEnabled((OptionSet)this.optionLayers()) || (this.gdi.getAction() & 0x10) != 0;
    }

    private void noteProcGone(String reason, MITList results) {
        this.session().setPid(-1L);
        this.session().setCorefile(null);
        this.session().update();
        this.session().setSessionEngine(null);
        this.state().isProcess = false;
        this.state().isCore = false;
        this.stateSetRunning(false);
        this.stateChanged();
        this.session().setSessionState(this.state());
        this.clearFiredEvents();
        String msg = "";
        boolean skipkill = false;
        if ("exited-normally".equals(reason)) {
            String exitcodeString = "0";
            msg = Catalog.format("ProgCompletedExit", "0");
            skipkill = this.dontKillOnExit();
        } else if ("exited".equals(reason)) {
            String exitcodeString = results.getConstValue("exit-code");
            msg = Catalog.format("ProgCompletedExit", exitcodeString);
            skipkill = this.dontKillOnExit();
        } else if ("exited-signalled".equals(reason)) {
            String signalnameString = results.getConstValue("signal-name");
            msg = Catalog.format("ProgAborted", signalnameString);
        } else {
            msg = "Stopped for unrecognized reason: " + reason;
        }
        this.setStatusText(msg);
        if (!skipkill && NativeDebuggerManager.isStartModel()) {
            this.postKill();
        }
        this.setVisitedLocation(null);
        this.resetCurrentLine();
    }

    public boolean isMultiThreading() {
        return false;
    }

    public void registerThreadModel(ThreadModel model) {
        if (Log.Variable.mi_threads) {
            System.out.println("registerThreadModel " + model);
        }
        this.threadUpdater.setListener((ModelListener)model);
        if (model != null) {
            this.get_threads = true;
            if (this.state().isProcess && !this.state().isRunning) {
                this.showThreads();
            }
        } else {
            this.get_threads = false;
        }
    }

    public Thread[] getThreads() {
        return this.threads;
    }

    public void makeThreadCurrent(Thread thread) {
        if (!thread.isCurrent()) {
            String tid = ((GdbThread)thread).getId();
            this.selectThread(-1, tid, true);
        }
    }

    private void updateLocalsForSelectFrame() {
        if (this.get_locals) {
            this.getMILocals(false);
        }
    }

    private void setCurrentThread(int index, MIRecord threadframe, boolean isCurrent) {
        MITList threadresults = threadframe.results();
        this.currentThreadId = threadresults.getConstValue("new-thread-id");
        MIValue frame = threadresults.valueOf(MI_FRAME);
        if (Log.Variable.mi_threads) {
            System.out.println("threadframe " + threadresults.toString());
            System.out.println("tid_no " + this.currentThreadId);
            System.out.println("frame " + frame.toString());
        }
        GdbFrame f = new GdbFrame(this, frame, null, null);
        if (isCurrent) {
            if (!f.getLineNo().equals("")) {
                this.getFullPath(f);
            }
            for (int tx = 0; tx < this.threads.length; ++tx) {
                if (this.threads[tx].getId().equals(this.currentThreadId)) {
                    this.threads[tx].setCurrent(true);
                    continue;
                }
                this.threads[tx].setCurrent(false);
            }
        }
        if (isCurrent || index == this.threads.length - 1) {
            this.threadUpdater.treeChanged();
        }
    }

    private void selectThread(final int index, String id_no, final boolean isCurrent) {
        MiCommandImpl cmd = new MiCommandImpl("-thread-select " + id_no){

            @Override
            protected void onDone(MIRecord record) {
                GdbDebuggerImpl.this.setCurrentThread(index, record, isCurrent);
                GdbDebuggerImpl.this.requestStack(record);
                this.finish();
            }
        };
        this.gdb.sendCommand(cmd);
    }

    private void initFeatures() {
        MiCommandImpl cmd = new MiCommandImpl("-list-features"){

            @Override
            protected void onDone(MIRecord record) {
                GdbDebuggerImpl.this.peculiarity.setFeatures(record);
                this.finish();
            }
        };
        cmd.dontReportError();
        this.gdb.sendCommand(cmd);
    }

    private void initSignalsList() {
        MiCommandImpl cmd = new MiCommandImpl("info signals"){

            @Override
            protected void onDone(MIRecord record) {
                String signalList = this.getConsoleStream();
                ((GdbDebuggerSettingsBridge)GdbDebuggerImpl.this.profileBridge()).noteSignalList(signalList);
                this.finish();
            }
        };
        cmd.dontReportError();
        this.gdb.sendCommand(cmd);
    }

    private void showThreads() {
        if (this.peculiarity.supports(GdbVersionPeculiarity.Feature.THREAD_INFO) || this.peculiarity.isLldb()) {
            MiCommandImpl cmd = new MiCommandImpl("-thread-info"){

                @Override
                protected void onDone(MIRecord record) {
                    ArrayList<GdbThread> res = new ArrayList<GdbThread>();
                    MITList results = record.results();
                    String threadId = results.getConstValue(GdbDebuggerImpl.MI_CURRENT_THREAD);
                    if (!threadId.isEmpty()) {
                        GdbDebuggerImpl.this.currentThreadId = threadId;
                    }
                    for (MITListItem thr : results.valueOf(GdbDebuggerImpl.MI_THREADS).asList()) {
                        MITList thrList = (MITList)thr;
                        String id = thrList.getConstValue("id");
                        String name = thrList.getConstValue("target-id");
                        MIValue frame = thrList.valueOf(GdbDebuggerImpl.MI_FRAME);
                        GdbFrame f = new GdbFrame(GdbDebuggerImpl.this, frame, null, null);
                        f.setCurrent(true);
                        String state = thrList.getConstValue("state");
                        GdbThread gdbThread = new GdbThread((NativeDebugger)GdbDebuggerImpl.this, GdbDebuggerImpl.this.threadUpdater, id, name, new Frame[]{f}, state);
                        if (id.equals(GdbDebuggerImpl.this.currentThreadId)) {
                            gdbThread.setCurrent(true);
                        }
                        res.add(gdbThread);
                    }
                    GdbDebuggerImpl.access$2602(GdbDebuggerImpl.this, res.toArray(new GdbThread[res.size()]));
                    GdbDebuggerImpl.this.threadUpdater.treeChanged();
                    this.finish();
                }
            };
            this.gdb.sendCommand(cmd);
        } else {
            MiCommandImpl cmd = new MiCommandImpl("info threads"){

                @Override
                protected void onDone(final MIRecord record) {
                    if (GdbDebuggerImpl.this.peculiarity.isThreadsOutputUnusual()) {
                        MiCommandImpl cmd2 = new MiCommandImpl("info thread"){

                            @Override
                            protected void onDone(MIRecord record2) {
                                ArrayList<GdbThread> res = new ArrayList<GdbThread>();
                                String msg = record2.command().getConsoleStream();
                                System.out.println(msg);
                                GdbDebuggerImpl.this.currentThreadId = msg.substring(msg.indexOf(32) + 1, msg.indexOf(32, msg.indexOf(32) + 1));
                                MITList results = record.results();
                                int i = 0;
                                do {
                                    MIValue frame;
                                    MIResult result;
                                    String id = "";
                                    String name = null;
                                    GdbFrame f = null;
                                    if ((result = (MIResult)results.get(i++)).matches("threadno")) {
                                        id = IpeUtils.unquoteIfNecessary((String)result.value().toString());
                                    }
                                    if ((result = (MIResult)results.get(i++)).matches("target_thread_name")) {
                                        name = result.value().toString();
                                        if ((result = (MIResult)results.get(i++)).matches(GdbDebuggerImpl.MI_FRAME)) {
                                            frame = result.value();
                                            f = new GdbFrame(GdbDebuggerImpl.this, frame, null, null);
                                        }
                                    } else if (result.matches(GdbDebuggerImpl.MI_FRAME)) {
                                        name = "Thread ".concat(id);
                                        frame = result.value();
                                        f = new GdbFrame(GdbDebuggerImpl.this, frame, null, null);
                                        f.setCurrent(true);
                                    }
                                    GdbThread gdbThread = new GdbThread((NativeDebugger)GdbDebuggerImpl.this, GdbDebuggerImpl.this.threadUpdater, id, name, new Frame[]{f}, "");
                                    if (id.equals(GdbDebuggerImpl.this.currentThreadId)) {
                                        gdbThread.setCurrent(true);
                                    }
                                    res.add(gdbThread);
                                } while (i < results.size());
                                this.finish();
                                GdbDebuggerImpl.access$2602(GdbDebuggerImpl.this, res.toArray(new GdbThread[res.size()]));
                                GdbDebuggerImpl.this.threadUpdater.treeChanged();
                                this.finish();
                            }
                        };
                        GdbDebuggerImpl.this.gdb.sendCommand(cmd2);
                    } else {
                        String msg = record.command().getConsoleStream();
                        if (msg.length() > 0) {
                            ArrayList<GdbThread> res = new ArrayList<GdbThread>();
                            StringBuilder sb = new StringBuilder();
                            boolean current = false;
                            for (String line : msg.split("\\\\n")) {
                                char ch;
                                if (line.startsWith("    ")) {
                                    sb.append(" " + line.replace("\\n", "").trim());
                                    continue;
                                }
                                if (sb.length() > 0) {
                                    GdbThread gdbThread = new GdbThread((NativeDebugger)GdbDebuggerImpl.this, GdbDebuggerImpl.this.threadUpdater, sb.toString());
                                    gdbThread.setCurrent(current);
                                    res.add(gdbThread);
                                    sb.delete(0, sb.length());
                                    current = false;
                                }
                                if ((ch = (line = line.trim()).charAt(0)) != '*' && !Character.isDigit(ch)) continue;
                                current = ch == '*';
                                sb.append(line);
                            }
                            if (sb.length() > 0) {
                                GdbThread gdbThread = new GdbThread((NativeDebugger)GdbDebuggerImpl.this, GdbDebuggerImpl.this.threadUpdater, sb.toString());
                                gdbThread.setCurrent(current);
                                res.add(gdbThread);
                            }
                            GdbDebuggerImpl.access$2602(GdbDebuggerImpl.this, res.toArray(new GdbThread[res.size()]));
                            GdbDebuggerImpl.this.threadUpdater.treeChanged();
                            this.finish();
                        }
                    }
                }
            };
            this.gdb.sendCommand(cmd);
        }
    }

    public void registerDebuggingViewModel(ModelListener model) {
        super.registerDebuggingViewModel(model);
        boolean bl = this.get_debugging = model != null;
        if (this.get_debugging && this.state().isProcess && !this.state().isRunning) {
            this.requestThreadsWithStacks();
        }
    }

    private void requestThreadsWithStacks() {
        if (this.peculiarity.supports(GdbVersionPeculiarity.Feature.THREAD_INFO) || this.peculiarity.isLldb()) {
            MiCommandImpl cmd = new MiCommandImpl("-thread-info"){

                @Override
                protected void onDone(MIRecord threads) {
                    final ArrayList<GdbThread> res = new ArrayList<GdbThread>();
                    MITList results = threads.results();
                    String threadId = results.getConstValue(GdbDebuggerImpl.MI_CURRENT_THREAD);
                    GdbThread curThread = null;
                    if (!threadId.isEmpty()) {
                        GdbDebuggerImpl.this.currentThreadId = threadId;
                    }
                    for (MITListItem thr : results.valueOf(GdbDebuggerImpl.MI_THREADS).asList()) {
                        MITList thrList = (MITList)thr;
                        final String id = thrList.getConstValue("id");
                        String name = thrList.getConstValue("target-id");
                        String state = thrList.getConstValue("state");
                        final GdbThread gdbThread = new GdbThread((NativeDebugger)GdbDebuggerImpl.this, GdbDebuggerImpl.this.threadUpdater, id, name, null, state);
                        if (id.equals(GdbDebuggerImpl.this.currentThreadId)) {
                            curThread = gdbThread;
                        }
                        res.add(gdbThread);
                        String frameNo = "0";
                        if (GdbDebuggerImpl.this.peculiarity.isLldb()) {
                            LinkedList<GdbFrame> frames = new LinkedList<GdbFrame>();
                            for (MIResult item : thrList) {
                                if (!item.matches(GdbDebuggerImpl.MI_FRAME)) continue;
                                MIValue frame = item.value();
                                GdbFrame gdbFrame = new GdbFrame(GdbDebuggerImpl.this, frame, null, gdbThread);
                                if (gdbFrame.getNumber().equals("0")) {
                                    gdbFrame.setCurrent(true);
                                }
                                frames.add(gdbFrame);
                            }
                            gdbThread.setStack(frames.toArray(new GdbFrame[0]));
                            if (gdbThread.isCurrent()) {
                                GdbDebuggerImpl.access$3402(GdbDebuggerImpl.this, gdbThread.getStack());
                            }
                            GdbDebuggerImpl.access$3502(GdbDebuggerImpl.this, res.toArray(new GdbThread[res.size()]));
                            continue;
                        }
                        if (!gdbThread.isSuspended()) continue;
                        MiCommandImpl cmd = new MiCommandImpl(GdbDebuggerImpl.this.peculiarity.stackListFramesCommand(id)){

                            @Override
                            protected void onDone(final MIRecord frames) {
                                String args_command = "-stack-list-arguments 1 --thread " + id;
                                MiCommandImpl cmd3 = new MiCommandImpl(args_command){

                                    @Override
                                    protected void onDone(MIRecord args) {
                                        MITList args_list = null;
                                        if (args != null) {
                                            MITList argsresults = args.results();
                                            args_list = (MITList)argsresults.valueOf("stack-args");
                                            String stringframes = args_list.toString();
                                            if (Log.Variable.mi_frame) {
                                                System.out.println("args_list " + stringframes);
                                            }
                                        }
                                        MITList results = frames.results();
                                        MITList stack_list = (MITList)results.valueOf("stack");
                                        int size = stack_list.size();
                                        Frame[] frames2 = new GdbFrame[size];
                                        for (int vx = 0; vx < size; ++vx) {
                                            GdbFrame gdbFrame;
                                            MIResult frame = (MIResult)stack_list.get(vx);
                                            MIResult frameArgs = null;
                                            if (args_list != null && vx < args_list.size()) {
                                                frameArgs = (MIResult)args_list.get(vx);
                                            }
                                            if ((gdbFrame = new GdbFrame(GdbDebuggerImpl.this, frame.value(), frameArgs, gdbThread)).getNumber().equals("0")) {
                                                gdbFrame.setCurrent(true);
                                            }
                                            frames2[vx] = gdbFrame;
                                        }
                                        gdbThread.setStack(frames2);
                                        GdbDebuggerImpl.access$3502(GdbDebuggerImpl.this, res.toArray(new GdbThread[res.size()]));
                                        GdbDebuggerImpl.this.debuggingViewUpdater.treeChanged();
                                        this.finish();
                                    }

                                    @Override
                                    protected void onError(MIRecord record) {
                                        this.onDone(null);
                                    }
                                };
                                GdbDebuggerImpl.this.gdb.sendCommand(cmd3);
                                this.finish();
                            }
                        };
                        GdbDebuggerImpl.this.gdb.sendCommand(cmd);
                    }
                    GdbDebuggerImpl.this.makeThreadCurrent(curThread);
                    this.finish();
                }
            };
            this.gdb.sendCommand(cmd);
        } else if (this.showMessage) {
            NativeDebuggerManager.warning((String)Catalog.get("MSG_OldGdbVersion"));
            this.showMessage = false;
        }
    }

    public Thread[] getThreadsWithStacks() {
        return this.threadsWithStacks;
    }

    public void registerStackModel(StackModel model) {
        if (Log.Variable.mi_frame) {
            System.out.println("registerStackModel " + model);
        }
        this.stackUpdater.setListener((ModelListener)model);
        this.get_frames = model != null;
    }

    public Frame[] getStack() {
        if (this.guiStackFrames == null) {
            return new GdbFrame[0];
        }
        return this.guiStackFrames;
    }

    public void postPrettyPrint(boolean v) {
    }

    public void postVerboseStack(boolean v) {
    }

    public GdbFrame getCurrentFrame() {
        if (this.guiStackFrames != null) {
            for (Frame frame : this.guiStackFrames) {
                if (!frame.isCurrent()) continue;
                return (GdbFrame)frame;
            }
            return (GdbFrame)this.guiStackFrames[0];
        }
        return null;
    }

    public void moreFrame() {
    }

    public void makeFrameCurrent(Frame f) {
        String fno = f.getNumber();
        boolean changed = false;
        if (this.guiStackFrames != null) {
            for (Frame frame : this.guiStackFrames) {
                if (frame.getNumber().equals(fno)) {
                    changed = true;
                    frame.setCurrent(true);
                    continue;
                }
                frame.setCurrent(false);
            }
        }
        if (changed) {
            this.selectFrame(fno);
            this.getFullPath((GdbFrame)f);
            if (this.get_debugging) {
                for (GdbThread gdbThread : this.threadsWithStacks) {
                    if (!gdbThread.isCurrent()) continue;
                    for (Frame frame : gdbThread.getStack()) {
                        frame.setCurrent(frame.getNumber().equals(fno));
                    }
                }
                this.debuggingViewUpdater.treeChanged();
            }
        }
        this.stackUpdater.treeChanged();
        this.disassembly.stateUpdated();
    }

    private void visitCurrentSrc(GdbFrame f, MIRecord srcRecord) {
        MITList srcTuple = srcRecord.results();
        if (f == null) {
            f = new GdbFrame(this, null, null, null);
        }
        MILocation l = MILocation.make((NativeDebugger)this, f.getMIframe(), srcTuple, false, this.getStack().length, null);
        if (this.homeLoc == null) {
            this.homeLoc = l;
        }
        boolean visited = this.state().isProcess ? !l.equals((Object)this.homeLoc) : true;
        this.setVisitedLocation(MILocation.make(l, visited));
        this.state().isUpAllowed = !l.bottomframe();
        this.state().isDownAllowed = !l.topframe();
        this.stateChanged();
    }

    private void getFullPath(final GdbFrame f) {
        MiCommandImpl cmd = new MiCommandImpl("-file-list-exec-source-file"){

            @Override
            protected void onDone(MIRecord record) {
                GdbDebuggerImpl.this.visitCurrentSrc(f, record);
                this.finish();
            }
        };
        cmd.dontReportError();
        this.gdb.sendCommand(cmd);
    }

    private void selectFrame(Object fno) {
        MiCommandImpl cmd = new MiCommandImpl("-stack-select-frame " + fno){

            @Override
            protected void onDone(MIRecord record) {
                GdbDebuggerImpl.this.updateLocalsForSelectFrame();
                this.finish();
            }
        };
        this.gdb.sendCommand(cmd);
    }

    private void setStackWithArgs(MIRecord framerecords, MIRecord args) {
        MITList args_list = null;
        if (args != null) {
            MITList argsresults = args.results();
            args_list = (MITList)argsresults.valueOf("stack-args");
            String stringframes = args_list.toString();
            if (Log.Variable.mi_frame) {
                System.out.println("args_list " + stringframes);
            }
        }
        MITList results = framerecords.results();
        MITList stack_list = (MITList)results.valueOf("stack");
        int size = stack_list.size();
        GdbFrame[] newGuiStackFrames = new GdbFrame[size];
        for (int vx = 0; vx < size; ++vx) {
            MIResult frame = (MIResult)stack_list.get(vx);
            MIResult frameArgs = null;
            if (args_list != null && vx < args_list.size()) {
                frameArgs = (MIResult)args_list.get(vx);
            }
            newGuiStackFrames[vx] = new GdbFrame(this, frame.value(), frameArgs, null);
            if (vx != 0) continue;
            newGuiStackFrames[vx].setCurrent(true);
        }
        this.guiStackFrames = newGuiStackFrames;
        if (this.get_locals) {
            this.getMILocals(true);
        }
        this.stackUpdater.treeChanged();
        this.disassembly.stateUpdated();
    }

    private void setStack(final MIRecord framerecords) {
        String args_command = "-stack-list-arguments 1";
        MiCommandImpl cmd = new MiCommandImpl(args_command){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void onDone(MIRecord record) {
                try {
                    GdbDebuggerImpl.this.setStackWithArgs(framerecords, record);
                }
                finally {
                    this.finish();
                }
            }

            @Override
            protected void onError(MIRecord record) {
                String errMsg = GdbDebuggerImpl.this.getErrMsg(record);
                if (errMsg.equals(corrupt_stack)) {
                    GdbDebuggerImpl.this.setStack(framerecords);
                } else {
                    GdbDebuggerImpl.this.setStackWithArgs(framerecords, null);
                }
                this.finish();
            }
        };
        this.gdb.sendCommand(cmd);
    }

    public void balloonEvaluate(int pos, String text) {
        StringBuilder command;
        if (this.gdb == null || !this.gdb.connected()) {
            return;
        }
        if (this.state().isProcess && this.state().isRunning) {
            return;
        }
        String expr = pos == -1 ? text : EvalAnnotation.extractExpr((int)pos, (String)text);
        if (expr == null || expr.isEmpty()) {
            return;
        }
        boolean dis = Disassembly.isInDisasm();
        if (dis && Character.isLetter(expr.charAt(0))) {
            expr = '$' + expr;
        }
        Handler[] handlers = this.bm().getHandlers();
        if (this.peculiarity.isLldb()) {
            if (handlers.length > 0) {
                command = new StringBuilder();
                command.append("-break-disable");
                for (Handler h : handlers) {
                    if (!h.breakpoint().isEnabled()) continue;
                    command.append(' ');
                    command.append(h.getId());
                }
                this.send(command.toString());
            }
        } else {
            this.send("-break-disable");
        }
        this.send("-gdb-set unwindonsignal on");
        this.dataMIEval(expr, dis);
        if (handlers.length > 0) {
            command = new StringBuilder();
            command.append("-break-enable");
            for (Handler h : handlers) {
                if (!h.breakpoint().isEnabled()) continue;
                command.append(' ');
                command.append(h.getId());
            }
            this.send(command.toString());
        }
        this.send("-gdb-set unwindonsignal off");
    }

    public void evaluateInOutline(String expr) {
        ModelChangeDelegator mcd = new ModelChangeDelegator();
        mcd.setListener((ModelListener)new ModelChangeListenerImpl());
        final GdbWatch watch = new GdbWatch((NativeDebugger)this, mcd, expr);
        this.createMIVar(watch, false);
        ToolTipView.VariableNode node = new ToolTipView.VariableNode((Variable)watch, (Children)new GdbVariableNodeChildren(watch, false));
        ActionListener disposeListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeleteMIVarCommand cmd = new DeleteMIVarCommand(watch);
                cmd.dontReportError();
                if (GdbDebuggerImpl.this.session() != null) {
                    GdbDebuggerImpl.this.sendCommandInt(cmd);
                }
            }
        };
        SwingUtilities.invokeLater(new Runnable((Node)node, disposeListener){
            final /* synthetic */ Node val$node;
            final /* synthetic */ ActionListener val$disposeListener;
            {
                this.val$node = node;
                this.val$disposeListener = actionListener;
            }

            @Override
            public void run() {
                ToolTipView.getDefault().setRootElement(this.val$node).setOnDisposeListener(this.val$disposeListener).showTooltip();
            }
        });
    }

    public void postExprQualify(String expr, NativeDebugger.QualifiedExprListener qeListener) {
    }

    private void dataMIEval(final String expr, final boolean dis) {
        String expandedExpr = MacroSupport.expandMacro((NativeDebugger)this, (String)expr);
        String cmdString = "-data-evaluate-expression \"" + expandedExpr + "\"";
        MiCommandImpl cmd = new MiCommandImpl(cmdString){

            @Override
            protected void onDone(MIRecord record) {
                MITList value = record.results();
                if (Log.Variable.mi_vars) {
                    System.out.println("value " + value.toString());
                }
                String value_string = value.getConstValue("value");
                if (dis) {
                    if (!value_string.startsWith("0x")) {
                        try {
                            value_string = Address.toHexString0x((long)Address.parseAddr((String)value_string), (boolean)true);
                        }
                        catch (Exception e) {}
                    }
                } else {
                    if (value_string.startsWith("@0x")) {
                        GdbDebuggerImpl.this.balloonEvaluate(-1, "*&" + expr);
                        this.finish();
                        return;
                    }
                    value_string = ValuePresenter.getValue(value_string);
                }
                final String finalVal = value_string;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ToolTipView.ExpandableTooltip expTooltip = ToolTipView.getExpTooltipForText((String)(expr + "=" + finalVal));
                        expTooltip.addExpansionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                GdbDebuggerImpl.this.evaluateInOutline(expr);
                            }
                        });
                        expTooltip.showTooltip();
                    }
                });
                this.finish();
            }

            @Override
            protected void onError(MIRecord record) {
                this.finish();
            }
        };
        this.gdb.sendCommand(cmd);
    }

    public void postCreateWatch(int routingToken, NativeWatch newWatch) {
    }

    public boolean watchError(int rt, Error error) {
        return false;
    }

    public void replaceWatch(NativeWatch original, String replacewith) {
        original.postDelete(false);
        this.manager().createWatch(replacewith.trim());
    }

    protected void restoreWatch(NativeWatch template) {
        NativeWatch nativeWatch = template;
        GdbWatch gdbWatch = new GdbWatch((NativeDebugger)this, this.watchUpdater(), nativeWatch.getExpression());
        this.createMIVar(gdbWatch, true);
        this.updateMIVar();
        nativeWatch.setSubWatchFor((WatchVariable)gdbWatch, (NativeDebugger)this);
        this.watches.add((ListMapItem)gdbWatch);
        this.manager().bringDownDialog();
        this.watchUpdater().treeChanged();
    }

    public void postDeleteAllWatches() {
    }

    public void postDeleteWatch(final WatchVariable variable, final boolean spreading) {
        if (!(variable instanceof GdbWatch)) {
            return;
        }
        GdbWatch watch = (GdbWatch)variable;
        if (watch.getMIName() == null) {
            this.deleteWatch(variable, spreading);
        } else {
            DeleteMIVarCommand cmd = new DeleteMIVarCommand(watch){

                @Override
                protected void onDone(MIRecord record) {
                    super.onDone(record);
                    GdbDebuggerImpl.this.deleteWatch(variable, spreading);
                }

                @Override
                protected void onError(MIRecord record) {
                    super.onDone(record);
                    GdbDebuggerImpl.this.deleteWatch(variable, spreading);
                }
            };
            this.sendCommandInt(cmd);
        }
    }

    public void postDynamicWatch(Variable variable) {
    }

    public void postInheritedWatch(Variable watch) {
    }

    public void deleteVar(Variable var, MIRecord record) {
        this.variableBag.remove_count = 0;
        this.variableBag.remove(var);
        if (Log.Variable.mi_vars) {
            System.out.println("variableBag.remove_count " + this.variableBag.remove_count);
        }
        this.variableBag.remove_count = 0;
    }

    public void registerWatchModel(WatchModel model) {
        if (Log.Variable.mi_vars) {
            System.out.println("registerWatchModel " + model);
        }
        this.watchUpdater().setListener((ModelListener)model);
        if (model != null) {
            this.get_watches = true;
            if (this.state().isProcess && !this.state().isRunning) {
                this.updateWatches();
            }
        } else {
            this.get_watches = false;
        }
    }

    private void retryWatches() {
        for (WatchVariable wv : this.watches) {
            GdbWatch w = (GdbWatch)wv;
            if (w.getMIName() != null) continue;
            this.createMIVar(w, true);
        }
    }

    private void updateWatches() {
        this.retryWatches();
        this.updateMIVar();
    }

    private void updateVarAttr(GdbVariable v, MIRecord attr, boolean evalValue) {
        MITList attr_results = attr.results();
        String value = attr_results.getConstValue("attr");
        v.setEditable(value);
        if (v.isEditable() && evalValue) {
            this.evalMIVar(v);
        }
    }

    private void updateStringValue(final GdbVariable v) {
        if (!ValuePresenter.acceptsType(v.getType())) {
            return;
        }
        MiCommandImpl cmd = new MiCommandImpl("-data-evaluate-expression \"" + v.getFullName() + '\"'){

            @Override
            protected void onDone(MIRecord record) {
                GdbDebuggerImpl.this.updateValue(v, record, false);
                super.onDone(record);
            }
        };
        cmd.dontReportError();
        this.gdb.sendCommand(cmd);
    }

    private void updateValue(GdbVariable v, MIRecord varvalue, boolean pretty) {
        MITList value_results = varvalue.results();
        MIValue miValue = value_results.valueOf("value");
        this.updateValue(v, miValue, pretty);
    }

    private void updateValue(GdbVariable v, MIValue miValue, boolean pretty) {
        String value = null;
        if (miValue != null) {
            value = miValue.asConst().value();
        }
        value = GdbDebuggerImpl.processValue(value);
        if (!pretty) {
            value = ValuePresenter.getValue(value);
        }
        v.setAsText(value);
        if (pretty) {
            this.updateStringValue(v);
        }
        if (v.isWatch()) {
            this.watchUpdater().treeNodeChanged((Object)v);
        } else {
            this.localUpdater.treeNodeChanged((Object)v);
        }
    }

    private static String processValue(String value) {
        if (value == null) {
            return STRUCT_VALUE;
        }
        if (value.startsWith("[") && value.endsWith("]")) {
            return STRUCT_VALUE;
        }
        return value;
    }

    private void interpMIChildren(GdbVariable parent, MIRecord miRecord, int level) {
        MITList results = miRecord.results();
        parent.setNumChild(results.getConstValue(MI_NUMCHILD));
        parent.setHasMore(results.getConstValue("has_more"));
        MITList children_list = null;
        MIValue childrenValue = results.valueOf("children");
        if (childrenValue instanceof MITList) {
            children_list = (MITList)childrenValue;
        }
        ArrayList<GdbVariable> children = new ArrayList<GdbVariable>();
        if (children_list != null) {
            int childIdx = 0;
            for (MITListItem childresult : children_list) {
                MITList childResList = ((MIResult)childresult).value().asTuple();
                String qname = childResList.getConstValue("name");
                String exp = childResList.getConstValue(MI_EXP);
                if (exp.equals("private") || exp.equals("public") || exp.equals("protected")) {
                    this.getMIChildren(parent, qname, level + 1);
                    continue;
                }
                if (parent.isDynamic() && parent.getDisplayHint() == GdbVariable.DisplayHint.MAP) {
                    exp = childIdx % 2 == 0 ? Catalog.format("Map_Key", childIdx / 2) : Catalog.format("Map_Value", childIdx / 2);
                    ++childIdx;
                } else {
                    try {
                        Integer.parseInt(exp);
                        exp = parent.getVariableName() + '[' + exp + ']';
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                GdbVariable childvar = new GdbVariable(this, parent.getUpdater(), parent, exp, null, null, parent.isWatch());
                String value = childResList.getConstValue("value");
                value = GdbDebuggerImpl.processValue(value);
                childvar.setAsText(value);
                childvar.populateFields(childResList);
                this.variableBag.add(childvar);
                children.add(childvar);
                this.attrMIVar(childvar, false);
            }
        }
        GdbVariable[] vars = new GdbVariable[children.size()];
        if (level == 0) {
            parent.setChildren(children.toArray(vars), true);
        } else {
            parent.addChildren(children.toArray(vars), true);
        }
    }

    private void interpUpdate(MIRecord var) {
        MITList varsresults = var.results();
        MITList update_list = (MITList)varsresults.valueOf("changelist");
        if (Log.Variable.mi_vars) {
            System.out.println("update_list " + update_list.toString());
        }
        for (MITListItem item : update_list) {
            GdbVariable wv;
            MIValue updatevar;
            if (update_list.isResultList()) {
                MIResult result = (MIResult)item;
                CndUtils.assertTrue((boolean)result.variable().equals("varobj"), (String)("Erroneous response:" + var.toString()));
                updatevar = result.value();
            } else {
                updatevar = (MIValue)item;
            }
            String mi_name = updatevar.asTuple().getConstValue("name");
            String in_scope = updatevar.asTuple().getConstValue("in_scope");
            if (Log.Variable.mi_vars) {
                System.out.println("update name " + mi_name + " in_scope " + in_scope);
            }
            if ((wv = this.variableBag.get(mi_name, true, 3)) == null) continue;
            wv.populateUpdate(updatevar.asTuple(), this.variableBag);
            if (updatevar.asTuple().valueOf("value") != null) {
                this.updateValue(wv, updatevar.asTuple().valueOf("value"), true);
                continue;
            }
            if (in_scope != null && !in_scope.equalsIgnoreCase("true")) continue;
            this.evalMIVar(wv);
        }
    }

    public void setDynamicType(boolean b) {
        String cmdString = b ? "-gdb-set print object on" : "-gdb-set print object off";
        this.send(cmdString);
        this.dynamicType = b;
    }

    public boolean isDynamicType() {
        return this.dynamicType;
    }

    public boolean isStaticMembers() {
        return true;
    }

    public void setStaticMembers(boolean b) {
    }

    public boolean isPrettyPrint() {
        return true;
    }

    public void setPrettyPrint(boolean b) {
    }

    public boolean isInheritedMembers() {
        return true;
    }

    public void setInheritedMembers(boolean b) {
    }

    public String[] formatChoices() {
        return new String[]{"binary", "octal", "decimal", "hexadecimal", "natural"};
    }

    private void interpVarFormat(GdbVariable v, MIRecord record) {
        MITList format_results = record.results();
        String format = format_results.getConstValue("format");
        v.setFormat(format);
        this.evalMIVar(v);
    }

    void postVarFormat(final GdbVariable v, String format) {
        String expr = v.getMIName();
        String cmdString = "-var-set-format " + expr + " " + format;
        MiCommandImpl cmd = new MiCommandImpl(cmdString){

            @Override
            protected void onDone(MIRecord record) {
                GdbDebuggerImpl.this.interpVarFormat(v, record);
                this.finish();
            }
        };
        this.gdb.sendCommand(cmd);
    }

    private void interpVar(GdbVariable v, MIRecord var) {
        v.populateFields(var.results());
        GdbVariable wv = this.variableBag.get(v.getMIName(), true, 3);
        if (wv == null) {
            this.variableBag.add(v);
        }
        this.attrMIVar(v, true);
    }

    private void attrMIVar(final GdbVariable v, final boolean evalValue) {
        if (v.getNumChild() == -1) {
            return;
        }
        String expr = v.getMIName();
        String cmdString = this.peculiarity.showAttributesCommand(expr);
        MiCommandImpl cmd = new MiCommandImpl(cmdString){

            @Override
            protected void onDone(MIRecord record) {
                GdbDebuggerImpl.this.updateVarAttr(v, record, evalValue);
                this.finish();
            }
        };
        this.gdb.sendCommand(cmd);
    }

    private void updateMIVar(GdbVariable var) {
        String cmdString = "-var-update --all-values " + var.getMIName();
        MiCommandImpl cmd = new MiCommandImpl(cmdString){

            @Override
            protected void onDone(MIRecord record) {
                GdbDebuggerImpl.this.interpUpdate(record);
                this.finish();
            }
        };
        this.gdb.sendCommand(cmd);
    }

    private void updateMIVar() {
        Variable[] list;
        if (!this.peculiarity.isLldb()) {
            String cmdString = "-var-update --all-values * ";
            MiCommandImpl cmd = new MiCommandImpl(cmdString){

                @Override
                protected void onDone(MIRecord record) {
                    GdbDebuggerImpl.this.interpUpdate(record);
                    this.finish();
                }

                @Override
                protected void onError(MIRecord record) {
                    String out_of_scope;
                    String errMsg = GdbDebuggerImpl.this.getErrMsg(record);
                    if (GdbDebuggerImpl.this.try_one_more && errMsg.equals(corrupt_stack)) {
                        GdbDebuggerImpl.this.try_one_more = true;
                    }
                    if (!errMsg.equals(out_of_scope = "mi_cmd_var_assign: Could not assign expression to varible object")) {
                        GdbDebuggerImpl.this.genericFailure(record);
                        this.finish();
                    }
                }
            };
            this.gdb.sendCommand(cmd);
        }
        for (Variable variable : list = this.isShowAutos() ? this.getAutos() : this.getLocals()) {
            if (!(variable instanceof GdbVariable)) continue;
            if (this.peculiarity.isLldb() && ((GdbVariable)variable).getMIName() != null) {
                this.updateMIVar((GdbVariable)variable);
            }
            this.updateStringValue((GdbVariable)variable);
        }
        for (Variable variable : this.getWatches()) {
            if (!(variable instanceof GdbVariable)) continue;
            if (this.peculiarity.isLldb() && ((GdbVariable)variable).getMIName() != null) {
                this.updateMIVar((GdbVariable)variable);
            }
            this.updateStringValue((GdbVariable)variable);
        }
        if (this.peculiarity.isLldb()) {
            this.localUpdater.treeChanged();
        }
    }

    private void evalMIVar(final GdbVariable v) {
        String mi_name = v.getMIName();
        String cmdString = "-var-evaluate-expression " + mi_name;
        MiCommandImpl cmd = new MiCommandImpl(cmdString){

            @Override
            protected void onDone(MIRecord record) {
                GdbDebuggerImpl.this.updateValue(v, record, true);
                this.finish();
            }

            @Override
            protected void onError(MIRecord record) {
                String out_of_scope;
                String errMsg = GdbDebuggerImpl.this.getErrMsg(record);
                if (!errMsg.equals(out_of_scope = "mi_cmd_var_assign: Could not assign expression to varible object")) {
                    GdbDebuggerImpl.this.genericFailure(record);
                    this.finish();
                }
            }
        };
        this.gdb.sendCommand(cmd);
    }

    void getMoreMIChildren(final GdbVariable parent, String expr, final int level) {
        String cmdString = this.peculiarity.listChildrenCommand(expr, parent.getChildrenRequestedCount(), parent.incrementChildrenRequestedCount());
        MiCommandImpl cmd = new MiCommandImpl(cmdString){

            @Override
            protected void onDone(MIRecord record) {
                GdbDebuggerImpl.this.interpMIChildren(parent, record, level);
                this.finish();
            }
        };
        cmd.dontReportError();
        this.gdb.sendCommand(cmd);
    }

    void getMIChildren(GdbVariable parent, String expr, int level) {
        parent.resetChildrenRequestedCount();
        this.getMoreMIChildren(parent, expr, level);
    }

    private void createMIVar(final GdbVariable v, boolean expandMacros) {
        String expr = v.getVariableName();
        if (expandMacros) {
            expr = MacroSupport.expandMacro((NativeDebugger)this, (String)v.getVariableName());
        }
        String cmdString = this.peculiarity.createVarCommand(expr, this.currentThreadId, "0");
        MiCommandImpl cmd = new MiCommandImpl(cmdString){

            @Override
            protected void onDone(MIRecord record) {
                v.setAsText(GdbDebuggerImpl.STRUCT_VALUE);
                v.setInScope(true);
                GdbDebuggerImpl.this.interpVar(v, record);
                GdbDebuggerImpl.this.updateValue(v, record, true);
                this.finish();
            }

            @Override
            protected void onError(MIRecord record) {
                String errMsg = GdbDebuggerImpl.this.getErrMsg(record);
                v.setAsText(errMsg);
                v.setInScope(false);
                this.finish();
                GdbDebuggerImpl.this.watchUpdater().treeChanged();
            }
        };
        this.gdb.sendCommand(cmd);
    }

    public void registerLocalModel(LocalModel model) {
        if (Log.Variable.mi_vars) {
            System.out.println("registerLocalModel " + model);
        }
        this.localUpdater.setListener((ModelListener)model);
        if (model != null) {
            this.get_locals = true;
            if ((this.state().isProcess || this.state().isCore) && !this.state().isRunning) {
                this.getMILocals(true);
            }
        } else {
            this.get_locals = false;
        }
    }

    public Variable[] getLocals() {
        return this.local_vars;
    }

    public int getLocalsCount() {
        return this.local_vars.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> requestAutos() {
        Set autoNames = super.requestAutos();
        LinkedList<GdbVariable> res = new LinkedList<GdbVariable>();
        if (autoNames != null) {
            for (String auto : autoNames) {
                GdbVariable var = this.variableBag.get(auto, false, 3);
                if (var == null) {
                    var = new GdbVariable(this, this.localUpdater, null, auto, null, null, false);
                    this.createMIVar(var, true);
                }
                res.add(var);
            }
        } else {
            res = null;
        }
        List list = this.autos;
        synchronized (list) {
            this.autos.clear();
            if (res == null) {
                this.autos.add(null);
            } else {
                this.autos.addAll(res);
            }
        }
        return autoNames;
    }

    public void setShowAutos(boolean showAutos) {
        super.setShowAutos(showAutos);
        if (this.gdb != null && this.gdb.connected() && showAutos) {
            this.requestAutos();
        }
    }

    private void setLocals(boolean update_var, MIRecord locals) {
        GdbVariable gv;
        int vx;
        int size;
        MITList localsresults = locals.results();
        MITList locals_list = (MITList)localsresults.valueOf("locals");
        int local_count = size = locals_list.size();
        List<GdbLocal> param_list = null;
        int params_count = 0;
        GdbFrame cf = this.getCurrentFrame();
        if (cf != null && (param_list = cf.getArgsList()) != null) {
            params_count = param_list.size();
        }
        local_count += params_count;
        if (Log.Variable.mi_vars) {
            System.out.println("locals " + locals_list.toString());
            System.out.println("args " + param_list.toString());
            System.out.println("local_count " + local_count);
            System.out.println("update_var " + update_var);
        }
        GdbVariable[] new_local_vars = new GdbVariable[local_count];
        for (vx = 0; vx < size; ++vx) {
            MIResult localvar;
            String var_name;
            MITListItem localItem = locals_list.get(vx);
            if (this.peculiarity.isLocalsOutputUnusual()) {
                localItem = ((MITList)localItem).get(0);
            }
            if ((gv = this.variableBag.get(var_name = (localvar = (MIResult)localItem).value().asConst().value(), false, 1)) == null) {
                new_local_vars[vx] = new GdbVariable(this, this.localUpdater, null, var_name, null, null, false);
                this.createMIVar(new_local_vars[vx], false);
                continue;
            }
            new_local_vars[vx] = gv;
            this.evalMIVar(new_local_vars[vx]);
        }
        for (vx = 0; vx < params_count; ++vx) {
            GdbLocal loc = param_list.get(vx);
            String var_name = loc.getName();
            String var_value = loc.getValue();
            gv = this.variableBag.get(var_name, false, 1);
            if (gv != null) {
                gv.setValue(var_value);
                new_local_vars[size + vx] = gv;
                continue;
            }
            new_local_vars[size + vx] = new GdbVariable(this, this.localUpdater, null, var_name, loc.getType(), loc.getValue(), false);
            this.createMIVar(new_local_vars[size + vx], false);
        }
        this.local_vars = new_local_vars;
        if (update_var) {
            this.updateMIVar();
        }
        this.localUpdater.treeChanged();
    }

    private void getMILocals(final boolean update_var) {
        MiCommandImpl cmd = new MiCommandImpl(this.peculiarity.stackListLocalsCommand()){

            @Override
            protected void onDone(MIRecord record) {
                GdbDebuggerImpl.this.setLocals(update_var, record);
                this.finish();
            }
        };
        this.gdb.sendCommand(cmd);
    }

    private void getMIDis(String command) {
        MiCommandImpl cmd = new MiCommandImpl(command){

            @Override
            protected void onDone(MIRecord record) {
                GdbDebuggerImpl.this.setDis(record);
                this.finish();
            }
        };
        this.gdb.sendCommand(cmd);
    }

    private void genericStoppedWithSrc(MIRecord record, MIRecord srcRecord) {
        MIValue reasonValue;
        String reason;
        MITList results;
        MITList srcResults = srcRecord == null ? null : srcRecord.results();
        MITList mITList = results = record == null ? null : record.results();
        if (results != null && results.isEmpty()) {
            results = null;
        }
        if ((reason = (reasonValue = results == null ? null : results.valueOf("reason")) == null ? "breakpoint-hit" : reasonValue.asConst().value()).equals("exited-normally")) {
            this.noteProcGone(reason, results);
            return;
        }
        if (reason.equals("exited")) {
            this.noteProcGone(reason, results);
            return;
        }
        if (reason.equals("exited-signalled")) {
            this.noteProcGone(reason, results);
            return;
        }
        if (reason.equals("breakpoint-hit") || reason.equals("end-stepping-range") || reason.equals("location-reached") || reason.equals("signal-received") || reason.equals(MI_WATCHPOINT_TRIGGER) || reason.equals(MI_WATCHPOINT_SCOPE) || reason.equals(MI_SYSCALL_ENTRY) || reason.equals(MI_SYSCALL_RETURN) || reason.equals("function-finished")) {
            MITList frameTuple;
            MITList stack;
            MIValue wpnumValue;
            MIValue wptValue;
            MIValue bkptnoValue;
            NativeBreakpoint breakpoint = null;
            MIValue mIValue = bkptnoValue = results != null ? results.valueOf("bkptno") : null;
            if (bkptnoValue != null) {
                String bkptnoString = bkptnoValue.asConst().value();
                int bkptno = Integer.parseInt(bkptnoString);
                Handler handler = this.bm().findHandler(bkptno);
                if (handler != null) {
                    handler.setFired(true);
                    breakpoint = handler.breakpoint();
                }
            }
            MIValue mIValue2 = wptValue = results != null ? results.valueOf(MI_WPT) : null;
            if (wptValue != null) {
                String bkptnoString = wptValue.asList().getConstValue(MI_NUMBER);
                int bkptno = Integer.parseInt(bkptnoString);
                Handler handler = this.bm().findHandler(bkptno);
                if (handler != null) {
                    handler.setFired(true);
                    breakpoint = handler.breakpoint();
                }
            }
            MIValue mIValue3 = wpnumValue = results != null ? results.valueOf("wpnum") : null;
            if (wpnumValue != null) {
                String bkptnoString = wpnumValue.asConst().value();
                int bkptno = Integer.parseInt(bkptnoString);
                Handler handler = this.bm().findHandler(bkptno);
                if (handler != null) {
                    handler.setFired(true);
                    handler.setEnabled(false);
                    breakpoint = handler.breakpoint();
                }
            }
            MIValue frameValue = results != null ? results.valueOf(MI_FRAME) : null;
            boolean visited = false;
            if (this.get_locals && frameValue != null) {
                this.guiStackFrames = new GdbFrame[]{new GdbFrame(this, frameValue, null, null)};
            }
            if (srcResults != null) {
                stack = srcResults.valueOf("stack").asList();
                frameValue = ((MIResult)stack.asList().get(0)).value();
                frameTuple = frameValue.asTuple();
                this.homeLoc = MILocation.make((NativeDebugger)this, frameTuple, null, false, stack.size(), breakpoint);
                for (MITListItem stf : stack.asList()) {
                    frameTuple = ((MIResult)stf).value().asTuple();
                    if (this.disRequested || frameTuple.valueOf("file") != null) break;
                    visited = true;
                }
                this.state().isUpAllowed = !this.homeLoc.bottomframe();
                this.state().isDownAllowed = !this.homeLoc.topframe();
                this.setStack(srcRecord);
            } else {
                frameTuple = frameValue == null ? null : frameValue.asTuple();
                stack = null;
            }
            this.setVisitedLocation(MILocation.make((NativeDebugger)this, frameTuple, null, visited, stack == null ? 0 : stack.size(), breakpoint));
            if (this.get_threads) {
                this.showThreads();
            }
            if (this.get_watches) {
                this.updateWatches();
            }
            if (this.get_debugging) {
                for (GdbThread debuggingViewThread : this.threadsWithStacks) {
                    debuggingViewThread.setCurrent(this.currentThreadId.equals(debuggingViewThread.getId()));
                }
                this.debuggingViewUpdater.treeChanged();
            }
            this.state().isProcess = true;
            if (RegistersWindow.getDefault().isShowing()) {
                this.requestRegisters();
            }
        }
        if (record != null) {
            this.explainStop(reason, record);
        }
        this.stateSetRunning(false);
        this.stateChanged();
        this.session().setSessionState(this.state());
    }

    private boolean haveCountingBreakpoints() {
        for (Handler h : this.bm().getHandlers()) {
            NativeBreakpoint b = h.breakpoint();
            if (b == null || !b.hasCountLimit()) continue;
            return true;
        }
        return false;
    }

    private void adjustIgnore(NativeBreakpoint b, MITList props) {
        assert (b.hasCountLimit()) : "adjustIgnore() called on a bpt w/o a count limit";
        MIValue ignore = props.valueOf("ignore");
        if (ignore != null) {
            return;
        }
        long limit = b.getCountLimit();
        int newIgnore = limit == -1L ? GdbHandlerExpert.infinity : (int)limit - 1;
        this.send("-break-after " + b.getId() + ' ' + newIgnore);
    }

    private void updateCounts(MIRecord record) {
        MITList bptresults = record.results();
        MITList table = bptresults.valueOf("BreakpointTable").asTuple();
        MITList bpts = table.valueOf("body").asList();
        System.out.printf("updateCounts: %d bpts\n", bpts.size());
        for (int bx = 0; bx < bpts.size(); ++bx) {
            MIResult b = (MIResult)bpts.get(bx);
            MITList props = b.value().asTuple();
            int hid = -1;
            try {
                hid = Integer.parseInt(props.getConstValue(MI_NUMBER));
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
            Handler h = this.bm().findHandler(hid);
            if (h == null || !h.breakpoint().hasCountLimit()) continue;
            int count = Integer.parseInt(props.getConstValue("times"));
            h.setCount(count);
            this.adjustIgnore(h.breakpoint(), props);
        }
        System.out.printf("............................................\n", new Object[0]);
    }

    void genericStopped(MIRecord stopRecord) {
        MIValue threadIdValue;
        MIValue signalValue;
        if (this.session.coreSession() != DebuggerManager.getDebuggerManager().getCurrentSession()) {
            DebuggerManager.getDebuggerManager().setCurrentSession(this.session.coreSession());
        }
        MITList results = stopRecord.results();
        this.state().isRunning = false;
        if (this.firstBreakpointId != null && "breakpoint-hit".equals(results.getConstValue("reason"))) {
            if (ATTACH_ID.equals(this.firstBreakpointId)) {
                this.attachDone();
                return;
            }
            MIValue bkptnoValue = results.valueOf("bkptno");
            boolean cont = bkptnoValue == null && !STEP_INTO_ID.equals(this.firstBreakpointId) || bkptnoValue != null && this.firstBreakpointId.equals(bkptnoValue.asConst().value());
            this.firstBreakpointId = null;
            ((GdbDebuggerSettingsBridge)this.profileBridge).noteFistStop();
            this.sendPidCommand(cont);
            if (cont) {
                return;
            }
        }
        if (this.gdb.isSignalled() && "signal-received".equals(results.getConstValue("reason")) && (signalValue = results.valueOf("signal-name")) != null) {
            String signal = signalValue.asConst().value();
            if ("SIGCONT".equals(signal)) {
                this.gdb.resetSignalled();
                this.go();
                return;
            }
            if ("SIGINT".equals(signal)) {
                if (this.gdb.isSilentStop()) {
                    this.gdb.resetSilentStop();
                    this.state().isRunning = false;
                    return;
                }
            } else if ("SIGTRAP".equals(signal) && (this.getHost().getPlatform() == Platform.Windows_x86 || this.getHost().getPlatform() == Platform.MacOSX_x86)) {
                if (this.gdb.isSilentStop()) {
                    this.gdb.resetSignalled();
                    this.state().isRunning = false;
                    return;
                }
            } else {
                this.gdb.resetSignalled();
            }
        }
        if ((threadIdValue = results.valueOf("thread-id")) != null) {
            this.currentThreadId = threadIdValue.asConst().value();
        }
        if (this.get_debugging) {
            this.requestThreadsWithStacks();
        }
        this.requestStack(stopRecord);
        if (MemoryWindow.getDefault().isShowing()) {
            MemoryWindow.getDefault().actionPerformed(new ActionEvent(this, 1001, "debugger stopped"));
        }
        if (this.haveCountingBreakpoints()) {
            MiCommandImpl cmd = new MiCommandImpl("-break-list"){

                @Override
                protected void onDone(MIRecord record) {
                    GdbDebuggerImpl.this.updateCounts(record);
                    this.finish();
                }
            };
            this.gdb.sendCommand(cmd);
        }
    }

    protected void requestStack(final MIRecord stopRecord) {
        MiCommandImpl cmd = new MiCommandImpl(this.peculiarity.stackListFramesCommand(this.currentThreadId)){

            @Override
            protected void onDone(MIRecord record) {
                GdbDebuggerImpl.this.genericStoppedWithSrc(stopRecord, record);
                this.finish();
            }

            @Override
            protected void onError(MIRecord record) {
                GdbDebuggerImpl.this.genericStoppedWithSrc(stopRecord, null);
                this.finish();
            }
        };
        this.gdb.sendCommand(cmd);
    }

    private void showSignalPopup(MITList results, String sigName) {
        boolean signalDiscarded;
        SignalDialog sd = new SignalDialog();
        String signum = results.getConstValue("signal-meaning", "?");
        String signalInfo = Catalog.format("FMT_SignalInfo", sigName, signum);
        sd.setSignalInfo(signalInfo);
        if (this.session != null) {
            sd.setReceiverInfo(this.session.getShortName(), this.session.getPid());
        } else {
            sd.setReceiverInfo("", 0L);
        }
        Signals.InitialSignalInfo dsii = null;
        int signo = 0;
        DbgProfile debugProfile = this.getNDI().getDbgProfile();
        dsii = debugProfile.signals().getSignalByName(sigName);
        boolean wasIgnored = false;
        if (dsii != null) {
            wasIgnored = !dsii.isCaught();
            sd.setIgnore(true, wasIgnored);
        } else {
            sd.setIgnore(true, false);
        }
        sd.show();
        if (dsii != null) {
            String cmd = sd.isIgnore() ? "handle " + sigName + " noprint" : "handle " + sigName + " stop";
            this.send(cmd);
        }
        this.deliverSignal = (signalDiscarded = sd.discardSignal()) ? -1 : signo;
        if (sd.discardSignal()) {
            this.send("handle " + sigName + " nopass");
        } else {
            this.send("handle " + sigName + " pass");
        }
        if (sd.shouldContinue()) {
            this.go();
        }
    }

    private void explainStop(String reason, MIRecord record) {
        MITList results = record.results();
        String stateMsg = reason;
        String signalName = "<UNKNOWN>";
        if (reason.equals("end-stepping-range")) {
            stateMsg = Catalog.get("Dbx_program_stopped");
        } else if (reason.equals("signal-received")) {
            signalName = results.getConstValue("signal-name", signalName);
            stateMsg = Catalog.get("Dbx_signal") + " " + signalName;
        } else if (reason.equals("function-finished")) {
            stateMsg = Catalog.get("Dbx_program_stopped");
        } else if (reason.equals("breakpoint-hit")) {
            stateMsg = Catalog.get("Dbx_program_stopped");
        } else if (reason.equals("location-reached")) {
            stateMsg = Catalog.get("Dbx_program_stopped");
        } else if (reason.equals(MI_WATCHPOINT_TRIGGER)) {
            String expValue = "";
            MIValue wptVal = results.valueOf(MI_WPT);
            if (wptVal != null) {
                expValue = wptVal.asList().getConstValue(MI_EXP);
            }
            stateMsg = Catalog.format("MSG_Watchpoint_Trigger", expValue);
        } else {
            stateMsg = reason.equals(MI_WATCHPOINT_SCOPE) ? Catalog.format("MSG_Watchpoint_Scope", new Object[0]) : (reason.equals(MI_SYSCALL_ENTRY) ? Catalog.format("MSG_Syscall_Entry", results.getConstValue("syscall-name", "?"), results.getConstValue("syscall-number", "?")) : (reason.equals(MI_SYSCALL_RETURN) ? Catalog.format("MSG_Syscall_Return", results.getConstValue("syscall-name", "?"), results.getConstValue("syscall-number", "?")) : "Stopped for unrecognized reason: " + reason));
        }
        if (stateMsg != null) {
            this.setStatusText(stateMsg);
        }
        if (reason.equals("signal-received") && !this.gdb.isSignalled()) {
            this.showSignalPopup(results, signalName);
        }
    }

    private static String toCString(String s) {
        StringBuilder sb = new StringBuilder();
        sb.append('\"');
        block3: for (int sx = 0; sx < s.length(); ++sx) {
            char c = s.charAt(sx);
            switch (c) {
                case '\"': 
                case '\\': {
                    sb.append('\\');
                    sb.append(c);
                    continue block3;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        sb.append('\"');
        return sb.toString();
    }

    public void reuse(NativeDebuggerInfo di) {
        this.debug((GdbDebuggerInfo)di);
    }

    private void debug(GdbDebuggerInfo gdi) {
        String tmp_cmd;
        String program = gdi.getTarget();
        long pid = gdi.getPid();
        String corefile = gdi.getCorefile();
        final boolean isCore = corefile != null;
        this.profileBridge.setup((NativeDebuggerInfo)gdi);
        if (corefile != null) {
            if (program == null) {
                program = "-";
            }
        } else if (pid != -1L) {
            if (program == null) {
                program = "-";
            }
        } else if (program == null) {
            return;
        }
        String outputFile = gdi.getSymbolFile();
        outputFile = this.localToRemote("symbol-file", outputFile);
        if (this.peculiarity.isLldb()) {
            tmp_cmd = "-file-exec-and-symbols";
        } else if (isCore || pid != -1L) {
            tmp_cmd = "-file-symbol-file ";
        } else if (!CndPathUtilities.sameString((String)program, (String)outputFile)) {
            this.send("-file-symbol-file " + GdbDebuggerImpl.toCString(outputFile), false);
            tmp_cmd = "-file-exec-file ";
        } else {
            tmp_cmd = "-file-exec-and-symbols";
        }
        String mi_command = tmp_cmd;
        final String fprogram = program;
        String mprogram = GdbDebuggerImpl.toCString(program);
        MiCommandImpl cmd = new MiCommandImpl(mi_command + ' ' + mprogram){

            @Override
            protected void onDone(MIRecord record) {
                if (isCore) {
                    GdbDebuggerImpl.this.state().isCore = true;
                }
                GdbDebuggerImpl.this.getFullPath(null);
                GdbDebuggerImpl.this.gdb.startProgressManager().finishProgress();
                GdbDebuggerImpl.this.session().setTarget(fprogram);
                GdbDebuggerImpl.this.session().update();
                GdbDebuggerImpl.this.session().setSessionEngine(GdbEngineCapabilityProvider.getGdbEngineType());
                GdbDebuggerImpl.this.state().isLoaded = true;
                GdbDebuggerImpl.this.stateChanged();
                GdbDebuggerImpl.this.session().setSessionState(GdbDebuggerImpl.this.state());
                long aPid = GdbDebuggerImpl.this.getNDI().getPid();
                if (aPid != -1L) {
                    GdbDebuggerImpl.this.session().setPid(aPid);
                }
                GdbDebuggerImpl.this.noteProgLoaded(fprogram);
                this.finish();
            }

            @Override
            protected void onError(MIRecord record) {
                GdbDebuggerImpl.this.gdb.startProgressManager().finishProgress();
                GdbDebuggerImpl.this.state().isLoaded = false;
                GdbDebuggerImpl.this.stateChanged();
                GdbDebuggerImpl.this.session().setSessionState(GdbDebuggerImpl.this.state());
                GdbDebuggerImpl.this.genericFailure(record);
                this.finish();
            }
        };
        this.gdb.sendCommand(cmd);
    }

    public HandlerExpert handlerExpert() {
        return this.handlerExpert;
    }

    public void postRestoreHandler(int rt, HandlerCommand hc) {
        MIRestoreBreakCommand cmd = new MIRestoreBreakCommand(rt, hc.getData());
        this.sendCommandInt(cmd);
    }

    public void registerDisassembly(Disassembly dis) {
        boolean makeAsmVisible;
        boolean bl = makeAsmVisible = dis != null;
        if (makeAsmVisible == this.isAsmVisible()) {
            return;
        }
        if (this.postedKillEngine) {
            return;
        }
        if (!this.isConnected()) {
            return;
        }
        if (makeAsmVisible) {
            this.setAsmVisible(true);
        } else {
            this.setAsmVisible(false);
        }
    }

    protected DisFragModel disModel() {
        return this.disModel;
    }

    public Controller disController() {
        return this.disController;
    }

    public GdbDisassembly getDisassembly() {
        return this.disassembly;
    }

    private void requestDisFromGdb(String cmd) {
        if (this.postedKill || this.postedKillEngine || this.gdb == null || cmd == null) {
            return;
        }
        this.getMIDis(cmd);
    }

    private void setDis(MIRecord record) {
        this.disModel.parseRecord(record);
        this.disassembly.update(record.toString());
    }

    public FormatOption[] getMemoryFormats() {
        return GdbMemoryFormat.values();
    }

    static List<String> parseMem(MIRecord record) {
        LinkedList<String> res = new LinkedList<String>();
        int[] size = new int[16];
        for (MITListItem elem : record.results().valueOf("memory").asList()) {
            MITList line = (MITList)elem;
            MIValue dataValue = line.valueOf("data");
            int count = 0;
            for (MITListItem dataElem : dataValue.asList()) {
                int len = ((MIConst)dataElem).value().length();
                size[count] = Math.max(size[count], len);
                ++count;
            }
        }
        for (MITListItem elem : record.results().valueOf("memory").asList()) {
            StringBuilder sb = new StringBuilder();
            MITList line = (MITList)elem;
            String addr = line.getConstValue("addr");
            sb.append(addr).append(':');
            MIValue dataValue = line.valueOf("data");
            int count = 0;
            for (MITListItem dataElem : dataValue.asList()) {
                for (int i = 0; i < size[count] - ((MIConst)dataElem).value().length() + 1; ++i) {
                    sb.append(' ');
                }
                sb.append(((MIConst)dataElem).value());
                ++count;
            }
            String ascii = line.getConstValue("ascii");
            sb.append(" \"").append(ascii).append("\"");
            res.add(sb.toString() + "\n");
        }
        return res;
    }

    public void requestMems(String start, String length, FormatOption format) {
        int lines;
        try {
            lines = (Integer.parseInt(length) - 1) / 16 + 1;
        }
        catch (Exception e) {
            return;
        }
        MiCommandImpl cmd = new MiCommandImpl("-data-read-memory " + start + ' ' + format.getOption() + " 1 " + lines + ' ' + 16 + " ."){

            @Override
            protected void onDone(MIRecord record) {
                if (MemoryWindow.getDefault().isShowing()) {
                    MemoryWindow.getDefault().updateData(GdbDebuggerImpl.parseMem(record));
                }
                this.finish();
            }

            @Override
            protected void onError(MIRecord record) {
                if (MemoryWindow.getDefault().isShowing()) {
                    MemoryWindow.getDefault().updateData(Collections.EMPTY_LIST);
                }
                this.finish();
            }
        };
        if (this.gdb != null) {
            this.gdb.sendCommand(cmd);
        }
    }

    public void requestRegisters() {
        MiCommandImpl cmd;
        if (this.regNames == null) {
            cmd = new MiCommandImpl("-data-list-register-names"){

                @Override
                protected void onDone(MIRecord record) {
                    HashMap<Integer, String> res = new HashMap<Integer, String>();
                    int idx = 0;
                    for (MITListItem elem : record.results().valueOf("register-names").asList()) {
                        res.put(idx++, ((MIConst)elem).value());
                    }
                    GdbDebuggerImpl.this.regNames = res;
                    this.finish();
                }
            };
            if (this.gdb != null) {
                this.gdb.sendCommand(cmd);
            }
        }
        if (this.state().isProcess) {
            cmd = new MiCommandImpl("-data-list-register-values x"){

                @Override
                protected void onDone(MIRecord record) {
                    if (RegistersWindow.getDefault().isShowing()) {
                        LinkedList<String> res = new LinkedList<String>();
                        for (MITListItem elem : record.results().valueOf("register-values").asList()) {
                            StringBuilder sb = new StringBuilder();
                            MITList line = (MITList)elem;
                            String number = line.getConstValue(GdbDebuggerImpl.MI_NUMBER);
                            try {
                                number = (String)GdbDebuggerImpl.this.regNames.get(Integer.valueOf(number));
                            }
                            catch (Exception e) {
                                Exceptions.printStackTrace((Throwable)e);
                            }
                            sb.append(number).append(' ');
                            String value = line.getConstValue("value");
                            sb.append(value);
                            res.add(sb.toString());
                        }
                        RegistersWindow.getDefault().updateData(res);
                    }
                    this.finish();
                }
            };
            if (this.gdb != null) {
                this.gdb.sendCommand(cmd);
            }
        }
    }

    public void registerEvaluationWindow(EvaluationWindow w) {
    }

    void newAsyncBreakpoint(MIRecord record) {
        BreakpointManager.BreakpointPlan bp;
        Integer rt = this.cliBreakpointsRTs.poll();
        if (rt == null) {
            rt = 0;
        }
        if ((bp = this.bm().getBreakpointPlan(rt.intValue(), BreakpointManager.BreakpointMsg.NEW)).op() == BreakpointManager.BreakpointOp.NEW) {
            this.newHandlers(rt, record, bp);
        } else {
            MIResult result = (MIResult)record.results().get(0);
            this.replaceHandler(rt, result, bp);
        }
    }

    void deleteAsyncBreakpoint(MIRecord record) {
        String id = record.results().getConstValue("id");
        int hid = Integer.parseInt(id);
        this.bm().deleteHandlerById(0, hid);
    }

    private void newHandlers(int rt, MIRecord record, BreakpointManager.BreakpointPlan bp) {
        MITList results = record.results();
        for (int tx = 0; tx < results.size(); ++tx) {
            MIResult result = (MIResult)results.get(tx);
            if (!result.matches(MI_BKPT) && !result.matches(MI_WPT)) continue;
            this.newHandler(rt, result, bp);
            return;
        }
        if (results.size() > 0) {
            this.newHandler(rt, (MIResult)results.get(0), bp);
        }
    }

    private void newHandler(int rt, MIResult result, BreakpointManager.BreakpointPlan bp) {
        if (Log.Bpt.pathway) {
            System.out.printf("GdbDebuggerImpl.newHandler(%s)\n", result);
        }
        Handler handler = null;
        try {
            if (bp == null) {
                bp = this.bm().getBreakpointPlan(rt, BreakpointManager.BreakpointMsg.NEW);
            }
            NativeBreakpoint template = bp.template();
            switch (bp.op()) {
                case NEW: {
                    if (template == null) {
                        template = this.prepareTemplate(result);
                    }
                    handler = this.handlerExpert.newHandler(template, result, null);
                    break;
                }
                case RESTORE: {
                    handler = this.handlerExpert.newHandler(template, result, bp.restored());
                    assert (handler.breakpoint() == bp.restored());
                    break;
                }
                case MODIFY: {
                    handler = bp.originalHandler();
                    handler = this.handlerExpert.replaceHandler(template, handler, result, new NativeBreakpoint[0]);
                }
            }
            this.handlerExpert.addAnnotations(handler, handler.breakpoint(), template, result);
            if (!template.isEnabled() && handler.breakpoint().isEnabled()) {
                handler.postEnable(false, handler.breakpoint().getId());
            }
            this.bm().noteNewHandler(rt, bp, handler);
        }
        catch (Exception x) {
            Exceptions.printStackTrace((Throwable)x);
        }
    }

    private NativeBreakpoint prepareTemplate(MIResult result) {
        SysCallBreakpointType type;
        MIValue bkptValue = result.value();
        MITList props = bkptValue.asTuple();
        String typeVal = props.getConstValue("type");
        if ("catchpoint".equals(typeVal)) {
            type = new SysCallBreakpointType();
        } else if ("breakpoint".equals(typeVal)) {
            type = new LineBreakpointType();
            String origLoc = props.getConstValue("original-location");
            if (origLoc != null) {
                if (origLoc.startsWith("*")) {
                    type = new InstructionBreakpointType();
                } else if (!origLoc.contains(":")) {
                    type = new FunctionBreakpointType();
                }
            }
        } else {
            type = new ExceptionBreakpointType();
        }
        return type.newInstance(4);
    }

    private void deleteForReplace(int rt, Handler targetHandler) {
        final int hid = targetHandler.getId();
        MIBreakCommand deleteCmd = new MIBreakCommand(rt, "-break-delete " + hid){

            @Override
            protected void onDone(MIRecord record) {
                Handler h = GdbDebuggerImpl.this.bm().findHandler(hid);
                GdbDebuggerImpl.this.bm().simpleRemove(h);
                this.finish();
            }
        };
        this.gdb.sendCommand(deleteCmd);
    }

    private void replaceHandler(int rt, MIResult result, BreakpointManager.BreakpointPlan bp) {
        if (bp == null) {
            bp = this.bm().getBreakpointPlan(rt, BreakpointManager.BreakpointMsg.REPLACE);
        }
        assert (bp.op() == BreakpointManager.BreakpointOp.MODIFY) : "replaceHandler(): bpt plan not CHANGE for rt " + rt;
        NativeBreakpoint targetBreakpoint = bp.target();
        assert (targetBreakpoint.isSubBreakpoint());
        assert (!targetBreakpoint.isEditable()) : "targetBreakpoint is editable";
        Handler targetHandler = targetBreakpoint.getHandler();
        assert (targetHandler == bp.originalHandler());
        Handler replacementHandler = this.handlerExpert.replaceHandler(targetBreakpoint, targetHandler, result, bp.template());
        this.handlerExpert.addAnnotations(replacementHandler, null, targetBreakpoint, result);
        this.deleteForReplace(rt, targetHandler);
        this.bm().noteReplacedHandler(bp, replacementHandler);
    }

    public void runFailed() {
        this.setStatusText(Catalog.get("RunFailed"));
        this.stateSetRunning(false);
        this.stateChanged();
        this.session().setSessionState(this.state());
    }

    private boolean userInteraction(int rt, MIUserInteraction ui, boolean isBreakpoint) {
        String returnValue;
        ItemSelectorResult result;
        boolean overloadCancelled = false;
        int nitems = ui.items().length;
        String[] item = ui.items();
        if (isBreakpoint) {
            assert (rt == 0 || RoutingToken.BREAKPOINTS.isSameSubsystem(rt));
            String title = "Overloaded breakpoint";
            result = this.bm().noteMultipleBreakpoints(rt, title, nitems, item);
        } else {
            String cookie = null;
            String title = "Ambiguous symbol";
            boolean cancelable = ui.hasCancel();
            boolean multiple_selection = true;
            result = this.manager().popup(rt, cookie, (NativeDebugger)this, title, nitems, item, cancelable, multiple_selection);
        }
        if (result.isCancelled()) {
            overloadCancelled = true;
            returnValue = "" + ui.cancelChoice();
        } else if (result.nSelected() == nitems) {
            returnValue = "" + ui.allChoice();
        } else {
            returnValue = "";
            for (int sx = 0; sx < result.nSelected(); ++sx) {
                returnValue = returnValue + " " + (result.selections()[sx] + ui.firstChoice());
            }
        }
        this.gdb.tap().inject(returnValue + "\n");
        return overloadCancelled;
    }

    public void postEnableAllHandlersImpl(final boolean enable) {
        final Handler[] handlers = this.bm().getHandlers();
        if (handlers.length == 0) {
            return;
        }
        StringBuilder command = new StringBuilder();
        if (enable) {
            command.append("-break-enable");
        } else {
            command.append("-break-disable");
        }
        for (Handler h : handlers) {
            command.append(' ');
            command.append(h.getId());
        }
        MIBreakCommand cmd = new MIBreakCommand(0, command.toString()){

            @Override
            protected void onDone(MIRecord record) {
                for (Handler h : handlers) {
                    h.setEnabled(enable);
                }
                this.finish();
            }
        };
        this.sendCommandInt(cmd);
    }

    public void postActivateBreakpoints() {
        final Handler[] handlers = this.bm().getHandlers();
        if (handlers.length == 0) {
            return;
        }
        StringBuilder command = new StringBuilder();
        command.append("-break-enable");
        for (Handler h : handlers) {
            if (!h.breakpoint().isEnabled()) continue;
            command.append(' ');
            command.append(h.getId());
        }
        MIBreakCommand cmd = new MIBreakCommand(0, command.toString()){

            @Override
            protected void onDone(MIRecord record) {
                GdbDebuggerImpl.this.breakpointsActivated = true;
                for (Handler h : handlers) {
                    h.breakpoint().update();
                }
                this.finish();
            }
        };
        this.sendCommandInt(cmd);
    }

    public void postDeactivateBreakpoints() {
        final Handler[] handlers = this.bm().getHandlers();
        if (handlers.length == 0) {
            return;
        }
        StringBuilder command = new StringBuilder();
        command.append("-break-disable");
        for (Handler h : handlers) {
            if (!h.breakpoint().isEnabled()) continue;
            command.append(' ');
            command.append(h.getId());
        }
        MIBreakCommand cmd = new MIBreakCommand(0, command.toString()){

            @Override
            protected void onDone(MIRecord record) {
                GdbDebuggerImpl.this.breakpointsActivated = false;
                for (Handler h : handlers) {
                    h.breakpoint().update();
                }
                this.finish();
            }
        };
        this.sendCommandInt(cmd);
    }

    public void postDeleteAllHandlersImpl() {
        final Handler[] handlers = this.bm().getHandlers();
        if (handlers.length == 0) {
            return;
        }
        StringBuilder command = new StringBuilder("-break-delete");
        for (Handler h : handlers) {
            command.append(' ');
            command.append(h.getId());
        }
        MIBreakCommand cmd = new MIBreakCommand(0, command.toString()){

            @Override
            protected void onDone(MIRecord record) {
                for (Handler h : handlers) {
                    GdbDebuggerImpl.this.bm().deleteHandlerById(0, h.getId());
                }
                this.finish();
            }
        };
        this.sendCommandInt(cmd);
    }

    public void postDeleteHandlerImpl(final int rt, final int hid) {
        MIBreakCommand cmd = new MIBreakCommand(rt, "-break-delete " + hid){

            @Override
            protected void onDone(MIRecord record) {
                GdbDebuggerImpl.this.bm().deleteHandlerById(rt, hid);
                this.finish();
            }
        };
        this.sendCommandInt(cmd);
    }

    public void postCreateHandlerImpl(int routingToken, HandlerCommand hc) {
        MIBreakLineCommand cmd = new MIBreakLineCommand(routingToken, hc.getData());
        this.sendCommandInt(cmd);
    }

    public void postChangeHandlerImpl(int rt, HandlerCommand hc) {
        assert (hc instanceof GdbHandlerCommand);
        MIChangeBreakCommand cmd = null;
        block4: for (GdbHandlerCommand ghc = (GdbHandlerCommand)hc; ghc != null; ghc = ghc.getNext()) {
            switch (ghc.getType()) {
                case CHANGE: {
                    MIChangeBreakCommand changeCmd = new MIChangeBreakCommand(rt, ghc);
                    if (cmd != null) {
                        cmd.chain(changeCmd, null);
                        continue block4;
                    }
                    cmd = changeCmd;
                    continue block4;
                }
                case REPLACE: {
                    MIReplaceBreakLineCommand old = cmd;
                    cmd = new MIReplaceBreakLineCommand(rt, ghc);
                    cmd.chain(old, null);
                }
            }
        }
        if (cmd != null) {
            this.sendCommandInt(cmd);
        }
    }

    public void postRepairHandlerImpl(int rt, HandlerCommand hc) {
        assert (hc instanceof GdbHandlerCommand);
        GdbHandlerCommand ghc = (GdbHandlerCommand)hc;
        MIRepairBreakLineCommand cmd = new MIRepairBreakLineCommand(rt, ghc);
        this.sendCommandInt(cmd);
    }

    public void setHandlerCountLimit(int hid, long countLimit) {
        this.notImplemented("setHandlerCountLimit()");
    }

    public void postEnableHandler(int rt, final int hid, final boolean enable) {
        String cmdString = enable ? "-break-enable " : "-break-disable ";
        MIBreakCommand cmd = new MIBreakCommand(rt, cmdString + hid){

            @Override
            protected void onDone(MIRecord record) {
                Handler handler = GdbDebuggerImpl.this.bm().findHandler(hid);
                if (handler != null) {
                    handler.setEnabled(enable);
                }
                this.finish();
            }
        };
        this.sendCommandInt(cmd);
    }

    public void postVarContinuation(VarContinuation vc) {
        this.notImplemented("postVarContinuation");
    }

    protected void postVarContinuation(int rt, VarContinuation vc) {
        this.notImplemented("postVarContinuation");
    }

    public void runArgs(String args) {
        this.sendSilent("-exec-arguments " + args);
    }

    public void runDir(String dir) {
        dir = this.localToRemote("runDir", dir);
        String cmdString = this.peculiarity.environmentCdCommand() + " " + dir;
        this.sendSilent(cmdString);
    }

    void setEnv(String envVar) {
        this.sendSilent("set environment " + envVar);
    }

    void unSetEnv(String envVar) {
        this.sendSilent("unset environment " + envVar);
    }

    private static String quoteValue(String value) {
        int length = value.length();
        if (length > 1) {
            return value.replace("\"", "\\\"");
        }
        return value;
    }

    private static String unquoteValue(String value) {
        int length = value.length();
        if (length > 1) {
            return value.replace("\\\"", "\"");
        }
        return value;
    }

    void assignVar(final GdbVariable var, final String value, boolean miVar) {
        String quotedValue = value;
        if (quotedValue.indexOf(32) >= 0 && quotedValue.indexOf(32) < quotedValue.indexOf(34)) {
            quotedValue = quotedValue.substring(quotedValue.indexOf(34));
        }
        quotedValue = GdbDebuggerImpl.quoteValue(quotedValue);
        String cmdString = miVar ? "-var-assign " + var.getMIName() + " " + quotedValue : "-data-evaluate-expression \"" + var.getFullName() + '=' + quotedValue + '\"';
        MiCommandImpl cmd = new MiCommandImpl(cmdString){

            @Override
            protected void onDone(MIRecord record) {
                GdbFrame currentFrame = GdbDebuggerImpl.this.getCurrentFrame();
                if (currentFrame != null) {
                    currentFrame.varUpdated(var.getFullName(), value);
                }
                GdbDebuggerImpl.this.updateMIVar();
                this.finish();
            }

            @Override
            protected void onError(MIRecord record) {
                String out_of_scope;
                String errMsg = GdbDebuggerImpl.this.getErrMsg(record);
                if (GdbDebuggerImpl.this.try_one_more && errMsg.equals(corrupt_stack)) {
                    GdbDebuggerImpl.this.try_one_more = true;
                }
                if (!errMsg.equals(out_of_scope = "mi_cmd_var_assign: Could not assign expression to varible object")) {
                    GdbDebuggerImpl.this.genericFailure(record);
                    this.finish();
                }
            }
        };
        this.gdb.sendCommand(cmd);
    }

    public void activate(boolean redundant) {
        if (this.isConnected()) {
            super.activate(redundant);
        } else {
            this.updateActions();
        }
        if (redundant) {
            return;
        }
    }

    public void deactivate(boolean redundant) {
        super.deactivate(redundant);
        if (redundant) {
            return;
        }
    }

    public void setCurrentDisLine(Line l) {
        this.notImplemented("setCurrentDisLine");
    }

    public Line getCurrentDisLine() {
        return null;
    }

    public void notifyUnsavedFiles(String[] file) {
    }

    public void stepOutInst() {
        this.execFinish();
    }

    public void stepOverInst() {
        this.sendResumptive(this.peculiarity.execNextInstCommand(this.currentThreadId));
    }

    public void stepInst() {
        this.sendResumptive(this.peculiarity.execStepInstCommand(this.currentThreadId));
    }

    public void postRestoring(boolean restoring) {
    }

    public void forkThisWay(NativeDebuggerManager.FollowForkInfo ffi) {
        this.notImplemented("forkThisWay");
    }

    public void fix() {
        this.notImplemented("fix");
    }

    public FormatOption[] getEvalFormats() {
        return null;
    }

    public void exprEval(FormatOption format, final String expr) {
        String cmdString = "-data-evaluate-expression \"" + GdbDebuggerImpl.quoteValue(expr) + "\"";
        MiCommandImpl cmd = new MiCommandImpl(cmdString){

            @Override
            protected void onDone(MIRecord record) {
                final String res = !record.isError() ? record.results().getConstValue("value") : record.error();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        EvaluationWindow evalWindow = EvaluationWindow.getDefault();
                        evalWindow.open();
                        evalWindow.requestActive();
                        evalWindow.componentShowing();
                        evalWindow.evalResult(expr + " = " + GdbDebuggerImpl.unquoteValue(res) + "\n");
                    }
                });
                this.finish();
            }
        };
        this.gdb.sendCommand(cmd);
    }

    public void execute(String cmd) {
        this.notImplemented("execute");
    }

    protected void stopUpdates() {
    }

    protected void startUpdates() {
    }

    void sendTerminalTypedCommand(String termLine) {
        TermCommandImpl cmd = new TermCommandImpl(termLine);
        this.gdb.sendCommand(cmd);
    }

    private void send(String commandStr, boolean reportError) {
        MiCommandImpl cmd = new MiCommandImpl(commandStr);
        if (!reportError) {
            cmd.dontReportError();
        }
        this.gdb.sendCommand(cmd);
    }

    private void sendSilent(String commandStr) {
        this.send(commandStr, false);
    }

    private void send(String commandStr) {
        this.send(commandStr, true);
    }

    private void sendResumptive(String commandStr) {
        MIResumptiveCommand cmd = new MIResumptiveCommand(commandStr);
        this.gdb.sendCommand(cmd, true);
    }

    private void sendCommandInt(MICommand cmd) {
        if (this.postedKill || this.postedKillEngine || this.gdb == null || cmd == null) {
            LOG.log(Level.FINE, "sendCommandInt when session is finished for example, see values to get more information postedKill= {0} postedKillEngine = {1} gdb == {2} || cmd == {3}", new String[]{this.postedKill + "", "" + this.postedKillEngine, this.gdb == null ? "null" : "Not null", cmd == null ? "null" : "Not null"});
            return;
        }
        this.pause(true);
        this.gdb.sendCommand(cmd);
    }

    public void registerRegistersWindow(RegistersWindow w) {
        if (w != null) {
            this.requestRegisters();
        }
    }

    public void assignRegisterValue(String register, String value) {
        MiCommandImpl cmd = new MiCommandImpl("-gdb-set $" + register + " = " + value){

            @Override
            protected void onDone(MIRecord record) {
                GdbDebuggerImpl.this.requestRegisters();
                this.finish();
            }
        };
        this.gdb.sendCommand(cmd);
    }

    void createWatchFromVariable(GdbVariable var) {
        MiCommandImpl cmd = new MiCommandImpl("-var-info-path-expression " + var.getMIName()){

            @Override
            protected void onDone(MIRecord record) {
                String expr;
                if (!record.isEmpty() && (expr = record.results().getConstValue("path_expr", null)) != null) {
                    GdbDebuggerImpl.this.manager().createWatch(expr);
                }
                this.finish();
            }
        };
        this.gdb.sendCommand(cmd);
    }

    static /* synthetic */ GdbThread[] access$2602(GdbDebuggerImpl x0, GdbThread[] x1) {
        x0.threads = x1;
        return x1;
    }

    static /* synthetic */ Frame[] access$3402(GdbDebuggerImpl x0, Frame[] x1) {
        x0.guiStackFrames = x1;
        return x1;
    }

    static /* synthetic */ GdbThread[] access$3502(GdbDebuggerImpl x0, GdbThread[] x1) {
        x0.threadsWithStacks = x1;
        return x1;
    }

    private class MIRepairBreakLineCommand
    extends MIChangeBreakCommand {
        MIRepairBreakLineCommand(int rt, GdbHandlerCommand ghc) {
            super(rt, ghc);
        }

        @Override
        protected void onDone(MIRecord record) {
            if (record.isEmpty() && !this.isConsoleCommand()) {
                this.onError(record);
            } else {
                GdbDebuggerImpl.this.newHandlers(this.routingToken(), record, null);
                GdbDebuggerImpl.this.manager().bringDownDialog();
            }
            this.finish();
        }
    }

    private class MIReplaceBreakLineCommand
    extends MIChangeBreakCommand {
        MIReplaceBreakLineCommand(int rt, GdbHandlerCommand ghc) {
            super(rt, ghc);
        }

        @Override
        protected void onDone(MIRecord record) {
            if (record.isEmpty() && !this.isConsoleCommand()) {
                this.onError(record);
            } else {
                MITList results = record.results();
                if (!results.isEmpty()) {
                    MIResult result = (MIResult)results.get(0);
                    GdbDebuggerImpl.this.replaceHandler(this.routingToken(), result, null);
                }
                GdbDebuggerImpl.this.manager().bringDownDialog();
            }
            this.finish();
        }
    }

    private class MIChangeBreakCommand
    extends MIBreakCommand {
        private final GdbHandlerCommand ghc;

        MIChangeBreakCommand(int rt, GdbHandlerCommand ghc) {
            super(rt, ghc.getData());
            this.ghc = ghc;
        }

        @Override
        protected void onDone(MIRecord record) {
            this.ghc.onDone();
            GdbDebuggerImpl.this.manager().bringDownDialog();
            super.onDone(record);
        }
    }

    private class MIBreakLineCommand
    extends MIBreakCommand {
        private final int newRT = 0;
        private boolean overloadCancelled;

        MIBreakLineCommand(int rt, String cmdString) {
            super(rt, cmdString);
            this.newRT = 0;
            this.overloadCancelled = false;
        }

        @Override
        protected void onDone(MIRecord record) {
            if (record.isEmpty() && !this.isConsoleCommand()) {
                this.onError(record);
            } else {
                GdbDebuggerImpl.this.newHandlers(this.routingToken(), record, null);
                GdbDebuggerImpl.this.manager().bringDownDialog();
            }
            this.finish();
        }

        @Override
        protected void onError(MIRecord record) {
            if (this.overloadCancelled) {
                this.finish();
            } else {
                super.onError(record);
            }
        }

        @Override
        protected void onUserInteraction(MIUserInteraction ui) {
            if (ui == null || ui.isEmpty()) {
                return;
            }
            this.overloadCancelled = GdbDebuggerImpl.this.userInteraction(this.routingToken(), ui, true);
        }
    }

    private class MIRestoreBreakCommand
    extends MIBreakCommand {
        private boolean overloadCancelled;

        MIRestoreBreakCommand(int rt, String cmdString) {
            super(rt, cmdString);
            this.overloadCancelled = false;
        }

        @Override
        protected void onDone(MIRecord record) {
            if (record.isEmpty() && !this.isConsoleCommand()) {
                this.onError(record);
            } else {
                GdbDebuggerImpl.this.newHandlers(this.routingToken(), record, null);
            }
            this.finish();
        }

        @Override
        protected void onError(MIRecord record) {
            if (this.overloadCancelled) {
                this.finish();
            } else {
                super.onError(record);
            }
        }

        @Override
        protected void onUserInteraction(MIUserInteraction ui) {
            if (ui == null || ui.isEmpty()) {
                return;
            }
            this.overloadCancelled = GdbDebuggerImpl.this.userInteraction(this.routingToken(), ui, true);
        }
    }

    abstract class MIBreakCommand
    extends MiCommandImpl {
        private final boolean wasRunning;

        protected MIBreakCommand(int rt, String cmdString) {
            super(rt, cmdString);
            this.wasRunning = GdbDebuggerImpl.this.state().isRunning;
            if (this.isConsoleCommand()) {
                GdbDebuggerImpl.this.cliBreakpointsRTs.add(rt);
            }
        }

        @Override
        protected void onError(MIRecord record) {
            GdbDebuggerImpl.this.cliBreakpointsRTs.poll();
            super.onError(record);
        }

        @Override
        protected void finish() {
            if (this.wasRunning) {
                GdbDebuggerImpl.this.go();
            }
            super.finish();
        }
    }

    private class MIResumptiveCommand
    extends MiCommandImpl {
        protected MIResumptiveCommand(String cmdString) {
            super(cmdString);
        }

        @Override
        protected void onRunning(MIRecord record) {
            GdbDebuggerImpl.this.genericRunning();
        }

        @Override
        protected void onError(MIRecord record) {
            GdbDebuggerImpl.this.stateSetRunning(false);
            GdbDebuggerImpl.this.stateChanged();
            GdbDebuggerImpl.this.session().setSessionState(GdbDebuggerImpl.this.state());
            GdbDebuggerImpl.this.genericFailure(record);
            this.finish();
        }

        @Override
        protected void onStopped(MIRecord record) {
            GdbDebuggerImpl.this.genericStopped(record);
            this.finish();
        }
    }

    private class DisController
    extends NativeDebuggerImpl.ControllerSupport {
        private DisController() {
            super((NativeDebuggerImpl)GdbDebuggerImpl.this);
        }

        protected void setBreakpointHelp(String address) {
            NativeBreakpoint b = NativeBreakpoint.newInstructionBreakpoint((String)address);
            if (b != null) {
                int routingToken = RoutingToken.BREAKPOINTS.getUniqueRoutingTokenInt();
                Handler.postNewHandler((NativeDebugger)GdbDebuggerImpl.this, (NativeBreakpoint)b, (int)routingToken);
            }
        }

        public void requestDis(boolean withSource) {
            int src;
            if (GdbDebuggerImpl.this.peculiarity.isLldb()) {
                MiCommandImpl cmd = new MiCommandImpl("-data-evaluate-expression $pc"){

                    @Override
                    protected void onDone(MIRecord record) {
                        if (!record.isError()) {
                            String start = record.results().getConstValue("value");
                            long end = Long.parseLong(start) + 100L;
                            GdbDebuggerImpl.this.requestDisFromGdb("-data-disassemble -s " + start + " -e " + end + " -- 0");
                        }
                    }
                };
                GdbDebuggerImpl.this.gdb.sendCommand(cmd);
                return;
            }
            GdbFrame currentFrame = GdbDebuggerImpl.this.getCurrentFrame();
            if (currentFrame == null) {
                return;
            }
            String file = currentFrame.getEngineFullName();
            String line = currentFrame.getLineNo();
            String cmd = "-data-disassemble";
            int n = src = withSource ? 1 : 0;
            if (file != null && line != null && !line.isEmpty()) {
                cmd = cmd + " -f \"" + file + '\"';
                cmd = cmd + " -l " + line;
                cmd = cmd + " -- " + src;
            } else {
                cmd = cmd + " -s $pc -e \"$pc+100\" -- " + src;
            }
            GdbDebuggerImpl.this.requestDisFromGdb(cmd);
        }

        public void requestDis(String start, int count, boolean withSource) {
            if (start == null) {
                return;
            }
            int src = withSource ? 1 : 0;
            String cmd = "-data-disassemble";
            cmd = cmd + " -s \"" + start + '\"';
            cmd = cmd + " -e \"" + start + '+' + count + '\"';
            cmd = cmd + " -- " + src;
            GdbDebuggerImpl.this.requestDisFromGdb(cmd);
        }
    }

    private final class DisModel
    extends NativeDebuggerImpl.DisModelSupport {
        private DisModel() {
            super((NativeDebuggerImpl)GdbDebuggerImpl.this);
        }

        private void parseDisasm(MITList inss, List<DisFragModel.Line> lines) {
            for (int ix = 0; ix < inss.size(); ++ix) {
                String fname;
                MITList ins = ((MIValue)inss.get(ix)).asTuple();
                String address = ins.getConstValue("address");
                MIValue fnameValue = ins.valueOf("func-name");
                String offset = null;
                if (fnameValue != null) {
                    fname = fnameValue.asConst().value();
                    offset = ins.getConstValue("offset");
                } else {
                    fname = Catalog.get("MSG_UnknownFunction");
                }
                String inst = ins.getConstValue("inst");
                if (offset != null) {
                    lines.add(new DisFragModel.Line(address + ":", fname + "+" + offset + ":\t" + inst));
                    continue;
                }
                lines.add(new DisFragModel.Line(address + ":", fname + ":\t" + inst));
            }
        }

        public void parseRecord(MIRecord record) {
            this.clear();
            StopWatch sw = new StopWatch("Parse MI instructions");
            sw.start();
            MITList asm_insnsR = record.results();
            MITList lines = asm_insnsR.valueOf("asm_insns").asList();
            ArrayList<DisFragModel.Line> list = new ArrayList<DisFragModel.Line>();
            if (lines.isValueList()) {
                this.parseDisasm(lines, list);
            } else {
                for (int lx = 0; lx < lines.size(); ++lx) {
                    MIResult src_and_asm_lineR = (MIResult)lines.get(lx);
                    MITList src_and_asm_line = src_and_asm_lineR.value().asTuple();
                    String line = src_and_asm_line.getConstValue("line");
                    String file = src_and_asm_line.getConstValue("file");
                    MITList inss = src_and_asm_line.valueOf("line_asm_insn").asList();
                    list.add(new DisFragModel.Line(line, file));
                    this.parseDisasm(inss, list);
                }
            }
            this.addAll(list);
            sw.stop();
            this.update();
        }
    }

    private class DeleteMIVarCommand
    extends MiCommandImpl {
        private final GdbVariable v;

        public DeleteMIVarCommand(GdbVariable v) {
            super("-var-delete " + v.getMIName());
            this.v = v;
        }

        @Override
        protected void onDone(MIRecord record) {
            GdbDebuggerImpl.this.deleteVar(this.v, record);
            this.finish();
        }
    }

    private static final class GdbVariableNodeChildren
    extends ToolTipView.VariableNodeChildren {
        public GdbVariableNodeChildren(Variable v, boolean requestChildren) {
            super(v);
            if (requestChildren) {
                ((GdbDebuggerImpl)v.getDebugger()).getMIChildren((GdbVariable)v, ((GdbVariable)v).getMIName(), 0);
            }
        }

        protected Node[] createNodes(Variable key) {
            return new Node[]{new ToolTipView.VariableNode(key, (Children)new GdbVariableNodeChildren(key, true))};
        }
    }

    private static final class ModelChangeListenerImpl
    implements ModelListener {
        private ModelChangeListenerImpl() {
        }

        public void modelChanged(ModelEvent event) {
            if (event instanceof ModelEvent.NodeChanged) {
                ModelEvent.NodeChanged nodeChanged = (ModelEvent.NodeChanged)event;
                Variable variable = (Variable)nodeChanged.getNode();
                ToolTipView.VariableNode.propertyChanged((Variable)variable);
            }
        }
    }

    private final class InfoProcMICmd
    extends MiCommandImpl {
        final boolean resume;

        public InfoProcMICmd(boolean resume) {
            super("info proc");
            this.resume = resume;
        }

        @Override
        protected void onDone(MIRecord record) {
            if (Log.Gdb.pid) {
                System.out.printf("FindPidMICmd.onDone(): record: %s\n", record);
                System.out.printf("                      command: %s\n", record.command());
                System.out.printf("                      console: %s\n", record.command().getConsoleStream());
            }
            int pid = GdbDebuggerImpl.extractPid1(record);
            GdbDebuggerImpl.this.session().setSessionEngine(GdbEngineCapabilityProvider.getGdbEngineType());
            if (pid != 0) {
                GdbDebuggerImpl.this.session().setPid((long)pid);
            }
            if (this.resume) {
                GdbDebuggerImpl.this.go();
            }
            this.finish();
        }
    }

    private final class InfoThreadsMICmd
    extends MiCommandImpl {
        final boolean resume;

        public InfoThreadsMICmd(boolean resume) {
            super("info threads");
            this.resume = resume;
        }

        @Override
        protected void onDone(MIRecord record) {
            long pid = GdbDebuggerImpl.extractPidThreads(record);
            GdbDebuggerImpl.this.session().setSessionEngine(GdbEngineCapabilityProvider.getGdbEngineType());
            if (pid != 0L) {
                GdbDebuggerImpl.this.session().setPid(pid);
            }
            if (this.resume) {
                GdbDebuggerImpl.this.go();
            }
            this.finish();
        }
    }

    private final class TermCommandImpl
    extends MiCommandImpl {
        public TermCommandImpl(String cmd) {
            super(cmd);
        }

        @Override
        protected void onDone(MIRecord record) {
            GdbDebuggerImpl.this.gdb.tap().log(this.getConsoleStream().replaceAll("\\\\n", "\r\n"));
        }

        @Override
        protected void onError(MIRecord record) {
            String errMsg = GdbDebuggerImpl.this.getErrMsg(record);
            if (!errMsg.isEmpty()) {
                GdbDebuggerImpl.this.gdb.tap().printError(errMsg);
            } else {
                super.onError(record);
            }
        }
    }

    private class MiCommandImpl
    extends MICommand {
        private MICommand successChain;
        private MICommand failureChain;
        private boolean emptyDoneIsError;
        private boolean reportError;

        protected MiCommandImpl(String cmd) {
            super(0, cmd);
            this.successChain = null;
            this.failureChain = null;
            this.emptyDoneIsError = false;
            this.reportError = true;
        }

        protected MiCommandImpl(int rt, String cmd) {
            super(rt, cmd);
            this.successChain = null;
            this.failureChain = null;
            this.emptyDoneIsError = false;
            this.reportError = true;
        }

        public void chain(MICommand successChain, MICommand failureChain) {
            this.successChain = successChain;
            this.failureChain = failureChain;
        }

        public void setEmptyDoneIsError() {
            this.emptyDoneIsError = true;
        }

        public void dontReportError() {
            this.reportError = false;
        }

        @Override
        protected void onDone(MIRecord record) {
            if (this.emptyDoneIsError && record.isEmpty()) {
                this.onError(record);
            } else {
                this.finish();
                if (this.successChain != null) {
                    GdbDebuggerImpl.this.gdb.sendCommand(this.successChain);
                }
            }
        }

        @Override
        protected void onRunning(MIRecord record) {
            GdbDebuggerImpl.this.unexpected("running", this.command());
        }

        @Override
        protected void onError(MIRecord record) {
            if (this.failureChain == null && this.reportError) {
                GdbDebuggerImpl.this.genericFailure(record);
            }
            this.finish();
            if (this.failureChain != null) {
                GdbDebuggerImpl.this.gdb.sendCommand(this.failureChain);
            }
        }

        @Override
        protected void onExit(MIRecord record) {
            GdbDebuggerImpl.this.unexpected("exit", this.command());
            GdbDebuggerImpl.this.kill();
            this.finish();
        }

        @Override
        protected void onStopped(MIRecord record) {
            GdbDebuggerImpl.this.unexpected("stopped", this.command());
        }

        @Override
        protected void onOther(MIRecord record) {
            GdbDebuggerImpl.this.unexpected("other", this.command());
        }

        @Override
        protected void onUserInteraction(MIUserInteraction ui) {
            GdbDebuggerImpl.this.unexpected("userinteraction", this.command());
        }
    }

    private static class MILocation
    extends Location {
        public static MILocation make(NativeDebugger debugger, MITList frameTuple, MITList srcTuple, boolean visited, int stackSize, NativeBreakpoint breakpoint) {
            String src = "";
            int line = 0;
            String func = null;
            long pc = 0L;
            int level = 0;
            try {
                if (frameTuple != null) {
                    pc = Address.parseAddr((String)frameTuple.getConstValue("addr", "0"));
                    func = frameTuple.getConstValue("func");
                    src = frameTuple.getConstValue("fullname", srcTuple != null ? srcTuple.getConstValue("fullname", null) : null);
                    level = Integer.parseInt(frameTuple.getConstValue("level", "0"));
                    line = Integer.parseInt(frameTuple.getConstValue("line", "0"));
                } else if (srcTuple != null) {
                    src = srcTuple.getConstValue("fullname", null);
                    line = Integer.parseInt(srcTuple.getConstValue("line", "0"));
                }
            }
            catch (NumberFormatException ex) {
                LOG.log(Level.WARNING, "NumberFormatException occurred while parsing  " + (frameTuple != null ? "frameTuple " + frameTuple : (srcTuple != null ? "srcTuple " + srcTuple : "")), ex);
            }
            src = debugger.remoteToLocal("MILocation", src);
            return new MILocation(src, line, func, pc, 1 | (visited ? 2 : 0) | (level == 0 ? 8 : 0) | (level >= stackSize - 1 ? 16 : 0), breakpoint);
        }

        public static MILocation make(MILocation h, boolean visited) {
            return new MILocation(h.src(), h.line(), h.func(), h.pc(), 1 | (visited ? 2 : 0) | (h.topframe() ? 8 : 0) | (h.bottomframe() ? 16 : 0), h.getBreakpoint());
        }

        private MILocation(String src, int line, String func, long pc, int flags, NativeBreakpoint breakpoint) {
            super(src, line, func, pc, flags, breakpoint);
        }
    }
}

