/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.url;

import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import org.netbeans.modules.url.URLDataObject;
import org.openide.awt.Mnemonics;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUIUtils;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.WeakListeners;
import org.openide.util.actions.Presenter;

final class URLPresenter
implements Presenter.Menu,
Presenter.Toolbar,
Presenter.Popup,
ActionListener {
    private final URLDataObject dataObject;

    URLPresenter(URLDataObject dataObject) {
        this.dataObject = dataObject;
    }

    public JMenuItem getMenuPresenter() {
        JMenuItem menuItem = new JMenuItem();
        this.initialize(menuItem, false);
        return menuItem;
    }

    public JMenuItem getPopupPresenter() {
        JMenuItem menuItem = new JMenuItem();
        this.initialize(menuItem, false);
        return menuItem;
    }

    public Component getToolbarPresenter() {
        JButton toolbarButton = new JButton();
        this.initialize(toolbarButton, true);
        return toolbarButton;
    }

    private void initialize(AbstractButton presenter, boolean useIcons) {
        if (useIcons) {
            Image icon = ImageUtilities.loadImage((String)"org/netbeans/modules/url/urlObject.png");
            try {
                FileObject file = this.dataObject.getPrimaryFile();
                icon = FileUIUtils.getImageDecorator((FileSystem)file.getFileSystem()).annotateIcon(icon, 1, this.dataObject.files());
            }
            catch (FileStateInvalidException fsie) {
                // empty catch block
            }
            presenter.setIcon(new ImageIcon(icon));
        }
        NameChangeListener listener = new NameChangeListener(presenter);
        presenter.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)listener, (Object)((Object)this.dataObject)));
        this.updateName(presenter);
        presenter.addActionListener(this);
        HelpCtx.setHelpIDString((JComponent)presenter, (String)this.dataObject.getHelpCtx().getHelpID());
    }

    private void updateName(AbstractButton presenter) {
        String name = this.dataObject.getName();
        try {
            FileObject file = this.dataObject.getPrimaryFile();
            name = file.getFileSystem().getDecorator().annotateName(name, this.dataObject.files());
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            // empty catch block
        }
        Mnemonics.setLocalizedText((AbstractButton)presenter, (String)name);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Node.Cookie open = this.dataObject.getCookie(OpenCookie.class);
        if (open != null) {
            ((OpenCookie)open).open();
        }
    }

    private class NameChangeListener
    implements PropertyChangeListener {
        private final AbstractButton presenter;

        NameChangeListener(AbstractButton presenter) {
            this.presenter = presenter;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("name".equals(evt.getPropertyName())) {
                URLPresenter.this.updateName(this.presenter);
            }
        }
    }
}

