/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.services;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.model.CsmListeners;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmProgressAdapter;
import org.netbeans.modules.cnd.api.model.CsmProgressListener;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.discovery.api.DiscoveryExtensionInterface;
import org.netbeans.modules.cnd.discovery.projectimport.ImportProject;
import org.netbeans.modules.cnd.discovery.wizard.DiscoveryWizardAction;
import org.netbeans.modules.cnd.discovery.wizard.DiscoveryWizardDescriptor;
import org.netbeans.modules.cnd.discovery.wizard.api.support.DiscoveryProjectGenerator;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.wizards.IteratorExtension;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public final class DiscoveryManagerImpl {
    public static final String BUILD_LOG_KEY = "build-log";
    public static final String BUILD_EXEC_KEY = "exec-log";
    private static final RequestProcessor RP = new RequestProcessor("Discovery Manager Worker", 1);
    private static final Map<CsmProject, CsmProgressListener> listeners = new WeakHashMap<CsmProject, CsmProgressListener>();
    private static final Map<NativeProject, CsmProgressListener> listeners2 = new WeakHashMap<NativeProject, CsmProgressListener>();

    private DiscoveryManagerImpl() {
    }

    public static void projectBuilt(Project project, Map<String, Object> artifacts, boolean isIncremental) {
        RP.post((Runnable)new DiscoveryWorker(project, artifacts, isIncremental));
    }

    public static void discoverHeadersByModel(final Project project) {
        RP.post(new Runnable(){

            @Override
            public void run() {
                final NativeProject np = (NativeProject)project.getLookup().lookup(NativeProject.class);
                ImportProject.logger.log(Level.INFO, "Post fixing of excluded header files for project {0}", np);
                CsmProgressAdapter listener = new CsmProgressAdapter(){

                    public void projectParsingFinished(CsmProject aCsmProject) {
                        ImportProject.logger.log(Level.INFO, "Model parsing finished and ready to fixing of excluded header files for project {0}", aCsmProject);
                        CsmProject csmProject = CsmModelAccessor.getModel().getProject((Object)np);
                        if (csmProject != null && csmProject.equals(aCsmProject)) {
                            CsmListeners.getDefault().removeProgressListener((CsmProgressListener)this);
                            listeners2.remove(np);
                            DiscoveryProjectGenerator.fixExcludedHeaderFiles(project, ImportProject.logger);
                        }
                    }
                };
                listeners2.put(np, listener);
                CsmListeners.getDefault().addProgressListener((CsmProgressListener)listener);
            }
        });
    }

    private static final class DiscoveryWorker
    implements Runnable {
        private final Project project;
        private final Map<String, Object> artifacts;
        private final boolean isIncremental;

        DiscoveryWorker(Project project, Map<String, Object> artifacts, boolean isIncremental) {
            this.project = project;
            this.artifacts = artifacts;
            this.isIncremental = isIncremental;
        }

        @Override
        public void run() {
            DiscoveryExtensionInterface extension = (DiscoveryExtensionInterface)Lookup.getDefault().lookup(IteratorExtension.class);
            if (extension == null) {
                return;
            }
            String artifact = (String)this.artifacts.get(DiscoveryManagerImpl.BUILD_EXEC_KEY);
            if (artifact != null) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                DiscoveryWizardDescriptor.ROOT_FOLDER.toMap(map, (Object)this.findRoot());
                DiscoveryWizardDescriptor.EXEC_LOG_FILE.toMap(map, (Object)artifact);
                DiscoveryWizardDescriptor.RESOLVE_SYMBOLIC_LINKS.toMap(map, (Object)this.resolveSymbolicLinks());
                DiscoveryWizardDescriptor.INCREMENTAL.toMap(map, (Object)this.isIncremental);
                if (extension.canApply(map, this.project, null)) {
                    try {
                        this.postModelTask();
                        extension.apply(map, this.project, null);
                    }
                    catch (IOException ex) {
                        ex.printStackTrace(System.err);
                    }
                    this.saveArtifact(artifact, "-exec");
                    artifact = (String)this.artifacts.get(DiscoveryManagerImpl.BUILD_LOG_KEY);
                    if (artifact != null) {
                        this.saveArtifact(artifact, "-build");
                    }
                }
                return;
            }
            artifact = (String)this.artifacts.get(DiscoveryManagerImpl.BUILD_LOG_KEY);
            if (artifact != null) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                DiscoveryWizardDescriptor.ROOT_FOLDER.toMap(map, (Object)this.findRoot());
                DiscoveryWizardDescriptor.LOG_FILE.toMap(map, (Object)artifact);
                DiscoveryWizardDescriptor.RESOLVE_SYMBOLIC_LINKS.toMap(map, (Object)this.resolveSymbolicLinks());
                DiscoveryWizardDescriptor.INCREMENTAL.toMap(map, (Object)this.isIncremental);
                if (extension.canApply(map, this.project, null)) {
                    try {
                        this.postModelTask();
                        extension.apply(map, this.project, null);
                    }
                    catch (IOException ex) {
                        ex.printStackTrace(System.err);
                    }
                    this.saveArtifact(artifact, "-build");
                    artifact = (String)this.artifacts.get(DiscoveryManagerImpl.BUILD_EXEC_KEY);
                    if (artifact != null) {
                        this.saveArtifact(artifact, "-exec");
                    }
                }
            }
        }

        private void saveArtifact(String artifact, String suffix) {
            MakeConfiguration activeConfiguration;
            FileObject log;
            if (!this.isIncremental && (log = FileUtil.toFileObject((File)new File(artifact))) != null && log.isValid() && (activeConfiguration = this.getActiveConfiguration()) != null) {
                try {
                    FileObject dest = this.project.getProjectDirectory().getFileObject("nbproject/private/" + activeConfiguration.getName() + suffix + "." + log.getExt());
                    if (dest != null) {
                        dest.delete();
                    }
                    FileUtil.copyFile((FileObject)log, (FileObject)this.project.getProjectDirectory().getFileObject("nbproject/private"), (String)(activeConfiguration.getName() + suffix));
                }
                catch (IOException ex) {
                    ex.printStackTrace(System.err);
                }
            }
        }

        private MakeConfiguration getActiveConfiguration() {
            ConfigurationDescriptorProvider cdp = (ConfigurationDescriptorProvider)this.project.getLookup().lookup(ConfigurationDescriptorProvider.class);
            MakeConfigurationDescriptor cd = cdp.getConfigurationDescriptor();
            if (cd != null) {
                return cd.getActiveConfiguration();
            }
            return null;
        }

        private boolean resolveSymbolicLinks() {
            MakeConfiguration activeConfiguration = this.getActiveConfiguration();
            if (activeConfiguration != null) {
                return activeConfiguration.getCodeAssistanceConfiguration().getResolveSymbolicLinks().getValue();
            }
            return false;
        }

        private String findRoot() {
            return DiscoveryWizardAction.findSourceRoot(this.project);
        }

        private void postModelTask() {
            NativeProject np = (NativeProject)this.project.getLookup().lookup(NativeProject.class);
            final CsmProject csmProject = CsmModelAccessor.getModel().getProject((Object)np);
            if (csmProject == null) {
                ImportProject.logger.log(Level.INFO, "Can not post fix excluded header files; no associated CsmProject for {0}", np);
                return;
            }
            ImportProject.logger.log(Level.INFO, "Post fixing of excluded header files for project {0}", csmProject);
            CsmProgressAdapter listener = new CsmProgressAdapter(){

                public void projectParsingFinished(CsmProject aCsmProject) {
                    ImportProject.logger.log(Level.INFO, "Model parsing finished and ready to fixing of excluded header files for model project {0}", aCsmProject);
                    if (csmProject.equals(aCsmProject)) {
                        CsmListeners.getDefault().removeProgressListener((CsmProgressListener)this);
                        listeners.remove(aCsmProject);
                        DiscoveryProjectGenerator.fixExcludedHeaderFiles(DiscoveryWorker.this.project, ImportProject.logger);
                    }
                }
            };
            listeners.put(csmProject, listener);
            CsmListeners.getDefault().addProgressListener((CsmProgressListener)listener);
        }
    }
}

