/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.infra.build.ant;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.netbeans.installer.infra.build.ant.utils.FileEntry;
import org.netbeans.installer.infra.build.ant.utils.Utils;

public class Package
extends Task {
    private File file;
    private File directory;
    private List<FileEntry> entries = new LinkedList<FileEntry>();
    private long directoriesCount;
    private long filesCount;
    private static final String METAINF_ENTRY = "META-INF/";
    private static final String FILES_LIST_ENTRY = "META-INF/files.list";
    private static final String MANIFEST_ENTRY = "META-INF/manifest.mf";

    public void setFile(String path) {
        this.file = new File(path);
        if (!this.file.equals(this.file.getAbsoluteFile())) {
            this.file = new File(this.getProject().getBaseDir(), path);
        }
    }

    public void setDirectory(String path) {
        this.directory = new File(path);
        if (!this.directory.equals(this.directory.getAbsoluteFile())) {
            this.directory = new File(this.getProject().getBaseDir(), path);
        }
    }

    public void execute() throws BuildException {
        Utils.setProject(this.getProject());
        JarOutputStream output = null;
        try {
            output = new JarOutputStream(new FileOutputStream(this.file));
            output.setLevel(9);
            this.log("browsing, packing, archiving directory " + this.directory.getCanonicalPath());
            this.browse(this.directory.getCanonicalFile(), output, this.directory.getCanonicalPath().length());
            this.log("adding manifest and files list");
            output.putNextEntry(new JarEntry(METAINF_ENTRY));
            output.putNextEntry(new JarEntry(MANIFEST_ENTRY));
            output.write("Manifest-Version: 1.0\n\n".getBytes("UTF-8"));
            output.putNextEntry(new JarEntry(FILES_LIST_ENTRY));
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)output, "UTF-8");
            writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            writer.write("<files-list>\n");
            for (FileEntry entry : this.entries) {
                writer.write("    <entry ");
                if (entry.isDirectory()) {
                    writer.write("type=\"directory\" ");
                    writer.write("empty=\"" + entry.isEmpty() + "\" ");
                    writer.write("modified=\"" + entry.getLastModified() + "\" ");
                    writer.write("permissions=\"" + entry.getPermissions() + "\"");
                } else {
                    writer.write("type=\"file\" ");
                    writer.write("size=\"" + entry.getSize() + "\" ");
                    writer.write("md5=\"" + entry.getMd5() + "\" ");
                    writer.write("jar=\"" + entry.isJarFile() + "\" ");
                    writer.write("packed=\"" + entry.isPackedJarFile() + "\" ");
                    writer.write("signed=\"" + entry.isSignedJarFile() + "\" ");
                    writer.write("modified=\"" + entry.getLastModified() + "\" ");
                    writer.write("permissions=\"" + entry.getPermissions() + "\"");
                }
                writer.write(">" + entry.getName().replace("&", "&amp;").replace("'", "&apos;").replace("\"", "&quot;").replace("<", "&lt;").replace(">", "&gt;") + "</entry>\n");
            }
            writer.write("</files-list>\n");
            writer.flush();
            writer.close();
            output.flush();
            output.close();
            this.log("archived " + this.directoriesCount + " directories and " + this.filesCount + " files");
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    private String getShortPath(File file, int offset) throws IOException {
        return file.getAbsolutePath().substring(offset + 1);
    }

    private void browse(File parent, JarOutputStream output, int offset) throws IOException {
        FileInputStream fis = null;
        LinkedList<File> toSkip = new LinkedList<File>();
        for (File child : parent.listFiles()) {
            FileEntry entry;
            if (toSkip.contains(child)) {
                this.log("    skipping " + this.getShortPath(child, offset));
                continue;
            }
            this.log("    visiting " + this.getShortPath(child, offset));
            String path = child.getAbsolutePath();
            String name = path.substring(offset + 1).replace('\\', '/');
            if (child.isDirectory()) {
                this.log("        archiving directory: " + name);
                name = name + "/";
                entry = new FileEntry(child, name);
                output.putNextEntry(new JarEntry(name));
                ++this.directoriesCount;
                this.browse(child, output, offset);
            } else {
                boolean packedProp = false;
                String pack200Enabled = this.getProject().getProperty("pack200.enabled");
                boolean usePacking = !"false".equals(pack200Enabled);
                boolean mirrorFileExist = false;
                File mirrorFile = null;
                if (child.getName().endsWith(".jar.pack.gz")) {
                    mirrorFile = new File(child.getParentFile(), child.getName().substring(0, child.getName().length() - ".pack.gz".length()));
                } else if (child.getName().endsWith(".jar")) {
                    mirrorFile = new File(child + ".pack.gz");
                }
                if (mirrorFile != null && mirrorFile.exists()) {
                    this.log("        mirror packing files exists, skipping repacking : " + mirrorFile);
                    mirrorFileExist = true;
                    usePacking = false;
                }
                if (!mirrorFileExist && child.getName().endsWith(".jar.pack.gz")) {
                    if (usePacking) {
                        this.log("        it is a packed jar - unpacking");
                        File unpacked = new File(child.getPath().substring(0, child.getPath().length() - 8));
                        File temp = null;
                        if (unpacked.exists()) {
                            temp = File.createTempFile("xxx", null, child.getParentFile());
                            temp.delete();
                            unpacked.renameTo(temp);
                        }
                        if (Utils.unpack(child, unpacked)) {
                            child.delete();
                            if (temp != null) {
                                temp.delete();
                            }
                            child = unpacked.getAbsoluteFile();
                            this.log("        successfully unpacked - processing file: " + this.getShortPath(child, offset));
                        } else {
                            unpacked.delete();
                            if (temp != null) {
                                temp.renameTo(unpacked);
                            }
                        }
                    } else {
                        packedProp = true;
                    }
                }
                entry = new FileEntry(child, name);
                if (packedProp) {
                    entry.setJarFile(true);
                    entry.setPackedJarFile(true);
                }
                if (usePacking && entry.isJarFile() && !entry.isSignedJarFile()) {
                    File backup = new File(child.getPath() + ".bak");
                    File packed = new File(child.getPath() + ".pack.gz");
                    if (packed.exists()) {
                        this.log("        packed jar already exists - deleting it");
                        packed.delete();
                        toSkip.add(packed);
                    }
                    Utils.copy(child, backup);
                    if (Utils.pack(child, packed) && Utils.unpack(packed, child) && Utils.verifyJad(child) && Utils.verify(child)) {
                        name = packed.getPath().substring(offset + 1).replace('\\', '/');
                        entry = new FileEntry(child, name);
                        entry.setJarFile(true);
                        entry.setPackedJarFile(true);
                        entry.setSignedJarFile(false);
                        child.delete();
                        backup.delete();
                        child = packed;
                    } else {
                        Utils.copy(backup, child);
                        packed.delete();
                        backup.delete();
                    }
                }
                this.log("        archiving file: " + name);
                JarEntry jarEntry = new JarEntry(name);
                jarEntry.setTime(entry.getLastModified());
                jarEntry.setSize(entry.getSize());
                output.putNextEntry(jarEntry);
                fis = new FileInputStream(child);
                Utils.copy(fis, (OutputStream)output);
                fis.close();
                ++this.filesCount;
            }
            this.entries.add(entry);
        }
    }
}

