/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.actions.base;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import org.netbeans.modules.cnd.api.remote.ServerListUI;
import org.openide.awt.Actions;
import org.openide.awt.DynamicMenuContent;
import org.openide.util.actions.Presenter;
import org.openide.util.lookup.Lookups;

public abstract class RemoteOpenActionBase
extends AbstractAction
implements DynamicMenuContent,
Presenter.Toolbar {
    static final String ENV_KEY = "org.netbeans.modules.cnd.remote.actions.ENV";
    public static final String ACTIVATED_PSEUDO_ACTION_COMAND = "performerActivated";
    private JButton lastToolbarPresenter;
    private boolean isEnabledToolbarAction = true;
    private ActionListener peformer;

    public RemoteOpenActionBase(String name) {
        super(name);
    }

    public JComponent[] getMenuPresenters() {
        this.initPerformer();
        return ((DynamicMenuContent)this.peformer).getMenuPresenters();
    }

    public JComponent[] synchMenuPresenters(JComponent[] jcs) {
        this.initPerformer();
        return ((DynamicMenuContent)this.peformer).synchMenuPresenters(jcs);
    }

    public JButton getToolbarPresenter() {
        this.lastToolbarPresenter = new JButton(){

            @Override
            public void setEnabled(boolean b) {
                super.setEnabled(RemoteOpenActionBase.this.isEnabledToolbarAction);
            }

            @Override
            public boolean isEnabled() {
                return RemoteOpenActionBase.this.isEnabledToolbarAction;
            }
        };
        this.lastToolbarPresenter.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 4L) != 0L && e.getChanged().isShowing()) {
                    RemoteOpenActionBase.this.initPerformer();
                }
            }
        });
        Actions.connect((AbstractButton)this.lastToolbarPresenter, (Action)this);
        return this.lastToolbarPresenter;
    }

    private void initPerformer() {
        assert (SwingUtilities.isEventDispatchThread());
        if (this.peformer == null) {
            this.peformer = (ActionListener)Lookups.forPath((String)this.getPerformerID()).lookup(ActionListener.class);
            this.peformer.actionPerformed(new ActionEvent(this, 0, ACTIVATED_PSEUDO_ACTION_COMAND));
        }
    }

    @Override
    public final void setEnabled(boolean enabled) {
        this.isEnabledToolbarAction = enabled;
        if (this.lastToolbarPresenter != null) {
            this.lastToolbarPresenter.setEnabled(enabled);
        }
    }

    @Override
    public final void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JMenuItem) {
            JMenuItem item = (JMenuItem)e.getSource();
            Object env = item.getClientProperty(ENV_KEY);
            if (env == null) {
                ServerListUI.showServerListDialog();
            } else {
                this.peformer.actionPerformed(e);
            }
        } else {
            this.peformer.actionPerformed(e);
        }
    }

    protected abstract Icon getIcon();

    protected abstract String getPerformerID();

    protected abstract String getSubmenuTitle();

    protected abstract String getItemTitle(String var1);
}

