/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.sync;

import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.text.ParseException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.modules.cnd.api.remote.HostInfoProvider;
import org.netbeans.modules.cnd.api.remote.SetupProvider;
import org.netbeans.modules.cnd.remote.server.RemoteServerList;
import org.netbeans.modules.cnd.remote.server.RemoteServerRecord;
import org.netbeans.modules.cnd.remote.support.RemoteUtil;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.MacroExpanderFactory;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class RfsSetupProvider
implements SetupProvider {
    public static final String POSTFIX_64 = "_64";
    private final Map<String, File> binarySetupMap;
    private static final String CONTROLLER = "rfs_controller";
    private static final String PRELOAD = "rfs_preload.so";

    public RfsSetupProvider() {
        String[] dirs = new String[]{"SunOS-x86", "SunOS-x86_64", "Linux-x86", "Linux-x86_64", "Linux-sparc_64", "SunOS-sparc", "SunOS-sparc_64"};
        this.binarySetupMap = new HashMap<String, File>();
        for (String dir : dirs) {
            this.binarySetupMap.put(dir + "/" + PRELOAD, InstalledFileLocator.getDefault().locate("bin/" + dir + "/" + PRELOAD, "org.netbeans.modules.cnd.remote", false));
            this.binarySetupMap.put(dir + "/" + CONTROLLER, InstalledFileLocator.getDefault().locate("bin/" + dir + "/" + CONTROLLER, "org.netbeans.modules.cnd.remote", false));
        }
    }

    public Map<String, File> getBinaryFiles(ExecutionEnvironment env) {
        LinkedHashMap<String, File> result = new LinkedHashMap<String, File>();
        Boolean applicable = RfsSetupProvider.isApplicable(env);
        if (applicable == null) {
            RemoteUtil.LOGGER.log(Level.WARNING, "Can not determine whether RFS is applicable for {0}", env.getDisplayName());
            return result;
        }
        if (!applicable.booleanValue()) {
            RemoteUtil.LOGGER.log(Level.WARNING, "RFS not applicable for {0}", env.getDisplayName());
            return result;
        }
        try {
            HostInfo hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)env);
            String osName = RfsSetupProvider.getOsName(env);
            String dir32 = osName + '/';
            String dir64 = RfsSetupProvider.getOsName(env) + POSTFIX_64 + '/';
            for (Map.Entry<String, File> entry : this.binarySetupMap.entrySet()) {
                boolean add = false;
                if (entry.getKey().startsWith(dir32)) {
                    add = true;
                } else if (entry.getKey().startsWith(dir64)) {
                    boolean bl = add = hostInfo.getOS().getBitness() == HostInfo.Bitness._64;
                }
                if (!add) continue;
                result.put(entry.getKey(), entry.getValue());
            }
        }
        catch (InterruptedIOException ex) {
        }
        catch (ConnectionManager.CancellationException ex) {
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (ParseException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return result;
    }

    public void failed(Collection<File> files, StringBuilder describeProblem) {
        describeProblem.append(NbBundle.getMessage(RfsSetupProvider.class, (String)"ErrorUploadingBinaries"));
    }

    public static String getPreloadName(ExecutionEnvironment execEnv) {
        return PRELOAD;
    }

    public static String getControllerPath(ExecutionEnvironment execEnv) throws ParseException, ConnectionManager.CancellationException, IOException {
        String result = RfsSetupProvider.getLibDir(execEnv);
        HostInfo hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)execEnv);
        if (hostInfo.getOS().getBitness() == HostInfo.Bitness._64) {
            result = result + POSTFIX_64;
        }
        result = result + "/rfs_controller";
        return result;
    }

    @SuppressWarnings(value={"NP"})
    public static Boolean isApplicable(ExecutionEnvironment env) {
        RemoteServerRecord record;
        if (env == null) {
            throw new NullPointerException();
        }
        HostInfo.OSFamily osFamily = null;
        HostInfo.CpuFamily cpuFamily = null;
        String osVersion = null;
        if (HostInfoUtils.isHostInfoAvailable((ExecutionEnvironment)env)) {
            try {
                HostInfo hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)env);
                osFamily = hostInfo.getOSFamily();
                cpuFamily = hostInfo.getCpuFamily();
                osVersion = hostInfo.getOS().getVersion();
            }
            catch (IOException ex) {
                RemoteUtil.LOGGER.log(Level.WARNING, "Exception when getting host info:", ex);
            }
            catch (ConnectionManager.CancellationException ex) {
                // empty catch block
            }
        }
        if ((osFamily == null || cpuFamily == null || osVersion == null) && (record = RemoteServerList.getInstance().get(env, false)) != null) {
            osFamily = record.getOsFamily();
            cpuFamily = record.getCpuFamily();
            osVersion = record.getOsVersion();
        }
        if (osFamily == null || cpuFamily == null) {
            RemoteUtil.LOGGER.log(Level.WARNING, "RFS: can not determine host OS and CPU for {0}", env.getDisplayName());
            return null;
        }
        switch (osFamily) {
            case LINUX: {
                return cpuFamily == HostInfo.CpuFamily.X86 || cpuFamily == HostInfo.CpuFamily.SPARC ? Boolean.TRUE : Boolean.FALSE;
            }
            case SUNOS: {
                if (osVersion == null || RfsSetupProvider.getSolarisOSVersionNumber(osVersion) <= 8) {
                    return Boolean.FALSE;
                }
                return cpuFamily == HostInfo.CpuFamily.X86 || cpuFamily == HostInfo.CpuFamily.SPARC ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        return Boolean.FALSE;
    }

    private static int getSolarisOSVersionNumber(String versionString) {
        String prefixToStrip = "Oracle ";
        if (versionString.startsWith(prefixToStrip)) {
            versionString = versionString.substring(prefixToStrip.length());
        }
        Pattern p = Pattern.compile("[a-zA-Z]+[ ]([\\d]+).*");
        Matcher m = p.matcher(versionString);
        String result = "-1";
        if (m.matches()) {
            result = m.group(1);
        }
        int version = -1;
        try {
            version = Integer.parseInt(result);
        }
        catch (NumberFormatException e) {
            return -1;
        }
        return version;
    }

    public static String getLdLibraryPath(ExecutionEnvironment execEnv) throws ParseException {
        String libDir = RfsSetupProvider.getLibDir(execEnv);
        return libDir + ':' + libDir + POSTFIX_64;
    }

    private static String getLibDir(ExecutionEnvironment execEnv) throws ParseException {
        String libDir = HostInfoProvider.getLibDir((ExecutionEnvironment)execEnv);
        String osname = RfsSetupProvider.getOsName(execEnv);
        return libDir + '/' + osname;
    }

    private static String getOsName(ExecutionEnvironment execEnv) throws ParseException {
        MacroExpanderFactory.MacroExpander mef = MacroExpanderFactory.getExpander((ExecutionEnvironment)execEnv);
        String osname = mef.expandPredefinedMacros("${osname}-${platform}");
        return osname;
    }
}

