/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.ui.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.cnd.remote.ui.networkneighbour.HostSelectionPanel;
import org.netbeans.modules.cnd.remote.ui.networkneighbour.NetworkNeighbourhoodList;
import org.netbeans.modules.cnd.remote.ui.proxysettings.ProxySettingsPanel;
import org.netbeans.modules.cnd.remote.ui.wizard.CreateHostData;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

final class CreateHostVisualPanel1
extends JPanel {
    private final NetworkNeighbourhoodList networkNeighbourhoodList;
    private final ChangeListener listener;
    private final CreateHostData data;
    private JCheckBox cbProxySettings;
    private HostSelectionPanel hostSelectionPanel;
    private JLabel lblNeighbouthood;
    private JLabel lblUser;
    private ProxySettingsPanel proxySettingsPanel;
    private JPanel serversListPanel;
    private JTextField textUser;
    static final boolean isGtk = "GTK".equals(UIManager.getLookAndFeel().getID());

    public CreateHostVisualPanel1(CreateHostData data, ChangeListener listener) {
        this.data = data;
        this.listener = listener;
        this.initComponents();
        this.lblUser.setVisible(data.isManagingUser());
        this.textUser.setVisible(data.isManagingUser());
        this.proxySettingsPanel.setVisible(false);
        this.cbProxySettings.setSelected(false);
        this.cbProxySettings.setIcon(CreateHostVisualPanel1.getCollapsedIcon());
        this.networkNeighbourhoodList = new NetworkNeighbourhoodList();
        this.serversListPanel.add((Component)this.networkNeighbourhoodList, "Center");
        this.hostSelectionPanel.attach(this.networkNeighbourhoodList);
        this.hostSelectionPanel.addChangeListener(listener);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CreateHostVisualPanel1.this.hostSelectionPanel.requestFocus();
                    }
                });
            }
        });
    }

    private void fireChange() {
        if (this.listener != null) {
            this.listener.stateChanged(null);
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.fireChange();
    }

    void init() {
        this.textUser.setText(this.data.getUserName());
        this.hostSelectionPanel.set(this.data.getHostName(), this.data.getPort());
    }

    @Override
    public String getName() {
        return NbBundle.getMessage(this.getClass(), (String)"CreateHostVisualPanel1.Title");
    }

    public String getHostname() {
        return this.hostSelectionPanel.getHostname();
    }

    public String getUser() {
        return this.textUser.getText().trim();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.textUser.setEnabled(enabled);
        this.hostSelectionPanel.setEnabled(enabled);
        this.proxySettingsPanel.setEnabled(enabled);
        this.cbProxySettings.setEnabled(enabled);
        this.lblUser.setEnabled(enabled);
        this.lblNeighbouthood.setEnabled(enabled);
        this.serversListPanel.setEnabled(enabled);
    }

    public int getPort() {
        return this.hostSelectionPanel.getPort();
    }

    private void initComponents() {
        this.lblUser = new JLabel();
        this.textUser = new JTextField();
        this.hostSelectionPanel = new HostSelectionPanel();
        this.lblNeighbouthood = new JLabel();
        this.serversListPanel = new JPanel();
        this.cbProxySettings = new JCheckBox();
        this.proxySettingsPanel = new ProxySettingsPanel();
        this.setPreferredSize(new Dimension(534, 409));
        this.setRequestFocusEnabled(false);
        this.lblUser.setLabelFor(this.textUser);
        Mnemonics.setLocalizedText((JLabel)this.lblUser, (String)NbBundle.getMessage(CreateHostVisualPanel1.class, (String)"CreateHostVisualPanel1.lblUser.text"));
        this.textUser.setText(NbBundle.getMessage(CreateHostVisualPanel1.class, (String)"CreateHostVisualPanel1.textUser.text"));
        this.lblNeighbouthood.setLabelFor(this.serversListPanel);
        Mnemonics.setLocalizedText((JLabel)this.lblNeighbouthood, (String)NbBundle.getMessage(CreateHostVisualPanel1.class, (String)"CreateHostVisualPanel1.lblNeighbouthood.text"));
        this.serversListPanel.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.cbProxySettings, (String)NbBundle.getMessage(CreateHostVisualPanel1.class, (String)"CreateHostVisualPanel1.cbProxySettings.text"));
        this.cbProxySettings.setFocusPainted(false);
        this.cbProxySettings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreateHostVisualPanel1.this.cbProxySettingsActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.lblNeighbouthood).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.hostSelectionPanel, -1, -1, Short.MAX_VALUE).addComponent(this.serversListPanel, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.lblUser, -2, 61, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.textUser, -1, 330, Short.MAX_VALUE).addGap(119, 119, 119)).addComponent(this.proxySettingsPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.cbProxySettings, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblUser).addComponent(this.textUser, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.hostSelectionPanel, -2, -1, -2).addGap(6, 6, 6).addComponent(this.lblNeighbouthood).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.serversListPanel, -1, 271, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbProxySettings).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.proxySettingsPanel, -1, 36, Short.MAX_VALUE)));
    }

    private void cbProxySettingsActionPerformed(ActionEvent evt) {
        this.proxySettingsPanel.setVisible(this.cbProxySettings.isSelected());
        this.cbProxySettings.setIcon(this.cbProxySettings.isSelected() ? CreateHostVisualPanel1.getExpandedIcon() : CreateHostVisualPanel1.getCollapsedIcon());
    }

    static Icon getExpandedIcon() {
        return UIManager.getIcon(isGtk ? "Tree.gtk_expandedIcon" : "Tree.expandedIcon");
    }

    static Icon getCollapsedIcon() {
        return UIManager.getIcon(isGtk ? "Tree.gtk_collapsedIcon" : "Tree.collapsedIcon");
    }

    boolean isProxyValid() {
        return this.proxySettingsPanel.isValidState();
    }

    void applyProxyChangesIfNeed() {
        this.proxySettingsPanel.applyProxyChangesIfNeed();
    }
}

