/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.ui;

import java.awt.Component;
import java.awt.HeadlessException;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileView;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.cnd.api.remote.RemoteFileUtil;
import org.netbeans.modules.cnd.remote.support.RemoteUtil;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.remote.api.ui.FileChooserBuilder;
import org.netbeans.modules.remote.ui.HostListRootNode;
import org.netbeans.modules.remote.ui.SingleHostAction;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;

public class OpenRemoteProjectAction
extends SingleHostAction {
    private static final RequestProcessor RP = new RequestProcessor("Opening remote project", 1);
    private static boolean isRunning = false;
    private static final Object lock = new Object();

    public String getName() {
        return NbBundle.getMessage(HostListRootNode.class, (String)"OpenRemoteProjectActionMenuItem");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void performAction(final ExecutionEnvironment env, Node node) {
        this.setEnabled(false);
        final Runnable edtWorker = new Runnable(){

            @Override
            public void run() {
                OpenRemoteProjectAction.this.openRemoteProject(env);
            }
        };
        Runnable connectWrapper = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    ConnectionManager.getInstance().connectTo(env);
                    SwingUtilities.invokeLater(edtWorker);
                }
                catch (IOException ex) {
                    OpenRemoteProjectAction.this.showErrorConnectionDialog(env, ex);
                }
                catch (ConnectionManager.CancellationException cancellationException) {
                }
                finally {
                    Object ex = lock;
                    synchronized (ex) {
                        isRunning = false;
                    }
                    OpenRemoteProjectAction.this.setEnabled(true);
                }
            }
        };
        Object object = lock;
        synchronized (object) {
            if (!isRunning) {
                isRunning = true;
                RP.post(connectWrapper);
            }
        }
    }

    private void showErrorConnectionDialog(final ExecutionEnvironment env, final IOException ex) throws HeadlessException, MissingResourceException {
        RemoteUtil.LOGGER.log(Level.INFO, "Error connecting " + env, ex);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(WindowManager.getDefault().getMainWindow(), NbBundle.getMessage(OpenRemoteProjectAction.class, (String)"ErrorConnectingHost", (Object)env.getDisplayName(), (Object)ex.getMessage()));
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean enable(ExecutionEnvironment env) {
        Object object = lock;
        synchronized (object) {
            return !isRunning;
        }
    }

    @Override
    public boolean isVisible(Node node) {
        return this.isRemote(node);
    }

    private void openRemoteProject(final ExecutionEnvironment env) {
        String chooser_key = "open.remote.project";
        final String homeDir = RemoteFileUtil.getCurrentChooserFile((String)"open.remote.project", (ExecutionEnvironment)env);
        Callable<String> homeDirCallable = new Callable<String>(){

            @Override
            public String call() throws Exception {
                return homeDir == null ? OpenRemoteProjectAction.getRemoteProjectDir(env) : homeDir;
            }
        };
        FileChooserBuilder.JFileChooserEx fileChooser = (FileChooserBuilder.JFileChooserEx)RemoteFileUtil.createFileChooser((ExecutionEnvironment)env, (String)NbBundle.getMessage(OpenRemoteProjectAction.class, (String)"OpenProjectTitle", (Object)env.getDisplayName()), (String)NbBundle.getMessage(OpenRemoteProjectAction.class, (String)"OpenProjectButtonText"), (int)1, null, (Callable)homeDirCallable, (boolean)true);
        fileChooser.setFileView((FileView)new ProjectSelectionFileView((JFileChooser)fileChooser));
        int ret = fileChooser.showOpenDialog((Component)WindowManager.getDefault().getMainWindow());
        if (ret == 1) {
            return;
        }
        FileObject remoteProjectFO = fileChooser.getSelectedFileObject();
        if (remoteProjectFO == null || !remoteProjectFO.isFolder()) {
            String msg;
            String string = msg = fileChooser.getSelectedFile() != null ? fileChooser.getSelectedFile().getPath() : null;
            if (msg != null) {
                JOptionPane.showMessageDialog(WindowManager.getDefault().getMainWindow(), NbBundle.getMessage(OpenRemoteProjectAction.class, (String)"InvalidFolder", (Object)msg));
            }
            return;
        }
        String currentChooserFile = remoteProjectFO.getParent() == null ? remoteProjectFO.getPath() : remoteProjectFO.getParent().getPath();
        RemoteFileUtil.setCurrentChooserFile((String)"open.remote.project", (String)currentChooserFile, (ExecutionEnvironment)env);
        try {
            Project project = ProjectManager.getDefault().findProject(remoteProjectFO);
            if (project != null) {
                OpenProjects.getDefault().open(new Project[]{project}, false, true);
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IllegalArgumentException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private static String getRemoteProjectDir(ExecutionEnvironment env) {
        try {
            return HostInfoUtils.getHostInfo((ExecutionEnvironment)env).getUserDir() + '/' + ProjectChooser.getProjectsFolder().getName();
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
        catch (ConnectionManager.CancellationException cancellationException) {
            // empty catch block
        }
        return null;
    }

    private static final class ProjectSelectionFileView
    extends FileView
    implements Runnable {
        private final JFileChooser chooser;
        private final Map<File, Icon> knownProjectIcons = new HashMap<File, Icon>();
        private final RequestProcessor.Task task = new RequestProcessor("ProjectIconFileView").create((Runnable)this);
        private File lookingForIcon;

        public ProjectSelectionFileView(JFileChooser chooser) {
            this.chooser = chooser;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Icon getIcon(File f) {
            if (f.isDirectory() && !f.toString().matches("/[^/]+") && f.getParentFile() != null) {
                ProjectSelectionFileView projectSelectionFileView = this;
                synchronized (projectSelectionFileView) {
                    Icon icon = this.knownProjectIcons.get(f);
                    if (icon != null) {
                        return icon;
                    }
                    if (this.lookingForIcon == null) {
                        this.lookingForIcon = f;
                        this.task.schedule(20);
                    }
                }
            }
            return this.chooser.getFileSystemView().getSystemIcon(f);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String path = this.lookingForIcon.getAbsolutePath();
            String project = path + "/nbproject";
            File projectDir = this.chooser.getFileSystemView().createFileObject(project);
            Icon icon = this.chooser.getFileSystemView().getSystemIcon(this.lookingForIcon);
            if (projectDir.exists() && projectDir.isDirectory() && projectDir.canRead()) {
                String projectXml = path + "/nbproject/project.xml";
                File projectFile = this.chooser.getFileSystemView().createFileObject(projectXml);
                if (projectFile.exists()) {
                    String conf = path + "/nbproject/configurations.xml";
                    File configuration = this.chooser.getFileSystemView().createFileObject(conf);
                    if (configuration.exists()) {
                        icon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/cnd/makeproject/ui/resources/makeProject.gif", (boolean)true);
                    }
                }
            }
            ProjectSelectionFileView projectSelectionFileView = this;
            synchronized (projectSelectionFileView) {
                this.knownProjectIcons.put(this.lookingForIcon, icon);
                this.lookingForIcon = null;
            }
            this.chooser.repaint();
        }
    }
}

