/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remotefs.versioning.api;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.extexecution.ProcessBuilder;
import org.netbeans.modules.remotefs.versioning.api.NativeTaskExecutorService;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;

public class ProcessUtils {
    public static final Logger LOG = Logger.getLogger("nativeexecution.support.logger");
    private static final String remoteCharSet = System.getProperty("cnd.remote.charset", "UTF-8");

    private ProcessUtils() {
    }

    public static ExitStatus executeInDir(String workingDir, Map<String, String> env, boolean binaryOutput, Canceler canceler, ProcessBuilder builder, String executable, String ... args) {
        if (workingDir != null) {
            builder.setWorkingDirectory(workingDir);
        }
        if (env != null) {
            builder.setEnvironmentVariables(env);
        }
        builder.setExecutable(executable);
        builder.setArguments(Arrays.asList(args));
        return ProcessUtils.execute(builder, binaryOutput, canceler);
    }

    private static ExitStatus execute(ProcessBuilder processBuilder, boolean binaryOutput, Canceler canceler) {
        ExitStatus result;
        if (processBuilder == null) {
            throw new NullPointerException("NULL process builder!");
        }
        try {
            final Process process = processBuilder.call();
            canceler.addListener(process);
            if (binaryOutput) {
                Future<String> error = NativeTaskExecutorService.submit(new Callable<String>(){

                    @Override
                    public String call() throws Exception {
                        return ProcessUtils.readProcessErrorLine(process);
                    }
                }, "e");
                Future<byte[]> output = NativeTaskExecutorService.submit(new Callable<byte[]>(){

                    @Override
                    public byte[] call() throws Exception {
                        return ProcessUtils.readProcessOutputBytes(process);
                    }
                }, "o");
                result = new ExitStatus(process.waitFor(), output.get(), error.get());
            } else {
                Future<String> error = NativeTaskExecutorService.submit(new Callable<String>(){

                    @Override
                    public String call() throws Exception {
                        return ProcessUtils.readProcessErrorLine(process);
                    }
                }, "e");
                Future<String> output = NativeTaskExecutorService.submit(new Callable<String>(){

                    @Override
                    public String call() throws Exception {
                        return ProcessUtils.readProcessOutputLine(process);
                    }
                }, "o");
                result = new ExitStatus(process.waitFor(), output.get(), error.get());
            }
        }
        catch (InterruptedException ex) {
            result = new ExitStatus(-100, "", ex.getMessage());
        }
        catch (Throwable th) {
            LOG.log(Level.INFO, th.getMessage(), th);
            result = new ExitStatus(-200, "", th.getMessage());
        }
        return result;
    }

    private static String getRemoteCharSet() {
        return remoteCharSet;
    }

    private static BufferedReader getReader(InputStream is, String charSet) {
        try {
            return new BufferedReader(new InputStreamReader(is, charSet));
        }
        catch (UnsupportedEncodingException ex) {
            String msg = ProcessUtils.getRemoteCharSet() + " encoding is not supported, try to override it with cnd.remote.charset";
            Exceptions.printStackTrace((Throwable)new IllegalStateException(msg, ex));
            return new BufferedReader(new InputStreamReader(is));
        }
    }

    private static String readProcessErrorLine(Process p) throws IOException {
        if (p == null) {
            return "";
        }
        return ProcessUtils.readProcessStreamLine(p.getErrorStream(), ProcessUtils.getCharSet(p));
    }

    private static String readProcessOutputLine(Process p) throws IOException {
        if (p == null) {
            return "";
        }
        return ProcessUtils.readProcessStreamLine(p.getInputStream(), ProcessUtils.getCharSet(p));
    }

    private static byte[] readProcessOutputBytes(Process p) throws IOException {
        if (p == null) {
            return new byte[0];
        }
        return ProcessUtils.readProcessStreamBytes(p.getInputStream());
    }

    private static String getCharSet(Process process) {
        return remoteCharSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readProcessStreamLine(InputStream stream, String charSet) throws IOException {
        if (stream == null) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        try (BufferedReader br = ProcessUtils.getReader(stream, charSet);){
            String line;
            boolean first = true;
            while ((line = br.readLine()) != null) {
                if (!first) {
                    result.append('\n');
                }
                result.append(line);
                first = false;
            }
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] readProcessStreamBytes(InputStream stream) throws IOException {
        if (stream == null) {
            return new byte[0];
        }
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        try {
            int i;
            while ((i = stream.read()) != -1) {
                b.write(i);
            }
        }
        finally {
            stream.close();
        }
        return b.toByteArray();
    }

    public static interface PostExecutor {
        public void processFinished(ExitStatus var1);
    }

    public static final class ExitStatus {
        public final int exitCode;
        public final String error;
        public final String output;
        public final byte[] bytes;

        private ExitStatus(int exitCode, String output, String error) {
            this.exitCode = exitCode;
            this.error = error;
            this.output = output;
            this.bytes = null;
        }

        private ExitStatus(int exitCode, byte[] bytes, String error) {
            this.exitCode = exitCode;
            this.error = error;
            this.bytes = bytes;
            this.output = null;
        }

        public boolean isOK() {
            return this.exitCode == 0;
        }

        public String toString() {
            return "ExitStatus exitCode=" + this.exitCode + "\nerror=" + this.error + "\noutput=" + this.output;
        }
    }

    public static final class Canceler
    implements Cancellable {
        private final List<Process> listeners = new ArrayList<Process>();
        private final AtomicBoolean canceled = new AtomicBoolean(false);

        public boolean cancel() {
            this.canceled.set(true);
            for (Process listener : this.listeners) {
                listener.destroy();
            }
            return true;
        }

        public boolean canceled() {
            return this.canceled.get();
        }

        public void addListener(Process listener) {
            this.listeners.add(listener);
        }
    }
}

