/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remotefs.versioning.util.common;

import java.util.ArrayList;
import org.netbeans.modules.remotefs.versioning.util.common.VCSFileInformation;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.util.common.VCSCommitOptions;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public abstract class VCSFileNode<I extends VCSFileInformation> {
    private final VCSFileProxy file;
    private final VCSFileProxy root;
    private String shortPath;
    private VCSCommitOptions commitOption;

    public VCSFileNode(VCSFileProxy root, VCSFileProxy file) {
        assert (file != null && root != null);
        this.file = file;
        this.root = root;
    }

    public abstract VCSCommitOptions getDefaultCommitOption(boolean var1);

    public abstract I getInformation();

    public String getStatusText() {
        return ((VCSFileInformation)this.getInformation()).getStatusText();
    }

    public VCSCommitOptions getCommitOptions() {
        if (this.commitOption == null) {
            this.commitOption = this.getDefaultCommitOption(true);
        }
        return this.commitOption;
    }

    void setCommitOptions(VCSCommitOptions option) {
        this.commitOption = option;
    }

    public String getName() {
        return this.file.getName();
    }

    public VCSFileProxy getFile() {
        return this.file;
    }

    public VCSFileProxy getRoot() {
        return this.root;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o instanceof VCSFileNode && this.file.equals((Object)((VCSFileNode)o).file);
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    public FileObject getFileObject() {
        return this.file.toFileObject();
    }

    public Object[] getLookupObjects() {
        ArrayList<Object> list = new ArrayList<Object>(2);
        list.add(this.file);
        FileObject fo = this.getFileObject();
        if (fo != null) {
            list.add(fo);
        }
        return list.toArray(new Object[list.size()]);
    }

    public String getRelativePath() {
        if (this.shortPath == null) {
            String rootPath;
            String path = this.file.getPath();
            this.shortPath = path.startsWith(rootPath = this.root.getPath()) ? (path.length() == rootPath.length() ? "." : path.substring(rootPath.length() + 1)) : NbBundle.getMessage(VCSFileNode.class, (String)"LBL_Location_NotInRepository");
        }
        return this.shortPath;
    }
}

