/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javaee.project.api;

import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.dd.api.web.WebAppMetadata;
import org.netbeans.modules.j2ee.dd.api.web.model.ServletInfo;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelException;
import org.netbeans.modules.javaee.project.api.JavaEEProjectSettings;
import org.netbeans.modules.javaee.project.spi.FrameworkServerURLMapping;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.browser.api.BrowserSupport;
import org.netbeans.modules.web.browser.api.BrowserUISupport;
import org.netbeans.modules.web.browser.api.WebBrowser;
import org.netbeans.modules.web.browser.spi.PageInspectorCustomizer;
import org.netbeans.modules.web.browser.spi.URLDisplayerImplementation;
import org.netbeans.modules.web.common.api.UsageLogger;
import org.netbeans.modules.web.common.api.WebUtils;
import org.netbeans.modules.web.common.spi.ServerURLMappingImplementation;
import org.openide.awt.HtmlBrowser;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public final class ClientSideDevelopmentSupport
implements ServerURLMappingImplementation,
URLDisplayerImplementation,
PageInspectorCustomizer {
    private final Project project;
    private Project webProject;
    private volatile String projectRootURL;
    private volatile FileObject webDocumentRoot;
    private BrowserSupport browserSupport = null;
    private boolean browserSupportInitialized = false;
    private boolean initialized = false;
    private final UsageLogger browserUsageLogger;
    private final String projectType;
    private final List<Pattern> servletURLPatterns = new CopyOnWriteArrayList<Pattern>();
    private final List<String> welcomeFiles = new CopyOnWriteArrayList<String>();

    public static ClientSideDevelopmentSupport createInstance(Project project, String projectType, String usageLoggerName) {
        return new ClientSideDevelopmentSupport(project, projectType, usageLoggerName);
    }

    private ClientSideDevelopmentSupport(Project project, String projectType, String usageLoggerName) {
        this.project = project;
        this.webProject = project;
        this.browserUsageLogger = UsageLogger.projectBrowserUsageLogger((String)usageLoggerName);
        this.projectType = projectType;
    }

    public synchronized void setWebProject(Project webProject) {
        this.webProject = webProject;
        this.webDocumentRoot = null;
    }

    private synchronized Project getWebProject() {
        return this.webProject;
    }

    public void showURL(URL applicationRootURL, URL urlToOpenInBrowser, FileObject context) {
        WebBrowser browser;
        String string = this.projectRootURL = applicationRootURL == null ? null : WebUtils.urlToString((URL)applicationRootURL);
        if (this.projectRootURL != null && !this.projectRootURL.contains(".") && !this.projectRootURL.endsWith("/")) {
            this.projectRootURL = this.projectRootURL + "/";
        }
        if (this.project.getProjectDirectory().equals(context) && this.webProject != null) {
            context = this.webProject.getProjectDirectory();
        }
        if ((browser = this.getWebBrowser()) != null) {
            urlToOpenInBrowser = browser.toBrowserURL(this.getWebProject(), context, urlToOpenInBrowser);
            this.browserUsageLogger.log(new Object[]{this.projectType, browser.getId(), browser.getBrowserFamily().name()});
        } else {
            WebBrowser wb = BrowserUISupport.getDefaultBrowserChoice((boolean)true);
            this.browserUsageLogger.log(new Object[]{this.projectType, wb.getId(), wb.getBrowserFamily().name()});
        }
        BrowserSupport bs = this.getBrowserSupport();
        if (bs != null) {
            bs.load(urlToOpenInBrowser, context);
        } else {
            HtmlBrowser.URLDisplayer.getDefault().showURL(urlToOpenInBrowser);
        }
    }

    public URL toServer(int projectContext, FileObject projectFile) {
        this.init();
        if (this.projectRootURL == null || this.webDocumentRoot == null) {
            return null;
        }
        String relPath = FileUtil.getRelativePath((FileObject)this.webDocumentRoot, (FileObject)projectFile);
        for (FrameworkServerURLMapping frameworkServerURLMapping : ClientSideDevelopmentSupport.lookupFrameworkMappings()) {
            relPath = frameworkServerURLMapping.convertFileToRelativeURL(projectFile, relPath);
        }
        try {
            URL u = new URL(this.projectRootURL + relPath);
            WebBrowser webBrowser = this.getWebBrowser();
            if (webBrowser != null) {
                u = webBrowser.toBrowserURL(this.getWebProject(), projectFile, u);
            }
            return u;
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    public FileObject fromServer(int projectContext, URL serverURL) {
        String u;
        String query = serverURL.getQuery();
        if ((serverURL = WebUtils.stringToUrl((String)WebUtils.urlToString((URL)serverURL, (boolean)true))) == null) {
            return null;
        }
        this.init();
        if (this.projectRootURL == null || this.webDocumentRoot == null) {
            return null;
        }
        WebBrowser browser = this.getWebBrowser();
        if (browser != null) {
            serverURL = browser.fromBrowserURL(this.getWebProject(), serverURL);
        }
        if ((u = WebUtils.urlToString((URL)serverURL)).startsWith(this.projectRootURL)) {
            String name = u.substring(this.projectRootURL.length());
            if (name.isEmpty()) {
                return this.getExistingWelcomeFile();
            }
            return this.convertServerURLToProjectFile(name, query);
        }
        return null;
    }

    public boolean isHighlightSelectionEnabled() {
        return true;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
    }

    public void close() {
        BrowserSupport support = this.getBrowserSupport();
        if (support != null) {
            support.close(true);
        }
    }

    private void init() {
        if (this.webDocumentRoot == null) {
            this.webDocumentRoot = this.getWebRoot();
        }
        this.readWebAppMetamodelData();
    }

    private FileObject getWebRoot() {
        WebModule webModule = this.getWebModule();
        return webModule != null ? webModule.getDocumentBase() : null;
    }

    private WebModule getWebModule() {
        if (this.getWebProject() != null) {
            return WebModule.getWebModule((FileObject)this.getWebProject().getProjectDirectory());
        }
        return null;
    }

    public boolean canReload() {
        BrowserSupport bs = this.getBrowserSupport();
        if (bs != null) {
            return bs.canReload();
        }
        return false;
    }

    public void reload(FileObject fo) {
        BrowserSupport bs = this.getBrowserSupport();
        if (bs == null) {
            return;
        }
        if (bs.ignoreChange(fo)) {
            return;
        }
        URL u = bs.getBrowserURL(fo, true);
        if (u == null && this.isWelcomeFile(fo)) {
            u = bs.getBrowserURL(this.project.getProjectDirectory(), true);
        }
        if (u != null && bs.canReload(u)) {
            bs.reload(u);
        }
    }

    public synchronized void resetBrowserSupport() {
        if (this.browserSupport != null) {
            this.browserSupport.close(false);
        }
        this.browserSupport = null;
        this.browserSupportInitialized = false;
        this.browserUsageLogger.reset();
    }

    @CheckForNull
    private synchronized BrowserSupport getBrowserSupport() {
        if (this.browserSupportInitialized) {
            return this.browserSupport;
        }
        this.browserSupportInitialized = true;
        WebBrowser browser = this.getWebBrowser();
        if (browser == null) {
            this.browserSupport = null;
            return null;
        }
        this.browserSupport = BrowserSupport.create((WebBrowser)browser);
        return this.browserSupport;
    }

    @CheckForNull
    private WebBrowser getWebBrowser() {
        String selectedBrowser = JavaEEProjectSettings.getBrowserID(this.project);
        if (selectedBrowser == null) {
            return null;
        }
        return BrowserUISupport.getBrowser((String)selectedBrowser);
    }

    private synchronized void readWebAppMetamodelData() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        final WebModule webModule = this.getWebModule();
        if (webModule == null) {
            return;
        }
        try {
            webModule.getMetadataModel().runReadAction((MetadataModelAction)new MetadataModelAction<WebAppMetadata, Void>(){

                public Void run(WebAppMetadata metadata) throws Exception {
                    WebApp ddRoot;
                    ArrayList<Pattern> l = new ArrayList<Pattern>();
                    for (ServletInfo si : metadata.getServlets()) {
                        for (String pattern : si.getUrlPatterns()) {
                            if (pattern.endsWith("*")) {
                                String pat = pattern.substring(0, pattern.length() - 1);
                                l.add(new Pattern(Pattern.Type.PREFIX, pat.startsWith("/") ? pat.substring(1) : pat));
                                continue;
                            }
                            if (!pattern.startsWith("*")) continue;
                            l.add(new Pattern(Pattern.Type.SUFFIX, pattern.substring(1)));
                        }
                    }
                    FileObject fo = webModule.getDeploymentDescriptor();
                    if (fo != null && (ddRoot = DDProvider.getDefault().getDDRoot(fo)) != null) {
                        fo.addFileChangeListener((FileChangeListener)new FileChangeAdapter(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void fileChanged(FileEvent fe) {
                                ClientSideDevelopmentSupport clientSideDevelopmentSupport = ClientSideDevelopmentSupport.this;
                                synchronized (clientSideDevelopmentSupport) {
                                    ClientSideDevelopmentSupport.this.initialized = false;
                                    ClientSideDevelopmentSupport.this.welcomeFiles.clear();
                                    ClientSideDevelopmentSupport.this.servletURLPatterns.clear();
                                }
                            }
                        });
                        if (ddRoot.getSingleWelcomeFileList() != null) {
                            ClientSideDevelopmentSupport.this.welcomeFiles.addAll(Arrays.asList(ddRoot.getSingleWelcomeFileList().getWelcomeFile()));
                        }
                    }
                    ClientSideDevelopmentSupport.this.welcomeFiles.add("index.html");
                    ClientSideDevelopmentSupport.this.welcomeFiles.add("index.htm");
                    ClientSideDevelopmentSupport.this.welcomeFiles.add("index.jsp");
                    ClientSideDevelopmentSupport.this.servletURLPatterns.addAll(l);
                    return null;
                }
            });
        }
        catch (MetadataModelException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private FileObject getExistingWelcomeFile() {
        for (String welcomeFile : this.welcomeFiles) {
            for (Pattern pattern : this.servletURLPatterns) {
                FileObject fo;
                if (!welcomeFile.startsWith(pattern.getPattern()) || (fo = this.webDocumentRoot.getFileObject(welcomeFile.substring(pattern.getPattern().length()))) == null) continue;
                return fo;
            }
            FileObject fo = this.webDocumentRoot.getFileObject(welcomeFile);
            if (fo == null) continue;
            return fo;
        }
        return null;
    }

    private FileObject convertServerURLToProjectFile(String name, String query) {
        block4: for (Pattern servletURLPattern : this.servletURLPatterns) {
            String pattern = servletURLPattern.getPattern();
            switch (servletURLPattern.getType()) {
                case PREFIX: {
                    FileObject file;
                    if (!name.startsWith(pattern)) break;
                    for (FrameworkServerURLMapping frameworkServerURLMapping : ClientSideDevelopmentSupport.lookupFrameworkMappings()) {
                        file = frameworkServerURLMapping.convertURLtoFile(this.webDocumentRoot, servletURLPattern, name, query);
                        if (file == null) continue;
                        return file;
                    }
                    FileObject fo = this.webDocumentRoot.getFileObject(name.substring(pattern.length()));
                    if (fo == null) continue block4;
                    return fo;
                }
                case SUFFIX: {
                    FileObject file;
                    name = ClientSideDevelopmentSupport.truncatePathForSessionId(name);
                    if (!name.endsWith(pattern)) break;
                    for (FrameworkServerURLMapping frameworkServerURLMapping : ClientSideDevelopmentSupport.lookupFrameworkMappings()) {
                        file = frameworkServerURLMapping.convertURLtoFile(this.webDocumentRoot, servletURLPattern, name, query);
                        if (file == null) continue;
                        return file;
                    }
                    break;
                }
            }
        }
        FileObject result = this.webDocumentRoot.getFileObject(name);
        if (result == null) {
            String tryName = null;
            if (name.endsWith(".jsf")) {
                tryName = name.substring(0, name.length() - 3);
            }
            if (name.endsWith(".faces")) {
                tryName = name.substring(0, name.length() - 5);
            }
            if (tryName != null && (result = this.webDocumentRoot.getFileObject(tryName + "xhtml")) == null) {
                result = this.webDocumentRoot.getFileObject(tryName + "jsp");
            }
        }
        return result;
    }

    private static Collection<? extends FrameworkServerURLMapping> lookupFrameworkMappings() {
        return Lookup.getDefault().lookupAll(FrameworkServerURLMapping.class);
    }

    private boolean isWelcomeFile(FileObject context) {
        for (String welcomeFile : this.welcomeFiles) {
            for (Pattern servletURLPattern : this.servletURLPatterns) {
                FileObject fo;
                String pattern = servletURLPattern.getPattern();
                if (!welcomeFile.startsWith(pattern) || (fo = this.webDocumentRoot.getFileObject(welcomeFile.substring(pattern.length()))) == null || !fo.equals(context)) continue;
                return true;
            }
            FileObject fo = this.webDocumentRoot.getFileObject(welcomeFile);
            if (fo == null || !fo.equals(context)) continue;
            return true;
        }
        return false;
    }

    private String applyServletPattern(String relPath) {
        Iterator<Pattern> i$ = this.servletURLPatterns.iterator();
        if (i$.hasNext()) {
            Pattern pattern = i$.next();
            return pattern.getPattern() + relPath;
        }
        return relPath;
    }

    private static String truncatePathForSessionId(String name) {
        int semicolonOffset = name.indexOf(";");
        if (semicolonOffset == -1) {
            return name;
        }
        return name.substring(0, semicolonOffset);
    }

    public static class Pattern {
        private final Type type;
        private final String pattern;

        public Pattern(Type type, String pattern) {
            this.type = type;
            this.pattern = pattern;
        }

        public Type getType() {
            return this.type;
        }

        public String getPattern() {
            return this.pattern;
        }

        public static enum Type {
            PREFIX,
            SUFFIX;

        }
    }
}

