/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.memory;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.global.InstrumentationFilter;
import org.netbeans.lib.profiler.results.RuntimeCCTNode;
import org.netbeans.lib.profiler.results.memory.AllocMemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.LivenessMemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.MemoryCCTProvider;
import org.netbeans.lib.profiler.results.memory.MemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.SampledMemoryResultsSnapshot;
import org.netbeans.lib.profiler.ui.memory.AllocTableView;
import org.netbeans.lib.profiler.ui.memory.AllocTreeTableView;
import org.netbeans.lib.profiler.ui.memory.LivenessTableView;
import org.netbeans.lib.profiler.ui.memory.LivenessTreeTableView;
import org.netbeans.lib.profiler.ui.memory.MemoryView;
import org.netbeans.lib.profiler.ui.memory.SampledTableView;
import org.netbeans.lib.profiler.ui.results.DataView;
import org.netbeans.lib.profiler.ui.swing.FilterUtils;
import org.netbeans.lib.profiler.ui.swing.SearchUtils;
import org.openide.util.Lookup;

public abstract class LiveMemoryView
extends JPanel {
    private static final int MIN_UPDATE_DIFF = 900;
    private static final int MAX_UPDATE_DIFF = 1400;
    private MemoryView dataView;
    private long lastupdate;
    private volatile boolean paused;
    private volatile boolean forceRefresh;
    private volatile boolean refreshIsRunning;
    private final Set<ClientUtils.SourceCodeSelection> selection;
    private final ResultsMonitor rm;
    private MemoryResultsSnapshot snapshot;
    private MemoryResultsSnapshot refSnapshot;
    private Collection<String> filter;

    public LiveMemoryView(Set<ClientUtils.SourceCodeSelection> selection) {
        this.selection = selection;
        this.initUI();
        this.rm = (ResultsMonitor)Lookup.getDefault().lookup(ResultsMonitor.class);
        this.rm.view = this;
    }

    private void refreshData(RuntimeCCTNode appRootNode) throws ClientUtils.TargetAppOrVMTerminated {
        if ((this.lastupdate + 900L > System.currentTimeMillis() || this.paused) && !this.forceRefresh) {
            return;
        }
        if (this.refreshIsRunning) {
            return;
        }
        this.refreshIsRunning = true;
        try {
            ProfilerClient client = this.getProfilerClient();
            final MemoryResultsSnapshot _snapshot = client.getMemoryProfilingResultsSnapshot(false);
            MemoryView.userFormClassNames(_snapshot);
            InstrumentationFilter ifilter = client.getSettings().getInstrumentationFilter();
            String[] _ifilter = ifilter == null ? null : ifilter.getUserFilterStrings();
            final List<String> _filter = _ifilter == null ? Collections.EMPTY_LIST : Arrays.asList(_ifilter);
            SwingUtilities.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        LiveMemoryView.this.refreshDataImpl(_snapshot, _filter);
                    }
                    finally {
                        LiveMemoryView.this.refreshIsRunning = false;
                    }
                }
            });
        }
        catch (RuntimeException ex) {
            this.refreshIsRunning = false;
            throw ex;
        }
        catch (ClientUtils.TargetAppOrVMTerminated ex) {
            this.refreshIsRunning = false;
            throw ex;
        }
        this.lastupdate = System.currentTimeMillis();
        this.forceRefresh = false;
    }

    private void refreshDataImpl(MemoryResultsSnapshot _snapshot, Collection<String> _filter) {
        assert (SwingUtilities.isEventDispatchThread());
        this.updateDataView(_snapshot);
        this.snapshot = _snapshot;
        this.filter = _filter;
        if (this.dataView != null && this.snapshot != null) {
            if (this.refSnapshot == null) {
                this.dataView.setData(this.snapshot, this.filter, 1);
            } else {
                this.dataView.setData(this.refSnapshot.createDiff(this.snapshot), this.filter, 1);
            }
        }
    }

    public boolean setDiffView(boolean diff) {
        if (this.snapshot == null) {
            return false;
        }
        this.refSnapshot = diff ? this.snapshot : null;
        this.refreshDataImpl(this.snapshot, this.filter);
        return true;
    }

    public void refreshData() throws ClientUtils.TargetAppOrVMTerminated {
        if (this.paused && !this.forceRefresh) {
            return;
        }
        ProfilerClient client = this.getProfilerClient();
        switch (client.getCurrentInstrType()) {
            case 7: {
                this.refreshData(null);
                break;
            }
            case 5: 
            case 6: {
                if (this.lastupdate + 1400L >= System.currentTimeMillis()) break;
                client.forceObtainedResultsDump(true);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid profiling instr. type: " + client.getCurrentInstrType());
            }
        }
    }

    public void resetData() {
        if (this.dataView != null) {
            this.dataView.resetData();
        }
        this.snapshot = null;
        this.refSnapshot = null;
        this.filter = null;
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    public void setForceRefresh(boolean forceRefresh) {
        this.forceRefresh = forceRefresh;
    }

    public void showSelectionColumn() {
        if (this.dataView != null) {
            this.dataView.showSelectionColumn();
        }
    }

    public void refreshSelection() {
        if (this.dataView != null) {
            this.dataView.showSelectionColumn();
        }
    }

    public void cleanup() {
        if (this.rm.view == this) {
            this.rm.view = null;
        }
    }

    protected abstract ProfilerClient getProfilerClient();

    protected abstract boolean showSourceSupported();

    protected abstract void showSource(ClientUtils.SourceCodeSelection var1);

    protected abstract void selectForProfiling(ClientUtils.SourceCodeSelection var1);

    protected void popupShowing() {
    }

    protected void popupHidden() {
    }

    private void updateDataView(MemoryResultsSnapshot snapshot) {
        if (snapshot == null || snapshot instanceof SampledMemoryResultsSnapshot) {
            if (this.dataView instanceof SampledTableView) {
                return;
            }
            this.dataView = new SampledTableView(this.selection){

                @Override
                protected void performDefaultAction(ClientUtils.SourceCodeSelection userValue) {
                    if (LiveMemoryView.this.showSourceSupported()) {
                        LiveMemoryView.this.showSource(userValue);
                    }
                }

                @Override
                protected void populatePopup(JPopupMenu popup, Object value, ClientUtils.SourceCodeSelection userValue) {
                    LiveMemoryView.this.populatePopup(LiveMemoryView.this.dataView, popup, value, userValue);
                }

                @Override
                protected void popupShowing() {
                    LiveMemoryView.this.popupShowing();
                }

                @Override
                protected void popupHidden() {
                    LiveMemoryView.this.popupHidden();
                }

                @Override
                protected boolean hasBottomFilterFindMargin() {
                    return true;
                }
            };
        } else if (snapshot instanceof AllocMemoryResultsSnapshot) {
            if (snapshot.containsStacks()) {
                if (this.dataView instanceof AllocTreeTableView) {
                    return;
                }
                this.dataView = new AllocTreeTableView(this.selection){

                    @Override
                    protected void performDefaultAction(ClientUtils.SourceCodeSelection userValue) {
                        if (LiveMemoryView.this.showSourceSupported()) {
                            LiveMemoryView.this.showSource(userValue);
                        }
                    }

                    @Override
                    protected void populatePopup(JPopupMenu popup, Object value, ClientUtils.SourceCodeSelection userValue) {
                        LiveMemoryView.this.populatePopup(LiveMemoryView.this.dataView, popup, value, userValue);
                    }

                    protected void popupShowing() {
                        LiveMemoryView.this.popupShowing();
                    }

                    protected void popupHidden() {
                        LiveMemoryView.this.popupHidden();
                    }

                    @Override
                    protected boolean hasBottomFilterFindMargin() {
                        return true;
                    }
                };
            } else {
                if (this.dataView instanceof AllocTableView) {
                    return;
                }
                this.dataView = new AllocTableView(this.selection){

                    @Override
                    protected void performDefaultAction(ClientUtils.SourceCodeSelection userValue) {
                        if (LiveMemoryView.this.showSourceSupported()) {
                            LiveMemoryView.this.showSource(userValue);
                        }
                    }

                    @Override
                    protected void populatePopup(JPopupMenu popup, Object value, ClientUtils.SourceCodeSelection userValue) {
                        LiveMemoryView.this.populatePopup(LiveMemoryView.this.dataView, popup, value, userValue);
                    }

                    @Override
                    protected void popupShowing() {
                        LiveMemoryView.this.popupShowing();
                    }

                    @Override
                    protected void popupHidden() {
                        LiveMemoryView.this.popupHidden();
                    }

                    @Override
                    protected boolean hasBottomFilterFindMargin() {
                        return true;
                    }
                };
            }
        } else if (snapshot instanceof LivenessMemoryResultsSnapshot) {
            if (snapshot.containsStacks()) {
                if (this.dataView instanceof LivenessTreeTableView) {
                    return;
                }
                this.dataView = new LivenessTreeTableView(this.selection, false){

                    @Override
                    protected void performDefaultAction(ClientUtils.SourceCodeSelection userValue) {
                        if (LiveMemoryView.this.showSourceSupported()) {
                            LiveMemoryView.this.showSource(userValue);
                        }
                    }

                    @Override
                    protected void populatePopup(JPopupMenu popup, Object value, ClientUtils.SourceCodeSelection userValue) {
                        LiveMemoryView.this.populatePopup(LiveMemoryView.this.dataView, popup, value, userValue);
                    }

                    protected void popupShowing() {
                        LiveMemoryView.this.popupShowing();
                    }

                    protected void popupHidden() {
                        LiveMemoryView.this.popupHidden();
                    }

                    @Override
                    protected boolean hasBottomFilterFindMargin() {
                        return true;
                    }
                };
            } else {
                if (this.dataView instanceof LivenessTableView) {
                    return;
                }
                this.dataView = new LivenessTableView(this.selection, false){

                    @Override
                    protected void performDefaultAction(ClientUtils.SourceCodeSelection userValue) {
                        if (LiveMemoryView.this.showSourceSupported()) {
                            LiveMemoryView.this.showSource(userValue);
                        }
                    }

                    @Override
                    protected void populatePopup(JPopupMenu popup, Object value, ClientUtils.SourceCodeSelection userValue) {
                        LiveMemoryView.this.populatePopup(LiveMemoryView.this.dataView, popup, value, userValue);
                    }

                    @Override
                    protected void popupShowing() {
                        LiveMemoryView.this.popupShowing();
                    }

                    @Override
                    protected void popupHidden() {
                        LiveMemoryView.this.popupHidden();
                    }

                    @Override
                    protected boolean hasBottomFilterFindMargin() {
                        return true;
                    }
                };
            }
        } else {
            this.dataView = null;
        }
        this.removeAll();
        this.resetData();
        if (this.dataView != null) {
            this.add((Component)this.dataView, "Center");
        }
        this.revalidate();
        this.repaint();
    }

    private void populatePopup(final DataView invoker, JPopupMenu popup, Object value, final ClientUtils.SourceCodeSelection userValue) {
        if (this.showSourceSupported()) {
            popup.add(new JMenuItem(MemoryView.ACTION_GOTOSOURCE){
                {
                    super(x0);
                    this.setEnabled(userValue != null);
                    this.setFont(this.getFont().deriveFont(1));
                }

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    LiveMemoryView.this.showSource(userValue);
                }
            });
            popup.addSeparator();
        }
        popup.add(new JMenuItem(MemoryView.ACTION_PROFILE_CLASS){
            {
                super(x0);
                this.setEnabled(userValue != null);
            }

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                LiveMemoryView.this.selectForProfiling(userValue);
            }
        });
        popup.addSeparator();
        popup.add(invoker.createCopyMenuItem());
        popup.addSeparator();
        popup.add(new JMenuItem(FilterUtils.ACTION_FILTER){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                invoker.activateFilter();
            }
        });
        popup.add(new JMenuItem(SearchUtils.ACTION_FIND){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                invoker.activateSearch();
            }
        });
    }

    private void initUI() {
        this.setLayout(new BorderLayout(0, 0));
        this.updateDataView(null);
        this.registerActions();
    }

    private void registerActions() {
        ActionMap map = this.getActionMap();
        map.put("filter-action-key", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LiveMemoryView.this.dataView.activateFilter();
            }
        });
        map.put("find-action-key", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LiveMemoryView.this.dataView.activateSearch();
            }
        });
    }

    public static final class ResultsMonitor
    implements MemoryCCTProvider.Listener {
        private LiveMemoryView view;

        public void cctEstablished(RuntimeCCTNode appRootNode, boolean empty) {
            if (this.view != null && !empty) {
                try {
                    this.view.refreshData(appRootNode);
                }
                catch (ClientUtils.TargetAppOrVMTerminated ex) {
                    Logger.getLogger(LiveMemoryView.class.getName()).log(Level.FINE, null, ex);
                }
            }
        }

        public void cctReset() {
            if (this.view != null) {
                this.view.resetData();
            }
        }
    }
}

