/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.swing;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.swing.InvisibleToolbar;
import org.netbeans.modules.profiler.api.icons.Icons;

public abstract class FilteringToolbar
extends InvisibleToolbar {
    private final List<Component> hiddenComponents = new ArrayList<Component>();
    private final AbstractButton filterButton;

    public FilteringToolbar(String name) {
        if (!UIUtils.isNimbusLookAndFeel()) {
            this.setBorder(BorderFactory.createEmptyBorder(3, 0, 0, 0));
        }
        this.filterButton = new JToggleButton(Icons.getIcon((String)"GeneralIcons.Filter")){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                if (this.isSelected()) {
                    FilteringToolbar.this.showFilter();
                } else {
                    FilteringToolbar.this.hideFilter();
                }
            }
        };
        this.filterButton.setToolTipText(name);
        this.add(this.filterButton);
    }

    protected abstract void filterChanged(String var1);

    private void showFilter() {
        this.filterButton.setSelected(true);
        final JTextField f = new JTextField();
        f.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.changed();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.changed();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.changed();
            }

            private void changed() {
                FilteringToolbar.this.filterChanged(f.getText().trim());
            }
        });
        f.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (this.esc(e)) {
                    FilteringToolbar.this.hideFilter();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                this.esc(e);
            }

            private boolean esc(KeyEvent e) {
                boolean esc;
                boolean bl = esc = e.getKeyCode() == 27;
                if (esc) {
                    e.consume();
                }
                return esc;
            }
        });
        for (int i = 1; i < this.getComponentCount(); ++i) {
            this.hiddenComponents.add(this.getComponent(i));
        }
        for (Component c : this.hiddenComponents) {
            this.remove(c);
        }
        this.add(Box.createHorizontalStrut(3));
        this.add(f);
        f.requestFocusInWindow();
        this.invalidate();
        this.revalidate();
        this.doLayout();
        this.repaint();
    }

    private void hideFilter() {
        this.filterChanged(null);
        this.remove(2);
        this.remove(1);
        for (Component c : this.hiddenComponents) {
            this.add(c);
        }
        this.filterButton.setSelected(false);
        this.filterButton.requestFocusInWindow();
        this.invalidate();
        this.revalidate();
        this.doLayout();
        this.repaint();
    }
}

