/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.plaf.synth.SynthTreeUI;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.netbeans.lib.profiler.results.CCTNode;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.swing.ProfilerRowSorter;
import org.netbeans.lib.profiler.ui.swing.ProfilerTable;
import org.netbeans.lib.profiler.ui.swing.ProfilerTreeTableModel;
import org.netbeans.lib.profiler.ui.swing.renderer.LabelRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.ProfilerRenderer;

public class ProfilerTreeTable
extends ProfilerTable {
    private final TableModelImpl model = (TableModelImpl)this.getModel();
    private final ProfilerTreeTableTree tree = this.model.getTree();

    public ProfilerTreeTable(ProfilerTreeTableModel model, boolean sortable, boolean hideableColums, int[] scrollableColumns) {
        super(new TableModelImpl(model), sortable, hideableColums, scrollableColumns);
        Adapter adapter = new Adapter();
        this.tree.addTreeSelectionListener(adapter);
        this.tree.addTreeExpansionListener(adapter);
        this.tree.getModel().addTreeModelListener(adapter);
        this.getSelectionModel().addListSelectionListener(adapter);
        this.tree.setRowHeight(this.rowHeight);
        this.setDefaultRenderer(JTree.class, this.tree);
    }

    TreePath getRootPath() {
        return new TreePath(this.model.treeModel.getRoot());
    }

    TreePath getSelectionPath() {
        return this.tree.getSelectionPath();
    }

    TreePath getNextPath(TreePath path) {
        return this.getNextPath(path, true);
    }

    private TreePath getNextPath(TreePath path, boolean down) {
        SortedFilteredTreeModel _model = this.model.treeModel;
        TreeNode node = (TreeNode)path.getLastPathComponent();
        if (down && _model.getChildCount(node) > 0) {
            return path.pathByAddingChild(_model.getChild(node, 0));
        }
        TreePath parentPath = path.getParentPath();
        if (!down && parentPath == null) {
            return path.pathByAddingChild(_model.getChild(node, 0));
        }
        TreeNode parent = (TreeNode)parentPath.getLastPathComponent();
        int idx = _model.getIndexOfChild(parent, node) + 1;
        if (_model.getChildCount(parent) > idx) {
            return parentPath.pathByAddingChild(_model.getChild(parent, idx));
        }
        if (!down && parentPath.getParentPath() == null) {
            return parentPath.pathByAddingChild(_model.getChild(parent, 0));
        }
        return this.getNextPath(parentPath, false);
    }

    TreePath getPreviousPath(TreePath path) {
        TreeNode parent;
        int idx;
        SortedFilteredTreeModel _model = this.model.treeModel;
        TreeNode node = (TreeNode)path.getLastPathComponent();
        TreePath parentPath = path.getParentPath();
        if (parentPath == null) {
            parentPath = path;
        }
        int n = idx = (parent = (TreeNode)parentPath.getLastPathComponent()) == node ? parent.getChildCount() : _model.getIndexOfChild(parent, node);
        if (idx == 0) {
            if (parent != this.model.treeModel.getRoot()) {
                return parentPath;
            }
            idx = parent.getChildCount();
        }
        node = (TreeNode)_model.getChild(parent, idx - 1);
        path = parentPath.pathByAddingChild(node);
        while (_model.getChildCount(node) != 0) {
            node = (TreeNode)_model.getChild(node, _model.getChildCount(node) - 1);
            path = path.pathByAddingChild(node);
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void selectPath(TreePath path, boolean scrollToVisible) {
        Rectangle bounds;
        this.internal = true;
        try {
            this.tree.expandPath(path);
            this.tree.setSelectionPath(path);
            this.tree.setSelectionPath(null);
            this.tree.setSelectionPath(path);
        }
        finally {
            this.internal = false;
        }
        if (scrollToVisible && (bounds = this.tree.getPathBounds(path)) != null) {
            this.scrollRectToVisible(bounds);
        }
    }

    public TreePath getPathForRow(int row) {
        return this.tree.getPathForRow(row);
    }

    @Override
    public TreeNode getValueForRow(int row) {
        if (row == -1) {
            return null;
        }
        return this.model.nodeForRow(row);
    }

    @Override
    public void setRowHeight(int rowHeight) {
        super.setRowHeight(rowHeight);
        if (this.tree != null) {
            this.tree.setRowHeight(rowHeight);
        }
    }

    public void setShowsRootHandles(boolean newValue) {
        if (this.tree != null) {
            this.tree.setShowsRootHandles(newValue);
        }
    }

    public void setRootVisible(boolean rootVisible) {
        if (this.tree != null) {
            this.tree.setRootVisible(rootVisible);
        }
    }

    public void makeTreeAutoExpandable(int maxChildToExpand) {
        if (this.tree != null) {
            UIUtils.makeTreeAutoExpandable((JTree)this.tree, maxChildToExpand);
        }
    }

    public void setCellRenderer(TreeCellRenderer renderer) {
        if (this.tree != null) {
            this.tree.setCellRenderer(renderer);
            this.model.setRenderer(renderer);
        }
    }

    public void setTreeCellRenderer(ProfilerRenderer renderer) {
        this.setCellRenderer(ProfilerTreeTable.createTreeCellRenderer(renderer));
    }

    public static TreeCellRenderer createTreeCellRenderer(final ProfilerRenderer renderer) {
        return new TreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                renderer.setValue(value, row);
                JComponent comp = renderer.getComponent();
                comp.setOpaque(false);
                if (tree != null) {
                    comp.setForeground(tree.getForeground());
                }
                return comp;
            }

            public String toString() {
                return renderer.toString();
            }
        };
    }

    @Override
    Component getRenderer(TableCellRenderer renderer, int row, int column, boolean sized) {
        Component comp = super.getRenderer(renderer, row, column, sized);
        if (sized && JTree.class.equals(this.getColumnClass(column))) {
            Rectangle bounds = this.tree.getRowBounds(row);
            comp.setBounds(bounds.x, 0, bounds.width, comp.getHeight());
        }
        return comp;
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        this.tree.dispatchEvent(e);
        if (!e.isConsumed()) {
            super.processKeyEvent(e);
        }
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        int row;
        Rectangle treeCellRect;
        Point point;
        int column;
        MouseEvent treeEvent = null;
        if (e != null && this.getColumnClass(column = this.columnAtPoint(point = e.getPoint())) == JTree.class && (treeCellRect = this.tree.getRowBounds(row = this.rowAtPoint(point))) != null) {
            Rectangle tableCellRect = this.getCellRect(row, column, true);
            int _column = this.convertColumnIndexToModel(column);
            int treeX = point.x - tableCellRect.x + this.getColumnOffset(_column);
            if (treeX > treeCellRect.x) {
                treeX = treeCellRect.x + treeCellRect.width / 2;
            }
            treeEvent = new MouseEvent(this.tree, e.getID(), e.getWhen(), e.getModifiers(), treeX, e.getY(), e.getClickCount(), e.isPopupTrigger());
            TreeNode value = this.getValueForRow(row);
            if (value instanceof TreeNode && !value.isLeaf()) {
                e = ProfilerTreeTable.clearClicks(e);
            }
        }
        super.processMouseEvent(e);
        if (treeEvent != null) {
            this.tree.dispatchEvent(treeEvent);
        }
    }

    @Override
    public void addRowFilter(RowFilter filter) {
        super.addRowFilter(filter);
        this.refreshFilter();
    }

    @Override
    public void removeRowFilter(RowFilter filter) {
        super.removeRowFilter(filter);
        this.refreshFilter();
    }

    @Override
    public void setRowFilter(RowFilter filter) {
        super.setRowFilter(filter);
        this.refreshFilter();
    }

    private void refreshFilter() {
        this.model.filter(this._getRowSorter().getRowFilter());
    }

    public String getStringValue(TreeNode node, int column) {
        Object value = this.model.getValueAt(node, this.convertColumnIndexToModel(column));
        if (this.getColumnClass(column) == JTree.class) {
            TreeCellRenderer renderer = this.tree.getCellRenderer();
            renderer.getTreeCellRendererComponent(this.tree, value, false, false, false, -1, false);
            return renderer.toString();
        }
        TableCellRenderer renderer = this.getCellRenderer(-1, column);
        if (renderer instanceof ProfilerRenderer) {
            ((ProfilerRenderer)((Object)renderer)).setValue(value, -1);
        } else {
            renderer.getTableCellRendererComponent(this, value, false, false, -1, column);
        }
        return renderer.toString();
    }

    @Override
    protected TableRowSorter createRowSorter() {
        ProfilerTreeTableSorter s = new ProfilerTreeTableSorter(this.getModel()){

            @Override
            public void allRowsChanged() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ProfilerTreeTable.this.updateColumnsPreferredWidth();
                    }
                });
            }
        };
        s.setDefaultSortOrder(SortOrder.DESCENDING);
        s.setDefaultSortOrder(0, SortOrder.ASCENDING);
        s.setSortColumn(0);
        return s;
    }

    @Override
    protected void saveSelection() {
    }

    @Override
    protected void restoreSelection() {
    }

    static UIState getUIState(JTree tree) {
        TreePath[] selectedPaths = tree.getSelectionPaths();
        TreePath rootPath = new TreePath(tree.getModel().getRoot());
        Enumeration<TreePath> expandedPaths = tree.getExpandedDescendants(rootPath);
        return new UIState(selectedPaths, expandedPaths);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void restoreUIState(JTree tree, UIState uiState) {
        try {
            tree.putClientProperty("expansion_transaction", Boolean.TRUE);
            Enumeration paths = uiState.getExpandedPaths();
            if (paths != null) {
                while (paths.hasMoreElements()) {
                    tree.expandPath((TreePath)paths.nextElement());
                }
            }
        }
        finally {
            tree.putClientProperty("expansion_transaction", null);
        }
        tree.setSelectionPaths(uiState.getSelectedPaths());
    }

    private static class SynthLikeTreeUI
    extends BasicTreeUI {
        private static final Icon[] ICONS = new Icon[4];
        private boolean isSelected;

        private SynthLikeTreeUI() {
        }

        void setSelected(boolean selected) {
            this.isSelected = selected;
        }

        @Override
        public Icon getExpandedIcon() {
            return this.isSelected ? ICONS[1] : ICONS[0];
        }

        @Override
        public Icon getCollapsedIcon() {
            return this.isSelected ? ICONS[3] : ICONS[2];
        }

        @Override
        protected void paintHorizontalPartOfLeg(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
        }

        @Override
        protected void paintVerticalPartOfLeg(Graphics g, Rectangle clipBounds, Insets insets, TreePath path) {
        }

        static {
            final BufferedImage[] image = new BufferedImage[1];
            BufferedImage tmp = new BufferedImage(50, 50, 2);
            DefaultMutableTreeNode root = new DefaultMutableTreeNode();
            root.add(new DefaultMutableTreeNode());
            JTree tree = new JTree(root);
            tree.setRootVisible(true);
            tree.setShowsRootHandles(true);
            tree.setSize(50, 50);
            tree.setUI(new SynthTreeUI(){

                @Override
                protected void drawCentered(Component c, Graphics graphics, Icon icon, int x, int y) {
                    int w = icon.getIconWidth();
                    int h = icon.getIconHeight();
                    image[0] = new BufferedImage(w, h, 2);
                    super.drawCentered(c, image[0].getGraphics(), icon, w / 2, h / 2);
                }
            });
            tree.expandRow(0);
            tree.clearSelection();
            tree.paint(tmp.getGraphics());
            SynthLikeTreeUI.ICONS[0] = new ImageIcon(image[0]);
            tree.expandRow(0);
            tree.setSelectionRow(0);
            tree.paint(tmp.getGraphics());
            SynthLikeTreeUI.ICONS[1] = new ImageIcon(image[0]);
            tree.collapseRow(0);
            tree.clearSelection();
            tree.paint(tmp.getGraphics());
            SynthLikeTreeUI.ICONS[2] = new ImageIcon(image[0]);
            tree.collapseRow(0);
            tree.setSelectionRow(0);
            tree.paint(tmp.getGraphics());
            SynthLikeTreeUI.ICONS[3] = new ImageIcon(image[0]);
        }
    }

    private static class ProfilerTreeTableTree
    extends JTree
    implements TableCellRenderer {
        private int currentX;
        private int currentWidth;
        private int currentRowOffset;
        private boolean currentFirst;
        private boolean currentSelected;
        private boolean customRendering;
        private SynthLikeTreeUI synthLikeUI;
        private final Dimension prefSize = new Dimension();
        private boolean changingModel;

        ProfilerTreeTableTree(SortedFilteredTreeModel model) {
            super(model);
            this.setOpaque(false);
            this.setBorder(BorderFactory.createEmptyBorder());
            this.getSelectionModel().setSelectionMode(1);
            this.setCellRenderer(ProfilerTreeTable.createTreeCellRenderer(new LabelRenderer()));
            this.setLargeModel(true);
        }

        @Override
        public void setUI(TreeUI ui) {
            if (ui instanceof SynthTreeUI) {
                if (this.synthLikeUI == null) {
                    super.setUI(ui);
                    SynthTreeUI synthUI = (SynthTreeUI)ui;
                    int left = synthUI.getLeftChildIndent();
                    int right = synthUI.getRightChildIndent();
                    this.synthLikeUI = new SynthLikeTreeUI();
                    super.setUI(this.synthLikeUI);
                    boolean nimbus = UIUtils.isNimbusLookAndFeel();
                    this.synthLikeUI.setLeftChildIndent(left + (nimbus ? 4 : 6));
                    this.synthLikeUI.setRightChildIndent(right);
                } else {
                    super.setUI(this.synthLikeUI);
                }
            } else {
                super.setUI(ui);
            }
        }

        @Override
        public void validate() {
        }

        @Override
        public void revalidate() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.currentRowOffset = row * this.rowHeight;
            this.currentFirst = column == 0 || this.isFirstColumn(table.getColumnModel(), column);
            this.currentSelected = isSelected;
            Rectangle cellBounds = this.getRowBounds(row);
            this.currentX = cellBounds.x;
            this.currentWidth = cellBounds.width;
            this.customRendering = ((ProfilerTable)table).isCustomRendering();
            if (this.synthLikeUI != null) {
                this.synthLikeUI.setSelected(isSelected);
            }
            return this;
        }

        @Override
        public Dimension getPreferredSize() {
            this.prefSize.setSize(this.currentX + this.currentWidth, this.rowHeight);
            return this.prefSize;
        }

        @Override
        public void paint(Graphics g) {
            g.setColor(this.getBackground());
            int rectX = this.currentSelected || this.customRendering || !this.currentFirst ? 0 : this.currentX;
            g.fillRect(rectX, 0, this.getWidth() - rectX, this.rowHeight);
            g.translate(this.customRendering ? -this.currentX : 0, -this.currentRowOffset);
            super.paint(g);
        }

        private boolean isFirstColumn(TableColumnModel columns, int column) {
            int x = 0;
            for (int i = 0; i < column; ++i) {
                x += columns.getColumn(i).getWidth();
            }
            return x == 0;
        }

        @Override
        public void expandPath(TreePath path) {
            if (this.changingModel) {
                path = this.getSimilarPath(path);
            }
            super.expandPath(path);
        }

        @Override
        public void setSelectionPath(TreePath path) {
            if (this.changingModel) {
                path = this.getSimilarPath(path);
            }
            super.setSelectionPath(path);
        }

        @Override
        public void setSelectionPaths(TreePath[] paths) {
            if (this.changingModel && paths != null) {
                for (int i = 0; i < paths.length; ++i) {
                    paths[i] = this.getSimilarPath(paths[i]);
                }
            }
            super.setSelectionPaths(paths);
        }

        private TreePath getSimilarPath(TreePath oldPath) {
            if (oldPath == null || oldPath.getPathCount() < 1) {
                return null;
            }
            TreeModel currentModel = this.getModel();
            Object currentRoot = currentModel.getRoot();
            if (!currentRoot.equals(oldPath.getPathComponent(0))) {
                return null;
            }
            TreePath p = new TreePath(currentRoot);
            Object[] op = oldPath.getPath();
            Object n = currentRoot;
            for (int i = 1; i < op.length; ++i) {
                Object nn = null;
                for (int ii = 0; ii < currentModel.getChildCount(n); ++ii) {
                    Object c = currentModel.getChild(n, ii);
                    if (!c.equals(op[i])) continue;
                    nn = c;
                    break;
                }
                if (nn == null) {
                    return null;
                }
                n = nn;
                p = p.pathByAddingChild(n);
            }
            return p;
        }

        private void setChangingModel(boolean changing) {
            this.changingModel = changing;
        }

        boolean isChangingModel() {
            return this.changingModel;
        }

        @Override
        public String toString() {
            return this.getCellRenderer().toString();
        }
    }

    private class Adapter
    implements TreeModelListener,
    TreeExpansionListener,
    TreeSelectionListener,
    ListSelectionListener {
        private boolean internal;

        private Adapter() {
        }

        @Override
        public void treeExpanded(TreeExpansionEvent event) {
            this.notifyTable();
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent event) {
            this.notifyTable();
        }

        @Override
        public void treeNodesChanged(TreeModelEvent e) {
            this.notifyTable();
        }

        @Override
        public void treeNodesInserted(TreeModelEvent e) {
            this.notifyTable();
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent e) {
            this.notifyTable();
        }

        @Override
        public void treeStructureChanged(TreeModelEvent e) {
            this.notifyTable();
        }

        private void notifyTable() {
            if (ProfilerTreeTable.this.tree.isChangingModel()) {
                return;
            }
            if (ProfilerTreeTable.this.tree.getClientProperty("expansion_transaction") != null) {
                return;
            }
            TreePath[] selectedPaths = ProfilerTreeTable.this.tree.getSelectionPaths();
            ProfilerTreeTable.this.model.fireTableDataChanged();
            ProfilerTreeTable.this.tree.setSelectionPaths(selectedPaths);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void valueChanged(TreeSelectionEvent e) {
            if (this.internal) {
                return;
            }
            TreePath selected = e.getPath();
            int row = selected == null ? -1 : ProfilerTreeTable.this.tree.getRowForPath(selected);
            try {
                this.internal = true;
                if (row != -1) {
                    ProfilerTreeTable.this.selectRow(row, !ProfilerTreeTable.this.tree.isChangingModel());
                } else {
                    ProfilerTreeTable.this.clearSelection();
                }
            }
            finally {
                this.internal = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (this.internal) {
                return;
            }
            int row = ProfilerTreeTable.this.getSelectedRow();
            try {
                this.internal = true;
                if (row != -1) {
                    ProfilerTreeTable.this.tree.setSelectionRow(row);
                } else {
                    ProfilerTreeTable.this.tree.clearSelection();
                }
                ProfilerTreeTable.this.repaint();
            }
            finally {
                this.internal = false;
            }
        }
    }

    static class UIState {
        private final TreePath[] selectedPaths;
        private final Enumeration<TreePath> expandedPaths;

        UIState(TreePath[] selectedPaths, Enumeration<TreePath> expandedPaths) {
            this.selectedPaths = selectedPaths;
            this.expandedPaths = expandedPaths;
        }

        public TreePath[] getSelectedPaths() {
            return this.selectedPaths;
        }

        public Enumeration getExpandedPaths() {
            return this.expandedPaths;
        }
    }

    private static final class TreePathKey {
        private final TreeNode[] pathToRoot;
        private final int hashCode;

        TreePathKey(TreeNode[] _pathToRoot) {
            this.pathToRoot = _pathToRoot;
            this.hashCode = Arrays.deepHashCode(this.pathToRoot);
        }

        public final int hashCode() {
            return this.hashCode;
        }

        public final boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TreePathKey)) {
                return false;
            }
            TreeNode[] _pathToRoot = ((TreePathKey)o).pathToRoot;
            if (this.pathToRoot.length != _pathToRoot.length) {
                return false;
            }
            for (int i = this.pathToRoot.length - 1; i >= 0; --i) {
                if (this.pathToRoot[i].equals(_pathToRoot[i])) continue;
                return false;
            }
            return true;
        }
    }

    private static class SortedFilteredTreeModel
    extends FilteredTreeModel {
        private Comparator comparator;
        private Map<TreePathKey, int[]> viewToModel;

        SortedFilteredTreeModel(TreeNode root, TreeCellRenderer r, Comparator comp, RowFilter filter) {
            super(root, r, filter);
            this.comparator = comp;
        }

        void setComparator(Comparator comp) {
            this.comparator = comp;
            this.reload();
        }

        Comparator getComparator() {
            return this.comparator;
        }

        @Override
        public Object getChild(Object parent, int index) {
            if (this.comparator == null) {
                return super.getChild(parent, index);
            }
            return super.getChild(parent, this.viewToModel(parent)[index]);
        }

        @Override
        public int getIndexOfChild(Object parent, Object child) {
            if (this.comparator == null) {
                return super.getIndexOfChild(parent, child);
            }
            int index = super.getIndexOfChild(parent, child);
            int[] indexes = this.viewToModel(parent);
            for (int i = 0; i < indexes.length; ++i) {
                if (indexes[i] != index) continue;
                return i;
            }
            return -1;
        }

        @Override
        protected void fireTreeStructureChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
            this.viewToModel = null;
            super.fireTreeStructureChanged(source, path, childIndices, children);
        }

        private int[] viewToModel(Object parent) {
            TreePathKey parentKey;
            int[] indexes;
            if (this.viewToModel == null) {
                this.viewToModel = new HashMap<TreePathKey, int[]>();
            }
            if ((indexes = this.viewToModel.get(parentKey = new TreePathKey(this.getPathToRoot((TreeNode)parent)))) == null) {
                int i;
                Object[] children = new Object[super.getChildCount(parent)];
                for (i = 0; i < children.length; ++i) {
                    children[i] = super.getChild(parent, i);
                }
                Arrays.sort(children, this.comparator);
                indexes = new int[children.length];
                for (i = 0; i < indexes.length; ++i) {
                    indexes[i] = super.getIndexOfChild(parent, children[i]);
                }
                this.viewToModel.put(parentKey, indexes);
            }
            return indexes;
        }
    }

    private static final class FilterEntry
    extends RowFilter.Entry {
        private Object value;
        private Object identifier;

        FilterEntry(Object _value, Object _identifier) {
            this.value = _value;
            this.identifier = _identifier;
        }

        void setContext(Object _value, Object _identifier) {
            this.value = _value;
            this.identifier = _identifier;
        }

        @Override
        public Object getValue(int index) {
            return this.value;
        }

        public Object getModel() {
            return null;
        }

        @Override
        public int getValueCount() {
            return 1;
        }

        public Object getIdentifier() {
            return this.identifier;
        }
    }

    private static class FilteredTreeModel
    extends DefaultTreeModel {
        private TreeCellRenderer renderer;
        private RowFilter filter;
        private Map<TreePathKey, List> cache;

        FilteredTreeModel(TreeNode root, TreeCellRenderer r, RowFilter f) {
            super(root);
            this.renderer = r;
            this.filter = f;
        }

        void setRenderer(TreeCellRenderer r) {
            this.renderer = r;
            this.reload();
        }

        TreeCellRenderer getRenderer() {
            return this.renderer;
        }

        void setFilter(RowFilter f) {
            this.filter = f;
            this.reload();
        }

        RowFilter getFilter() {
            return this.filter;
        }

        @Override
        public Object getChild(Object parent, int index) {
            if (this.renderer == null || this.filter == null) {
                return super.getChild(parent, index);
            }
            return this.filteredChildren(parent).get(index);
        }

        @Override
        public int getIndexOfChild(Object parent, Object child) {
            if (this.renderer == null || this.filter == null) {
                return super.getIndexOfChild(parent, child);
            }
            return this.filteredChildren(parent).indexOf(child);
        }

        @Override
        public int getChildCount(Object parent) {
            if (this.renderer == null || this.filter == null) {
                return super.getChildCount(parent);
            }
            return this.filteredChildren(parent).size();
        }

        @Override
        protected void fireTreeStructureChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
            this.cache = null;
            super.fireTreeStructureChanged(source, path, childIndices, children);
        }

        private List filteredChildren(Object parent) {
            TreeNode tParent;
            TreePathKey parentKey;
            ArrayList<TreeNode> children;
            if (this.cache == null) {
                this.cache = new HashMap<TreePathKey, List>();
            }
            if ((children = this.cache.get(parentKey = new TreePathKey(this.getPathToRoot(tParent = (TreeNode)parent)))) == null) {
                FilterEntry entry = null;
                children = new ArrayList<TreeNode>(tParent.getChildCount());
                CCTNode filtered = null;
                Enumeration<? extends TreeNode> childrenE = tParent.children();
                if (childrenE != null) {
                    while (childrenE.hasMoreElements()) {
                        TreeNode child = childrenE.nextElement();
                        this.renderer.getTreeCellRendererComponent(null, child, false, false, false, -1, false);
                        if (entry == null) {
                            entry = new FilterEntry(this.renderer.toString(), child);
                        } else {
                            entry.setContext(this.renderer.toString(), child);
                        }
                        if (this.filter.include(entry)) {
                            children.add(child);
                            continue;
                        }
                        if (!(parent instanceof CCTNode)) continue;
                        if (filtered == null) {
                            filtered = ((CCTNode)child).createFilteredNode();
                            continue;
                        }
                        filtered.merge((CCTNode)child);
                    }
                }
                if (filtered != null) {
                    List filteredChildren = this.filteredChildren(filtered);
                    if (!((CCTNode)parent).isFiltered()) {
                        children.add((TreeNode)filtered);
                    } else if (!children.isEmpty()) {
                        children.add((TreeNode)filtered);
                    } else {
                        children.addAll(filteredChildren);
                    }
                }
                this.cache.put(parentKey, children);
            }
            return children;
        }
    }

    private static class TableModelImpl
    extends AbstractTableModel {
        private final ProfilerTreeTableTree tree;
        private SortedFilteredTreeModel treeModel;
        private final ProfilerTreeTableModel treeTableModel;

        TableModelImpl(ProfilerTreeTableModel model) {
            this.treeTableModel = model;
            this.treeModel = this.treeModelImpl(model.getRoot(), null, null);
            model.addListener(new ProfilerTreeTableModel.Adapter(){

                @Override
                public void dataChanged() {
                    TableModelImpl.this.fireTableDataChanged();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void rootChanged(TreeNode oldRoot, TreeNode newRoot) {
                    TableModelImpl.this.tree.setChangingModel(true);
                    try {
                        UIState uiState = ProfilerTreeTable.getUIState(TableModelImpl.this.tree);
                        Comparator comparator = TableModelImpl.this.treeModel != null ? TableModelImpl.this.treeModel.getComparator() : null;
                        RowFilter filter = TableModelImpl.this.treeModel != null ? TableModelImpl.this.treeModel.getFilter() : null;
                        TableModelImpl.this.treeModel = TableModelImpl.this.treeModelImpl(newRoot, comparator, filter);
                        TableModelImpl.this.tree.setModel(TableModelImpl.this.treeModel);
                        TableModelImpl.this.fireTableDataChanged();
                        if (uiState != null) {
                            ProfilerTreeTable.restoreUIState(TableModelImpl.this.tree, uiState);
                        }
                    }
                    finally {
                        TableModelImpl.this.tree.setChangingModel(false);
                    }
                }
            });
            this.tree = new ProfilerTreeTableTree(this.treeModel);
        }

        private SortedFilteredTreeModel treeModelImpl(TreeNode root, Comparator comparator, RowFilter filter) {
            return new SortedFilteredTreeModel(root, this.tree == null ? null : this.tree.getCellRenderer(), comparator, filter){

                @Override
                protected void fireTreeStructureChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
                    UIState uiState = TableModelImpl.this.tree == null ? null : ProfilerTreeTable.getUIState(TableModelImpl.this.tree);
                    super.fireTreeStructureChanged(source, path, childIndices, children);
                    if (uiState != null) {
                        ProfilerTreeTable.restoreUIState(TableModelImpl.this.tree, uiState);
                    }
                    TableModelImpl.this.fireTableDataChanged();
                }
            };
        }

        void sort(Comparator comparator) {
            this.treeModel.setComparator(comparator);
        }

        void filter(RowFilter filter) {
            this.treeModel.setFilter(filter);
        }

        RowFilter getFilter() {
            return this.treeModel.getFilter();
        }

        void setRenderer(TreeCellRenderer renderer) {
            this.treeModel.setRenderer(renderer);
        }

        ProfilerTreeTableTree getTree() {
            return this.tree;
        }

        TreeNode nodeForRow(int rowIndex) {
            TreePath path = this.tree.getPathForRow(rowIndex);
            return path == null ? null : (TreeNode)path.getLastPathComponent();
        }

        @Override
        public int getRowCount() {
            return this.tree.getRowCount();
        }

        @Override
        public int getColumnCount() {
            return this.treeTableModel.getColumnCount();
        }

        @Override
        public String getColumnName(int columnIndex) {
            return this.treeTableModel.getColumnName(columnIndex);
        }

        public Class getColumnClass(int columnIndex) {
            return this.treeTableModel.getColumnClass(columnIndex);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return this.treeTableModel.isCellEditable(this.nodeForRow(rowIndex), columnIndex);
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.treeTableModel.getValueAt(this.nodeForRow(rowIndex), columnIndex);
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            this.treeTableModel.setValueAt(aValue, this.nodeForRow(rowIndex), columnIndex);
        }

        Object getValueAt(TreeNode node, int column) {
            return this.treeTableModel.getValueAt(node, column);
        }
    }

    private static class ProfilerTreeTableSorter
    extends ProfilerRowSorter {
        private final TableModelImpl model;
        private List<RowSorter.SortKey> sortKeys;
        private boolean sorting;

        ProfilerTreeTableSorter(TableModel model) {
            super(model);
            this.model = (TableModelImpl)model;
        }

        @Override
        public int convertRowIndexToModel(int index) {
            return index;
        }

        @Override
        public int convertRowIndexToView(int index) {
            return index;
        }

        @Override
        public int getViewRowCount() {
            return this.model.getRowCount();
        }

        @Override
        public int getModelRowCount() {
            return this.model.getRowCount();
        }

        @Override
        public void sort() {
            this.sorting = true;
            super.sort();
            this.sorting = false;
        }

        @Override
        public RowFilter getRowFilter() {
            return this.sorting ? null : super.getRowFilter();
        }

        @Override
        protected void setSortKeysImpl(List newKeys) {
            this.sortKeys = newKeys == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList(newKeys));
            this.model.sort(newKeys == null ? null : this.getComparator());
        }

        @Override
        public List<? extends RowSorter.SortKey> getSortKeys() {
            return this.sortKeys;
        }

        private Comparator getComparator() {
            SortOrder sortOrder = this.getSortOrder();
            if (SortOrder.UNSORTED.equals((Object)sortOrder)) {
                return null;
            }
            final boolean ascending = SortOrder.ASCENDING.equals((Object)sortOrder);
            final int sortColumn = this.getSortColumn();
            boolean sortingTree = JTree.class.equals((Object)this.model.getColumnClass(sortColumn));
            final Comparator<?> comparator = sortingTree ? null : this.getComparator(sortColumn);
            return new Comparator(){

                public int compare(Object o1, Object o2) {
                    int result;
                    if (comparator == null) {
                        String s1 = o1.toString();
                        String s2 = o2.toString();
                        result = s1.compareTo(s2);
                    } else {
                        Object v1 = ProfilerTreeTableSorter.this.model.getValueAt((TreeNode)o1, sortColumn);
                        Object v2 = ProfilerTreeTableSorter.this.model.getValueAt((TreeNode)o2, sortColumn);
                        result = comparator.compare(v1, v2);
                    }
                    return ascending ? result : result * -1;
                }
            };
        }
    }
}

