/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.swing.renderer;

import java.awt.Color;
import java.awt.Font;
import javax.swing.Icon;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.swing.renderer.LabelRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.MultiRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.ProfilerRenderer;

public class NormalBoldGrayRenderer
extends MultiRenderer {
    private final LabelRenderer normalRenderer = new LabelRenderer(true);
    private final LabelRenderer boldRenderer;
    private final LabelRenderer grayRenderer;
    private final ProfilerRenderer[] renderers;

    public NormalBoldGrayRenderer() {
        this.normalRenderer.setMargin(3, 3, 3, 0);
        this.boldRenderer = new LabelRenderer(true);
        this.boldRenderer.setMargin(3, 0, 3, 0);
        Font font = this.boldRenderer.getFont();
        this.boldRenderer.setFont(font.deriveFont(1));
        this.grayRenderer = new LabelRenderer(true){

            @Override
            public void setForeground(Color foreground) {
                if (foreground == null) {
                    foreground = Color.BLACK;
                }
                super.setForeground(UIUtils.getDisabledForeground(foreground));
            }
        };
        this.grayRenderer.setMargin(3, 0, 3, 3);
        this.renderers = new ProfilerRenderer[]{this.normalRenderer, this.boldRenderer, this.grayRenderer};
        this.setOpaque(true);
        this.setHorizontalAlignment(10);
    }

    @Override
    protected ProfilerRenderer[] valueRenderers() {
        return this.renderers;
    }

    protected void setNormalValue(String value) {
        this.normalRenderer.setText(value);
    }

    protected final String getNormalValue() {
        return this.normalRenderer.getText();
    }

    protected void setBoldValue(String value) {
        this.boldRenderer.setText(value);
    }

    protected final String getBoldValue() {
        return this.boldRenderer.getText();
    }

    protected void setGrayValue(String value) {
        this.grayRenderer.setText(value);
    }

    protected final String getGrayValue() {
        return this.grayRenderer.getText();
    }

    protected void setIcon(Icon icon) {
        String text = this.normalRenderer.getText();
        if (text == null || text.isEmpty()) {
            this.normalRenderer.setIcon(null);
            text = this.boldRenderer.getText();
            if (text == null || text.isEmpty()) {
                this.boldRenderer.setIcon(null);
                this.grayRenderer.setIcon(icon);
            } else {
                this.boldRenderer.setIcon(icon);
                this.grayRenderer.setIcon(null);
            }
        } else {
            this.normalRenderer.setIcon(icon);
            this.boldRenderer.setIcon(null);
            this.grayRenderer.setIcon(null);
        }
    }

    @Override
    public String toString() {
        return this.normalRenderer.toString() + this.boldRenderer.toString() + this.grayRenderer.toString();
    }
}

