/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.editors;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.beans.PropertyEditorSupport;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.netbeans.modules.form.NamedPropertyEditor;
import org.openide.awt.Mnemonics;
import org.openide.explorer.propertysheet.editors.XMLPropertyEditor;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class KeyStrokeEditor
extends PropertyEditorSupport
implements XMLPropertyEditor,
NamedPropertyEditor {
    private String TXT_CTRL;
    private String TXT_ALT;
    private String TXT_SHIFT;
    private String TXT_META;
    public static final String XML_KEYSTROKE = "KeyStroke";
    public static final String ATTR_KEY = "key";
    private static String[] _virtualKeys;
    private static final Method keyEvent_getExtendedKeyCode;

    public KeyStrokeEditor() {
        ResourceBundle bundle = NbBundle.getBundle(KeyStrokeEditor.class);
        this.TXT_CTRL = bundle.getString("CTL_CtrlAsText");
        this.TXT_SHIFT = bundle.getString("CTL_ShiftAsText");
        this.TXT_ALT = bundle.getString("CTL_AltAsText");
        this.TXT_META = bundle.getString("CTL_MetaAsText");
    }

    @Override
    public String getJavaInitializationString() {
        KeyStroke key = (KeyStroke)this.getValue();
        int mods = key.getModifiers();
        StringBuilder modsText = new StringBuilder();
        if (0 != (mods & 0xF)) {
            if (0 != (mods & 8)) {
                modsText.append("java.awt.event.InputEvent.ALT_MASK");
            }
            if (0 != (mods & 1)) {
                if (modsText.length() > 0) {
                    modsText.append(" | ");
                }
                modsText.append("java.awt.event.InputEvent.SHIFT_MASK");
            }
            if (0 != (mods & 2)) {
                if (modsText.length() > 0) {
                    modsText.append(" | ");
                }
                modsText.append("java.awt.event.InputEvent.CTRL_MASK");
            }
            if (0 != (mods & 4)) {
                if (modsText.length() > 0) {
                    modsText.append(" | ");
                }
                modsText.append("java.awt.event.InputEvent.META_MASK");
            }
        } else {
            modsText.append("0");
        }
        return "javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent." + KeyStrokeEditor.getVirtualkeyName(key.getKeyCode()) + ", " + modsText.toString() + ")";
    }

    @Override
    public String getAsText() {
        KeyStroke key = (KeyStroke)this.getValue();
        return key != null ? this.keyStrokeAsString(key, true) : "null";
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        if (text == null || "".equals(text) || "null".equals(text)) {
            this.setValue(null);
            return;
        }
        KeyStroke key = this.keyStrokeFromString(text, true);
        if (key == null) {
            throw new IllegalArgumentException("Unrecognized key: " + text);
        }
        this.setValue(key);
    }

    private static String getVirtualkeyName(int keycode) {
        Field[] fields = KeyEvent.class.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field f = fields[i];
            int modifiers = f.getModifiers();
            if (!Modifier.isPublic(modifiers) || !Modifier.isStatic(modifiers) || !Modifier.isFinal(modifiers) || f.getType() != Integer.TYPE || !f.getName().startsWith("VK_")) continue;
            try {
                if (f.getInt(KeyEvent.class) != keycode) continue;
                return f.getName();
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    private KeyStroke keyStrokeFromString(String s, boolean i18ned) {
        String token;
        String meta;
        StringTokenizer st = new StringTokenizer(s, "+");
        int mods = 0;
        int keycode = 0;
        String alt = i18ned ? this.TXT_ALT : "Alt";
        String shift = i18ned ? this.TXT_SHIFT : "Shift";
        String ctrl = i18ned ? this.TXT_CTRL : "Ctrl";
        String string = meta = i18ned ? this.TXT_META : "Meta";
        while (st.hasMoreTokens() && (token = st.nextToken()) != null) {
            if (alt.equalsIgnoreCase(token)) {
                mods |= 8;
                continue;
            }
            if (shift.equalsIgnoreCase(token)) {
                mods |= 1;
                continue;
            }
            if (ctrl.equalsIgnoreCase(token)) {
                mods |= 2;
                continue;
            }
            if (meta.equalsIgnoreCase(token)) {
                mods |= 4;
                continue;
            }
            String keycodeName = "VK_" + token.toUpperCase();
            try {
                keycode = KeyEvent.class.getField(keycodeName).getInt(KeyEvent.class);
            }
            catch (Exception e) {}
        }
        if (keycode != 0) {
            return KeyStroke.getKeyStroke(keycode, mods);
        }
        return null;
    }

    private String keyStrokeAsString(KeyStroke key, boolean i18ned) {
        String alt = i18ned ? this.TXT_ALT : "Alt";
        String shift = i18ned ? this.TXT_SHIFT : "Shift";
        String ctrl = i18ned ? this.TXT_CTRL : "Ctrl";
        String meta = i18ned ? this.TXT_META : "Meta";
        StringBuilder buf = new StringBuilder();
        int mods = key.getModifiers();
        int[] modMasks = new int[]{1, 2, 8, 4};
        String[] modMaskStrings = new String[]{shift, ctrl, alt, meta};
        for (int i = 0; i < modMasks.length; ++i) {
            if ((mods & modMasks[i]) == 0) continue;
            buf.append(modMaskStrings[i]);
            buf.append("+");
        }
        String keyName = KeyStrokeEditor.getVirtualkeyName(key.getKeyCode());
        if (keyName != null) {
            buf.append(keyName.substring(3));
        }
        return buf.toString();
    }

    public void readFromXML(Node element) throws IOException {
        if (!XML_KEYSTROKE.equals(element.getNodeName())) {
            throw new IOException();
        }
        NamedNodeMap attributes = element.getAttributes();
        try {
            String value = attributes.getNamedItem(ATTR_KEY).getNodeValue();
            KeyStroke key = this.keyStrokeFromString(value, false);
            if (key == null) {
                throw new IllegalArgumentException();
            }
            this.setValue(key);
        }
        catch (Exception e) {
            throw new IOException();
        }
    }

    public Node storeToXML(Document doc) {
        KeyStroke key = (KeyStroke)this.getValue();
        String str = key != null ? this.keyStrokeAsString(key, false) : "null";
        Element el = doc.createElement(XML_KEYSTROKE);
        el.setAttribute(ATTR_KEY, str);
        return el;
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Component getCustomEditor() {
        return new CustomEditor();
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getBundle(this.getClass()).getString("CTL_KeyStrokeEditor_DisplayName");
    }

    static KeyStroke createKeyStroke(KeyEvent e) {
        int code = e.getKeyCode();
        if (keyEvent_getExtendedKeyCode != null) {
            try {
                int ecode = (Integer)keyEvent_getExtendedKeyCode.invoke((Object)e, new Object[0]);
                if (ecode != 0) {
                    code = ecode;
                }
            }
            catch (IllegalAccessException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (IllegalArgumentException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (InvocationTargetException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return KeyStroke.getKeyStroke(code, e.getModifiers());
    }

    static /* synthetic */ String[] access$202(String[] x0) {
        _virtualKeys = x0;
        return x0;
    }

    static {
        Class<KeyEvent> eventClass = KeyEvent.class;
        Method m = null;
        try {
            m = eventClass.getMethod("getExtendedKeyCode", new Class[0]);
        }
        catch (NoSuchMethodException ex) {
        }
        catch (SecurityException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        keyEvent_getExtendedKeyCode = m;
    }

    private class CustomEditor
    extends JPanel {
        private KeyGrabberField _keyGrabber;
        private JCheckBox _ctrl;
        private JCheckBox _alt;
        private JCheckBox _shift;
        private JCheckBox _meta;
        private JComboBox _virtualKey;

        CustomEditor() {
            this.setLayout(new GridBagLayout());
            ResourceBundle bundle = NbBundle.getBundle(KeyStrokeEditor.class);
            JLabel virtualKeyLabel = new JLabel();
            Mnemonics.setLocalizedText((JLabel)virtualKeyLabel, (String)bundle.getString("CTL_VirtualKey"));
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.anchor = 17;
            gbc.fill = 0;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            gbc.insets = new Insets(12, 12, 5, 12);
            this.add((Component)virtualKeyLabel, gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            gbc.insets = new Insets(12, 0, 5, 11);
            this._virtualKey = new JComboBox();
            this.add(this._virtualKey, gbc);
            this._virtualKey.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_VirtualKey"));
            JPanel panel = new JPanel(new FlowLayout(0, 6, 0));
            this._ctrl = new JCheckBox();
            Mnemonics.setLocalizedText((AbstractButton)this._ctrl, (String)bundle.getString("CTL_Ctrl"));
            this._ctrl.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_CtrlKey"));
            panel.add(this._ctrl);
            this._alt = new JCheckBox();
            Mnemonics.setLocalizedText((AbstractButton)this._alt, (String)bundle.getString("CTL_Alt"));
            this._alt.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_AltKey"));
            panel.add(this._alt);
            this._shift = new JCheckBox();
            Mnemonics.setLocalizedText((AbstractButton)this._shift, (String)bundle.getString("CTL_Shift"));
            this._shift.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_ShiftKey"));
            panel.add(this._shift);
            this._meta = new JCheckBox();
            Mnemonics.setLocalizedText((AbstractButton)this._meta, (String)bundle.getString("CTL_Meta"));
            this._meta.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_MetaKey"));
            panel.add(this._meta);
            virtualKeyLabel.setLabelFor(this._virtualKey);
            gbc = new GridBagConstraints();
            gbc.gridx = 2;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.fill = 0;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            gbc.insets = new Insets(12, 0, 5, 12);
            this.add((Component)panel, gbc);
            JLabel keyStrokeLabel = new JLabel();
            Mnemonics.setLocalizedText((JLabel)keyStrokeLabel, (String)bundle.getString("CTL_KeyStroke"));
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.gridwidth = 1;
            gbc.anchor = 17;
            gbc.fill = 0;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            gbc.insets = new Insets(0, 12, 0, 12);
            this.add((Component)keyStrokeLabel, gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 1;
            gbc.gridwidth = 2;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            gbc.insets = new Insets(0, 0, 0, 11);
            this._keyGrabber = new KeyGrabberField();
            this.add((Component)this._keyGrabber, gbc);
            this._keyGrabber.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_KeyStroke"));
            keyStrokeLabel.setLabelFor(this._keyGrabber);
            this._keyGrabber.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    KeyStrokeEditor.this.setAsText(CustomEditor.this._keyGrabber.getText());
                }
            });
            this.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_KeyStrokeCustomEditor"));
            if (_virtualKeys == null) {
                int i;
                ArrayList<String> list = new ArrayList<String>();
                Field[] fields = KeyEvent.class.getDeclaredFields();
                for (i = 0; i < fields.length; ++i) {
                    Field f = fields[i];
                    int modifiers = f.getModifiers();
                    if (!Modifier.isPublic(modifiers) || !Modifier.isStatic(modifiers) || !Modifier.isFinal(modifiers) || f.getType() != Integer.TYPE || !f.getName().startsWith("VK_")) continue;
                    list.add(f.getName());
                }
                KeyStrokeEditor.access$202(new String[list.size()]);
                for (i = 0; i < list.size(); ++i) {
                    _virtualKeys[i] = (String)list.get(i);
                }
            }
            this._virtualKey.addItem("");
            for (int i = 0; i < _virtualKeys.length; ++i) {
                this._virtualKey.addItem(_virtualKeys[i]);
            }
            KeyStroke key = (KeyStroke)KeyStrokeEditor.this.getValue();
            if (key != null) {
                this.setKeyStroke(key);
            }
            ItemListener il = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    CustomEditor.this.virtualKeyChanged();
                }
            };
            this._virtualKey.addItemListener(il);
            this._ctrl.addItemListener(il);
            this._alt.addItemListener(il);
            this._shift.addItemListener(il);
            this._meta.addItemListener(il);
        }

        Component getKeyGrabber() {
            return this._keyGrabber;
        }

        private void setKeyStroke(KeyStroke key) {
            this._ctrl.setSelected(0 != (2 & key.getModifiers()));
            this._alt.setSelected(0 != (8 & key.getModifiers()));
            this._shift.setSelected(0 != (1 & key.getModifiers()));
            this._meta.setSelected(0 != (4 & key.getModifiers()));
            int keycode = key.getKeyCode();
            String keyName = KeyStrokeEditor.getVirtualkeyName(keycode);
            if (keyName != null) {
                this._virtualKey.setSelectedItem(keyName);
                this._keyGrabber.setText(KeyStrokeEditor.this.getAsText());
            }
        }

        private void virtualKeyChanged() {
            String keyName = (String)this._virtualKey.getSelectedItem();
            if ("".equals(keyName)) {
                this._keyGrabber.setText("");
                KeyStrokeEditor.this.setValue(null);
                return;
            }
            try {
                Field f = KeyEvent.class.getDeclaredField(keyName);
                int keycode = f.getInt(KeyEvent.class);
                int mods = 0;
                if (this._ctrl.isSelected()) {
                    mods |= 2;
                }
                if (this._shift.isSelected()) {
                    mods |= 1;
                }
                if (this._alt.isSelected()) {
                    mods |= 8;
                }
                if (this._meta.isSelected()) {
                    mods |= 4;
                }
                KeyStrokeEditor.this.setValue(KeyStroke.getKeyStroke(keycode, mods));
                this._keyGrabber.setText(KeyStrokeEditor.this.getAsText());
            }
            catch (NoSuchFieldException ex) {
                ex.printStackTrace();
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
            }
        }

        private class KeyGrabberField
        extends JTextField {
            private KeyGrabberField() {
            }

            @Override
            protected void processKeyEvent(KeyEvent e) {
                if (e.getKeyCode() == 9) {
                    super.processKeyEvent(e);
                } else if (e.getID() == 401) {
                    int keycode = e.getKeyCode();
                    if (keycode != 17 && keycode != 18 && keycode != 16 && keycode != 157) {
                        KeyStroke key = KeyStrokeEditor.createKeyStroke(e);
                        CustomEditor.this.setKeyStroke(key);
                    }
                    e.consume();
                }
            }
        }
    }
}

