/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.codegen.model;

import java.util.List;
import javax.xml.namespace.QName;
import org.netbeans.modules.websvc.saas.codegen.util.Util;
import org.netbeans.modules.websvc.saas.model.wadl.Option;

public class ParameterInfo {
    private String id;
    private String name;
    private Class type;
    private String typeName;
    private Object defaultValue;
    private QName qname;
    private ParamStyle style;
    private List<Option> option;
    private boolean required;
    private boolean repeating;
    private String fixed;
    private boolean isApiKey;
    private boolean isSessionKey;

    public ParameterInfo(String name, Class type) {
        this(name, type, null);
    }

    public ParameterInfo(QName qname, Class type, String typeName) {
        this(qname.getLocalPart(), type, typeName);
        this.qname = qname;
    }

    public ParameterInfo(String name, Class type, String typeName) {
        this.name = name;
        this.type = type;
        this.typeName = typeName;
        this.defaultValue = null;
        this.style = ParameterInfo.isQualifiedParameterType(type) ? ParamStyle.QUERY : ParamStyle.UNKNOWN;
    }

    private static boolean isQualifiedParameterType(Class type) {
        return type.isPrimitive() || type.equals(String.class) || Util.getValueOfMethod(type) != null || Util.getConstructorWithStringParam(type) != null;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public QName getQName() {
        if (this.qname == null) {
            this.qname = new QName(this.name);
        }
        return this.qname;
    }

    public Class getType() {
        return this.type;
    }

    public String getTypeName() {
        if (this.typeName == null) {
            return this.type.getName();
        }
        return this.typeName;
    }

    public String getSimpleTypeName() {
        return this.type.getSimpleName();
    }

    public boolean isApiKey() {
        return this.isApiKey;
    }

    public void setIsApiKey(boolean isApiKey) {
        this.isApiKey = isApiKey;
    }

    public boolean isSessionKey() {
        return this.isSessionKey;
    }

    public void setIsSessionKey(boolean isSessionKey) {
        this.isSessionKey = isSessionKey;
    }

    public void setDefaultValue(Object value) {
        this.defaultValue = value;
    }

    public Object getDefaultValue() {
        if (this.defaultValue == null) {
            this.defaultValue = this.generateDefaultValue();
        }
        return this.defaultValue;
    }

    public String getFixed() {
        return this.fixed;
    }

    public void setFixed(String fixed) {
        this.fixed = fixed;
    }

    public boolean isRepeating() {
        return this.repeating;
    }

    public void setIsRepeating(boolean repeating) {
        this.repeating = repeating;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setIsRequired(boolean required) {
        this.required = required;
    }

    public List<Option> getOption() {
        return this.option;
    }

    public void setOption(List<Option> option) {
        this.option = option;
    }

    public ParamStyle getStyle() {
        return this.style;
    }

    public void setStyle(ParamStyle style) {
        this.style = style;
    }

    public boolean isFixed() {
        return this.getFixed() != null;
    }

    private Object generateDefaultValue() {
        if (this.type == Integer.class || this.type == Integer.TYPE) {
            return new Integer(0);
        }
        if (this.type == Short.class || this.type == Short.TYPE) {
            return new Short(0);
        }
        if (this.type == Long.class || this.type == Long.TYPE) {
            return new Long(0L);
        }
        if (this.type == Float.class || this.type == Float.TYPE) {
            return new Float(0.0f);
        }
        if (this.type == Double.class || this.type == Double.TYPE) {
            return new Double(0.0);
        }
        if (this.type == Boolean.class || this.type == Boolean.TYPE) {
            return Boolean.FALSE;
        }
        if (this.type == Character.class || this.type == Character.TYPE) {
            return new Character('\u0000');
        }
        return null;
    }

    public static enum ParamFilter {
        FIXED("fixed");

        private String value;

        private ParamFilter(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }

        public static ParamStyle fromValue(String v) {
            for (ParamStyle c : ParamStyle.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }
    }

    public static enum ParamStyle {
        UNKNOWN(""),
        PLAIN("plain"),
        TEMPLATE("template"),
        MATRIX("matrix"),
        HEADER("header"),
        QUERY("query");

        private String value;

        private ParamStyle(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }

        public static ParamStyle fromValue(String v) {
            for (ParamStyle c : ParamStyle.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }
    }
}

