/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import java.util.Deque;
import java.util.LinkedList;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.hints.StopProcessing;

public class SideEffectVisitor
extends TreePathScanner {
    private int nestingLevel;
    private int invocationChainLevel;
    private final boolean nonLocals;
    private final CompilationInfo ci;
    private Deque<TypeElement> enclosingElements = new LinkedList<TypeElement>();
    private Tree invocationTree;

    public SideEffectVisitor(CompilationInfo ci) {
        this.ci = ci;
        this.nonLocals = false;
    }

    public SideEffectVisitor(CompilationInfo ci, boolean nonLocals) {
        this.ci = ci;
        this.nonLocals = false;
    }

    @Override
    public Object visitUnary(UnaryTree node, Object p) {
        switch (node.getKind()) {
            case POSTFIX_DECREMENT: 
            case POSTFIX_INCREMENT: 
            case PREFIX_DECREMENT: 
            case PREFIX_INCREMENT: {
                break;
            }
            default: {
                return super.visitUnary(node, p);
            }
        }
        this.checkVariableAccess(node.getExpression(), node);
        return super.visitUnary(node, p);
    }

    @Override
    public Object visitCompoundAssignment(CompoundAssignmentTree node, Object p) {
        this.checkVariableAccess(node.getVariable(), node.getVariable());
        return super.visitCompoundAssignment(node, p);
    }

    private void checkVariableAccess(Tree checkVar, Tree subNode) {
        Element x;
        Element el;
        if (this.nestingLevel == 0) {
            this.stop(subNode);
        }
        if ((el = this.ci.getTrees().getElement(checkVar == this.getCurrentPath().getLeaf() ? this.getCurrentPath() : new TreePath(this.getCurrentPath(), checkVar))) != null && el.getKind() == ElementKind.FIELD && !this.enclosingElements.contains(x = el.getEnclosingElement())) {
            this.stop(subNode);
        }
    }

    @Override
    public Object visitAssignment(AssignmentTree node, Object p) {
        this.checkVariableAccess(node.getVariable(), node.getVariable());
        return super.visitAssignment(node, p);
    }

    private void stop(Tree node) {
        throw new StopProcessing(this.invocationTree != null ? this.invocationTree : node);
    }

    @Override
    public Object visitClass(ClassTree node, Object p) {
        Element e = this.ci.getTrees().getElement(this.getCurrentPath());
        Object r = this.scan(node.getModifiers(), p);
        r = this.scanAndReduce(node.getTypeParameters(), p, r);
        r = this.scanAndReduce(node.getExtendsClause(), p, r);
        r = this.scanAndReduce(node.getImplementsClause(), p, r);
        ++this.nestingLevel;
        this.enclosingElements.push((TypeElement)e);
        r = this.scanAndReduce(node.getMembers(), p, r);
        --this.nestingLevel;
        this.enclosingElements.pop();
        return r;
    }

    @Override
    public Object visitNewClass(NewClassTree node, Object p) {
        Element e = this.ci.getTrees().getElement(this.getCurrentPath()).getEnclosingElement();
        if (e != null && e.getKind().isClass()) {
            Object r = this.scan(node.getEnclosingExpression(), p);
            r = this.scanAndReduce(node.getIdentifier(), p, r);
            r = this.scanAndReduce(node.getTypeArguments(), p, r);
            r = this.scanAndReduce(node.getArguments(), p, r);
            ++this.nestingLevel;
            this.enclosingElements.push((TypeElement)e);
            r = this.scanAndReduce(node.getClassBody(), p, r);
            --this.nestingLevel;
            this.enclosingElements.pop();
            return r;
        }
        return super.visitNewClass(node, p);
    }

    @Override
    public Object visitMemberSelect(MemberSelectTree node, Object p) {
        String s = node.getExpression().toString();
        Name id = node.getIdentifier();
        if (id.contentEquals("this") || id.contentEquals("super")) {
            return Boolean.TRUE;
        }
        if (s.endsWith("this") || s.endsWith("super")) {
            return Boolean.TRUE;
        }
        return node;
    }

    @Override
    public Object visitMethodInvocation(MethodInvocationTree node, Object p) {
        Object r = this.scan(node.getArguments(), p);
        Object x = this.scan(node.getMethodSelect(), p);
        if (x instanceof Tree && this.nonLocals) {
            this.stop((Tree)x);
        }
        Object o = this.reduce(r, x);
        Element e = this.ci.getTrees().getElement(this.getCurrentPath());
        if (e != null && e.getKind() != ElementKind.METHOD) {
            return o;
        }
        if (this.invocationChainLevel > 0) {
            return o;
        }
        ExecutableElement el = (ExecutableElement)e;
        TreePath target = this.ci.getTrees().getPath(el);
        if (target != null) {
            ++this.invocationChainLevel;
            ++this.nestingLevel;
            this.invocationTree = node;
            this.scan(target, null);
            this.invocationTree = null;
            --this.nestingLevel;
            --this.invocationChainLevel;
        }
        return o;
    }

    private Object scanAndReduce(Tree node, Object p, Object r) {
        return this.reduce(this.scan(node, p), r);
    }

    private Object scanAndReduce(Iterable<? extends Tree> nodes, Object p, Object r) {
        return this.reduce(this.scan(nodes, p), r);
    }
}

