/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.introduce;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeKind;
import javax.swing.JButton;
import org.netbeans.api.java.source.CodeStyle;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.StopProcessing;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.introduce.InstanceRefFinder;
import org.netbeans.modules.java.hints.introduce.IntroduceFieldFix;
import org.netbeans.modules.java.hints.introduce.IntroduceFieldPanel;
import org.netbeans.modules.java.hints.introduce.IntroduceHint;
import org.netbeans.modules.java.hints.introduce.IntroduceKind;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class IntroduceConstantFix
extends IntroduceFieldFix {
    static TreePath findAcceptableConstantTarget(CompilationInfo info, TreePath from) {
        boolean compileTimeConstant = info.getTreeUtilities().isCompileTimeConstantExpression(from);
        while (from != null) {
            if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)from.getLeaf().getKind())) {
                if (from.getParentPath().getLeaf().getKind() == Tree.Kind.COMPILATION_UNIT) {
                    return from;
                }
                if (compileTimeConstant || ((ClassTree)from.getLeaf()).getModifiers().getFlags().contains((Object)Modifier.STATIC)) {
                    return from;
                }
            }
            from = from.getParentPath();
        }
        return null;
    }

    @Override
    public String getText() {
        return NbBundle.getMessage(IntroduceConstantFix.class, (String)"FIX_IntroduceConstant");
    }

    static IntroduceFieldFix createConstant(TreePath resolved, CompilationInfo info, TreePath value, String guessedName, int numDuplicates, int offset, boolean variableRewrite, AtomicBoolean cancel) {
        String varName;
        TreePath constantTarget;
        CodeStyle cs = CodeStyle.getDefault((FileObject)info.getFileObject());
        boolean isConstant = IntroduceConstantFix.checkConstantExpression(info, value);
        TreePath treePath = constantTarget = isConstant ? IntroduceConstantFix.findAcceptableConstantTarget(info, resolved) : null;
        if (!isConstant || constantTarget == null || cancel.get()) {
            return null;
        }
        TreePathHandle h = TreePathHandle.create((TreePath)resolved, (CompilationInfo)info);
        if (variableRewrite) {
            varName = guessedName;
        } else {
            String proposed = Utilities.toConstantName(guessedName);
            varName = Utilities.makeNameUnique(info, info.getTrees().getScope(constantTarget), proposed, cs.getStaticFieldNamePrefix(), cs.getStaticFieldNameSuffix());
        }
        ClassTree clazz = (ClassTree)constantTarget.getLeaf();
        IntroduceConstantFix fix = new IntroduceConstantFix(h, info.getJavaSource(), varName, numDuplicates, offset);
        fix.setTargetIsInterface(clazz.getKind() == Tree.Kind.INTERFACE);
        return fix;
    }

    static boolean checkConstantExpression(final CompilationInfo info, TreePath path) {
        InstanceRefFinder finder = new InstanceRefFinder(info, path){

            @Override
            public Object visitIdentifier(IdentifierTree node, Object p) {
                Element el = info.getTrees().getElement(this.getCurrentPath());
                if (el == null || el.asType() == null || el.asType().getKind() == TypeKind.ERROR) {
                    return null;
                }
                if (el.getKind() == ElementKind.LOCAL_VARIABLE || el.getKind() == ElementKind.PARAMETER) {
                    throw new StopProcessing();
                }
                if (el.getKind() == ElementKind.FIELD && !el.getModifiers().contains((Object)Modifier.FINAL)) {
                    throw new StopProcessing();
                }
                return super.visitIdentifier(node, p);
            }
        };
        try {
            finder.process();
            return !finder.containsInstanceReferences() && !finder.containsLocalReferences() && !finder.containsReferencesToSuper();
        }
        catch (StopProcessing e) {
            return false;
        }
    }

    public IntroduceConstantFix(TreePathHandle handle, JavaSource js, String guessedName, int numDuplicates, int offset) {
        super(handle, js, guessedName, numDuplicates, null, true, true, offset, true);
    }

    @Override
    public String toString() {
        return "[IntroduceFix:" + this.guessedName + ":" + this.duplicatesCount + ":" + (Object)((Object)IntroduceKind.CREATE_CONSTANT) + "]";
    }

    @Override
    protected String getCaption() {
        return NbBundle.getMessage(IntroduceHint.class, (String)"CAP_IntroduceConstant");
    }

    @Override
    protected IntroduceFieldPanel createPanel(JButton btnOk) {
        return new IntroduceFieldPanel(this.guessedName, null, this.duplicatesCount, true, this.handle.getKind() == Tree.Kind.VARIABLE, 1, "introduceField", btnOk);
    }

    @Override
    protected TreePath findTargetClass(WorkingCopy copy, TreePath resolved) {
        return IntroduceConstantFix.findAcceptableConstantTarget((CompilationInfo)copy, resolved);
    }
}

