/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.jdk.mapreduce;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import javax.lang.model.SourceVersion;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.hints.jdk.mapreduce.Bundle;
import org.netbeans.modules.java.hints.jdk.mapreduce.PreconditionsChecker;
import org.netbeans.modules.java.hints.jdk.mapreduce.Refactorer;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;

public class ForLoopToFunctionalHint {
    static boolean DISABLE_CHECK_FOR_STREAM = false;

    public static ErrorDescription computeWarning(HintContext ctx) {
        if (ctx.getInfo().getSourceVersion().compareTo(SourceVersion.RELEASE_8) < 0) {
            return null;
        }
        if (ctx.getInfo().getElements().getTypeElement("java.util.stream.Streams") == null && !DISABLE_CHECK_FOR_STREAM) {
            return null;
        }
        PreconditionsChecker pc = new PreconditionsChecker(ctx.getPath().getLeaf(), ctx.getInfo());
        if (pc.isSafeToRefactor().booleanValue()) {
            BlockTree bt;
            EnhancedForLoopTree eflt = (EnhancedForLoopTree)ctx.getPath().getLeaf();
            StatementTree stmt = eflt.getStatement();
            if (stmt == null) {
                return null;
            }
            if (stmt.getKind() == Tree.Kind.BLOCK && ((bt = (BlockTree)stmt).getStatements() == null || bt.getStatements().isEmpty())) {
                return null;
            }
            Fix fix = new FixImpl(ctx.getInfo(), ctx.getPath(), null).toEditorFix();
            return ErrorDescriptionFactory.forName((HintContext)ctx, (TreePath)ctx.getPath(), (String)Bundle.ERR_ForLoopToFunctionalHint(), (Fix[])new Fix[]{fix});
        }
        return null;
    }

    private static final class FixImpl
    extends JavaFix {
        private PreconditionsChecker pc;
        private Refactorer refactorer;

        public FixImpl(CompilationInfo info, TreePath tp, PreconditionsChecker pc) {
            super(info, tp);
            this.pc = pc;
        }

        protected String getText() {
            return Bundle.FIX_ForLoopToFunctionalHint();
        }

        protected void performRewrite(JavaFix.TransformationContext ctx) {
            EnhancedForLoopTree loop = (EnhancedForLoopTree)ctx.getPath().getLeaf();
            this.pc = new PreconditionsChecker(loop, (CompilationInfo)ctx.getWorkingCopy());
            this.refactorer = new Refactorer(loop, ctx.getWorkingCopy(), this.pc);
            if (this.pc.isSafeToRefactor().booleanValue() && this.refactorer.isRefactorable().booleanValue()) {
                ctx.getWorkingCopy().rewrite(ctx.getPath().getLeaf(), (Tree)this.refactorer.refactor(ctx.getWorkingCopy().getTreeMaker()));
            }
        }
    }
}

