/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.disk.index;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.netbeans.modules.cnd.repository.disk.index.ChunkInfo;
import org.netbeans.modules.cnd.repository.disk.index.FileIndex;
import org.netbeans.modules.cnd.repository.impl.spi.LayerKey;

class SynchronizedFileIndex
implements FileIndex {
    private final FileIndex delegate;
    private final ReadWriteLock indexLock = new ReentrantReadWriteLock();

    public SynchronizedFileIndex(FileIndex delegate) {
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        this.indexLock.readLock().lock();
        try {
            int n = this.delegate.size();
            return n;
        }
        finally {
            this.indexLock.readLock().unlock();
        }
    }

    @Override
    public Iterator<LayerKey> getKeySetIterator() {
        return new SyncRemoveIterator<LayerKey>(this.delegate.getKeySetIterator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<LayerKey> keySet() {
        this.indexLock.readLock().lock();
        try {
            ArrayList<LayerKey> arrayList = new ArrayList<LayerKey>(this.delegate.keySet());
            return arrayList;
        }
        finally {
            this.indexLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int put(LayerKey key, long offset, int size) {
        this.indexLock.writeLock().lock();
        try {
            int n = this.delegate.put(key, offset, size);
            return n;
        }
        finally {
            this.indexLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int remove(LayerKey key) {
        this.indexLock.writeLock().lock();
        try {
            int n = this.delegate.remove(key);
            return n;
        }
        finally {
            this.indexLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChunkInfo get(LayerKey key) {
        this.indexLock.readLock().lock();
        try {
            ChunkInfo chunkInfo = this.delegate.get(key);
            return chunkInfo;
        }
        finally {
            this.indexLock.readLock().unlock();
        }
    }

    private class SyncRemoveIterator<K>
    implements Iterator<K> {
        Iterator<K> delegate;

        SyncRemoveIterator(Iterator<K> delegate) {
            this.delegate = delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            SynchronizedFileIndex.this.indexLock.writeLock().lock();
            try {
                this.delegate.remove();
            }
            finally {
                SynchronizedFileIndex.this.indexLock.writeLock().unlock();
            }
        }

        @Override
        public K next() {
            return this.delegate.next();
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }
    }
}

