/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.storage;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import org.netbeans.modules.cnd.repository.Logger;
import org.netbeans.modules.cnd.repository.api.FilePath;
import org.netbeans.modules.cnd.repository.api.Repository;
import org.netbeans.modules.cnd.repository.api.RepositoryException;
import org.netbeans.modules.cnd.repository.api.RepositoryExceptions;
import org.netbeans.modules.cnd.repository.api.UnitDescriptor;
import org.netbeans.modules.cnd.repository.impl.spi.FSConverter;
import org.netbeans.modules.cnd.repository.impl.spi.FilePathConverter;
import org.netbeans.modules.cnd.repository.impl.spi.Layer;
import org.netbeans.modules.cnd.repository.impl.spi.LayerConvertersProvider;
import org.netbeans.modules.cnd.repository.impl.spi.LayerDescriptor;
import org.netbeans.modules.cnd.repository.impl.spi.LayerFactory;
import org.netbeans.modules.cnd.repository.impl.spi.LayerKey;
import org.netbeans.modules.cnd.repository.impl.spi.LayerListener;
import org.netbeans.modules.cnd.repository.impl.spi.LayeringSupport;
import org.netbeans.modules.cnd.repository.impl.spi.ReadLayerCapability;
import org.netbeans.modules.cnd.repository.impl.spi.UnitDescriptorsList;
import org.netbeans.modules.cnd.repository.impl.spi.UnitsConverter;
import org.netbeans.modules.cnd.repository.impl.spi.WriteLayerCapability;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.spi.Persistent;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.storage.FilePathsDictionary;
import org.netbeans.modules.cnd.repository.storage.FilePathsDictionaryKey;
import org.netbeans.modules.cnd.repository.storage.FileSystemsDictionary;
import org.netbeans.modules.cnd.repository.storage.RepositoryMapper;
import org.netbeans.modules.cnd.repository.storage.UnitDescriptorsDictionary;
import org.netbeans.modules.cnd.repository.storage.data.RepositoryDataInputStream;
import org.netbeans.modules.cnd.repository.storage.data.RepositoryDataOutputStream;
import org.netbeans.modules.cnd.repository.testbench.Stats;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.openide.filesystems.FileSystem;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

final class Storage {
    private static boolean PRINT_STACK_FILES = CndUtils.getBoolean((String)"cnd.repository.print.stack.wrong.file", (boolean)true);
    private static boolean UnitIDReadConverterImpl_layer_to_client = CndUtils.getBoolean((String)"cnd.repository.print.stack.wrong.units.layer_to_client", (boolean)true);
    private static boolean UnitIDWriteConverterImpl_client_to_layer = CndUtils.getBoolean((String)"cnd.repository.print.stack.wrong.units.client_to_layer", (boolean)true);
    private static final java.util.logging.Logger LOG = java.util.logging.Logger.getLogger("repository.support.filecreate.logger");
    private final List<Layer> layers;
    private final List<LayerDescriptor> layerDescriptors;
    private final FileSystemsDictionary clientFileSystemsDictionary = new FileSystemsDictionary();
    private final UnitDescriptorsDictionary clientUnitDescriptorsDictionary = new UnitDescriptorsDictionary();
    private final Map<Integer, FilePathsDictionary> filePathDictionaries = new HashMap<Integer, FilePathsDictionary>();
    private final ConcurrentMap<LayerDescriptor, Map<Integer, Integer>> fileSystemsTranslationMap = new ConcurrentHashMap<LayerDescriptor, Map<Integer, Integer>>();
    private final ConcurrentMap<LayerDescriptor, Map<Integer, Integer>> unitsTranslationMap = new ConcurrentHashMap<LayerDescriptor, Map<Integer, Integer>>();
    private final UnitsConverter storageMask;
    private final ReentrantLock storageLock = new ReentrantLock();
    private final int storageID;
    private final LayeringSupportImpl layeringSupport;
    private static final java.util.logging.Logger log = Logger.getInstance();

    Storage(int persistMechanismVersion, int storageID, List<LayerDescriptor> layerDescriptors, UnitsConverter unitIDConverter) {
        assert (layerDescriptors != null);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "New storage with storageID == {0} created", new Object[]{storageID, unitIDConverter});
        }
        this.layeringSupport = new LayeringSupportImpl();
        this.storageID = storageID;
        this.storageMask = unitIDConverter;
        Collection lst = Lookups.forPath((String)"CND/RepositoryLayerListener").lookupAll(LayerListener.class);
        this.layers = Collections.unmodifiableList(this.createLayers(layerDescriptors, this.layeringSupport, lst, persistMechanismVersion));
        assert (this.layers != null);
        ArrayList<LayerDescriptor> descriptors = new ArrayList<LayerDescriptor>();
        for (Layer layer : this.layers) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Layer added: {0}", new Object[]{layer.getLayerDescriptor()});
            }
            descriptors.add(layer.getLayerDescriptor());
        }
        this.layerDescriptors = Collections.unmodifiableList(descriptors);
    }

    public int getUnitID(UnitDescriptor clientUnitDescriptor) {
        if (this.clientUnitDescriptorsDictionary.contains(clientUnitDescriptor)) {
            return this.storageMask.layerToClient(this.clientUnitDescriptorsDictionary.getUnitID(clientUnitDescriptor));
        }
        int clientShortUnitID = this.clientUnitDescriptorsDictionary.getUnitID(clientUnitDescriptor);
        FileSystem clientFileSystem = clientUnitDescriptor.getFileSystem();
        int clientFileSystemID = this.clientFileSystemsDictionary.getFileSystemID(clientFileSystem);
        for (Layer layer : this.layers) {
            Map prev;
            LayerDescriptor ld = layer.getLayerDescriptor();
            Map<Integer, Integer> map = (ConcurrentHashMap<Integer, Integer>)this.fileSystemsTranslationMap.get(ld);
            if (map == null && (prev = (Map)this.fileSystemsTranslationMap.putIfAbsent(ld, map = new ConcurrentHashMap<Integer, Integer>())) != null) {
                map = prev;
            }
            if (map.containsKey(clientFileSystemID)) continue;
            int matchedFileSystemIndexInLayer = layer.findMatchedFileSystemIndexInLayer(clientFileSystem);
            if (matchedFileSystemIndexInLayer < 0 && layer.getWriteCapability() != null) {
                matchedFileSystemIndexInLayer = layer.getWriteCapability().registerClientFileSystem(clientFileSystem);
            }
            map.put(clientFileSystemID, matchedFileSystemIndexInLayer);
        }
        this.updateUnitsTranslationMap(clientUnitDescriptor);
        return this.storageMask.layerToClient(clientShortUnitID);
    }

    private void updateUnitsTranslationMap(UnitDescriptor clientUnitDescriptor) {
        int clientShortUnitID = this.clientUnitDescriptorsDictionary.getUnitID(clientUnitDescriptor);
        for (Layer layer : this.layers) {
            Map old;
            LayerDescriptor ld = layer.getLayerDescriptor();
            Map<Integer, Integer> map = (ConcurrentHashMap<Integer, Integer>)this.unitsTranslationMap.get(ld);
            if (map == null && (old = (Map)this.unitsTranslationMap.putIfAbsent(ld, map = new ConcurrentHashMap<Integer, Integer>())) != null) {
                map = old;
            }
            if (map.containsKey(clientShortUnitID)) continue;
            int matchedUnitIDInLayer = this.findMatchedUnitIDInLayer(layer, clientUnitDescriptor);
            if (matchedUnitIDInLayer == -1 && layer.getWriteCapability() != null) {
                UnitDescriptor layerUnitDescriptor = this.createLayerUnitDescriptor(layer, clientUnitDescriptor);
                matchedUnitIDInLayer = layer.getWriteCapability().registerNewUnit(layerUnitDescriptor);
            }
            map.put(clientShortUnitID, matchedUnitIDInLayer);
        }
    }

    private List<Layer> createLayers(List<LayerDescriptor> layerDescriptors, LayeringSupport layeringSupport, Collection<? extends LayerListener> lst, int persistMechanismVersion) {
        Collection factories = Lookup.getDefault().lookupAll(LayerFactory.class);
        ArrayList<Layer> result = new ArrayList<Layer>();
        for (LayerDescriptor layerDescriptor : layerDescriptors) {
            Layer layer = null;
            for (LayerFactory factory : factories) {
                if (!factory.canHandle(layerDescriptor)) continue;
                layer = factory.createLayer(layerDescriptor, layeringSupport);
                break;
            }
            if (layer == null) continue;
            boolean isOK = true;
            for (LayerListener layerListener : lst) {
                isOK &= layerListener.layerOpened(layerDescriptor);
            }
            boolean success = layer.startup(persistMechanismVersion, !isOK);
            if (!success) continue;
            result.add(layer);
        }
        return result;
    }

    int getMaintananceWeight() {
        int weight = 0;
        for (Layer l : this.layers) {
            weight += Storage.getMaintenanceWeight(l);
        }
        return weight;
    }

    boolean maintain(long timeout) {
        if (this.layers.isEmpty()) {
            return false;
        }
        if (Stats.traceDefragmentation) {
            System.out.println("-------Storage with id " + this.storageID + " start defragmenting------");
        }
        Layer[] unitList = this.layers.toArray(new Layer[this.layers.size()]);
        Arrays.sort(unitList, new MaintenanceComparator());
        boolean needMoreTime = false;
        long start = System.currentTimeMillis();
        for (int i = 0; i < unitList.length; ++i) {
            WriteLayerCapability writeCapability = unitList[i].getWriteCapability();
            if (writeCapability == null) continue;
            int weight = 0;
            try {
                weight = writeCapability.getMaintenanceWeight();
            }
            catch (IOException ex) {
                RepositoryExceptions.throwException((Object)this, (Throwable)ex);
            }
            if (weight < Stats.defragmentationThreashold) {
                return needMoreTime;
            }
            try {
                if (writeCapability.maintenance(timeout)) {
                    needMoreTime = true;
                }
            }
            catch (IOException ex) {
                // empty catch block
            }
            if ((timeout -= System.currentTimeMillis() - start) > 0L || i >= unitList.length - 1) continue;
            needMoreTime = true;
            break;
        }
        return needMoreTime;
    }

    public RepositoryDataInputStream getInputStream(Key key) {
        int unitId = key.getUnitId();
        this.openUnit(unitId);
        for (Layer layer : this.layers) {
            ByteBuffer rawData;
            LayerDescriptor ld = layer.getLayerDescriptor();
            LayerKey layerKey = this.getReadLayerKey(key, layer);
            if (layerKey == null) continue;
            if (layer.removedTableKeySet().contains(layerKey)) {
                return null;
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "will get ByteBuffer from the read capability for the key with unit id:{0} and behaviour: {1}", new Object[]{key.getUnitId(), key.getBehavior()});
            }
            if ((rawData = layer.getReadCapability().read(layerKey)) == null) continue;
            return new RepositoryDataInputStream(new ByteArrayInputStream(rawData.array()), LayerConvertersProvider.getReadInstance((UnitsConverter)new UnitIDReadConverterImpl(layer), (FSConverter)new FSReadConverterImpl(ld), (FilePathConverter)new FilePathReadConverterImpl(unitId)));
        }
        return null;
    }

    public RepositoryDataOutputStream getOutputStream(Key key) {
        for (Layer layer : this.layers) {
            WriteLayerCapability wc = layer.getWriteCapability();
            if (wc == null) continue;
            UnitIDWriteConverterImpl unitIDConverter = new UnitIDWriteConverterImpl(layer);
            FSWriteConverterImpl fsConverter = new FSWriteConverterImpl(layer);
            FilePathWriteConverterImpl filePathConverter = new FilePathWriteConverterImpl(key.getUnitId());
            LayerKey layerKey = this.getWriteLayerKey(key, layer);
            if (layerKey == null) continue;
            return new RepositoryDataOutputStream(layerKey, wc, LayerConvertersProvider.getWriteInstance((UnitsConverter)unitIDConverter, (FSConverter)fsConverter, (FilePathConverter)filePathConverter));
        }
        RepositoryExceptions.throwException((Object)this, (Key)key, (Throwable)new RepositoryException(true));
        return null;
    }

    public List<LayerDescriptor> getLayerDescriptors() {
        return this.layerDescriptors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown() {
        this.storageLock.lock();
        try {
            Collection<Integer> clientShortUnitIDs = this.clientUnitDescriptorsDictionary.getUnitIDs();
            for (Integer clientShortUnitID : clientShortUnitIDs) {
                this.closeUnit(clientShortUnitID);
            }
            for (Layer layer : this.layers) {
                layer.shutdown();
            }
        }
        finally {
            this.storageLock.unlock();
        }
    }

    private LayerKey getReadLayerKey(Key key, Layer layer) {
        UnitIDWriteConverterImpl unitIDConverter = new UnitIDWriteConverterImpl(layer);
        int unitId = key.getUnitId();
        Integer layerUnitID = unitIDConverter.clientToLayer(unitId);
        if (layerUnitID < 0) {
            return null;
        }
        return LayerKey.create((Key)key, (int)layerUnitID);
    }

    private LayerKey getWriteLayerKey(Key key, Layer layer) {
        UnitIDWriteConverterImpl unitIDConverter = new UnitIDWriteConverterImpl(layer);
        int clientUnitID = key.getUnitId();
        Integer layerUnitID = unitIDConverter.clientToLayer(clientUnitID);
        if (layerUnitID < 0) {
            throw new InternalError();
        }
        return LayerKey.create((Key)key, (int)layerUnitID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void openUnit(int clientUnitID) {
        Integer clientShortUnitID = this.storageMask.clientToLayer(clientUnitID);
        Map<Integer, FilePathsDictionary> map = this.filePathDictionaries;
        synchronized (map) {
            FilePathsDictionary fsDict = this.filePathDictionaries.get(clientShortUnitID);
            if (fsDict != null) {
                return;
            }
        }
        UnitDescriptor clientUnitDescriptor = this.clientUnitDescriptorsDictionary.getUnitDescriptor(clientShortUnitID);
        if (clientUnitDescriptor == null) {
            System.err.println(clientUnitDescriptor + " is not registered in the storage!!!!");
            return;
        }
        int clientFileSystemID = this.clientFileSystemsDictionary.getFileSystemID(clientUnitDescriptor.getFileSystem());
        Layer layer_to_read_files_from = null;
        int unit_id_layer_to_read_files_from = -1;
        for (Layer layer : this.layers) {
            Map map2;
            Integer n;
            UnitIDWriteConverterImpl unitIDConverter = new UnitIDWriteConverterImpl(layer);
            Integer unitIDInLayer = unitIDConverter.clientToLayer(clientUnitID);
            if (unitIDInLayer < 0) continue;
            layer.openUnit(unitIDInLayer.intValue());
            FilePathsDictionary files = this.getFilesDictionary(clientUnitID, layer);
            if (layer_to_read_files_from == null || files != null && files.size() > 0) {
                layer_to_read_files_from = layer;
                unit_id_layer_to_read_files_from = unitIDInLayer;
            }
            if ((n = (Integer)(map2 = (Map)this.fileSystemsTranslationMap.get(layer.getLayerDescriptor())).get(clientFileSystemID)) == null) {
                throw new InternalError();
            }
            if (n >= 0) continue;
        }
        Map<Integer, FilePathsDictionary> map3 = this.filePathDictionaries;
        synchronized (map3) {
            FilePathsDictionary fsDict = this.filePathDictionaries.get(clientShortUnitID);
            if (fsDict == null) {
                ArrayList<CharSequence> convertedTable;
                if (layer_to_read_files_from != null) {
                    FilePathsDictionary dict = this.getFilesDictionary(clientUnitID, layer_to_read_files_from);
                    List<Object> fileNameTable = dict == null ? Collections.emptyList() : dict.toList();
                    convertedTable = new ArrayList(fileNameTable.size());
                    for (CharSequence charSequence : fileNameTable) {
                        UnitDescriptor unitDescriptor = layer_to_read_files_from.getUnitsTable().getUnitDescriptor(Integer.valueOf(unit_id_layer_to_read_files_from));
                        if (unitDescriptor == null) {
                            System.err.println("UnitDesctipor not found  for " + unit_id_layer_to_read_files_from + " and layer " + layer_to_read_files_from.getLayerDescriptor());
                            CndUtils.threadsDump();
                            continue;
                        }
                        FilePath sourceFSPath = new FilePath(unitDescriptor.getFileSystem(), charSequence.toString());
                        CharSequence pathInClient = RepositoryMapper.map(clientUnitDescriptor, sourceFSPath);
                        convertedTable.add(pathInClient);
                    }
                } else {
                    convertedTable = new ArrayList<CharSequence>();
                }
                if (convertedTable.isEmpty()) {
                    // empty if block
                }
                this.filePathDictionaries.put(clientShortUnitID, new FilePathsDictionary(convertedTable));
            }
        }
    }

    private FilePathsDictionary getFilesDictionary(int clientUnitID, Layer layer) {
        try {
            ByteBuffer rawData;
            FilePathsDictionaryKey key = new FilePathsDictionaryKey(clientUnitID);
            LayerDescriptor ld = layer.getLayerDescriptor();
            LayerKey layerKey = this.getReadLayerKey(key, layer);
            if (layerKey == null) {
                return null;
            }
            if (layer.removedTableKeySet().contains(layerKey)) {
                return null;
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "will get ByteBuffer from the read capability for the key with unit id:{0} and behaviour: {1}", new Object[]{key.getUnitId(), key.getBehavior()});
            }
            if ((rawData = layer.getReadCapability().read(layerKey)) == null) {
                return null;
            }
            RepositoryDataInputStream inputStream = new RepositoryDataInputStream(new ByteArrayInputStream(rawData.array()), LayerConvertersProvider.getReadInstance((UnitsConverter)new UnitIDReadConverterImpl(layer), (FSConverter)new FSReadConverterImpl(ld), (FilePathConverter)new FilePathReadConverterImpl(clientUnitID)));
            Persistent obj = key.getPersistentFactory().read((RepositoryDataInput)inputStream);
            assert (obj instanceof FilePathsDictionary);
            return (FilePathsDictionary)obj;
        }
        catch (Throwable ex) {
            RepositoryExceptions.throwException((Object)this, (Throwable)ex);
            return null;
        }
    }

    private void closeUnit(int shortClientUnitID) {
        Integer clientUnitID = this.storageMask.layerToClient(shortClientUnitID);
        this.closeUnit(clientUnitID, false, Collections.<Integer>emptySet());
    }

    void closeUnit(int clientUnitID, boolean cleanRepository, Set<Integer> requiredUnits) {
        Integer clientShortUnitID = this.storageMask.clientToLayer(clientUnitID);
        for (Layer layer : this.layers) {
            Map map = (Map)this.unitsTranslationMap.get(layer.getLayerDescriptor());
            Integer unitIDInLayer = (Integer)map.get(clientShortUnitID);
            if (unitIDInLayer == null) continue;
            layer.closeUnit(unitIDInLayer.intValue(), cleanRepository, requiredUnits);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CharSequence getFileName(int unitID, int fileIdx) {
        FilePathsDictionary fsDict;
        Integer clientShortUnitID = this.storageMask.clientToLayer(unitID);
        Map<Integer, FilePathsDictionary> map = this.filePathDictionaries;
        synchronized (map) {
            fsDict = this.filePathDictionaries.get(clientShortUnitID);
            if (fsDict == null) {
                this.openUnit(unitID);
                fsDict = this.filePathDictionaries.get(clientShortUnitID);
            }
        }
        CharSequence res = fsDict.getFilePath(fileIdx);
        if ("<WRONG FILE>" == res && PRINT_STACK_FILES) {
            System.err.println("Path by index fileIdx/clientShortUnitID" + fileIdx + "/" + clientShortUnitID + " not found. files dictionary size is " + fsDict.size());
            System.err.println("filePathDictionaries:" + fsDict);
            this.dumpStorage();
            PRINT_STACK_FILES = false;
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getFileID(int clientUnitID, CharSequence fileName) {
        int result;
        int size;
        FilePathsDictionary fsDict;
        Integer clientShortUnitID = this.storageMask.clientToLayer(clientUnitID);
        Map<Integer, FilePathsDictionary> map = this.filePathDictionaries;
        synchronized (map) {
            fsDict = this.filePathDictionaries.get(clientShortUnitID);
            if (fsDict == null) {
                this.openUnit(clientUnitID);
                fsDict = this.filePathDictionaries.get(clientShortUnitID);
            }
            size = fsDict.size();
            result = fsDict.getFileID(fileName, clientShortUnitID);
        }
        if (fsDict.size() > size) {
            Repository.put((Key)new FilePathsDictionaryKey(clientUnitID), (Persistent)fsDict);
        }
        return result;
    }

    CharSequence getUnitName(int unitID) {
        this.openUnit(unitID);
        Integer unmaskedID = this.storageMask.clientToLayer(unitID);
        UnitDescriptor unitDescriptor = this.clientUnitDescriptorsDictionary.getUnitDescriptor(unmaskedID);
        if (unitDescriptor == null) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "unitDescriptor is null for unitID={0}", unitID);
            }
            return null;
        }
        return unitDescriptor.getName();
    }

    private int findMatchedUnitIDInLayer(Layer layer, UnitDescriptor clientUnitDescriptor) {
        UnitDescriptorsList layerUnitsTable = layer.getUnitsTable();
        int clientFileSystemID = this.clientFileSystemsDictionary.getFileSystemID(clientUnitDescriptor.getFileSystem());
        Map map = (Map)this.fileSystemsTranslationMap.get(layer.getLayerDescriptor());
        Integer requiredFileSystem = (Integer)map.get(clientFileSystemID);
        if (requiredFileSystem == null) {
            throw new InternalError();
        }
        if (requiredFileSystem < 0 && layer.getWriteCapability() != null) {
            requiredFileSystem = layer.getWriteCapability().registerClientFileSystem(clientUnitDescriptor.getFileSystem());
            map.put(clientFileSystemID, requiredFileSystem);
        }
        Collection unitIDs = layerUnitsTable.getUnitIDs();
        for (Integer unitIDInLayer : unitIDs) {
            UnitDescriptor layerUnitDescriptor = layerUnitsTable.getUnitDescriptor(unitIDInLayer);
            FileSystem unitFileSystemInLayer = layerUnitDescriptor.getFileSystem();
            int fileSystemIndexInLayer = layer.getFileSystemsTable().indexOf(unitFileSystemInLayer);
            if (!requiredFileSystem.equals(fileSystemIndexInLayer) || !RepositoryMapper.matches(layerUnitDescriptor, clientUnitDescriptor)) continue;
            return unitIDInLayer;
        }
        return -1;
    }

    private UnitDescriptor createClientUnitDescriptor(Layer layer, UnitDescriptor layerUnitDescriptor) {
        FileSystem unitFileSystemInLayer = layerUnitDescriptor.getFileSystem();
        Map map = (Map)this.fileSystemsTranslationMap.get(layer.getLayerDescriptor());
        int fileSystemIndexInLayer = layer.getFileSystemsTable().indexOf(unitFileSystemInLayer);
        if (fileSystemIndexInLayer == -1) {
            throw new InternalError();
        }
        int clientFileSystemID = -1;
        for (Map.Entry entry : map.entrySet()) {
            if (!((Integer)entry.getValue()).equals(fileSystemIndexInLayer)) continue;
            clientFileSystemID = (Integer)entry.getKey();
            break;
        }
        if (clientFileSystemID == -1) {
            clientFileSystemID = this.clientFileSystemsDictionary.getFileSystemID(unitFileSystemInLayer);
            map.put(clientFileSystemID, fileSystemIndexInLayer);
        }
        FileSystem clientFileSystem = this.clientFileSystemsDictionary.getFileSystem(clientFileSystemID);
        return RepositoryMapper.mapToClient(clientFileSystem, layerUnitDescriptor);
    }

    private UnitDescriptor createLayerUnitDescriptor(Layer layer, UnitDescriptor clientUnitDescriptor) {
        FileSystem clientFileSystem;
        int clientFileSystemID;
        Map map = (Map)this.fileSystemsTranslationMap.get(layer.getLayerDescriptor());
        Integer fileSystemIndexInLayer = (Integer)map.get(clientFileSystemID = this.clientFileSystemsDictionary.getFileSystemID(clientFileSystem = clientUnitDescriptor.getFileSystem()));
        if (fileSystemIndexInLayer == null || fileSystemIndexInLayer == -1) {
            fileSystemIndexInLayer = layer.getWriteCapability().registerClientFileSystem(clientFileSystem);
            map.put(clientFileSystemID, fileSystemIndexInLayer);
        }
        return RepositoryMapper.mapToLayer((FileSystem)layer.getFileSystemsTable().get(fileSystemIndexInLayer), clientUnitDescriptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeUnit(int clientLongUnitID) {
        try {
            for (Layer layer : this.layers) {
                WriteLayerCapability wc = layer.getWriteCapability();
                if (wc == null) continue;
                UnitIDWriteConverterImpl unitIDConverter = new UnitIDWriteConverterImpl(layer);
                Integer unitIDInLayer = unitIDConverter.clientToLayer(clientLongUnitID);
                wc.removeUnit(unitIDInLayer.intValue());
            }
        }
        finally {
            this.flush();
        }
    }

    UnitsConverter getStorageMask() {
        return this.storageMask;
    }

    UnitsConverter getReadUnitsConverter(LayerDescriptor layerDescriptor) {
        int layerID = this.layerDescriptors.indexOf(layerDescriptor);
        assert (layerID >= 0);
        Layer layer = this.layers.get(layerID);
        return new UnitIDReadConverterImpl(layer);
    }

    UnitsConverter getWriteUnitsConverter(LayerDescriptor layerDescriptor) {
        int layerID = this.layerDescriptors.indexOf(layerDescriptor);
        assert (layerID >= 0);
        Layer layer = this.layers.get(layerID);
        return new UnitIDWriteConverterImpl(layer);
    }

    FSConverter getReadFSConverter(LayerDescriptor layerDescriptor) {
        return new FSReadConverterImpl(layerDescriptor);
    }

    FSConverter getWriteFSConverter(LayerDescriptor layerDescriptor) {
        int layerID = this.layerDescriptors.indexOf(layerDescriptor);
        assert (layerID >= 0);
        Layer layer = this.layers.get(layerID);
        return new FSWriteConverterImpl(layer);
    }

    LayeringSupport getLayeringSupport() {
        return this.layeringSupport;
    }

    final void remove(Key key) {
        boolean keepInRemovedTable = false;
        for (Layer layer : this.layers) {
            LayerKey layerKey;
            ReadLayerCapability readCapability = layer.getReadCapability();
            WriteLayerCapability wc = layer.getWriteCapability();
            if (readCapability != null && wc == null) {
                layerKey = this.getReadLayerKey(key, layer);
                boolean bl = keepInRemovedTable = keepInRemovedTable || readCapability.knowsKey(layerKey);
            }
            if (wc == null || (layerKey = this.getWriteLayerKey(key, layer)) == null) continue;
            wc.remove(layerKey, keepInRemovedTable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flush() {
        this.storageLock.lock();
        try {
            Collection<Integer> clientShortUnitIDs = this.clientUnitDescriptorsDictionary.getUnitIDs();
            for (Integer clientShortUnitID : clientShortUnitIDs) {
                FilePathsDictionary fsDict;
                Map<Integer, FilePathsDictionary> map = this.filePathDictionaries;
                synchronized (map) {
                    fsDict = this.filePathDictionaries.get(clientShortUnitID);
                }
                if (fsDict == null) continue;
                Repository.put((Key)new FilePathsDictionaryKey(this.storageMask.layerToClient(clientShortUnitID.intValue())), (Persistent)fsDict);
            }
        }
        finally {
            this.storageLock.unlock();
        }
    }

    private void dumpStorage() {
        System.err.println("--------Dump storage internals--------:\n");
        for (Layer l : this.layers) {
            System.err.println("Later.unitsTable is: \n" + l.getUnitsTable());
            LayerDescriptor ld = l.getLayerDescriptor();
            Map unitsMap = (Map)this.unitsTranslationMap.get(ld);
            System.err.println("for layer:" + ld.getURI());
            System.err.println("clientShortUnitID => unitIDInLayer:");
            for (Map.Entry entry : unitsMap.entrySet()) {
                System.err.println(entry.getKey() + " => " + entry.getValue());
            }
        }
        System.err.println("unitsTranslationMap is " + this.clientUnitDescriptorsDictionary);
        CndUtils.threadsDump();
    }

    private static int getMaintenanceWeight(Layer layer) {
        try {
            WriteLayerCapability writeCapability = layer.getWriteCapability();
            if (writeCapability == null) {
                return 0;
            }
            return writeCapability.getMaintenanceWeight();
        }
        catch (IOException iOException) {
            return 0;
        }
    }

    private static class MaintenanceComparator
    implements Comparator<Layer>,
    Serializable {
        private static final long serialVersionUID = 7249059246763182397L;

        private MaintenanceComparator() {
        }

        @Override
        public int compare(Layer o1, Layer o2) {
            return Storage.getMaintenanceWeight(o2) - Storage.getMaintenanceWeight(o1);
        }
    }

    private final class FilePathWriteConverterImpl
    implements FilePathConverter {
        private final int writeToUnitClientId;

        public FilePathWriteConverterImpl(int writeToUnitClientId) {
            this.writeToUnitClientId = writeToUnitClientId;
        }

        public CharSequence layerToClient(int fileIdx) {
            throw new InternalError("Should not be called");
        }

        public int clientToLayer(CharSequence filePath) {
            return Storage.this.getFileID(this.writeToUnitClientId, filePath);
        }
    }

    private final class FilePathReadConverterImpl
    implements FilePathConverter {
        private final int readFromUnitClientId;

        public FilePathReadConverterImpl(int readFromUnitClientId) {
            this.readFromUnitClientId = readFromUnitClientId;
        }

        public CharSequence layerToClient(int fileIdx) {
            return Storage.this.getFileName(this.readFromUnitClientId, fileIdx);
        }

        public int clientToLayer(CharSequence filePath) {
            throw new InternalError("Should not be called");
        }
    }

    private class FSWriteConverterImpl
    implements FSConverter {
        private final Map<Integer, Integer> map;
        private final Layer layer;

        private FSWriteConverterImpl(Layer layer) {
            this.layer = layer;
            LayerDescriptor ld = layer.getLayerDescriptor();
            this.map = (Map)Storage.this.fileSystemsTranslationMap.get(ld);
            if (this.map == null) {
                throw new InternalError("fileSystemsTranslationMap must contain entry for " + ld + " at this point.");
            }
        }

        public FileSystem layerToClient(int fileSystemIndexInLayer) {
            throw new InternalError("Should not be called");
        }

        public int clientToLayer(FileSystem clientFileSystem) {
            int clientFileSystemID;
            Integer result;
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "FSWriteConverterImpl.clientToLayer ({0})", clientFileSystem);
            }
            if ((result = this.map.get(clientFileSystemID = Storage.this.clientFileSystemsDictionary.getFileSystemID(clientFileSystem))) == null) {
                throw new InternalError();
            }
            if (result == -1) {
                return this.layer.getWriteCapability().registerClientFileSystem(clientFileSystem);
            }
            return result;
        }
    }

    private class FSReadConverterImpl
    implements FSConverter {
        private final Map<Integer, Integer> map;

        private FSReadConverterImpl(LayerDescriptor ld) {
            this.map = (Map)Storage.this.fileSystemsTranslationMap.get(ld);
            if (this.map == null) {
                throw new InternalError("fileSystemsTranslationMap must contain entry for " + ld + " at this point.");
            }
        }

        public FileSystem layerToClient(int fileSystemIndexInLayer) {
            FileSystem fs;
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "FSReadConverterImpl.clientToLayer ({0})", fileSystemIndexInLayer);
            }
            int clientFileSystemID = -1;
            for (Map.Entry<Integer, Integer> entry : this.map.entrySet()) {
                if (!entry.getValue().equals(fileSystemIndexInLayer)) continue;
                clientFileSystemID = entry.getKey();
            }
            FileSystem fileSystem = fs = clientFileSystemID < 0 ? null : Storage.this.clientFileSystemsDictionary.getFileSystem(clientFileSystemID);
            if (fs == null) {
                Exceptions.printStackTrace((Throwable)((Object)new AssertionError((Object)("Read null FileSystem from code model persistence for fileSystemIndexInLayer == " + fileSystemIndexInLayer))));
                Storage.this.dumpStorage();
            }
            return fs;
        }

        public int clientToLayer(FileSystem clientFileSystem) {
            throw new InternalError("Should not be called");
        }
    }

    private class UnitIDWriteConverterImpl
    implements UnitsConverter {
        private final Map<Integer, Integer> map;
        private final Layer layer;

        private UnitIDWriteConverterImpl(Layer layer) {
            this.layer = layer;
            this.map = (Map)Storage.this.unitsTranslationMap.get(layer.getLayerDescriptor());
            if (this.map == null) {
                throw new InternalError("unitsTranslationMap must contain entry for " + layer + " at this point.");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int clientToLayer(int clientUnitID) {
            Integer result;
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "UnitIDWriteConverterImpl.clientToLayer ({0})", clientUnitID);
            }
            int clientShortUnitID = Storage.this.storageMask.clientToLayer(clientUnitID);
            Map<Integer, Integer> map = this.map;
            synchronized (map) {
                result = this.map.get(clientShortUnitID);
                if (result == null || result == -1) {
                    UnitDescriptor unitDescriptor = Storage.this.clientUnitDescriptorsDictionary.getUnitDescriptor(clientShortUnitID);
                    if (unitDescriptor == null) {
                        if (UnitIDWriteConverterImpl_client_to_layer) {
                            System.err.println("UnitIDWriteConverterImpl.clientToLayer. Means somehow it was deleted from the units table, even though we never delete data from the units list (see LayerIndex implementation) will return -1 as client unit id! unitID=" + clientUnitID + " " + "not found, current units list is " + this.layer.getUnitsTable());
                            Storage.this.dumpStorage();
                            UnitIDWriteConverterImpl_client_to_layer = false;
                        }
                        return -1;
                    }
                    UnitDescriptor layerUnitDescriptor = Storage.this.createLayerUnitDescriptor(this.layer, unitDescriptor);
                    int res = this.layer.getWriteCapability().registerNewUnit(layerUnitDescriptor);
                    this.map.put(clientShortUnitID, res);
                    return res;
                }
            }
            return result;
        }

        public int layerToClient(int unitIDInLayer) {
            throw new InternalError("Should not be called");
        }
    }

    private class UnitIDReadConverterImpl
    implements UnitsConverter {
        private final Map<Integer, Integer> map;
        private final Layer layer;

        private UnitIDReadConverterImpl(Layer layer) {
            this.layer = layer;
            this.map = (Map)Storage.this.unitsTranslationMap.get(layer.getLayerDescriptor());
            if (this.map == null) {
                throw new InternalError("unitsTranslationMap must contain entry for " + layer + " at this point.");
            }
        }

        public int clientToLayer(int clientLongUnitID) {
            throw new InternalError("Should not be called");
        }

        public int layerToClient(int unitIDInLayer) {
            Integer result = null;
            for (Map.Entry<Integer, Integer> entry : this.map.entrySet()) {
                if (!entry.getValue().equals(unitIDInLayer)) continue;
                result = entry.getKey();
            }
            if (result == null) {
                UnitDescriptor layerUnit = this.layer.getUnitsTable().getUnitDescriptor(Integer.valueOf(unitIDInLayer));
                if (layerUnit == null) {
                    if (UnitIDReadConverterImpl_layer_to_client) {
                        System.err.println("In previous version we had IndexOutOfBounds here! unitID=" + unitIDInLayer + " " + "not found, current units list is " + this.layer.getUnitsTable());
                        Storage.this.dumpStorage();
                        UnitIDReadConverterImpl_layer_to_client = false;
                    }
                    return -1;
                }
                UnitDescriptor clientUnitDescriptor = Storage.this.createClientUnitDescriptor(this.layer, layerUnit);
                result = Storage.this.clientUnitDescriptorsDictionary.getUnitID(clientUnitDescriptor);
                this.map.put(result, unitIDInLayer);
                Storage.this.updateUnitsTranslationMap(clientUnitDescriptor);
            }
            if (result.equals(-1) && UnitIDReadConverterImpl_layer_to_client) {
                System.err.println("UnitIDReadConverterImpl.layerToClient will return -1 as client unit id! unitID=" + unitIDInLayer + " " + "not found, current units list is " + this.layer.getUnitsTable());
                Storage.this.dumpStorage();
                UnitIDReadConverterImpl_layer_to_client = false;
            }
            return result.equals(-1) ? -1 : Storage.this.storageMask.layerToClient(result.intValue());
        }
    }

    private class LayeringSupportImpl
    implements LayeringSupport {
        private LayeringSupportImpl() {
        }

        public List<LayerDescriptor> getLayerDescriptors() {
            return Storage.this.getLayerDescriptors();
        }

        public int getStorageID() {
            return Storage.this.storageID;
        }

        public UnitsConverter getReadUnitsConverter(LayerDescriptor layerDescriptor) {
            return Storage.this.getReadUnitsConverter(layerDescriptor);
        }

        public UnitsConverter getWriteUnitsConverter(LayerDescriptor layerDescriptor) {
            return Storage.this.getWriteUnitsConverter(layerDescriptor);
        }

        public FSConverter getReadFSConverter(LayerDescriptor layerDescriptor) {
            return Storage.this.getReadFSConverter(layerDescriptor);
        }

        public FSConverter getWriteFSConverter(LayerDescriptor layerDescriptor) {
            return Storage.this.getWriteFSConverter(layerDescriptor);
        }
    }
}

