/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.model.visitor;

import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.Message;
import org.netbeans.modules.xml.wsdl.model.NotificationOperation;
import org.netbeans.modules.xml.wsdl.model.OneWayOperation;
import org.netbeans.modules.xml.wsdl.model.Part;
import org.netbeans.modules.xml.wsdl.model.Port;
import org.netbeans.modules.xml.wsdl.model.PortType;
import org.netbeans.modules.xml.wsdl.model.ReferenceableWSDLComponent;
import org.netbeans.modules.xml.wsdl.model.RequestResponseOperation;
import org.netbeans.modules.xml.wsdl.model.Service;
import org.netbeans.modules.xml.wsdl.model.SolicitResponseOperation;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.visitor.DefaultVisitor;

public class FindReferencedVisitor<T extends ReferenceableWSDLComponent>
extends DefaultVisitor {
    private Class<T> type;
    private String localName;
    private T referenced = null;
    private Definitions root;

    public FindReferencedVisitor(Definitions root) {
        this.root = root;
    }

    public T find(String localName, Class<T> type) {
        this.type = type;
        this.localName = localName;
        this.visitChildren(this.root);
        return this.referenced;
    }

    @Override
    public void visit(Binding c) {
        this.checkReference(c, true);
    }

    @Override
    public void visit(Message c) {
        this.checkReference(c, true);
    }

    @Override
    public void visit(PortType c) {
        this.checkReference(c, true);
    }

    @Override
    public void visit(RequestResponseOperation op) {
        this.checkReference(op, true);
    }

    @Override
    public void visit(OneWayOperation op) {
        this.checkReference(op, true);
    }

    @Override
    public void visit(NotificationOperation op) {
        this.checkReference(op, true);
    }

    @Override
    public void visit(SolicitResponseOperation op) {
        this.checkReference(op, true);
    }

    @Override
    public void visit(Service s) {
        this.checkReference(s, true);
    }

    @Override
    public void visit(Port p) {
        this.checkReference(p, true);
    }

    @Override
    public void visit(Part part) {
        this.checkReference(part, true);
    }

    @Override
    public void visit(ExtensibilityElement c) {
        if (c instanceof ReferenceableWSDLComponent) {
            this.checkReference((ReferenceableWSDLComponent)ReferenceableWSDLComponent.class.cast(c), true);
        }
        this.visitChildren(c);
    }

    private void checkReference(ReferenceableWSDLComponent c, boolean checkChildren) {
        if (this.type.isAssignableFrom(c.getClass()) && c.getName() != null && c.getName().equals(this.localName)) {
            this.referenced = (ReferenceableWSDLComponent)this.type.cast(c);
            return;
        }
        if (checkChildren) {
            this.visitChildren(c);
        }
    }

    private void visitChildren(WSDLComponent c) {
        for (WSDLComponent child : c.getChildren()) {
            if (this.referenced != null) {
                return;
            }
            child.accept(this);
        }
    }
}

