/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.remote.ui.add;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.mercurial.remote.HgException;
import org.netbeans.modules.mercurial.remote.HgProgressSupport;
import org.netbeans.modules.mercurial.remote.Mercurial;
import org.netbeans.modules.mercurial.remote.OutputLogger;
import org.netbeans.modules.mercurial.remote.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.remote.util.HgCommand;
import org.netbeans.modules.mercurial.remote.util.HgUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.spi.VCSContext;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class AddAction
extends ContextAction {
    private static final String ICON_RESOURCE = "org/netbeans/modules/mercurial/remote/resources/icons/add.png";

    public AddAction() {
        super(ICON_RESOURCE);
    }

    protected String iconResource() {
        return ICON_RESOURCE;
    }

    @Override
    protected boolean enable(Node[] nodes) {
        VCSContext ctx = HgUtils.getCurrentContext(nodes);
        return Mercurial.getInstance().getFileStatusCache().containsFileOfStatus(ctx, 4, true);
    }

    @Override
    protected String getBaseName(Node[] nodes) {
        return "CTL_MenuItem_Add";
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        final VCSContext ctx = HgUtils.getCurrentContext(nodes);
        new HgProgressSupport(){

            @Override
            public void perform() {
                VCSFileProxy[] allFilesToAdd = HgUtils.getModifiedFiles(ctx, 4, true);
                Map<VCSFileProxy, List<VCSFileProxy>> candidates = this.filterUnderRepository(allFilesToAdd);
                AddAction.this.addFiles(candidates);
            }

            private Map<VCSFileProxy, List<VCSFileProxy>> filterUnderRepository(VCSFileProxy[] allFilesToAdd) {
                HashMap<VCSFileProxy, List<VCSFileProxy>> filtered = new HashMap<VCSFileProxy, List<VCSFileProxy>>(5);
                Mercurial hg = Mercurial.getInstance();
                for (VCSFileProxy file : allFilesToAdd) {
                    VCSFileProxy repository = hg.getRepositoryRoot(file);
                    LinkedList<VCSFileProxy> repoFiles = (LinkedList<VCSFileProxy>)filtered.get(repository);
                    if (repoFiles == null) {
                        repoFiles = new LinkedList<VCSFileProxy>();
                        filtered.put(repository, repoFiles);
                    }
                    repoFiles.add(file);
                }
                return filtered;
            }
        }.start(Mercurial.getInstance().getParallelRequestProcessor(), HgUtils.getRootFile(ctx), NbBundle.getMessage(AddAction.class, (String)"MSG_Add_Progress_Init"));
    }

    private void addFiles(final Map<VCSFileProxy, List<VCSFileProxy>> candidates) {
        Mercurial.getInstance().getParallelRequestProcessor().post(new Runnable(){

            @Override
            public void run() {
                for (Map.Entry e : candidates.entrySet()) {
                    final VCSFileProxy root = (VCSFileProxy)e.getKey();
                    final List files = (List)e.getValue();
                    RequestProcessor rp = Mercurial.getInstance().getRequestProcessor(root);
                    HgProgressSupport support = new HgProgressSupport(){

                        @Override
                        public void perform() {
                            OutputLogger logger = this.getLogger();
                            try {
                                logger.outputInRed(NbBundle.getMessage(AddAction.class, (String)"MSG_ADD_TITLE"));
                                logger.outputInRed(NbBundle.getMessage(AddAction.class, (String)"MSG_ADD_TITLE_SEP"));
                                HgCommand.doAdd(root, files, logger);
                                logger.output(NbBundle.getMessage(AddAction.class, (String)"MSG_ADD_FILES"));
                                for (VCSFileProxy file : files) {
                                    logger.output(file.getPath());
                                }
                                Mercurial.getInstance().getFileStatusCache().refreshAllRoots(Collections.singletonMap(root, new HashSet(files)));
                            }
                            catch (HgException.HgCommandCanceledException ex) {
                            }
                            catch (HgException ex) {
                                HgUtils.notifyException(ex);
                            }
                            logger.outputInRed(NbBundle.getMessage(AddAction.class, (String)"MSG_ADD_DONE"));
                            logger.output("");
                        }
                    };
                    support.start(rp, root, NbBundle.getMessage(AddAction.class, (String)"MSG_Add_Progress", (Object)root.getName())).waitFinished();
                }
            }
        });
    }
}

