/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.remote.ui.push;

import java.util.Iterator;
import java.util.Set;
import org.netbeans.modules.mercurial.remote.HgException;
import org.netbeans.modules.mercurial.remote.HgProgressSupport;
import org.netbeans.modules.mercurial.remote.Mercurial;
import org.netbeans.modules.mercurial.remote.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.remote.ui.push.Bundle;
import org.netbeans.modules.mercurial.remote.ui.push.PushAction;
import org.netbeans.modules.mercurial.remote.util.HgCommand;
import org.netbeans.modules.mercurial.remote.util.HgUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.spi.VCSContext;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class PushCurrentBranchAction
extends ContextAction {
    public static final String ICON_RESOURCE = "org/netbeans/modules/mercurial/remote/resources/icons/push.png";

    public PushCurrentBranchAction() {
        super(ICON_RESOURCE);
    }

    @Override
    protected boolean enable(Node[] nodes) {
        VCSContext context = HgUtils.getCurrentContext(nodes);
        return HgUtils.isFromHgRepository(context);
    }

    @Override
    protected String getBaseName(Node[] nodes) {
        return "CTL_MenuItem_PushBranchLocal";
    }

    protected String iconResource() {
        return ICON_RESOURCE;
    }

    @Override
    public String getName(String role, Node[] activatedNodes) {
        VCSContext ctx = HgUtils.getCurrentContext(activatedNodes);
        Set<VCSFileProxy> roots = HgUtils.getRepositoryRoots(ctx);
        return roots.size() == 1 ? NbBundle.getMessage(PushCurrentBranchAction.class, (String)"CTL_MenuItem_PushBranchRoot", (Object)roots.iterator().next().getName()) : NbBundle.getMessage(PushCurrentBranchAction.class, (String)"CTL_MenuItem_PushBranchLocal");
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        VCSContext context = HgUtils.getCurrentContext(nodes);
        final Set<VCSFileProxy> repositoryRoots = HgUtils.getRepositoryRoots(context);
        Mercurial.getInstance().getRequestProcessor().post(new Runnable(){

            @Override
            public void run() {
                Iterator i$ = repositoryRoots.iterator();
                while (i$.hasNext()) {
                    VCSFileProxy repositoryRoot;
                    final VCSFileProxy root = repositoryRoot = (VCSFileProxy)i$.next();
                    final boolean[] canceled = new boolean[1];
                    try {
                        final String branch = HgCommand.getBranch(root);
                        RequestProcessor rp = Mercurial.getInstance().getRequestProcessor(root);
                        HgProgressSupport support = new HgProgressSupport(){

                            @Override
                            public void perform() {
                                PushAction.getDefaultAndPerformPush(root, null, branch, this.getLogger());
                                canceled[0] = this.isCanceled();
                            }
                        };
                        support.start(rp, root, Bundle.MSG_PUSH_BRANCH_PROGRESS(branch)).waitFinished();
                        if (!canceled[0]) continue;
                        break;
                    }
                    catch (HgException.HgCommandCanceledException ex) {
                    }
                    catch (HgException ex) {
                        HgUtils.notifyException(ex);
                    }
                }
            }
        });
    }
}

