/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.remote.ui.repository;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.util.NbBundle;

public final class HgURL {
    public static final HgURL NO_URL = new HgURL();
    private static final char SEGMENT_SEPARATOR = '/';
    private static final String PASSWORD_REPLACEMENT = "****";
    private static final String hexadecimalChars = "0123456789abcdef";
    private final Scheme scheme;
    private final String host;
    private final String username;
    private final char[] password;
    private final int port;
    private final String rawPath;
    private final String rawQuery;
    private final String rawFragment;
    private final String path;
    private String hgCommandForm;
    private String publicForm;

    public static String validateQuickly(String uriString) {
        if (uriString == null) {
            throw new IllegalArgumentException("URI string is <null>");
        }
        String schemeName = HgURL.getSchemeName(uriString);
        if (schemeName == null) {
            return HgURL.invalidUrlMessage(uriString);
        }
        Scheme scheme = HgURL.determineScheme(schemeName);
        if (scheme == null) {
            return HgURL.invalidUrlMessage(uriString);
        }
        String afterScheme = uriString.substring(scheme.name().length());
        if (scheme == Scheme.FILE) {
            if (!afterScheme.startsWith(":/")) {
                return HgURL.invalidUrlMessage(uriString);
            }
        } else {
            if (!afterScheme.startsWith("://")) {
                return HgURL.invalidUrlMessage(uriString);
            }
            if (afterScheme.length() == "://".length()) {
                return HgURL.invalidUrlMessage(uriString);
            }
        }
        return null;
    }

    private static String invalidUrlMessage(String uriString) {
        return NbBundle.getMessage(HgURL.class, (String)"MSG_INVALID_URL", (Object)uriString);
    }

    private static String getSchemeName(String uriString) {
        return HgURL.getSchemeName(uriString, Scheme.getMaxSchemeNameLength());
    }

    private static String getSchemeName(String uriString, int maxLength) {
        if (uriString.length() < 2) {
            return null;
        }
        int maxSchemeLength = maxLength != -1 ? Math.min(uriString.length() - 1, maxLength) : uriString.length() - 1;
        StringBuilder buf = null;
        char c = uriString.charAt(0);
        int lowercase = c | 0x20;
        if (!HgURL.isLowercaseAsciiAlpha(lowercase)) {
            return null;
        }
        if (c != lowercase) {
            buf = new StringBuilder(maxSchemeLength);
            buf.append(lowercase);
        }
        int firstInvalid = maxSchemeLength;
        for (int i = 1; i < maxSchemeLength; ++i) {
            c = uriString.charAt(i);
            lowercase = c | 0x20;
            if (!HgURL.isLegalLowercaseSchemeLetter(lowercase)) {
                firstInvalid = i;
                break;
            }
            if (c != lowercase && buf == null) {
                buf = new StringBuilder(maxSchemeLength);
                HgURL.appendLowercase(uriString, 1, i, buf);
            }
            if (buf == null) continue;
            buf.append(lowercase);
        }
        if (uriString.charAt(firstInvalid) != ':') {
            return null;
        }
        return buf == null ? uriString.substring(0, firstInvalid) : buf.toString();
    }

    private static boolean isLegalLowercaseSchemeLetter(int c) {
        return c >= 97 && c <= 122 || c >= 48 && c <= 57 || c == 43 || c == 45 || c == 46;
    }

    private static boolean isAsciiAlpha(char c) {
        return HgURL.isLowercaseAsciiAlpha(c | 0x20);
    }

    private static boolean isLowercaseAsciiAlpha(int c) {
        return c >= 97 && c <= 122;
    }

    private static boolean isSlash(char c) {
        return c == '/' || c == '\\';
    }

    private static void appendLowercase(String s, int from, int to, StringBuilder buf) {
        for (int i = from; i < to; ++i) {
            buf.append(s.charAt(i) | 0x20);
        }
    }

    private HgURL() {
        this.scheme = null;
        this.username = null;
        this.password = null;
        this.host = null;
        this.port = -1;
        this.path = null;
        this.rawPath = null;
        this.rawQuery = null;
        this.rawFragment = null;
    }

    public HgURL(VCSFileProxy file) {
        this.scheme = Scheme.FILE;
        this.username = null;
        this.password = null;
        this.host = null;
        this.port = -1;
        this.path = VCSFileProxySupport.toURI((VCSFileProxy)file).getPath();
        this.rawPath = HgURL.makeRawPathInfo(this.path);
        this.rawQuery = null;
        this.rawFragment = null;
    }

    public HgURL(String urlString) throws URISyntaxException {
        this(urlString, null, null);
    }

    public HgURL(String urlString, String username, char[] password) throws URISyntaxException {
        URI originalUri;
        if (urlString == null) {
            throw new IllegalArgumentException("<null> URL string");
        }
        if (urlString.length() == 0) {
            throw new IllegalArgumentException("empty URL string");
        }
        if (HgURL.looksLikePlainFilePath(urlString)) {
            originalUri = new File(urlString).toURI();
            this.scheme = Scheme.FILE;
        } else {
            originalUri = new URI(urlString).parseServerAuthority();
            String originalScheme = originalUri.getScheme();
            Scheme scheme = this.scheme = originalScheme != null ? HgURL.determineScheme(originalScheme) : null;
        }
        if (this.scheme == null) {
            throw new URISyntaxException(urlString, NbBundle.getMessage(HgURL.class, (String)"MSG_UNSUPPORTED_PROTOCOL", (Object)originalUri.getScheme()));
        }
        HgURL.verifyUserInfoData(this.scheme, username, password);
        if (username != null) {
            this.username = username;
            this.password = password == null ? null : (char[])password.clone();
        } else {
            String rawUserInfo = originalUri.getRawUserInfo();
            if (rawUserInfo == null) {
                this.username = null;
                this.password = null;
            } else {
                int colonIndex = rawUserInfo.indexOf(58);
                if (colonIndex == -1) {
                    this.username = rawUserInfo;
                    this.password = null;
                } else {
                    this.username = rawUserInfo.substring(0, colonIndex);
                    this.password = rawUserInfo.substring(colonIndex + 1).toCharArray();
                }
            }
        }
        this.host = originalUri.getHost();
        this.port = originalUri.getPort();
        this.rawPath = originalUri.getRawPath();
        this.rawQuery = originalUri.getRawQuery();
        this.rawFragment = originalUri.getRawFragment();
        this.path = originalUri.getPath();
    }

    public static boolean looksLikePlainFilePath(String urlString) {
        if (urlString == null) {
            throw new IllegalArgumentException("<null> URL string");
        }
        if (urlString.length() == 0) {
            return false;
        }
        return urlString.charAt(0) == '/';
    }

    public static String stripUserInfo(String urlString) {
        if (urlString == null) {
            throw new IllegalArgumentException("<null> URL string");
        }
        if ((urlString = urlString.trim()).length() == 0) {
            return urlString;
        }
        try {
            HgURL hgUrl = new HgURL(urlString);
            if (hgUrl.isFile() && HgURL.looksLikePlainFilePath(urlString)) {
                return hgUrl.toHgCommandUrlStringWithoutUserInfo();
            }
            return hgUrl.toUrlStringWithoutUserInfo();
        }
        catch (URISyntaxException ex) {
            return HgURL.stripUserInfoFromInvalidURI(urlString);
        }
    }

    private static String stripUserInfoFromInvalidURI(String urlString) {
        if (HgURL.looksLikePlainFilePath(urlString) && !urlString.startsWith("//")) {
            return urlString;
        }
        String schemeName = HgURL.getSchemeName(urlString, -1);
        String schemeSpecific = schemeName != null ? urlString.substring(schemeName.length() + 1).trim() : urlString;
        int atIndex = schemeSpecific.lastIndexOf(64);
        if (atIndex == -1) {
            return urlString;
        }
        String schemeSpecNoAuth = schemeSpecific.substring(atIndex + 1);
        if (schemeName == null) {
            if (schemeSpecific.startsWith("//")) {
                return "//" + schemeSpecNoAuth;
            }
            return schemeSpecNoAuth;
        }
        StringBuilder buf = new StringBuilder(urlString.length());
        buf.append(schemeName).append(':');
        if (schemeSpecific.startsWith("//")) {
            buf.append("//");
        }
        buf.append(schemeSpecNoAuth);
        return buf.toString();
    }

    private static String trimDupliciteInitialSlashes(String schemaSpecificUrlPart) {
        int index;
        int length = schemaSpecificUrlPart.length();
        if (length == 0) {
            return schemaSpecificUrlPart;
        }
        String str = schemaSpecificUrlPart;
        for (index = 0; index < length && str.charAt(index) == '/'; ++index) {
        }
        if (index == 0 || index == 1) {
            return schemaSpecificUrlPart;
        }
        return schemaSpecificUrlPart.substring(index - 1);
    }

    private static Scheme determineScheme(String schemeString) {
        if (schemeString == null) {
            throw new IllegalArgumentException();
        }
        for (Scheme scheme : Scheme.values()) {
            if (!scheme.name.equals(schemeString)) continue;
            return scheme;
        }
        return null;
    }

    private static void verifyUserInfoData(Scheme scheme, String username, char[] password) {
        boolean authenticationSupported = scheme.supportsAuthentication();
        if (!(authenticationSupported || username == null && password == null)) {
            throw new IllegalArgumentException("this URI does not support authentication, but username and/or password is specified");
        }
        if (username == null && password != null) {
            throw new IllegalArgumentException("username is unset but password is set");
        }
    }

    private static boolean isWindowsAbsolutePath(String urlString) {
        int length = urlString.length();
        if (length == 0) {
            return false;
        }
        int index = 0;
        if (HgURL.isSlash(urlString.charAt(index))) {
            ++index;
        }
        if (length <= index || !HgURL.isAsciiAlpha(urlString.charAt(index++))) {
            return false;
        }
        if (length <= index || urlString.charAt(index++) != ':') {
            return false;
        }
        return length > index && HgURL.isSlash(urlString.charAt(index++));
    }

    public boolean isFile() {
        return this.scheme == Scheme.FILE;
    }

    public String getProtocol() {
        return this.scheme.name();
    }

    public Scheme getScheme() {
        return this.scheme;
    }

    public String getPath() {
        return this.path;
    }

    public String getFilePath() {
        return this.path;
    }

    public String getUsername() {
        return this.username;
    }

    public char[] getPassword() {
        return this.password;
    }

    public void clearPassword() {
        if (this.password != null) {
            Arrays.fill(this.password, '\u0000');
            this.hgCommandForm = null;
        }
    }

    public String getUserInfo() {
        if (this.username == null) {
            return null;
        }
        if (this.password == null) {
            return this.username;
        }
        return this.username + ':' + PASSWORD_REPLACEMENT;
    }

    public boolean supportsAuthentication() {
        return this.scheme.supportsAuthentication();
    }

    public static VCSFileProxy getFile(VCSFileProxy root, HgURL url) {
        if (!url.isFile()) {
            throw new IllegalArgumentException("The passed HgURL must represent a file.");
        }
        return VCSFileProxySupport.getResource((VCSFileProxy)root, (String)url.getPath());
    }

    public boolean equals(Object otherObj) {
        if (otherObj == null) {
            return false;
        }
        assert (this.getClass() == HgURL.class);
        if (otherObj.getClass() != HgURL.class) {
            return false;
        }
        return ((HgURL)otherObj).getUniqueIdentifier().equals(this.getUniqueIdentifier());
    }

    public int hashCode() {
        return this.getUniqueIdentifier().hashCode();
    }

    private Object getUniqueIdentifier() {
        return this.toHgCommandUrlString();
    }

    public String toString() {
        if (this.publicForm == null) {
            this.publicForm = this.toUrlString(false, true, true);
        }
        return this.publicForm;
    }

    public String toHgCommandUrlString() {
        if (this.hgCommandForm == null) {
            this.hgCommandForm = this.isFile() ? this.getFilePath() : this.toUrlString();
        }
        return this.hgCommandForm;
    }

    public String toHgCommandUrlStringWithoutUserInfo() {
        return this.isFile() ? this.getFilePath() : this.toUrlStringWithoutUserInfo();
    }

    public String toHgCommandStringWithMaskedPassword() {
        return this.isFile() ? this.getFilePath() : this.toUrlString(false, true, true);
    }

    public String toHgCommandStringWithNoPassword() {
        return this.isFile() ? this.getFilePath() : this.toUrlString(false, false, false);
    }

    public URL toURL() {
        String urlSpec = this.toCompleteUrlString();
        try {
            return new URL(urlSpec);
        }
        catch (MalformedURLException ex) {
            assert (false) : ex.getMessage();
            return null;
        }
    }

    public String toCompleteUrlString() {
        return this.toUrlString();
    }

    public String toUrlString() {
        return this.toUrlString(false, true, false);
    }

    public String toUrlStringWithoutUserInfo() {
        return this.toUrlString(true, true, true);
    }

    private String toUrlString(boolean stripUserinfo, boolean displayPasswordSection, boolean maskPassword) {
        if (this == NO_URL) {
            return "";
        }
        StringBuilder buf = new StringBuilder(128);
        buf.append(this.scheme.name).append(':');
        boolean authorityPartSeparationPending = this.scheme != Scheme.FILE ? this.addAuthoritySpec(stripUserinfo, displayPasswordSection, maskPassword, buf) : false;
        if (this.rawPath != null && this.rawPath.length() != 0) {
            if (authorityPartSeparationPending && this.rawPath.charAt(0) != '/') {
                buf.append('/');
            }
            buf.append(this.rawPath);
            authorityPartSeparationPending = false;
        }
        if (this.rawQuery != null) {
            buf.append('?').append(this.rawQuery);
        }
        if (this.rawFragment != null) {
            buf.append('#').append(this.rawFragment);
        }
        return buf.toString();
    }

    public boolean addAuthoritySpec(boolean stripUserInfo, boolean displayPasswordSection, boolean maskPassword, StringBuilder buf) {
        if (this.host == null) {
            return false;
        }
        buf.append("//");
        if (!stripUserInfo && this.username != null) {
            buf.append(HgURL.makeRawUserInfo(this.username));
            if (this.password != null && displayPasswordSection) {
                buf.append(':');
                if (maskPassword) {
                    buf.append(PASSWORD_REPLACEMENT);
                } else {
                    buf.append(HgURL.makeRawUserInfo(new String(this.password)));
                }
            }
            buf.append('@');
        }
        buf.append(this.host);
        if (this.port != -1) {
            buf.append(':').append(this.port);
        }
        return true;
    }

    private static String makeRawUserInfo(String userInfo) {
        StringBuilder buf = new StringBuilder(userInfo.length() + 10);
        int length = userInfo.length();
        for (int i = 0; i < length; ++i) {
            char c = userInfo.charAt(i);
            if (HgURL.isLegalUserInfoChar(c)) {
                buf.append(c);
                continue;
            }
            HgURL.appendEncoded(c, buf);
        }
        return buf.toString();
    }

    private static String makeRawPathInfo(String path) {
        char c;
        int i;
        int length = path.length();
        if (length == 0) {
            return path;
        }
        for (i = 0; i < length && HgURL.isLegalPathChar(c = path.charAt(i)); ++i) {
        }
        if (i == length) {
            return path;
        }
        StringBuilder buf = new StringBuilder(path.length() + 20);
        if (i != 0) {
            buf.append(path.substring(0, i));
        }
        assert (!HgURL.isLegalPathChar(path.charAt(i)));
        HgURL.appendEncoded(path.charAt(i++), buf);
        while (i < length) {
            char c2 = path.charAt(i);
            if (HgURL.isLegalPathChar(c2)) {
                buf.append(c2);
            } else {
                HgURL.appendEncoded(c2, buf);
            }
            ++i;
        }
        return buf.toString();
    }

    private static boolean isLegalUserInfoChar(char c) {
        return HgURL.isAlnumChar(c) || "-_.!~*'();&=+$,%".indexOf(c) != -1;
    }

    private static boolean isLegalPathChar(char c) {
        return HgURL.isAlnumChar(c) || "/-_.!~*'():@&=+$,%".indexOf(c) != -1;
    }

    private static boolean isAlnumChar(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9';
    }

    private static void appendEncoded(int c, StringBuilder buf) {
        if (c < 128) {
            HgURL.appendEncodedByte(c & 0x7F, buf);
        } else if (c < 2048) {
            HgURL.appendEncodedByte(0xC0 | (c & 0x7C0) >>> 6, buf);
            HgURL.appendEncodedByte(0x80 | c & 0x3F, buf);
        } else if (c < 65536) {
            HgURL.appendEncodedByte(0xE0 | (c & 0xF000) >>> 12, buf);
            HgURL.appendEncodedByte(0x80 | (c & 0xFC0) >>> 6, buf);
            HgURL.appendEncodedByte(0x80 | c & 0x3F, buf);
        } else {
            HgURL.appendEncodedByte(0xF0 | (c & 0x1C0000) >>> 18, buf);
            HgURL.appendEncodedByte(0x80 | (c & 0x3F000) >>> 12, buf);
            HgURL.appendEncodedByte(0x80 | (c & 0xFC0) >>> 6, buf);
            HgURL.appendEncodedByte(0x80 | c & 0x3F, buf);
        }
    }

    private static void appendEncodedByte(int c, StringBuilder buf) {
        assert (c < 256);
        buf.append('%');
        buf.append(hexadecimalChars.charAt((c & 0xF0) >>> 4));
        buf.append(hexadecimalChars.charAt(c & 0xF));
    }

    public static enum Scheme {
        FILE("file", false),
        HTTP("http", true),
        HTTPS("https", true),
        STATIC_HTTP("static-http", true),
        SSH("ssh", true),
        SVN_HTTP("svn+http", true),
        SVN_HTTPS("svn+https", true),
        SVN_SSH("svn+ssh", true);

        private static int longestSchemeName;
        private final String name;
        private final boolean supportsAuthentication;

        private Scheme(String name, boolean supportsAuthentication) {
            this.name = name;
            this.supportsAuthentication = supportsAuthentication;
        }

        public static int getMaxSchemeNameLength() {
            if (longestSchemeName == 0) {
                for (Scheme scheme : Scheme.values()) {
                    longestSchemeName = Math.max(scheme.name.length(), longestSchemeName);
                }
            }
            return longestSchemeName;
        }

        public String toString() {
            return this.name;
        }

        public boolean supportsAuthentication() {
            return this.supportsAuthentication;
        }
    }
}

