/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.generator;

import com.sun.xml.rpc.processor.ProcessorAction;
import com.sun.xml.rpc.processor.config.Configuration;
import com.sun.xml.rpc.processor.generator.nodes.JavaWsdlMappingNode;
import com.sun.xml.rpc.processor.model.Model;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

public class JaxRpcMappingGenerator
implements ProcessorAction {
    private boolean debug = false;
    private File mappingFile;

    public JaxRpcMappingGenerator(File mappingFile) {
        this.mappingFile = mappingFile;
    }

    public void perform(Model model, Configuration config, Properties options) {
        Document document = this.buildMapping(model, config);
        this.write(document, this.mappingFile);
    }

    private Document buildMapping(Model model, Configuration config) {
        this.debug("building mapping");
        Document root = this.newDocument();
        try {
            new JavaWsdlMappingNode().write(root, "java-wsdl-mapping", model, config);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex.toString());
        }
        return root;
    }

    private Document newDocument() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            DOMImplementation domImplementation = builder.getDOMImplementation();
            Document document = builder.newDocument();
            return document;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void write(Document document, File resultFile) {
        try {
            FileOutputStream out = new FileOutputStream(resultFile);
            StreamResult output = new StreamResult(out);
            DOMSource source = new DOMSource(document);
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.transform(source, output);
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.toString());
        }
    }

    private void debug(String msg) {
        if (this.debug) {
            System.out.println("[JaxRpcMappingGenerator] --> " + msg);
        }
    }
}

