/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.mysql.actions;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.db.explorer.ConnectionListener;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.modules.db.mysql.Database;
import org.netbeans.modules.db.mysql.DatabaseServer;
import org.netbeans.modules.db.mysql.util.DatabaseUtils;
import org.netbeans.modules.db.mysql.util.Utils;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CookieAction;

public class ConnectAction
extends CookieAction {
    private static final Logger LOGGER = Logger.getLogger(ConnectAction.class.getName());
    private static final Class[] COOKIE_CLASSES = new Class[]{Database.class};

    public ConnectAction() {
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    protected boolean asynchronous() {
        return false;
    }

    public String getName() {
        return Utils.getBundle().getString("LBL_ConnectAction");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(ConnectAction.class);
    }

    public boolean enable(Node[] activatedNodes) {
        return true;
    }

    protected int mode() {
        return 8;
    }

    protected Class<?>[] cookieClasses() {
        return COOKIE_CLASSES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performAction(Node[] activatedNodes) {
        if (activatedNodes == null || activatedNodes.length == 0) {
            return;
        }
        Database model = (Database)activatedNodes[0].getCookie(Database.class);
        DatabaseServer server = model.getServer();
        String dbname = model.getDbName();
        List<DatabaseConnection> conns = DatabaseUtils.findDatabaseConnections(server.getURL(dbname));
        try {
            if (conns.size() == 0) {
                final DatabaseConnection dbconn = DatabaseConnection.create((JDBCDriver)DatabaseUtils.getJDBCDriver(), (String)server.getURL(dbname), (String)server.getUser(), null, (String)(server.isSavePassword() ? server.getPassword() : null), (boolean)server.isSavePassword());
                ConnectionManager.getDefault().addConnectionListener(new ConnectionListener(){

                    public void connectionsChanged() {
                        if (ConnectionManager.getDefault().getConnection(dbconn.getName()) == null) {
                            return;
                        }
                        ConnectionManager.getDefault().showConnectionDialog(dbconn);
                        ConnectionManager.getDefault().removeConnectionListener((ConnectionListener)this);
                    }
                });
                ConnectionManager.getDefault().addConnection(dbconn);
            } else {
                ConnectionManager.getDefault().showConnectionDialog(conns.get(0));
            }
        }
        catch (DatabaseException dbe) {
            LOGGER.log(Level.INFO, dbe.getMessage(), dbe);
            Utils.displayErrorMessage(NbBundle.getMessage(ConnectAction.class, (String)"MSG_FailureConnecting", (Object)dbname, (Object)dbe.getMessage()));
        }
        finally {
            server.refreshDatabaseList();
        }
    }
}

