/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.cli.jgit.commands;

import org.netbeans.modules.git.remote.cli.GitException;
import org.netbeans.modules.git.remote.cli.jgit.GitClassFactory;
import org.netbeans.modules.git.remote.cli.jgit.JGitRepository;
import org.netbeans.modules.git.remote.cli.jgit.commands.GitCommand;
import org.netbeans.modules.git.remote.cli.progress.ProgressMonitor;
import org.netbeans.modules.remotefs.versioning.api.ProcessUtils;
import org.openide.util.Cancellable;

public class DeleteBranchCommand
extends GitCommand {
    public static final boolean KIT = false;
    private final String branchName;
    private final boolean forceDeleteUnmerged;
    private final ProgressMonitor monitor;

    public DeleteBranchCommand(JGitRepository repository, GitClassFactory gitFactory, String branchName, boolean forceDeleteUnmerged, ProgressMonitor monitor) {
        super(repository, gitFactory, monitor);
        this.branchName = branchName;
        this.forceDeleteUnmerged = forceDeleteUnmerged;
        this.monitor = monitor;
    }

    @Override
    protected void prepare() throws GitException {
        super.prepare();
        this.addArgument(0, "branch");
        if (this.forceDeleteUnmerged) {
            this.addArgument(0, "-D");
        } else {
            this.addArgument(0, "-d");
        }
        this.addArgument(0, this.branchName);
    }

    @Override
    protected void run() throws GitException {
        block4: {
            ProcessUtils.Canceler canceled = new ProcessUtils.Canceler();
            if (this.monitor != null) {
                this.monitor.setCancelDelegate((Cancellable)canceled);
            }
            try {
                new GitCommand.Runner(canceled, 0){

                    @Override
                    public void outputParser(String output) throws GitException {
                    }

                    @Override
                    protected void errorParser(String error) throws GitException {
                        for (String msg : error.split("\n")) {
                            if (msg.startsWith("error: The branch")) {
                                throw new GitException.NotMergedException(DeleteBranchCommand.this.branchName);
                            }
                            if (!msg.startsWith("error: Cannot delete the branch")) continue;
                            throw new GitException.DeleteBranchException(DeleteBranchCommand.this.branchName);
                        }
                        super.errorParser(error);
                    }
                }.runCLI();
            }
            catch (GitException t) {
                throw t;
            }
            catch (Throwable t) {
                if (canceled.canceled()) break block4;
                throw new GitException(t);
            }
        }
    }
}

