/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.cli.jgit.commands;

import org.netbeans.modules.git.remote.cli.GitException;
import org.netbeans.modules.git.remote.cli.GitRevisionInfo;
import org.netbeans.modules.git.remote.cli.jgit.GitClassFactory;
import org.netbeans.modules.git.remote.cli.jgit.JGitRepository;
import org.netbeans.modules.git.remote.cli.jgit.commands.CommitCommand;
import org.netbeans.modules.git.remote.cli.jgit.commands.GitCommand;
import org.netbeans.modules.git.remote.cli.progress.ProgressMonitor;
import org.netbeans.modules.remotefs.versioning.api.ProcessUtils;
import org.openide.util.Cancellable;

public class GetCommonAncestorCommand
extends GitCommand {
    public static final boolean KIT = false;
    private final String[] revisions;
    private GitRevisionInfo revision;
    private final GitCommand.Revision revisionPlaseHolder;
    private final ProgressMonitor monitor;

    public GetCommonAncestorCommand(JGitRepository repository, GitClassFactory gitFactory, String[] revisions, ProgressMonitor monitor) {
        super(repository, gitFactory, monitor);
        this.revisions = revisions;
        this.monitor = monitor;
        this.revisionPlaseHolder = new GitCommand.Revision();
    }

    public GitRevisionInfo getRevision() {
        return this.revision;
    }

    @Override
    protected void prepare() throws GitException {
        this.setCommandsNumber(2);
        super.prepare();
        this.addArgument(0, "merge-base");
        for (String s : this.revisions) {
            this.addArgument(0, s);
        }
        this.addArgument(1, "log");
        this.addArgument(1, "--raw");
        this.addArgument(1, "--pretty=raw");
        this.addArgument(1, "-1");
        this.addArgument(1, this.revisionPlaseHolder);
    }

    @Override
    protected void run() throws GitException {
        block8: {
            ProcessUtils.Canceler canceled = new ProcessUtils.Canceler();
            if (this.monitor != null) {
                this.monitor.setCancelDelegate((Cancellable)canceled);
            }
            try {
                final GitRevisionInfo.GitRevCommit status = new GitRevisionInfo.GitRevCommit();
                if (this.revisions.length != 1) {
                    new GitCommand.Runner(canceled, 0){

                        @Override
                        public void outputParser(String output) throws GitException {
                            GetCommonAncestorCommand.this.parseCommit(output, status);
                        }
                    }.runCLI();
                } else {
                    status.revisionCode = this.revisions[0];
                }
                if (status.revisionCode != null) {
                    this.revisionPlaseHolder.setContent(status.revisionCode);
                    new GitCommand.Runner(canceled, 1){

                        @Override
                        public void outputParser(String output) throws GitException {
                            CommitCommand.parseLog(output, status);
                        }
                    }.runCLI();
                }
                if (canceled.canceled()) {
                    return;
                }
                this.revision = this.getClassFactory().createRevisionInfo(status, this.getRepository());
            }
            catch (GitException t) {
                throw t;
            }
            catch (Throwable t) {
                if (canceled.canceled()) break block8;
                throw new GitException(t);
            }
        }
    }

    private void parseCommit(String output, GitRevisionInfo.GitRevCommit status) {
        for (String line : output.split("\n")) {
            if ((line = line.trim()).isEmpty()) continue;
            status.revisionCode = line;
        }
    }
}

