/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.cli.jgit.commands;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.api.extexecution.ProcessBuilder;
import org.netbeans.modules.git.remote.cli.GitException;
import org.netbeans.modules.git.remote.cli.jgit.GitClassFactory;
import org.netbeans.modules.git.remote.cli.jgit.JGitRepository;
import org.netbeans.modules.git.remote.cli.jgit.Utils;
import org.netbeans.modules.git.remote.cli.progress.ProgressMonitor;
import org.netbeans.modules.remotefs.versioning.api.ProcessUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.api.VersioningSupport;

public abstract class GitCommand {
    private final JGitRepository repository;
    private final ProgressMonitor monitor;
    protected static final String EMPTY_ROOTS = Utils.getBundle(GitCommand.class).getString("MSG_Error_NoFiles");
    private final GitClassFactory gitFactory;
    private final List<List<CharSequence>> args = new ArrayList<List<CharSequence>>(2);
    private static final String MSG_WARNING = "warning:";
    private static final String MSG_ERROR = "error:";
    private static final String MSG_FATAL = "fatal:";

    protected GitCommand(JGitRepository repository, GitClassFactory gitFactory, ProgressMonitor monitor) {
        this.repository = repository;
        this.gitFactory = gitFactory;
        this.monitor = monitor;
        this.args.add(new ArrayList(5));
    }

    public final void execute() throws GitException {
        if (this.prepareCommand()) {
            try {
                this.monitor.started(this.getCommandLine(0));
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                        @Override
                        public Void run() throws GitException {
                            GitCommand.this.run();
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    throw (GitException)e.getException();
                }
            }
            catch (RuntimeException ex) {
                if (ex.getMessage() != null && ex.getMessage().contains("Unknown repository format")) {
                    throw new GitException("It seems the config file for repository at [" + this.repository.getLocation() + "] is corrupted.\nEnsure it's valid.", ex);
                }
                throw ex;
            }
            finally {
                this.monitor.finished();
            }
        }
    }

    protected abstract void run() throws GitException;

    protected final void setCommandsNumber(int commandNumber) {
        for (int i = 1; i < commandNumber; ++i) {
            this.args.add(new ArrayList(5));
        }
    }

    protected void prepare() throws GitException {
        for (List<CharSequence> arg : this.args) {
            arg.add("--no-pager");
        }
    }

    protected boolean prepareCommand() throws GitException {
        boolean repositoryExists = this.repository.getMetadataLocation().exists();
        if (!repositoryExists) {
            String message = MessageFormat.format(Utils.getBundle(GitCommand.class).getString("MSG_Error_RepositoryDoesNotExist"), this.repository.getLocation().getPath());
            this.monitor.preparationsFailed(message);
            throw new GitException(message);
        }
        this.prepare();
        return repositoryExists;
    }

    protected JGitRepository getRepository() {
        return this.repository;
    }

    protected final GitClassFactory getClassFactory() {
        return this.gitFactory;
    }

    public final void addArgument(int command, CharSequence argument) {
        this.args.get(command).add(argument);
    }

    public final void addFiles(int command, VCSFileProxy ... files) {
        for (String s : Utils.getRelativePaths(this.getRepository().getLocation(), files)) {
            this.addArgument(command, s);
        }
    }

    public final void addExistingFiles(int command, VCSFileProxy ... files) {
        for (VCSFileProxy root : files) {
            if (!root.exists()) continue;
            String relativePath = Utils.getRelativePath(this.getRepository().getLocation(), root);
            if (relativePath.isEmpty()) {
                this.addArgument(0, ".");
                continue;
            }
            this.addArgument(0, relativePath);
        }
    }

    public final String getExecutable() {
        return "git";
    }

    protected Map<String, String> getEnvVar() {
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put("LC_ALL", "");
        ret.put("LC_MESSAGES", "C");
        ret.put("LC_TIME", "C");
        return ret;
    }

    public final String[] getCliArguments(int command) {
        List<CharSequence> commandArgs = this.args.get(command);
        String[] res = new String[this.args.get(command).size()];
        for (int i = 0; i < commandArgs.size(); ++i) {
            res[i] = commandArgs.get(i).toString();
        }
        return res;
    }

    protected final String getCommandLine(int command) {
        StringBuilder sb = new StringBuilder(this.getExecutable());
        for (CharSequence s : this.args.get(command)) {
            sb.append(" ").append(s);
        }
        return sb.toString();
    }

    protected final void processMessages(String messages) {
        for (String msg : messages.split("\n")) {
            if (msg.startsWith(MSG_FATAL)) {
                this.monitor.notifyError(msg.substring(MSG_ERROR.length()).trim());
                continue;
            }
            if (msg.startsWith(MSG_ERROR)) {
                this.monitor.notifyError(msg.substring(MSG_ERROR.length()).trim());
                continue;
            }
            if (msg.startsWith(MSG_WARNING)) {
                this.monitor.notifyWarning(msg.substring(MSG_WARNING.length()).trim());
                continue;
            }
            if (msg.isEmpty()) continue;
            this.monitor.notifyMessage(msg);
        }
    }

    protected static final class Revision
    implements CharSequence {
        private String currentRevision = "place-holder";

        protected Revision() {
        }

        protected void setContent(String revision) {
            this.currentRevision = revision;
        }

        @Override
        public int length() {
            return this.currentRevision.length();
        }

        @Override
        public char charAt(int index) {
            return this.currentRevision.charAt(index);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return this.currentRevision.subSequence(end, end);
        }

        @Override
        public String toString() {
            return this.currentRevision;
        }
    }

    protected abstract class Runner {
        private final ProcessUtils.Canceler canceled;
        private final int command;
        private final String cmd;

        protected Runner(ProcessUtils.Canceler canceled, int command) {
            this.canceled = canceled;
            this.command = command;
            this.cmd = GitCommand.this.getCommandLine(command);
        }

        protected void runCLI() throws GitException {
            if (this.canceled.canceled()) {
                return;
            }
            ProcessBuilder processBuilder = VersioningSupport.createProcessBuilder((VCSFileProxy)GitCommand.this.getRepository().getLocation());
            String executable = GitCommand.this.getExecutable();
            String[] args = GitCommand.this.getCliArguments(this.command);
            ProcessUtils.ExitStatus exitStatus = ProcessUtils.executeInDir((String)GitCommand.this.getRepository().getLocation().getPath(), GitCommand.this.getEnvVar(), (boolean)false, (ProcessUtils.Canceler)this.canceled, (ProcessBuilder)processBuilder, (String)executable, (String[])args);
            if (this.canceled.canceled()) {
                return;
            }
            if (exitStatus.output != null && exitStatus.isOK()) {
                if (exitStatus.error != null && !exitStatus.error.isEmpty()) {
                    if (exitStatus.output.isEmpty()) {
                        this.outputParser(exitStatus.error);
                    } else {
                        this.outputParser(exitStatus.output + "\n" + exitStatus.error);
                    }
                } else {
                    this.outputParser(exitStatus.output);
                }
            } else {
                this.outputErrorParser(exitStatus.output, exitStatus.error, exitStatus.exitCode);
            }
            if (exitStatus.error != null && !exitStatus.isOK()) {
                this.errorParser(exitStatus.error);
            }
        }

        protected abstract void outputParser(String var1) throws GitException;

        protected void errorParser(String error) throws GitException {
            throw new GitException("#" + this.cmd + "\n" + error);
        }

        protected void outputErrorParser(String output, String error, int exitCode) throws GitException {
        }
    }
}

