/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.cli.jgit.commands;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.git.remote.cli.GitException;
import org.netbeans.modules.git.remote.cli.GitPushResult;
import org.netbeans.modules.git.remote.cli.GitRefUpdateResult;
import org.netbeans.modules.git.remote.cli.GitTransportUpdate;
import org.netbeans.modules.git.remote.cli.jgit.GitClassFactory;
import org.netbeans.modules.git.remote.cli.jgit.JGitRepository;
import org.netbeans.modules.git.remote.cli.jgit.commands.GitCommand;
import org.netbeans.modules.git.remote.cli.jgit.commands.TransportCommand;
import org.netbeans.modules.git.remote.cli.progress.ProgressMonitor;
import org.netbeans.modules.remotefs.versioning.api.ProcessUtils;
import org.openide.util.Cancellable;

public class PushCommand
extends TransportCommand {
    private final ProgressMonitor monitor;
    private final List<String> pushRefSpecs;
    private final String remote;
    private GitPushResult result;
    private final List<String> fetchRefSpecs;

    public PushCommand(JGitRepository repository, GitClassFactory gitFactory, String remote, List<String> pushRefSpecifications, List<String> fetchRefSpecifications, ProgressMonitor monitor) {
        super(repository, gitFactory, remote, monitor);
        this.monitor = monitor;
        this.remote = remote;
        this.pushRefSpecs = pushRefSpecifications;
        this.fetchRefSpecs = fetchRefSpecifications;
    }

    public GitPushResult getResult() {
        return this.result;
    }

    @Override
    protected void prepare() throws GitException {
        super.prepare();
        this.addArgument(0, "push");
        this.addArgument(0, "--porcelain");
        this.addArgument(0, "--thin");
        this.addArgument(0, this.remote);
        for (String refSpec : this.pushRefSpecs) {
            this.addArgument(0, refSpec);
        }
        for (String refSpec : this.fetchRefSpecs) {
            this.addArgument(0, refSpec);
        }
    }

    @Override
    protected void runTransportCommand() throws GitException.AuthorizationException, GitException {
        block4: {
            ProcessUtils.Canceler canceled = new ProcessUtils.Canceler();
            if (this.monitor != null) {
                this.monitor.setCancelDelegate((Cancellable)canceled);
            }
            try {
                final LinkedHashMap<String, GitTransportUpdate> remoteRepositoryUpdates = new LinkedHashMap<String, GitTransportUpdate>();
                final LinkedHashMap<String, GitTransportUpdate> localRepositoryUpdates = new LinkedHashMap<String, GitTransportUpdate>();
                new GitCommand.Runner(canceled, 0){

                    @Override
                    public void outputParser(String output) throws GitException {
                        PushCommand.this.parsePushOutput(output, remoteRepositoryUpdates, localRepositoryUpdates);
                    }
                }.runCLI();
                this.result = this.getClassFactory().createPushResult(remoteRepositoryUpdates, localRepositoryUpdates);
            }
            catch (GitException t) {
                throw t;
            }
            catch (Throwable t) {
                if (canceled.canceled()) break block4;
                throw new GitException(t);
            }
        }
    }

    private void parsePushOutput(String output, Map<String, GitTransportUpdate> remoteRepositoryUpdates, Map<String, GitTransportUpdate> localRepositoryUpdates) {
        String url = null;
        block8: for (String line : output.split("\n")) {
            if (line.startsWith("To")) {
                String[] s = line.split("\\s");
                url = s[s.length - 1];
                continue;
            }
            if (line.startsWith("Done")) continue;
            GitTransportUpdate.GitTransportUpdateContainer details = new GitTransportUpdate.GitTransportUpdateContainer();
            switch (line.charAt(0)) {
                case ' ': {
                    details.status = GitRefUpdateResult.OK;
                    break;
                }
                case '+': {
                    details.status = GitRefUpdateResult.OK;
                    break;
                }
                case '-': {
                    details.status = GitRefUpdateResult.OK;
                    break;
                }
                case '*': {
                    details.status = GitRefUpdateResult.OK;
                    break;
                }
                case '!': {
                    details.status = GitRefUpdateResult.REJECTED;
                    break;
                }
                case '=': {
                    details.status = GitRefUpdateResult.UP_TO_DATE;
                    break;
                }
                default: {
                    continue block8;
                }
            }
            String[] s = line.split("\t");
            String spec = s[1];
            int i = spec.indexOf(58);
            if (i < 0) continue;
            String local = spec.substring(0, i);
            String remote = spec.substring(i + 1);
            if (local.indexOf(47) > 0) {
                details.localBranch = local.substring(local.lastIndexOf(47) + 1);
            } else if (!local.isEmpty()) {
                details.localBranch = local;
            }
            details.remoteBranch = remote.indexOf(47) > 0 ? remote.substring(remote.lastIndexOf(47) + 1) : remote;
            details.url = url;
            details.type = GitTransportUpdate.getType(remote);
            remoteRepositoryUpdates.put(details.remoteBranch, this.getClassFactory().createTransportUpdate(details));
        }
    }
}

