/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.spi.testing.create;

import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.gsf.testrunner.ui.spi.TestCreatorConfiguration;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.api.queries.PhpVisibilityQuery;
import org.netbeans.modules.php.api.testing.PhpTesting;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.spi.testing.PhpTestingProvider;
import org.netbeans.modules.php.spi.testing.create.Bundle;
import org.netbeans.modules.php.spi.testing.create.CreateTestsResult;
import org.netbeans.modules.php.spi.testing.create.EmptyTestCreatorConfiguration;
import org.openide.DialogDisplayer;
import org.openide.LifecycleManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;

public final class CreateTestsSupport {
    private static final Logger LOGGER = Logger.getLogger(CreateTestsSupport.class.getName());
    private static final RequestProcessor RP = new RequestProcessor(CreateTestsSupport.class.getName(), 2);
    @NonNull
    private final PhpTestingProvider testingProvider;
    @NonNull
    private final FileObject[] activatedFileObjects;
    @NullAllowed
    private PhpModule phpModule;
    @NullAllowed
    private Project project;

    private CreateTestsSupport(@NonNull PhpTestingProvider testingProvider, @NonNull FileObject[] activatedFileObjects) {
        assert (testingProvider != null);
        assert (activatedFileObjects != null);
        this.testingProvider = testingProvider;
        this.activatedFileObjects = activatedFileObjects;
    }

    public static CreateTestsSupport create(@NonNull PhpTestingProvider testingProvider, @NonNull FileObject[] activatedFileObjects) {
        Parameters.notNull((CharSequence)"testingProvider", (Object)testingProvider);
        Parameters.notNull((CharSequence)"activatedFileObjects", (Object)activatedFileObjects);
        return new CreateTestsSupport(testingProvider, activatedFileObjects);
    }

    @CheckForNull
    public synchronized PhpModule getPhpModule() {
        assert (Thread.holdsLock(this));
        if (this.phpModule == null) {
            if (this.activatedFileObjects.length == 0) {
                return null;
            }
            PhpModule onlyOnePhpModuleAllowed = null;
            for (FileObject fileObj : this.activatedFileObjects) {
                if (fileObj == null) {
                    return null;
                }
                PhpModule module = PhpModule.Factory.forFileObject((FileObject)fileObj);
                if (module == null) {
                    return null;
                }
                if (onlyOnePhpModuleAllowed == null) {
                    onlyOnePhpModuleAllowed = module;
                    continue;
                }
                if (onlyOnePhpModuleAllowed.equals(module)) continue;
                return null;
            }
            this.phpModule = onlyOnePhpModuleAllowed;
        }
        return this.phpModule;
    }

    @CheckForNull
    private synchronized Project getProject() {
        PhpModule module;
        assert (Thread.holdsLock(this));
        if (this.project == null && (module = this.getPhpModule()) != null) {
            this.project = FileOwnerQuery.getOwner((FileObject)module.getProjectDirectory());
        }
        return this.project;
    }

    public TestCreatorConfiguration createEmptyConfiguration(@NonNull String framework) {
        Parameters.notNull((CharSequence)"framework", (Object)framework);
        return EmptyTestCreatorConfiguration.create(framework, this);
    }

    public Object[] getTestSourceRoots(@NonNull Collection<SourceGroup> createdSourceRoots, @NonNull FileObject fileObject) {
        SourceGroup[] sourceGroups;
        PhpModule phpModuleRef = this.getPhpModule();
        assert (phpModuleRef != null) : Arrays.toString(this.activatedFileObjects);
        Project projectRef = this.getProject();
        assert (projectRef != null) : Arrays.toString(this.activatedFileObjects) + " :: " + phpModuleRef.getProjectDirectory();
        ArrayList<SourceGroup> folders = new ArrayList<SourceGroup>();
        List testDirectories = phpModuleRef.getTestDirectories();
        for (SourceGroup sg : sourceGroups = ProjectUtils.getSources((Project)projectRef).getSourceGroups("PHPSOURCE")) {
            if (sg.contains(fileObject) || !testDirectories.contains(sg.getRootFolder())) continue;
            folders.add(sg);
        }
        return folders.toArray();
    }

    public boolean isEnabled() {
        if (this.activatedFileObjects.length == 0) {
            return false;
        }
        PhpModule phpModuleRef = this.getPhpModule();
        if (phpModuleRef == null) {
            return false;
        }
        if (phpModuleRef.isBroken()) {
            return false;
        }
        if (!PhpTesting.isTestingProviderEnabled(this.testingProvider.getIdentifier(), phpModuleRef)) {
            return false;
        }
        for (FileObject fileObj : this.activatedFileObjects) {
            if (fileObj == null) {
                return false;
            }
            if (fileObj.isData() && !FileUtils.isPhpFile((FileObject)fileObj)) {
                return false;
            }
            if (this.isUnderSources(phpModuleRef, fileObj) && !this.isUnderTests(phpModuleRef, fileObj)) continue;
            return false;
        }
        return true;
    }

    public void createTests(Map<String, Object> configurationPanelProperties) {
        final Map<String, Object> properties = Collections.synchronizedMap(configurationPanelProperties);
        RP.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ProgressHandle handle = ProgressHandle.createHandle((String)Bundle.CreateTestsSupport_creating());
                handle.start();
                try {
                    LifecycleManager.getDefault().saveAll();
                    CreateTestsSupport.this.generateTests(properties);
                }
                finally {
                    handle.finish();
                }
            }
        });
    }

    private boolean isUnderSources(PhpModule phpModule, FileObject fileObj) {
        return FileUtil.isParentOf((FileObject)phpModule.getSourceDirectory(), (FileObject)fileObj);
    }

    private boolean isUnderTests(PhpModule phpModule, FileObject fileObj) {
        for (FileObject dir : phpModule.getTestDirectories()) {
            if (!FileUtil.isParentOf((FileObject)dir, (FileObject)fileObj)) continue;
            return true;
        }
        return false;
    }

    void generateTests(final Map<String, Object> configurationPanelProperties) {
        assert (!EventQueue.isDispatchThread());
        final PhpModule phpModuleRef = this.getPhpModule();
        assert (phpModuleRef != null) : Arrays.toString(this.activatedFileObjects);
        List<FileObject> files = Arrays.asList(this.activatedFileObjects);
        assert (!files.isEmpty()) : "No files for tests?!";
        final ArrayList<FileObject> sanitizedFiles = new ArrayList<FileObject>(files.size() * 2);
        this.sanitizeFiles(sanitizedFiles, files, phpModuleRef, (PhpVisibilityQuery)phpModuleRef.getLookup().lookup(PhpVisibilityQuery.class));
        if (sanitizedFiles.isEmpty()) {
            LOGGER.info("No visible files for creating tests -> exiting.");
            return;
        }
        final HashSet<FileObject> succeeded = new HashSet<FileObject>();
        final HashSet<FileObject> failed = new HashSet<FileObject>();
        FileUtil.runAtomicAction((Runnable)new Runnable(){

            @Override
            public void run() {
                assert (phpModuleRef != null);
                CreateTestsResult result = CreateTestsSupport.this.testingProvider.createTests(phpModuleRef, sanitizedFiles, configurationPanelProperties);
                succeeded.addAll(result.getSucceeded());
                failed.addAll(result.getFailed());
            }
        });
        this.showFailures(failed);
        this.reformat(succeeded);
        this.open(succeeded);
        this.refreshTests(phpModuleRef.getTestDirectories());
    }

    private void sanitizeFiles(List<FileObject> sanitizedFiles, List<FileObject> files, PhpModule phpModule, PhpVisibilityQuery phpVisibilityQuery) {
        for (FileObject fo : files) {
            FileObject[] children;
            if (fo.isData() && FileUtils.isPhpFile((FileObject)fo) && !this.isUnderTests(phpModule, fo) && phpVisibilityQuery.isVisible(fo)) {
                sanitizedFiles.add(fo);
            }
            if ((children = fo.getChildren()).length <= 0) continue;
            this.sanitizeFiles(sanitizedFiles, Arrays.asList(children), phpModule, phpVisibilityQuery);
        }
    }

    private void showFailures(Set<FileObject> files) {
        if (files.isEmpty()) {
            return;
        }
        StringBuilder sb = new StringBuilder(50);
        for (FileObject file : files) {
            sb.append(file.getNameExt());
            sb.append("\n");
        }
        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.CreateTestsSupport_failed(sb.toString()), 2));
    }

    private void reformat(Set<FileObject> files) {
        for (FileObject file : files) {
            try {
                FileUtils.reformatFile((File)FileUtil.toFile((FileObject)file));
            }
            catch (IOException ex) {
                LOGGER.log(Level.INFO, "Cannot reformat file " + file, ex);
            }
        }
    }

    private void open(Set<FileObject> files) {
        for (FileObject file : files) {
            assert (file.isData()) : "File must be given to open: " + file;
            FileUtils.openFile((File)FileUtil.toFile((FileObject)file));
        }
    }

    private void refreshTests(List<FileObject> testDirs) {
        final CopyOnWriteArrayList<FileObject> dirs = new CopyOnWriteArrayList<FileObject>(testDirs);
        RP.post(new Runnable(){

            @Override
            public void run() {
                for (FileObject dir : dirs) {
                    FileUtil.refreshFor((File[])new File[]{FileUtil.toFile((FileObject)dir)});
                }
            }
        });
    }
}

