/*
 * Decompiled with CFR 0.152.
 */
package org.clank.java;

import org.clank.support.Destructors;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativeTrace;
import org.clank.support.aliases.type$ptr;
import org.clank.support.aliases.type$ref;

public interface std_ptr {

    public static class unique_ptr_null_eq<T extends Native.NativeComparable>
    implements Destructors.ClassWithDestructor {
        private boolean destroyed = false;
        private T Ptr;

        private void checkAlive() {
            if (NativeTrace.isDebugMode() && this.destroyed) {
                throw new IllegalStateException("Already destroyed");
            }
        }

        private unique_ptr_null_eq(unique_ptr_null_eq<T> $Prm0) {
            throw new AssertionError((Object)"LLVM_DELETED_FUNCTION");
        }

        private unique_ptr_null_eq<T> $assign(unique_ptr_null_eq<T> $Prm0) {
            throw new AssertionError((Object)"LLVM_DELETED_FUNCTION");
        }

        public unique_ptr_null_eq() {
            this((Native.NativeComparable)null);
        }

        public unique_ptr_null_eq(T P) {
            this.Ptr = P;
            assert (P == null || Native.$eq(P, null)) : "this object is not $eq to null, use OwningPtr instead";
        }

        @Override
        public void $destroy() {
            this.checkAlive();
            if (this.Ptr != null) {
                Destructors.$destroy(this.Ptr);
            }
            this.destroyed = true;
        }

        public void reset() {
            this.reset(null);
        }

        public void reset(T P) {
            this.checkAlive();
            if (P == this.Ptr) {
                return;
            }
            assert (P == null || Native.$eq(P, null)) : "this object is not $eq to null, use OwningPtr instead";
            T Tmp = this.Ptr;
            this.Ptr = P;
            if (Tmp != null) {
                Destructors.$destroy(Tmp);
            }
        }

        public T take() {
            this.checkAlive();
            T Tmp = this.Ptr;
            this.Ptr = null;
            return Tmp;
        }

        public T $star() {
            this.checkAlive();
            if (NativeTrace.isDebugMode() && this.Ptr == null) {
                throw new NullPointerException("Cannot dereference null pointer");
            }
            return this.Ptr;
        }

        public T $arrow() {
            this.checkAlive();
            if (NativeTrace.isDebugMode() && this.Ptr == null) {
                throw new NullPointerException("Cannot dereference null pointer");
            }
            return this.Ptr;
        }

        public T get() {
            this.checkAlive();
            return this.Ptr;
        }

        public boolean $boolean() {
            if (this.destroyed) {
                return false;
            }
            return this.Ptr == null ? false : Native.$noteq(this.Ptr, null);
        }

        public boolean $not() {
            if (this.destroyed) {
                return true;
            }
            return this.Ptr == null ? true : Native.$eq(this.Ptr, null);
        }

        public boolean isValid() {
            return this.Ptr == null ? false : Native.$noteq(this.Ptr, null);
        }

        public void swap(unique_ptr_null_eq<T> RHS) {
            this.checkAlive();
            T Tmp = RHS.Ptr;
            RHS.Ptr = this.Ptr;
            this.Ptr = Tmp;
        }

        public String toString() {
            return "unique_ptr_null_eq{destroyed=" + this.destroyed + ", Ptr=" + this.Ptr + '}';
        }
    }

    public static class unique_ptr_with_deleter<T>
    extends unique_ptr<T> {
        private final deleter<T> _Dp;

        public unique_ptr_with_deleter() {
            this._Dp = new default_delete();
        }

        public unique_ptr_with_deleter(T P) {
            super(P);
            this._Dp = new default_delete();
        }

        public unique_ptr_with_deleter(T P, deleter<T> _Dp) {
            super(P);
            this._Dp = _Dp;
        }

        public unique_ptr_with_deleter(unique_ptr $Prm0) {
            super($Prm0);
            assert ($Prm0.getClass() == unique_ptr_with_deleter.class) : "Copy constructor called for different class!";
            this._Dp = ((unique_ptr_with_deleter)$Prm0)._Dp;
        }

        public unique_ptr_with_deleter(JavaDifferentiators.Move _dparam, unique_ptr<T> $Prm0) {
            super(_dparam, $Prm0);
            assert ($Prm0.getClass() == unique_ptr_with_deleter.class) : "Move constructor called for different class!";
            this._Dp = ((unique_ptr_with_deleter)$Prm0)._Dp;
        }

        @Override
        public unique_ptr<T> $assignRvalue(unique_ptr<T> __u) {
            super.$assignRvalue(__u);
            assert (__u.getClass() == unique_ptr_with_deleter.class) : "Move constructor called for different class!";
            assert (this._Dp.getClass() == ((unique_ptr_with_deleter)__u)._Dp.getClass()) : "Moving to the ptr with differnet deleter!";
            return this;
        }

        @Override
        public void $destroy() {
            this.checkAlive();
            this._Dp.$call(this.get());
            this.destroyed = true;
            if (NativeTrace.CHECK_STD_PTR_ACCESS) {
                this.destroyedStack = new Exception("First destroyed was at");
            }
        }
    }

    public static class unique_ptr<T>
    implements Destructors.ClassWithDestructor {
        private final Exception createdStack;
        protected Exception destroyedStack = null;
        protected boolean destroyed = false;
        private T Ptr;

        protected void checkAlive() {
            if ((NativeTrace.isDebugMode() || NativeTrace.CHECK_STD_PTR_ACCESS) && this.destroyed) {
                if (NativeTrace.CHECK_STD_PTR_ACCESS) {
                    this.destroyedStack.printStackTrace(System.err);
                    this.createdStack.printStackTrace(System.err);
                }
                throw new IllegalStateException("Already destroyed");
            }
        }

        public static <T> unique_ptr<T> $unique_ptr(unique_ptr<T> $Prm0) {
            return new unique_ptr<T>($Prm0.release());
        }

        private unique_ptr<T> $assign(unique_ptr<T> $Prm0) {
            throw new AssertionError((Object)"LLVM_DELETED_FUNCTION");
        }

        public unique_ptr() {
            this(null);
        }

        public unique_ptr(T P) {
            this.Ptr = P;
            assert (P == null || Native.$noteq(P, null)) : "this object is $eq to null, use OwningPtrNullEq instead";
            this.createdStack = NativeTrace.CHECK_STD_PTR_ACCESS ? new Exception("created for " + (this.Ptr == null ? "<null>" : this.Ptr.getClass().getName())) : null;
        }

        public unique_ptr(unique_ptr $Prm0) {
            this.Ptr = $Prm0.release();
            this.createdStack = NativeTrace.CHECK_STD_PTR_ACCESS ? new Exception("created for " + (this.Ptr == null ? "<null>" : this.Ptr.getClass().getName())) : null;
        }

        public unique_ptr(JavaDifferentiators.Move _dparam, unique_ptr<T> $Prm0) {
            this($Prm0.release());
        }

        @Override
        public void $destroy() {
            this.checkAlive();
            if (this.Ptr != null) {
                Destructors.$destroy(this.Ptr);
            }
            this.destroyed = true;
            this.Ptr = null;
            if (NativeTrace.CHECK_STD_PTR_ACCESS) {
                this.destroyedStack = new Exception("First destroyed was at");
            }
        }

        public unique_ptr<T> $assignRvalue(unique_ptr<T> __u) {
            return this.$assignMove(__u);
        }

        public unique_ptr<T> $assignMove(unique_ptr<T> __u) {
            this.reset(__u.release());
            return this;
        }

        public unique_ptr<T> $assignNullptr(Object obj) {
            assert (obj == null) : "Operator can be used only to assign nullptr_t!";
            this.reset();
            return this;
        }

        public T release() {
            T result = this.get();
            this.Ptr = null;
            return result;
        }

        public void reset() {
            this.reset(null);
        }

        public void reset(T P) {
            this.checkAlive();
            if (P == this.Ptr) {
                return;
            }
            T Tmp = this.Ptr;
            this.Ptr = P;
            assert (P == null || Native.$noteq(P, null)) : "this object is $eq to null, use OwningPtrNullEq instead";
            if (Tmp != null) {
                Destructors.$destroy(Tmp);
            }
        }

        public T take() {
            this.checkAlive();
            T Tmp = this.Ptr;
            this.Ptr = null;
            return Tmp;
        }

        public T $star() {
            this.checkAlive();
            if (NativeTrace.isDebugMode() && this.Ptr == null) {
                throw new NullPointerException("Cannot dereference null pointer");
            }
            return this.Ptr;
        }

        public type$ref<T> star$ref() {
            this.checkAlive();
            if (NativeTrace.isDebugMode() && this.Ptr == null) {
                throw new NullPointerException("Cannot dereference null pointer");
            }
            return new type$ref<T>(){

                @Override
                public T $deref() {
                    return unique_ptr.this.Ptr;
                }

                @Override
                public T $set(T value) {
                    unique_ptr.this.Ptr = Native.$tryAssign(unique_ptr.this.Ptr, value, false);
                    return unique_ptr.this.Ptr;
                }

                @Override
                public type$ptr<T> deref$ptr() {
                    throw new UnsupportedOperationException("Not implemented yet!");
                }
            };
        }

        public T $arrow() {
            this.checkAlive();
            if (NativeTrace.isDebugMode() && this.Ptr == null) {
                throw new NullPointerException("Cannot dereference null pointer");
            }
            return this.Ptr;
        }

        public T get() {
            this.checkAlive();
            return this.Ptr;
        }

        public boolean $boolean() {
            if (this.destroyed) {
                return false;
            }
            return this.Ptr != null;
        }

        public boolean $not() {
            if (this.destroyed) {
                return true;
            }
            return this.Ptr == null;
        }

        public boolean isValid() {
            return this.Ptr != null;
        }

        public void swap(unique_ptr<T> RHS) {
            this.checkAlive();
            T Tmp = RHS.Ptr;
            RHS.Ptr = this.Ptr;
            this.Ptr = Tmp;
        }

        public String toString() {
            return "unique_ptr{destroyed=" + this.destroyed + ", Ptr=" + this.Ptr + '}';
        }
    }

    public static class shared_ptr<T>
    implements Destructors.ClassWithDestructor {
        private T Obj;
        private int _M_refcount;

        public shared_ptr() {
            this.Obj = null;
            this._M_refcount = 0;
        }

        public shared_ptr(T obj) {
            this.Obj = obj;
            this.retain();
        }

        public shared_ptr(shared_ptr<T> S) {
            this.Obj = S.Obj;
            this.retain();
        }

        public shared_ptr<T> $assign(shared_ptr<T> S) {
            this.swap(S);
            return this;
        }

        @Override
        public void $destroy() {
            this.release();
        }

        public T $star() {
            return this.Obj;
        }

        public T $arrow() {
            return this.Obj;
        }

        public T getPtr() {
            return this.Obj;
        }

        public boolean $boolean() {
            return this.Obj != null;
        }

        public T $Void2Type() {
            return this.Obj == null ? null : (T)this.Obj;
        }

        public void swap(shared_ptr<T> other) {
            T tmp = other.Obj;
            int _M_refcount_Tmp = other._M_refcount;
            other.Obj = this.Obj;
            other._M_refcount = this._M_refcount;
            this.Obj = tmp;
            this._M_refcount = _M_refcount_Tmp;
        }

        public void reset() {
            this.release();
            this.Obj = null;
        }

        public void resetWithoutRelease() {
            this.Obj = null;
        }

        private void retain() {
            if (this.Obj != null) {
                ++this._M_refcount;
            }
        }

        private void release() {
            if (this.Obj != null && --this._M_refcount == 0) {
                Destructors.$destroy(this.Obj);
                this.Obj = null;
            }
        }

        public String toString() {
            return "shared_ptr{counter=" + this._M_refcount + ", Obj=" + this.Obj + '}';
        }

        public T get() {
            return this.Obj;
        }
    }

    public static class default_delete<T>
    implements deleter<T> {
        @Override
        public void $call(T __ptr) {
            Native.destroy(__ptr);
        }
    }

    public static interface deleter<T> {
        public void $call(T var1);
    }
}

